<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Multi-Supplier_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Multi-Supplier Data
 * @subpackage Structs
 */
class Multi_Supplier_DataType extends AbstractStructBase
{
    /**
     * The Allow_All_Suppliers
     * Meta information extracted from the WSDL
     * - documentation: If the Allow All Suppliers flag is true, then the Supplier List Entry Data elements are ignored.
     * - choice: Allow_All_Suppliers | From_Supplier_List_Only
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Allow_All_Suppliers;
    /**
     * The From_Supplier_List_Only
     * Meta information extracted from the WSDL
     * - documentation: From Supplier List Only
     * - choice: Allow_All_Suppliers | From_Supplier_List_Only
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $From_Supplier_List_Only;
    /**
     * The Markup_for_All_Suppliers
     * Meta information extracted from the WSDL
     * - documentation: You can use this field to submit the markup percentage for the pricing of goods on multi-supplier contracts, which are enabled for all the suppliers in your tenant. Submit a negative percentage to apply a discount. Markups aren't
     * applied to service and project-based contract lines.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 5
     * @var float
     */
    public $Markup_for_All_Suppliers;
    /**
     * The Supplier_List_Entry_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier List Entry Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_List_Entry_DataType[]
     */
    public $Supplier_List_Entry_Data;
    /**
     * Constructor method for Multi-Supplier_DataType
     * @uses Multi_Supplier_DataType::setAllow_All_Suppliers()
     * @uses Multi_Supplier_DataType::setFrom_Supplier_List_Only()
     * @uses Multi_Supplier_DataType::setMarkup_for_All_Suppliers()
     * @uses Multi_Supplier_DataType::setSupplier_List_Entry_Data()
     * @param bool $allow_All_Suppliers
     * @param bool $from_Supplier_List_Only
     * @param float $markup_for_All_Suppliers
     * @param \StructType\Supplier_List_Entry_DataType[] $supplier_List_Entry_Data
     */
    public function __construct($allow_All_Suppliers = null, $from_Supplier_List_Only = null, $markup_for_All_Suppliers = null, array $supplier_List_Entry_Data = array())
    {
        $this
            ->setAllow_All_Suppliers($allow_All_Suppliers)
            ->setFrom_Supplier_List_Only($from_Supplier_List_Only)
            ->setMarkup_for_All_Suppliers($markup_for_All_Suppliers)
            ->setSupplier_List_Entry_Data($supplier_List_Entry_Data);
    }
    /**
     * Get Allow_All_Suppliers value
     * @return bool|null
     */
    public function getAllow_All_Suppliers()
    {
        return isset($this->Allow_All_Suppliers) ? $this->Allow_All_Suppliers : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAllow_All_Suppliers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllow_All_Suppliers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAllow_All_SuppliersForChoiceConstraintsFromSetAllow_All_Suppliers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'From_Supplier_List_Only',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Allow_All_Suppliers can\'t be set as the property %s is already set. Only one property must be set among these properties: Allow_All_Suppliers, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Allow_All_Suppliers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $allow_All_Suppliers
     * @return \StructType\Multi_Supplier_DataType
     */
    public function setAllow_All_Suppliers($allow_All_Suppliers = null)
    {
        // validation for constraint: boolean
        if (!is_null($allow_All_Suppliers) && !is_bool($allow_All_Suppliers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allow_All_Suppliers, true), gettype($allow_All_Suppliers)), __LINE__);
        }
        // validation for constraint: choice(Allow_All_Suppliers, From_Supplier_List_Only)
        if ('' !== ($allow_All_SuppliersChoiceErrorMessage = self::validateAllow_All_SuppliersForChoiceConstraintsFromSetAllow_All_Suppliers($allow_All_Suppliers))) {
            throw new \InvalidArgumentException($allow_All_SuppliersChoiceErrorMessage, __LINE__);
        }
        if (is_null($allow_All_Suppliers) || (is_array($allow_All_Suppliers) && empty($allow_All_Suppliers))) {
            unset($this->Allow_All_Suppliers);
        } else {
            $this->Allow_All_Suppliers = $allow_All_Suppliers;
        }
        return $this;
    }
    /**
     * Get From_Supplier_List_Only value
     * @return bool|null
     */
    public function getFrom_Supplier_List_Only()
    {
        return isset($this->From_Supplier_List_Only) ? $this->From_Supplier_List_Only : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFrom_Supplier_List_Only method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFrom_Supplier_List_Only method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFrom_Supplier_List_OnlyForChoiceConstraintsFromSetFrom_Supplier_List_Only($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Allow_All_Suppliers',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property From_Supplier_List_Only can\'t be set as the property %s is already set. Only one property must be set among these properties: From_Supplier_List_Only, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set From_Supplier_List_Only value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $from_Supplier_List_Only
     * @return \StructType\Multi_Supplier_DataType
     */
    public function setFrom_Supplier_List_Only($from_Supplier_List_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($from_Supplier_List_Only) && !is_bool($from_Supplier_List_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($from_Supplier_List_Only, true), gettype($from_Supplier_List_Only)), __LINE__);
        }
        // validation for constraint: choice(Allow_All_Suppliers, From_Supplier_List_Only)
        if ('' !== ($from_Supplier_List_OnlyChoiceErrorMessage = self::validateFrom_Supplier_List_OnlyForChoiceConstraintsFromSetFrom_Supplier_List_Only($from_Supplier_List_Only))) {
            throw new \InvalidArgumentException($from_Supplier_List_OnlyChoiceErrorMessage, __LINE__);
        }
        if (is_null($from_Supplier_List_Only) || (is_array($from_Supplier_List_Only) && empty($from_Supplier_List_Only))) {
            unset($this->From_Supplier_List_Only);
        } else {
            $this->From_Supplier_List_Only = $from_Supplier_List_Only;
        }
        return $this;
    }
    /**
     * Get Markup_for_All_Suppliers value
     * @return float|null
     */
    public function getMarkup_for_All_Suppliers()
    {
        return $this->Markup_for_All_Suppliers;
    }
    /**
     * Set Markup_for_All_Suppliers value
     * @param float $markup_for_All_Suppliers
     * @return \StructType\Multi_Supplier_DataType
     */
    public function setMarkup_for_All_Suppliers($markup_for_All_Suppliers = null)
    {
        // validation for constraint: float
        if (!is_null($markup_for_All_Suppliers) && !(is_float($markup_for_All_Suppliers) || is_numeric($markup_for_All_Suppliers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($markup_for_All_Suppliers, true), gettype($markup_for_All_Suppliers)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($markup_for_All_Suppliers) && mb_strlen(mb_substr($markup_for_All_Suppliers, false !== mb_strpos($markup_for_All_Suppliers, '.') ? mb_strpos($markup_for_All_Suppliers, '.') + 1 : mb_strlen($markup_for_All_Suppliers))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($markup_for_All_Suppliers, true), mb_strlen(mb_substr($markup_for_All_Suppliers, mb_strpos($markup_for_All_Suppliers, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($markup_for_All_Suppliers) && mb_strlen(preg_replace('/(\D)/', '', $markup_for_All_Suppliers)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($markup_for_All_Suppliers, true), mb_strlen(preg_replace('/(\D)/', '', $markup_for_All_Suppliers))), __LINE__);
        }
        $this->Markup_for_All_Suppliers = $markup_for_All_Suppliers;
        return $this;
    }
    /**
     * Get Supplier_List_Entry_Data value
     * @return \StructType\Supplier_List_Entry_DataType[]|null
     */
    public function getSupplier_List_Entry_Data()
    {
        return $this->Supplier_List_Entry_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_List_Entry_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_List_Entry_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_List_Entry_DataForArrayConstraintsFromSetSupplier_List_Entry_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $multi_Supplier_DataTypeSupplier_List_Entry_DataItem) {
            // validation for constraint: itemType
            if (!$multi_Supplier_DataTypeSupplier_List_Entry_DataItem instanceof \StructType\Supplier_List_Entry_DataType) {
                $invalidValues[] = is_object($multi_Supplier_DataTypeSupplier_List_Entry_DataItem) ? get_class($multi_Supplier_DataTypeSupplier_List_Entry_DataItem) : sprintf('%s(%s)', gettype($multi_Supplier_DataTypeSupplier_List_Entry_DataItem), var_export($multi_Supplier_DataTypeSupplier_List_Entry_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_List_Entry_Data property can only contain items of type \StructType\Supplier_List_Entry_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_List_Entry_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_List_Entry_DataType[] $supplier_List_Entry_Data
     * @return \StructType\Multi_Supplier_DataType
     */
    public function setSupplier_List_Entry_Data(array $supplier_List_Entry_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_List_Entry_DataArrayErrorMessage = self::validateSupplier_List_Entry_DataForArrayConstraintsFromSetSupplier_List_Entry_Data($supplier_List_Entry_Data))) {
            throw new \InvalidArgumentException($supplier_List_Entry_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_List_Entry_Data = $supplier_List_Entry_Data;
        return $this;
    }
    /**
     * Add item to Supplier_List_Entry_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_List_Entry_DataType $item
     * @return \StructType\Multi_Supplier_DataType
     */
    public function addToSupplier_List_Entry_Data(\StructType\Supplier_List_Entry_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_List_Entry_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_List_Entry_Data property can only contain items of type \StructType\Supplier_List_Entry_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_List_Entry_Data[] = $item;
        return $this;
    }
}
