<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Lot_Serial_Information_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element used to capture Lot Serial Information for a Goods Line on a Bill Only Purchase Order.
 * @subpackage Structs
 */
class Lot_Serial_Information_DataType extends AbstractStructBase
{
    /**
     * The Lot_Serial_Information_Reference
     * Meta information extracted from the WSDL
     * - documentation: Lot Serial Information Reference
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Lot_Serial_Information_Reference;
    /**
     * The Lot_Number
     * Meta information extracted from the WSDL
     * - documentation: Lot Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Lot_Number;
    /**
     * The Serial_Number
     * Meta information extracted from the WSDL
     * - documentation: Serial Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Serial_Number;
    /**
     * Constructor method for Lot_Serial_Information_DataType
     * @uses Lot_Serial_Information_DataType::setLot_Serial_Information_Reference()
     * @uses Lot_Serial_Information_DataType::setLot_Number()
     * @uses Lot_Serial_Information_DataType::setSerial_Number()
     * @param \StructType\Unique_IdentifierObjectType $lot_Serial_Information_Reference
     * @param string $lot_Number
     * @param string $serial_Number
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $lot_Serial_Information_Reference = null, $lot_Number = null, $serial_Number = null)
    {
        $this
            ->setLot_Serial_Information_Reference($lot_Serial_Information_Reference)
            ->setLot_Number($lot_Number)
            ->setSerial_Number($serial_Number);
    }
    /**
     * Get Lot_Serial_Information_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getLot_Serial_Information_Reference()
    {
        return $this->Lot_Serial_Information_Reference;
    }
    /**
     * Set Lot_Serial_Information_Reference value
     * @param \StructType\Unique_IdentifierObjectType $lot_Serial_Information_Reference
     * @return \StructType\Lot_Serial_Information_DataType
     */
    public function setLot_Serial_Information_Reference(\StructType\Unique_IdentifierObjectType $lot_Serial_Information_Reference = null)
    {
        $this->Lot_Serial_Information_Reference = $lot_Serial_Information_Reference;
        return $this;
    }
    /**
     * Get Lot_Number value
     * @return string|null
     */
    public function getLot_Number()
    {
        return $this->Lot_Number;
    }
    /**
     * Set Lot_Number value
     * @param string $lot_Number
     * @return \StructType\Lot_Serial_Information_DataType
     */
    public function setLot_Number($lot_Number = null)
    {
        // validation for constraint: string
        if (!is_null($lot_Number) && !is_string($lot_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lot_Number, true), gettype($lot_Number)), __LINE__);
        }
        $this->Lot_Number = $lot_Number;
        return $this;
    }
    /**
     * Get Serial_Number value
     * @return string|null
     */
    public function getSerial_Number()
    {
        return $this->Serial_Number;
    }
    /**
     * Set Serial_Number value
     * @param string $serial_Number
     * @return \StructType\Lot_Serial_Information_DataType
     */
    public function setSerial_Number($serial_Number = null)
    {
        // validation for constraint: string
        if (!is_null($serial_Number) && !is_string($serial_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serial_Number, true), gettype($serial_Number)), __LINE__);
        }
        $this->Serial_Number = $serial_Number;
        return $this;
    }
}
