<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Location_Customer_Account_Number_Detail_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing filter criteria for Location Customer Account Number Details.
 * @subpackage Structs
 */
class Location_Customer_Account_Number_Detail_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Suppliers.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Locations.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LocationObjectType[]
     */
    public $Location_Reference;
    /**
     * The Customer_Account_Number
     * Meta information extracted from the WSDL
     * - documentation: Location Customer Account Number | Customer Account Number.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Customer_Account_Number;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Location Customer Account Number is inactive or not.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for
     * Location_Customer_Account_Number_Detail_Request_CriteriaType
     * @uses Location_Customer_Account_Number_Detail_Request_CriteriaType::setSupplier_Reference()
     * @uses Location_Customer_Account_Number_Detail_Request_CriteriaType::setLocation_Reference()
     * @uses Location_Customer_Account_Number_Detail_Request_CriteriaType::setCustomer_Account_Number()
     * @uses Location_Customer_Account_Number_Detail_Request_CriteriaType::setInactive()
     * @param \StructType\SupplierObjectType[] $supplier_Reference
     * @param \StructType\LocationObjectType[] $location_Reference
     * @param string $customer_Account_Number
     * @param bool $inactive
     */
    public function __construct(array $supplier_Reference = array(), array $location_Reference = array(), $customer_Account_Number = null, $inactive = null)
    {
        $this
            ->setSupplier_Reference($supplier_Reference)
            ->setLocation_Reference($location_Reference)
            ->setCustomer_Account_Number($customer_Account_Number)
            ->setInactive($inactive);
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $location_Customer_Account_Number_Detail_Request_CriteriaTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$location_Customer_Account_Number_Detail_Request_CriteriaTypeSupplier_ReferenceItem instanceof \StructType\SupplierObjectType) {
                $invalidValues[] = is_object($location_Customer_Account_Number_Detail_Request_CriteriaTypeSupplier_ReferenceItem) ? get_class($location_Customer_Account_Number_Detail_Request_CriteriaTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($location_Customer_Account_Number_Detail_Request_CriteriaTypeSupplier_ReferenceItem), var_export($location_Customer_Account_Number_Detail_Request_CriteriaTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType[] $supplier_Reference
     * @return \StructType\Location_Customer_Account_Number_Detail_Request_CriteriaType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType $item
     * @return \StructType\Location_Customer_Account_Number_Detail_Request_CriteriaType
     */
    public function addToSupplier_Reference(\StructType\SupplierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\SupplierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Location_Reference value
     * @return \StructType\LocationObjectType[]|null
     */
    public function getLocation_Reference()
    {
        return $this->Location_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocation_ReferenceForArrayConstraintsFromSetLocation_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $location_Customer_Account_Number_Detail_Request_CriteriaTypeLocation_ReferenceItem) {
            // validation for constraint: itemType
            if (!$location_Customer_Account_Number_Detail_Request_CriteriaTypeLocation_ReferenceItem instanceof \StructType\LocationObjectType) {
                $invalidValues[] = is_object($location_Customer_Account_Number_Detail_Request_CriteriaTypeLocation_ReferenceItem) ? get_class($location_Customer_Account_Number_Detail_Request_CriteriaTypeLocation_ReferenceItem) : sprintf('%s(%s)', gettype($location_Customer_Account_Number_Detail_Request_CriteriaTypeLocation_ReferenceItem), var_export($location_Customer_Account_Number_Detail_Request_CriteriaTypeLocation_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Location_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType[] $location_Reference
     * @return \StructType\Location_Customer_Account_Number_Detail_Request_CriteriaType
     */
    public function setLocation_Reference(array $location_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($location_ReferenceArrayErrorMessage = self::validateLocation_ReferenceForArrayConstraintsFromSetLocation_Reference($location_Reference))) {
            throw new \InvalidArgumentException($location_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Location_Reference = $location_Reference;
        return $this;
    }
    /**
     * Add item to Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType $item
     * @return \StructType\Location_Customer_Account_Number_Detail_Request_CriteriaType
     */
    public function addToLocation_Reference(\StructType\LocationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Location_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Location_Reference[] = $item;
        return $this;
    }
    /**
     * Get Customer_Account_Number value
     * @return string|null
     */
    public function getCustomer_Account_Number()
    {
        return $this->Customer_Account_Number;
    }
    /**
     * Set Customer_Account_Number value
     * @param string $customer_Account_Number
     * @return \StructType\Location_Customer_Account_Number_Detail_Request_CriteriaType
     */
    public function setCustomer_Account_Number($customer_Account_Number = null)
    {
        // validation for constraint: string
        if (!is_null($customer_Account_Number) && !is_string($customer_Account_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customer_Account_Number, true), gettype($customer_Account_Number)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($customer_Account_Number) && mb_strlen($customer_Account_Number) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($customer_Account_Number)), __LINE__);
        }
        $this->Customer_Account_Number = $customer_Account_Number;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Location_Customer_Account_Number_Detail_Request_CriteriaType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
