<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item_Return_Line_Replacement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Combination of Stocking Location Reference, Unit of Measure Reference and Lot Reference should be unique for each Stocking Information Data. | You can't complete an Inventory return to Supplier when the return line contains splits. |
 * Enter a quantity that is equal to the total of all the Inventory Return line quantities. | The Unit Cost for Return Line must be greater than or equal to zero. | Enter a Quantity To Return that isn't greater than the quantity received minus the
 * quantity already returned for the selected company. | Sum of Split Amount does not equal total amount. | You can't return the goods when 1 or more associated PO lines are closed for receiving | The Quantity to Return must be greater than zero. |
 * Purchase Order Lines or Supplier Contract Lines can only be Return if they have an Approved Receipt. | Item Return Line Replacement Data
 * @subpackage Structs
 */
class Item_Return_Line_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Line associated with the Return Line. It must be for a goods item, or else an invalid instance error will occur.
     * - choice: Purchase_Order_Line_Reference | Supplier_Contract_Line_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Item_Order_LineObjectType
     */
    public $Purchase_Order_Line_Reference;
    /**
     * The Supplier_Contract_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Line associated with the Return Line. It must be for a goods item, or else an invalid instance error will occur.
     * - choice: Purchase_Order_Line_Reference | Supplier_Contract_Line_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Supplier_Contract_Item_LineObjectType
     */
    public $Supplier_Contract_Line_Reference;
    /**
     * The Quantity_to_Return
     * Meta information extracted from the WSDL
     * - documentation: Quantity to Return
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity_to_Return;
    /**
     * The Stocking_Information_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType[]
     */
    public $Stocking_Information_Data;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enter a valid UOM for this item. | Enter a valid Unit of Measure for the purchase item. This unit of measure is not defined for the supplier. | Only the unit of measure of the corresponding supplier contract line is valid. | The Unit
     * of Measure is invalid for the catalog item. Only defined ordering units of measure for the catalog item can be used. | Unit of measure for this return line
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Comment for Return Line
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Return_Line_Split_Data
     * Meta information extracted from the WSDL
     * - documentation: Splits for Return Line
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Submit_Return_Line_Split_DataType[]
     */
    public $Return_Line_Split_Data;
    /**
     * Constructor method for Item_Return_Line_Replacement_DataType
     * @uses Item_Return_Line_Replacement_DataType::setPurchase_Order_Line_Reference()
     * @uses Item_Return_Line_Replacement_DataType::setSupplier_Contract_Line_Reference()
     * @uses Item_Return_Line_Replacement_DataType::setQuantity_to_Return()
     * @uses Item_Return_Line_Replacement_DataType::setStocking_Information_Data()
     * @uses Item_Return_Line_Replacement_DataType::setUnit_of_Measure_Reference()
     * @uses Item_Return_Line_Replacement_DataType::setUnit_Cost()
     * @uses Item_Return_Line_Replacement_DataType::setMemo()
     * @uses Item_Return_Line_Replacement_DataType::setReturn_Line_Split_Data()
     * @param \StructType\Item_Order_LineObjectType $purchase_Order_Line_Reference
     * @param \StructType\Supplier_Contract_Item_LineObjectType $supplier_Contract_Line_Reference
     * @param float $quantity_to_Return
     * @param \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType[] $stocking_Information_Data
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $unit_Cost
     * @param string $memo
     * @param \StructType\Submit_Return_Line_Split_DataType[] $return_Line_Split_Data
     */
    public function __construct(\StructType\Item_Order_LineObjectType $purchase_Order_Line_Reference = null, \StructType\Supplier_Contract_Item_LineObjectType $supplier_Contract_Line_Reference = null, $quantity_to_Return = null, array $stocking_Information_Data = array(), \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $unit_Cost = null, $memo = null, array $return_Line_Split_Data = array())
    {
        $this
            ->setPurchase_Order_Line_Reference($purchase_Order_Line_Reference)
            ->setSupplier_Contract_Line_Reference($supplier_Contract_Line_Reference)
            ->setQuantity_to_Return($quantity_to_Return)
            ->setStocking_Information_Data($stocking_Information_Data)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setUnit_Cost($unit_Cost)
            ->setMemo($memo)
            ->setReturn_Line_Split_Data($return_Line_Split_Data);
    }
    /**
     * Get Purchase_Order_Line_Reference value
     * @return \StructType\Item_Order_LineObjectType|null
     */
    public function getPurchase_Order_Line_Reference()
    {
        return isset($this->Purchase_Order_Line_Reference) ? $this->Purchase_Order_Line_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPurchase_Order_Line_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Line_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePurchase_Order_Line_ReferenceForChoiceConstraintsFromSetPurchase_Order_Line_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Supplier_Contract_Line_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Purchase_Order_Line_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Purchase_Order_Line_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Purchase_Order_Line_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Order_LineObjectType $purchase_Order_Line_Reference
     * @return \StructType\Item_Return_Line_Replacement_DataType
     */
    public function setPurchase_Order_Line_Reference(\StructType\Item_Order_LineObjectType $purchase_Order_Line_Reference = null)
    {
        // validation for constraint: choice(Purchase_Order_Line_Reference, Supplier_Contract_Line_Reference)
        if ('' !== ($purchase_Order_Line_ReferenceChoiceErrorMessage = self::validatePurchase_Order_Line_ReferenceForChoiceConstraintsFromSetPurchase_Order_Line_Reference($purchase_Order_Line_Reference))) {
            throw new \InvalidArgumentException($purchase_Order_Line_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($purchase_Order_Line_Reference) || (is_array($purchase_Order_Line_Reference) && empty($purchase_Order_Line_Reference))) {
            unset($this->Purchase_Order_Line_Reference);
        } else {
            $this->Purchase_Order_Line_Reference = $purchase_Order_Line_Reference;
        }
        return $this;
    }
    /**
     * Get Supplier_Contract_Line_Reference value
     * @return \StructType\Supplier_Contract_Item_LineObjectType|null
     */
    public function getSupplier_Contract_Line_Reference()
    {
        return isset($this->Supplier_Contract_Line_Reference) ? $this->Supplier_Contract_Line_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSupplier_Contract_Line_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Contract_Line_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSupplier_Contract_Line_ReferenceForChoiceConstraintsFromSetSupplier_Contract_Line_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Purchase_Order_Line_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Supplier_Contract_Line_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Supplier_Contract_Line_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Supplier_Contract_Line_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Item_LineObjectType $supplier_Contract_Line_Reference
     * @return \StructType\Item_Return_Line_Replacement_DataType
     */
    public function setSupplier_Contract_Line_Reference(\StructType\Supplier_Contract_Item_LineObjectType $supplier_Contract_Line_Reference = null)
    {
        // validation for constraint: choice(Purchase_Order_Line_Reference, Supplier_Contract_Line_Reference)
        if ('' !== ($supplier_Contract_Line_ReferenceChoiceErrorMessage = self::validateSupplier_Contract_Line_ReferenceForChoiceConstraintsFromSetSupplier_Contract_Line_Reference($supplier_Contract_Line_Reference))) {
            throw new \InvalidArgumentException($supplier_Contract_Line_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($supplier_Contract_Line_Reference) || (is_array($supplier_Contract_Line_Reference) && empty($supplier_Contract_Line_Reference))) {
            unset($this->Supplier_Contract_Line_Reference);
        } else {
            $this->Supplier_Contract_Line_Reference = $supplier_Contract_Line_Reference;
        }
        return $this;
    }
    /**
     * Get Quantity_to_Return value
     * @return float|null
     */
    public function getQuantity_to_Return()
    {
        return $this->Quantity_to_Return;
    }
    /**
     * Set Quantity_to_Return value
     * @param float $quantity_to_Return
     * @return \StructType\Item_Return_Line_Replacement_DataType
     */
    public function setQuantity_to_Return($quantity_to_Return = null)
    {
        // validation for constraint: float
        if (!is_null($quantity_to_Return) && !(is_float($quantity_to_Return) || is_numeric($quantity_to_Return))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity_to_Return, true), gettype($quantity_to_Return)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity_to_Return) && mb_strlen(mb_substr($quantity_to_Return, false !== mb_strpos($quantity_to_Return, '.') ? mb_strpos($quantity_to_Return, '.') + 1 : mb_strlen($quantity_to_Return))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity_to_Return, true), mb_strlen(mb_substr($quantity_to_Return, mb_strpos($quantity_to_Return, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($quantity_to_Return) && $quantity_to_Return < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($quantity_to_Return, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity_to_Return) && mb_strlen(preg_replace('/(\D)/', '', $quantity_to_Return)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity_to_Return, true), mb_strlen(preg_replace('/(\D)/', '', $quantity_to_Return))), __LINE__);
        }
        $this->Quantity_to_Return = $quantity_to_Return;
        return $this;
    }
    /**
     * Get Stocking_Information_Data value
     * @return \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType[]|null
     */
    public function getStocking_Information_Data()
    {
        return $this->Stocking_Information_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setStocking_Information_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStocking_Information_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStocking_Information_DataForArrayConstraintsFromSetStocking_Information_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Return_Line_Replacement_DataTypeStocking_Information_DataItem) {
            // validation for constraint: itemType
            if (!$item_Return_Line_Replacement_DataTypeStocking_Information_DataItem instanceof \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType) {
                $invalidValues[] = is_object($item_Return_Line_Replacement_DataTypeStocking_Information_DataItem) ? get_class($item_Return_Line_Replacement_DataTypeStocking_Information_DataItem) : sprintf('%s(%s)', gettype($item_Return_Line_Replacement_DataTypeStocking_Information_DataItem), var_export($item_Return_Line_Replacement_DataTypeStocking_Information_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Stocking_Information_Data property can only contain items of type \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Stocking_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType[] $stocking_Information_Data
     * @return \StructType\Item_Return_Line_Replacement_DataType
     */
    public function setStocking_Information_Data(array $stocking_Information_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($stocking_Information_DataArrayErrorMessage = self::validateStocking_Information_DataForArrayConstraintsFromSetStocking_Information_Data($stocking_Information_Data))) {
            throw new \InvalidArgumentException($stocking_Information_DataArrayErrorMessage, __LINE__);
        }
        $this->Stocking_Information_Data = $stocking_Information_Data;
        return $this;
    }
    /**
     * Add item to Stocking_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType $item
     * @return \StructType\Item_Return_Line_Replacement_DataType
     */
    public function addToStocking_Information_Data(\StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType) {
            throw new \InvalidArgumentException(sprintf('The Stocking_Information_Data property can only contain items of type \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Stocking_Information_Data[] = $item;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Item_Return_Line_Replacement_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\Item_Return_Line_Replacement_DataType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Item_Return_Line_Replacement_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Return_Line_Split_Data value
     * @return \StructType\Submit_Return_Line_Split_DataType[]|null
     */
    public function getReturn_Line_Split_Data()
    {
        return $this->Return_Line_Split_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setReturn_Line_Split_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturn_Line_Split_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturn_Line_Split_DataForArrayConstraintsFromSetReturn_Line_Split_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Return_Line_Replacement_DataTypeReturn_Line_Split_DataItem) {
            // validation for constraint: itemType
            if (!$item_Return_Line_Replacement_DataTypeReturn_Line_Split_DataItem instanceof \StructType\Submit_Return_Line_Split_DataType) {
                $invalidValues[] = is_object($item_Return_Line_Replacement_DataTypeReturn_Line_Split_DataItem) ? get_class($item_Return_Line_Replacement_DataTypeReturn_Line_Split_DataItem) : sprintf('%s(%s)', gettype($item_Return_Line_Replacement_DataTypeReturn_Line_Split_DataItem), var_export($item_Return_Line_Replacement_DataTypeReturn_Line_Split_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Return_Line_Split_Data property can only contain items of type \StructType\Submit_Return_Line_Split_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Return_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Submit_Return_Line_Split_DataType[] $return_Line_Split_Data
     * @return \StructType\Item_Return_Line_Replacement_DataType
     */
    public function setReturn_Line_Split_Data(array $return_Line_Split_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($return_Line_Split_DataArrayErrorMessage = self::validateReturn_Line_Split_DataForArrayConstraintsFromSetReturn_Line_Split_Data($return_Line_Split_Data))) {
            throw new \InvalidArgumentException($return_Line_Split_DataArrayErrorMessage, __LINE__);
        }
        $this->Return_Line_Split_Data = $return_Line_Split_Data;
        return $this;
    }
    /**
     * Add item to Return_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Submit_Return_Line_Split_DataType $item
     * @return \StructType\Item_Return_Line_Replacement_DataType
     */
    public function addToReturn_Line_Split_Data(\StructType\Submit_Return_Line_Split_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Submit_Return_Line_Split_DataType) {
            throw new \InvalidArgumentException(sprintf('The Return_Line_Split_Data property can only contain items of type \StructType\Submit_Return_Line_Split_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Return_Line_Split_Data[] = $item;
        return $this;
    }
}
