<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item_Receipt_Line_Replacement_Lot_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Receipt Line Item Lot Quantity Data
 * @subpackage Structs
 */
class Item_Receipt_Line_Replacement_Lot_DataType extends AbstractStructBase
{
    /**
     * The Lot_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Lot Quantity for Lot Control Item
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Lot_Quantity;
    /**
     * The Item_Lot_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enter Lot for Lot Control Item
     * - minOccurs: 0
     * @var \StructType\Item_LotObjectType
     */
    public $Item_Lot_Reference;
    /**
     * The Item_Receipt_Line_Replacement_Serial_Data
     * Meta information extracted from the WSDL
     * - documentation: Item Receipt Line Replacement Serial Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_Receipt_Line_Replacement_Serial_DataType[]
     */
    public $Item_Receipt_Line_Replacement_Serial_Data;
    /**
     * Constructor method for Item_Receipt_Line_Replacement_Lot_DataType
     * @uses Item_Receipt_Line_Replacement_Lot_DataType::setLot_Quantity()
     * @uses Item_Receipt_Line_Replacement_Lot_DataType::setItem_Lot_Reference()
     * @uses Item_Receipt_Line_Replacement_Lot_DataType::setItem_Receipt_Line_Replacement_Serial_Data()
     * @param float $lot_Quantity
     * @param \StructType\Item_LotObjectType $item_Lot_Reference
     * @param \StructType\Item_Receipt_Line_Replacement_Serial_DataType[] $item_Receipt_Line_Replacement_Serial_Data
     */
    public function __construct($lot_Quantity = null, \StructType\Item_LotObjectType $item_Lot_Reference = null, array $item_Receipt_Line_Replacement_Serial_Data = array())
    {
        $this
            ->setLot_Quantity($lot_Quantity)
            ->setItem_Lot_Reference($item_Lot_Reference)
            ->setItem_Receipt_Line_Replacement_Serial_Data($item_Receipt_Line_Replacement_Serial_Data);
    }
    /**
     * Get Lot_Quantity value
     * @return float|null
     */
    public function getLot_Quantity()
    {
        return $this->Lot_Quantity;
    }
    /**
     * Set Lot_Quantity value
     * @param float $lot_Quantity
     * @return \StructType\Item_Receipt_Line_Replacement_Lot_DataType
     */
    public function setLot_Quantity($lot_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($lot_Quantity) && !(is_float($lot_Quantity) || is_numeric($lot_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lot_Quantity, true), gettype($lot_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($lot_Quantity) && mb_strlen(mb_substr($lot_Quantity, false !== mb_strpos($lot_Quantity, '.') ? mb_strpos($lot_Quantity, '.') + 1 : mb_strlen($lot_Quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($lot_Quantity, true), mb_strlen(mb_substr($lot_Quantity, mb_strpos($lot_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($lot_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $lot_Quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($lot_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $lot_Quantity))), __LINE__);
        }
        $this->Lot_Quantity = $lot_Quantity;
        return $this;
    }
    /**
     * Get Item_Lot_Reference value
     * @return \StructType\Item_LotObjectType|null
     */
    public function getItem_Lot_Reference()
    {
        return $this->Item_Lot_Reference;
    }
    /**
     * Set Item_Lot_Reference value
     * @param \StructType\Item_LotObjectType $item_Lot_Reference
     * @return \StructType\Item_Receipt_Line_Replacement_Lot_DataType
     */
    public function setItem_Lot_Reference(\StructType\Item_LotObjectType $item_Lot_Reference = null)
    {
        $this->Item_Lot_Reference = $item_Lot_Reference;
        return $this;
    }
    /**
     * Get Item_Receipt_Line_Replacement_Serial_Data value
     * @return \StructType\Item_Receipt_Line_Replacement_Serial_DataType[]|null
     */
    public function getItem_Receipt_Line_Replacement_Serial_Data()
    {
        return $this->Item_Receipt_Line_Replacement_Serial_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Receipt_Line_Replacement_Serial_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Receipt_Line_Replacement_Serial_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Receipt_Line_Replacement_Serial_DataForArrayConstraintsFromSetItem_Receipt_Line_Replacement_Serial_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Receipt_Line_Replacement_Lot_DataTypeItem_Receipt_Line_Replacement_Serial_DataItem) {
            // validation for constraint: itemType
            if (!$item_Receipt_Line_Replacement_Lot_DataTypeItem_Receipt_Line_Replacement_Serial_DataItem instanceof \StructType\Item_Receipt_Line_Replacement_Serial_DataType) {
                $invalidValues[] = is_object($item_Receipt_Line_Replacement_Lot_DataTypeItem_Receipt_Line_Replacement_Serial_DataItem) ? get_class($item_Receipt_Line_Replacement_Lot_DataTypeItem_Receipt_Line_Replacement_Serial_DataItem) : sprintf('%s(%s)', gettype($item_Receipt_Line_Replacement_Lot_DataTypeItem_Receipt_Line_Replacement_Serial_DataItem), var_export($item_Receipt_Line_Replacement_Lot_DataTypeItem_Receipt_Line_Replacement_Serial_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Receipt_Line_Replacement_Serial_Data property can only contain items of type \StructType\Item_Receipt_Line_Replacement_Serial_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Receipt_Line_Replacement_Serial_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Receipt_Line_Replacement_Serial_DataType[] $item_Receipt_Line_Replacement_Serial_Data
     * @return \StructType\Item_Receipt_Line_Replacement_Lot_DataType
     */
    public function setItem_Receipt_Line_Replacement_Serial_Data(array $item_Receipt_Line_Replacement_Serial_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Receipt_Line_Replacement_Serial_DataArrayErrorMessage = self::validateItem_Receipt_Line_Replacement_Serial_DataForArrayConstraintsFromSetItem_Receipt_Line_Replacement_Serial_Data($item_Receipt_Line_Replacement_Serial_Data))) {
            throw new \InvalidArgumentException($item_Receipt_Line_Replacement_Serial_DataArrayErrorMessage, __LINE__);
        }
        $this->Item_Receipt_Line_Replacement_Serial_Data = $item_Receipt_Line_Replacement_Serial_Data;
        return $this;
    }
    /**
     * Add item to Item_Receipt_Line_Replacement_Serial_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Receipt_Line_Replacement_Serial_DataType $item
     * @return \StructType\Item_Receipt_Line_Replacement_Lot_DataType
     */
    public function addToItem_Receipt_Line_Replacement_Serial_Data(\StructType\Item_Receipt_Line_Replacement_Serial_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_Receipt_Line_Replacement_Serial_DataType) {
            throw new \InvalidArgumentException(sprintf('The Item_Receipt_Line_Replacement_Serial_Data property can only contain items of type \StructType\Item_Receipt_Line_Replacement_Serial_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Receipt_Line_Replacement_Serial_Data[] = $item;
        return $this;
    }
}
