<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item_Inventory_Attributes_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Inventory specific attributes for the purchase item.
 * @subpackage Structs
 */
class Item_Inventory_Attributes_DataType extends AbstractStructBase
{
    /**
     * The Inventory_Site_Reference
     * Meta information extracted from the WSDL
     * - documentation: Inventory Site for the attributes. Only one set of attributes are allowed per site/item combination.
     * @var \StructType\LocationObjectType
     */
    public $Inventory_Site_Reference;
    /**
     * The Preferred_Picking_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Preferred Picking Location for this Site for the purchase item.
     * - minOccurs: 0
     * @var \StructType\Inventory_Location_EnabledObjectType
     */
    public $Preferred_Picking_Location_Reference;
    /**
     * The Item_Status_for_Site_Reference
     * Meta information extracted from the WSDL
     * - documentation: Spend Item Status for Item Inventory Site.Active: Available for spend transactions for this inventory site.Restricted from Purchasing: Item can't be added to purchase orders for this inventory site. This site can still fulfill
     * requisitions for this item from available stock.Inactive: Item no longer available for use for this inventory site.
     * - minOccurs: 0
     * @var \StructType\Spend_Item_StatusObjectType
     */
    public $Item_Status_for_Site_Reference;
    /**
     * The Just_In_Time
     * Meta information extracted from the WSDL
     * - documentation: Indicates if Item-Site is using Just In Time replenishment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Just_In_Time;
    /**
     * The Use_Reservations
     * Meta information extracted from the WSDL
     * - documentation: Item level Reservation Flag. Can only be changed if reservations are enabled for the site. Can be used to disable reservations for an item belonging to a site which uses reservations.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Reservations;
    /**
     * The Site_Default_Stocking_Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Default Stocking Unit of Measure Reference
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Site_Default_Stocking_Unit_of_Measure_Reference;
    /**
     * The Valid_Issue_Units_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: References a list of valid issue units of measure
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType[]
     */
    public $Valid_Issue_Units_of_Measure_Reference;
    /**
     * The Site_Default_Issue_Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: References the default issue unit of measure associated with the item/inventory site. It is required if a list of valid issue units of measure is provided.
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Site_Default_Issue_Unit_of_Measure_Reference;
    /**
     * The Default_Stocking_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Default Stocking Location for this Site for the purchase item.
     * - minOccurs: 0
     * @var \StructType\Inventory_Location_EnabledObjectType
     */
    public $Default_Stocking_Location_Reference;
    /**
     * The Fulfillment_Attributes_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Fulfillment_Attributes_DataType
     */
    public $Fulfillment_Attributes_Data;
    /**
     * The Replenishment_Policy_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Replenishment_Policy_DataType
     */
    public $Replenishment_Policy_Data;
    /**
     * The Counting_Attributes_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Counting_Attributes_DataType
     */
    public $Counting_Attributes_Data;
    /**
     * The Patient_Chargeable_Reference
     * Meta information extracted from the WSDL
     * - documentation: Patient Chargeable flag. This will be enabled only if Enable Healthcare Option is turned ON at the Edit Tenant Setup- Financials.
     * - minOccurs: 0
     * @var \StructType\Patient_ChargeObjectType
     */
    public $Patient_Chargeable_Reference;
    /**
     * The Replenishment_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Replenishment Option for this Item/Site combination
     * - minOccurs: 0
     * @var \StructType\Replenishment_OptionObjectType
     */
    public $Replenishment_Option_Reference;
    /**
     * The Source_Site_Reference
     * Meta information extracted from the WSDL
     * - documentation: Replenishment Source Site for this Item/Site combination
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Source_Site_Reference;
    /**
     * The Source_Requisition_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Replenishment Source Requisition Company for this Item/Site combination
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Source_Requisition_Company_Reference;
    /**
     * The Consigned_Reorder_Option_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Consigned Reorder Option Type for Purchase Item and Inventory Site Combination
     * - minOccurs: 0
     * @var \StructType\Consigned_Reorder_InitiationObjectType
     */
    public $Consigned_Reorder_Option_Type_Reference;
    /**
     * The Default_Consigned_Stocking_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Sets the default consigned stocking location for an item in a particular site.
     * - minOccurs: 0
     * @var \StructType\Inventory_Location_EnabledObjectType
     */
    public $Default_Consigned_Stocking_Location_Reference;
    /**
     * Constructor method for Item_Inventory_Attributes_DataType
     * @uses Item_Inventory_Attributes_DataType::setInventory_Site_Reference()
     * @uses Item_Inventory_Attributes_DataType::setPreferred_Picking_Location_Reference()
     * @uses Item_Inventory_Attributes_DataType::setItem_Status_for_Site_Reference()
     * @uses Item_Inventory_Attributes_DataType::setJust_In_Time()
     * @uses Item_Inventory_Attributes_DataType::setUse_Reservations()
     * @uses Item_Inventory_Attributes_DataType::setSite_Default_Stocking_Unit_of_Measure_Reference()
     * @uses Item_Inventory_Attributes_DataType::setValid_Issue_Units_of_Measure_Reference()
     * @uses Item_Inventory_Attributes_DataType::setSite_Default_Issue_Unit_of_Measure_Reference()
     * @uses Item_Inventory_Attributes_DataType::setDefault_Stocking_Location_Reference()
     * @uses Item_Inventory_Attributes_DataType::setFulfillment_Attributes_Data()
     * @uses Item_Inventory_Attributes_DataType::setReplenishment_Policy_Data()
     * @uses Item_Inventory_Attributes_DataType::setCounting_Attributes_Data()
     * @uses Item_Inventory_Attributes_DataType::setPatient_Chargeable_Reference()
     * @uses Item_Inventory_Attributes_DataType::setReplenishment_Option_Reference()
     * @uses Item_Inventory_Attributes_DataType::setSource_Site_Reference()
     * @uses Item_Inventory_Attributes_DataType::setSource_Requisition_Company_Reference()
     * @uses Item_Inventory_Attributes_DataType::setConsigned_Reorder_Option_Type_Reference()
     * @uses Item_Inventory_Attributes_DataType::setDefault_Consigned_Stocking_Location_Reference()
     * @param \StructType\LocationObjectType $inventory_Site_Reference
     * @param \StructType\Inventory_Location_EnabledObjectType $preferred_Picking_Location_Reference
     * @param \StructType\Spend_Item_StatusObjectType $item_Status_for_Site_Reference
     * @param bool $just_In_Time
     * @param bool $use_Reservations
     * @param \StructType\Unit_of_MeasureObjectType $site_Default_Stocking_Unit_of_Measure_Reference
     * @param \StructType\Unit_of_MeasureObjectType[] $valid_Issue_Units_of_Measure_Reference
     * @param \StructType\Unit_of_MeasureObjectType $site_Default_Issue_Unit_of_Measure_Reference
     * @param \StructType\Inventory_Location_EnabledObjectType $default_Stocking_Location_Reference
     * @param \StructType\Fulfillment_Attributes_DataType $fulfillment_Attributes_Data
     * @param \StructType\Replenishment_Policy_DataType $replenishment_Policy_Data
     * @param \StructType\Counting_Attributes_DataType $counting_Attributes_Data
     * @param \StructType\Patient_ChargeObjectType $patient_Chargeable_Reference
     * @param \StructType\Replenishment_OptionObjectType $replenishment_Option_Reference
     * @param \StructType\LocationObjectType $source_Site_Reference
     * @param \StructType\CompanyObjectType $source_Requisition_Company_Reference
     * @param \StructType\Consigned_Reorder_InitiationObjectType $consigned_Reorder_Option_Type_Reference
     * @param \StructType\Inventory_Location_EnabledObjectType $default_Consigned_Stocking_Location_Reference
     */
    public function __construct(\StructType\LocationObjectType $inventory_Site_Reference = null, \StructType\Inventory_Location_EnabledObjectType $preferred_Picking_Location_Reference = null, \StructType\Spend_Item_StatusObjectType $item_Status_for_Site_Reference = null, $just_In_Time = null, $use_Reservations = null, \StructType\Unit_of_MeasureObjectType $site_Default_Stocking_Unit_of_Measure_Reference = null, array $valid_Issue_Units_of_Measure_Reference = array(), \StructType\Unit_of_MeasureObjectType $site_Default_Issue_Unit_of_Measure_Reference = null, \StructType\Inventory_Location_EnabledObjectType $default_Stocking_Location_Reference = null, \StructType\Fulfillment_Attributes_DataType $fulfillment_Attributes_Data = null, \StructType\Replenishment_Policy_DataType $replenishment_Policy_Data = null, \StructType\Counting_Attributes_DataType $counting_Attributes_Data = null, \StructType\Patient_ChargeObjectType $patient_Chargeable_Reference = null, \StructType\Replenishment_OptionObjectType $replenishment_Option_Reference = null, \StructType\LocationObjectType $source_Site_Reference = null, \StructType\CompanyObjectType $source_Requisition_Company_Reference = null, \StructType\Consigned_Reorder_InitiationObjectType $consigned_Reorder_Option_Type_Reference = null, \StructType\Inventory_Location_EnabledObjectType $default_Consigned_Stocking_Location_Reference = null)
    {
        $this
            ->setInventory_Site_Reference($inventory_Site_Reference)
            ->setPreferred_Picking_Location_Reference($preferred_Picking_Location_Reference)
            ->setItem_Status_for_Site_Reference($item_Status_for_Site_Reference)
            ->setJust_In_Time($just_In_Time)
            ->setUse_Reservations($use_Reservations)
            ->setSite_Default_Stocking_Unit_of_Measure_Reference($site_Default_Stocking_Unit_of_Measure_Reference)
            ->setValid_Issue_Units_of_Measure_Reference($valid_Issue_Units_of_Measure_Reference)
            ->setSite_Default_Issue_Unit_of_Measure_Reference($site_Default_Issue_Unit_of_Measure_Reference)
            ->setDefault_Stocking_Location_Reference($default_Stocking_Location_Reference)
            ->setFulfillment_Attributes_Data($fulfillment_Attributes_Data)
            ->setReplenishment_Policy_Data($replenishment_Policy_Data)
            ->setCounting_Attributes_Data($counting_Attributes_Data)
            ->setPatient_Chargeable_Reference($patient_Chargeable_Reference)
            ->setReplenishment_Option_Reference($replenishment_Option_Reference)
            ->setSource_Site_Reference($source_Site_Reference)
            ->setSource_Requisition_Company_Reference($source_Requisition_Company_Reference)
            ->setConsigned_Reorder_Option_Type_Reference($consigned_Reorder_Option_Type_Reference)
            ->setDefault_Consigned_Stocking_Location_Reference($default_Consigned_Stocking_Location_Reference);
    }
    /**
     * Get Inventory_Site_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getInventory_Site_Reference()
    {
        return $this->Inventory_Site_Reference;
    }
    /**
     * Set Inventory_Site_Reference value
     * @param \StructType\LocationObjectType $inventory_Site_Reference
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function setInventory_Site_Reference(\StructType\LocationObjectType $inventory_Site_Reference = null)
    {
        $this->Inventory_Site_Reference = $inventory_Site_Reference;
        return $this;
    }
    /**
     * Get Preferred_Picking_Location_Reference value
     * @return \StructType\Inventory_Location_EnabledObjectType|null
     */
    public function getPreferred_Picking_Location_Reference()
    {
        return $this->Preferred_Picking_Location_Reference;
    }
    /**
     * Set Preferred_Picking_Location_Reference value
     * @param \StructType\Inventory_Location_EnabledObjectType $preferred_Picking_Location_Reference
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function setPreferred_Picking_Location_Reference(\StructType\Inventory_Location_EnabledObjectType $preferred_Picking_Location_Reference = null)
    {
        $this->Preferred_Picking_Location_Reference = $preferred_Picking_Location_Reference;
        return $this;
    }
    /**
     * Get Item_Status_for_Site_Reference value
     * @return \StructType\Spend_Item_StatusObjectType|null
     */
    public function getItem_Status_for_Site_Reference()
    {
        return $this->Item_Status_for_Site_Reference;
    }
    /**
     * Set Item_Status_for_Site_Reference value
     * @param \StructType\Spend_Item_StatusObjectType $item_Status_for_Site_Reference
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function setItem_Status_for_Site_Reference(\StructType\Spend_Item_StatusObjectType $item_Status_for_Site_Reference = null)
    {
        $this->Item_Status_for_Site_Reference = $item_Status_for_Site_Reference;
        return $this;
    }
    /**
     * Get Just_In_Time value
     * @return bool|null
     */
    public function getJust_In_Time()
    {
        return $this->Just_In_Time;
    }
    /**
     * Set Just_In_Time value
     * @param bool $just_In_Time
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function setJust_In_Time($just_In_Time = null)
    {
        // validation for constraint: boolean
        if (!is_null($just_In_Time) && !is_bool($just_In_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($just_In_Time, true), gettype($just_In_Time)), __LINE__);
        }
        $this->Just_In_Time = $just_In_Time;
        return $this;
    }
    /**
     * Get Use_Reservations value
     * @return bool|null
     */
    public function getUse_Reservations()
    {
        return $this->Use_Reservations;
    }
    /**
     * Set Use_Reservations value
     * @param bool $use_Reservations
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function setUse_Reservations($use_Reservations = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Reservations) && !is_bool($use_Reservations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Reservations, true), gettype($use_Reservations)), __LINE__);
        }
        $this->Use_Reservations = $use_Reservations;
        return $this;
    }
    /**
     * Get Site_Default_Stocking_Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getSite_Default_Stocking_Unit_of_Measure_Reference()
    {
        return $this->Site_Default_Stocking_Unit_of_Measure_Reference;
    }
    /**
     * Set Site_Default_Stocking_Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $site_Default_Stocking_Unit_of_Measure_Reference
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function setSite_Default_Stocking_Unit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $site_Default_Stocking_Unit_of_Measure_Reference = null)
    {
        $this->Site_Default_Stocking_Unit_of_Measure_Reference = $site_Default_Stocking_Unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Valid_Issue_Units_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType[]|null
     */
    public function getValid_Issue_Units_of_Measure_Reference()
    {
        return $this->Valid_Issue_Units_of_Measure_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setValid_Issue_Units_of_Measure_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValid_Issue_Units_of_Measure_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValid_Issue_Units_of_Measure_ReferenceForArrayConstraintsFromSetValid_Issue_Units_of_Measure_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Inventory_Attributes_DataTypeValid_Issue_Units_of_Measure_ReferenceItem) {
            // validation for constraint: itemType
            if (!$item_Inventory_Attributes_DataTypeValid_Issue_Units_of_Measure_ReferenceItem instanceof \StructType\Unit_of_MeasureObjectType) {
                $invalidValues[] = is_object($item_Inventory_Attributes_DataTypeValid_Issue_Units_of_Measure_ReferenceItem) ? get_class($item_Inventory_Attributes_DataTypeValid_Issue_Units_of_Measure_ReferenceItem) : sprintf('%s(%s)', gettype($item_Inventory_Attributes_DataTypeValid_Issue_Units_of_Measure_ReferenceItem), var_export($item_Inventory_Attributes_DataTypeValid_Issue_Units_of_Measure_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Valid_Issue_Units_of_Measure_Reference property can only contain items of type \StructType\Unit_of_MeasureObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Valid_Issue_Units_of_Measure_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unit_of_MeasureObjectType[] $valid_Issue_Units_of_Measure_Reference
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function setValid_Issue_Units_of_Measure_Reference(array $valid_Issue_Units_of_Measure_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($valid_Issue_Units_of_Measure_ReferenceArrayErrorMessage = self::validateValid_Issue_Units_of_Measure_ReferenceForArrayConstraintsFromSetValid_Issue_Units_of_Measure_Reference($valid_Issue_Units_of_Measure_Reference))) {
            throw new \InvalidArgumentException($valid_Issue_Units_of_Measure_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Valid_Issue_Units_of_Measure_Reference = $valid_Issue_Units_of_Measure_Reference;
        return $this;
    }
    /**
     * Add item to Valid_Issue_Units_of_Measure_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unit_of_MeasureObjectType $item
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function addToValid_Issue_Units_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unit_of_MeasureObjectType) {
            throw new \InvalidArgumentException(sprintf('The Valid_Issue_Units_of_Measure_Reference property can only contain items of type \StructType\Unit_of_MeasureObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Valid_Issue_Units_of_Measure_Reference[] = $item;
        return $this;
    }
    /**
     * Get Site_Default_Issue_Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getSite_Default_Issue_Unit_of_Measure_Reference()
    {
        return $this->Site_Default_Issue_Unit_of_Measure_Reference;
    }
    /**
     * Set Site_Default_Issue_Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $site_Default_Issue_Unit_of_Measure_Reference
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function setSite_Default_Issue_Unit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $site_Default_Issue_Unit_of_Measure_Reference = null)
    {
        $this->Site_Default_Issue_Unit_of_Measure_Reference = $site_Default_Issue_Unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Default_Stocking_Location_Reference value
     * @return \StructType\Inventory_Location_EnabledObjectType|null
     */
    public function getDefault_Stocking_Location_Reference()
    {
        return $this->Default_Stocking_Location_Reference;
    }
    /**
     * Set Default_Stocking_Location_Reference value
     * @param \StructType\Inventory_Location_EnabledObjectType $default_Stocking_Location_Reference
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function setDefault_Stocking_Location_Reference(\StructType\Inventory_Location_EnabledObjectType $default_Stocking_Location_Reference = null)
    {
        $this->Default_Stocking_Location_Reference = $default_Stocking_Location_Reference;
        return $this;
    }
    /**
     * Get Fulfillment_Attributes_Data value
     * @return \StructType\Fulfillment_Attributes_DataType|null
     */
    public function getFulfillment_Attributes_Data()
    {
        return $this->Fulfillment_Attributes_Data;
    }
    /**
     * Set Fulfillment_Attributes_Data value
     * @param \StructType\Fulfillment_Attributes_DataType $fulfillment_Attributes_Data
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function setFulfillment_Attributes_Data(\StructType\Fulfillment_Attributes_DataType $fulfillment_Attributes_Data = null)
    {
        $this->Fulfillment_Attributes_Data = $fulfillment_Attributes_Data;
        return $this;
    }
    /**
     * Get Replenishment_Policy_Data value
     * @return \StructType\Replenishment_Policy_DataType|null
     */
    public function getReplenishment_Policy_Data()
    {
        return $this->Replenishment_Policy_Data;
    }
    /**
     * Set Replenishment_Policy_Data value
     * @param \StructType\Replenishment_Policy_DataType $replenishment_Policy_Data
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function setReplenishment_Policy_Data(\StructType\Replenishment_Policy_DataType $replenishment_Policy_Data = null)
    {
        $this->Replenishment_Policy_Data = $replenishment_Policy_Data;
        return $this;
    }
    /**
     * Get Counting_Attributes_Data value
     * @return \StructType\Counting_Attributes_DataType|null
     */
    public function getCounting_Attributes_Data()
    {
        return $this->Counting_Attributes_Data;
    }
    /**
     * Set Counting_Attributes_Data value
     * @param \StructType\Counting_Attributes_DataType $counting_Attributes_Data
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function setCounting_Attributes_Data(\StructType\Counting_Attributes_DataType $counting_Attributes_Data = null)
    {
        $this->Counting_Attributes_Data = $counting_Attributes_Data;
        return $this;
    }
    /**
     * Get Patient_Chargeable_Reference value
     * @return \StructType\Patient_ChargeObjectType|null
     */
    public function getPatient_Chargeable_Reference()
    {
        return $this->Patient_Chargeable_Reference;
    }
    /**
     * Set Patient_Chargeable_Reference value
     * @param \StructType\Patient_ChargeObjectType $patient_Chargeable_Reference
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function setPatient_Chargeable_Reference(\StructType\Patient_ChargeObjectType $patient_Chargeable_Reference = null)
    {
        $this->Patient_Chargeable_Reference = $patient_Chargeable_Reference;
        return $this;
    }
    /**
     * Get Replenishment_Option_Reference value
     * @return \StructType\Replenishment_OptionObjectType|null
     */
    public function getReplenishment_Option_Reference()
    {
        return $this->Replenishment_Option_Reference;
    }
    /**
     * Set Replenishment_Option_Reference value
     * @param \StructType\Replenishment_OptionObjectType $replenishment_Option_Reference
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function setReplenishment_Option_Reference(\StructType\Replenishment_OptionObjectType $replenishment_Option_Reference = null)
    {
        $this->Replenishment_Option_Reference = $replenishment_Option_Reference;
        return $this;
    }
    /**
     * Get Source_Site_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getSource_Site_Reference()
    {
        return $this->Source_Site_Reference;
    }
    /**
     * Set Source_Site_Reference value
     * @param \StructType\LocationObjectType $source_Site_Reference
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function setSource_Site_Reference(\StructType\LocationObjectType $source_Site_Reference = null)
    {
        $this->Source_Site_Reference = $source_Site_Reference;
        return $this;
    }
    /**
     * Get Source_Requisition_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getSource_Requisition_Company_Reference()
    {
        return $this->Source_Requisition_Company_Reference;
    }
    /**
     * Set Source_Requisition_Company_Reference value
     * @param \StructType\CompanyObjectType $source_Requisition_Company_Reference
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function setSource_Requisition_Company_Reference(\StructType\CompanyObjectType $source_Requisition_Company_Reference = null)
    {
        $this->Source_Requisition_Company_Reference = $source_Requisition_Company_Reference;
        return $this;
    }
    /**
     * Get Consigned_Reorder_Option_Type_Reference value
     * @return \StructType\Consigned_Reorder_InitiationObjectType|null
     */
    public function getConsigned_Reorder_Option_Type_Reference()
    {
        return $this->Consigned_Reorder_Option_Type_Reference;
    }
    /**
     * Set Consigned_Reorder_Option_Type_Reference value
     * @param \StructType\Consigned_Reorder_InitiationObjectType $consigned_Reorder_Option_Type_Reference
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function setConsigned_Reorder_Option_Type_Reference(\StructType\Consigned_Reorder_InitiationObjectType $consigned_Reorder_Option_Type_Reference = null)
    {
        $this->Consigned_Reorder_Option_Type_Reference = $consigned_Reorder_Option_Type_Reference;
        return $this;
    }
    /**
     * Get Default_Consigned_Stocking_Location_Reference value
     * @return \StructType\Inventory_Location_EnabledObjectType|null
     */
    public function getDefault_Consigned_Stocking_Location_Reference()
    {
        return $this->Default_Consigned_Stocking_Location_Reference;
    }
    /**
     * Set Default_Consigned_Stocking_Location_Reference value
     * @param \StructType\Inventory_Location_EnabledObjectType $default_Consigned_Stocking_Location_Reference
     * @return \StructType\Item_Inventory_Attributes_DataType
     */
    public function setDefault_Consigned_Stocking_Location_Reference(\StructType\Inventory_Location_EnabledObjectType $default_Consigned_Stocking_Location_Reference = null)
    {
        $this->Default_Consigned_Stocking_Location_Reference = $default_Consigned_Stocking_Location_Reference;
        return $this;
    }
}
