<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Inventory_Location_EnabledObjectType StructType
 * @subpackage Structs
 */
class Inventory_Location_EnabledObjectType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Inventory_Location_EnabledObjectIDType[]
     */
    public $ID;
    /**
     * The Descriptor
     * Meta information extracted from the WSDL
     * - documentation: Display information used to describe an instance of an object. This 'optional' information is for outbound descriptive purposes only and is not processed on inbound Workday Web Services requests.
     * @var string
     */
    public $Descriptor;
    /**
     * Constructor method for Inventory_Location_EnabledObjectType
     * @uses Inventory_Location_EnabledObjectType::setID()
     * @uses Inventory_Location_EnabledObjectType::setDescriptor()
     * @param \StructType\Inventory_Location_EnabledObjectIDType[] $iD
     * @param string $descriptor
     */
    public function __construct(array $iD = array(), $descriptor = null)
    {
        $this
            ->setID($iD)
            ->setDescriptor($descriptor);
    }
    /**
     * Get ID value
     * @return \StructType\Inventory_Location_EnabledObjectIDType[]|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * This method is responsible for validating the values passed to the setID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIDForArrayConstraintsFromSetID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $inventory_Location_EnabledObjectTypeIDItem) {
            // validation for constraint: itemType
            if (!$inventory_Location_EnabledObjectTypeIDItem instanceof \StructType\Inventory_Location_EnabledObjectIDType) {
                $invalidValues[] = is_object($inventory_Location_EnabledObjectTypeIDItem) ? get_class($inventory_Location_EnabledObjectTypeIDItem) : sprintf('%s(%s)', gettype($inventory_Location_EnabledObjectTypeIDItem), var_export($inventory_Location_EnabledObjectTypeIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ID property can only contain items of type \StructType\Inventory_Location_EnabledObjectIDType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Inventory_Location_EnabledObjectIDType[] $iD
     * @return \StructType\Inventory_Location_EnabledObjectType
     */
    public function setID(array $iD = array())
    {
        // validation for constraint: array
        if ('' !== ($iDArrayErrorMessage = self::validateIDForArrayConstraintsFromSetID($iD))) {
            throw new \InvalidArgumentException($iDArrayErrorMessage, __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Add item to ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Inventory_Location_EnabledObjectIDType $item
     * @return \StructType\Inventory_Location_EnabledObjectType
     */
    public function addToID(\StructType\Inventory_Location_EnabledObjectIDType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Inventory_Location_EnabledObjectIDType) {
            throw new \InvalidArgumentException(sprintf('The ID property can only contain items of type \StructType\Inventory_Location_EnabledObjectIDType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ID[] = $item;
        return $this;
    }
    /**
     * Get Descriptor value
     * @return string|null
     */
    public function getDescriptor()
    {
        return $this->Descriptor;
    }
    /**
     * Set Descriptor value
     * @param string $descriptor
     * @return \StructType\Inventory_Location_EnabledObjectType
     */
    public function setDescriptor($descriptor = null)
    {
        // validation for constraint: string
        if (!is_null($descriptor) && !is_string($descriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptor, true), gettype($descriptor)), __LINE__);
        }
        $this->Descriptor = $descriptor;
        return $this;
    }
}
