<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Internal_Catalog_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing the criteria for retrieving Internal Catalogs.
 * @subpackage Structs
 */
class Internal_Catalog_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Catalog_Name
     * Meta information extracted from the WSDL
     * - documentation: Name of the Internal Catalog.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Catalog_Name;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency Reference
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Internal_Service_Provider_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Internal Service Provider.
     * - minOccurs: 0
     * @var \StructType\Internal_Service_ProviderObjectType
     */
    public $Internal_Service_Provider_Reference;
    /**
     * Constructor method for Internal_Catalog_Request_CriteriaType
     * @uses Internal_Catalog_Request_CriteriaType::setCatalog_Name()
     * @uses Internal_Catalog_Request_CriteriaType::setCurrency_Reference()
     * @uses Internal_Catalog_Request_CriteriaType::setInternal_Service_Provider_Reference()
     * @param string $catalog_Name
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference
     */
    public function __construct($catalog_Name = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference = null)
    {
        $this
            ->setCatalog_Name($catalog_Name)
            ->setCurrency_Reference($currency_Reference)
            ->setInternal_Service_Provider_Reference($internal_Service_Provider_Reference);
    }
    /**
     * Get Catalog_Name value
     * @return string|null
     */
    public function getCatalog_Name()
    {
        return $this->Catalog_Name;
    }
    /**
     * Set Catalog_Name value
     * @param string $catalog_Name
     * @return \StructType\Internal_Catalog_Request_CriteriaType
     */
    public function setCatalog_Name($catalog_Name = null)
    {
        // validation for constraint: string
        if (!is_null($catalog_Name) && !is_string($catalog_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catalog_Name, true), gettype($catalog_Name)), __LINE__);
        }
        $this->Catalog_Name = $catalog_Name;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Internal_Catalog_Request_CriteriaType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Internal_Service_Provider_Reference value
     * @return \StructType\Internal_Service_ProviderObjectType|null
     */
    public function getInternal_Service_Provider_Reference()
    {
        return $this->Internal_Service_Provider_Reference;
    }
    /**
     * Set Internal_Service_Provider_Reference value
     * @param \StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference
     * @return \StructType\Internal_Catalog_Request_CriteriaType
     */
    public function setInternal_Service_Provider_Reference(\StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference = null)
    {
        $this->Internal_Service_Provider_Reference = $internal_Service_Provider_Reference;
        return $this;
    }
}
