<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Impair_Asset_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Root element for the Request on the Impair Asset operation.
 * @subpackage Structs
 */
class Impair_Asset_RequestType extends AbstractStructBase
{
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Impair_Asset_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains data used to process the asset impairment.
     * @var \StructType\Impair_Asset_WWS_DataType
     */
    public $Impair_Asset_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Impair_Asset_RequestType
     * @uses Impair_Asset_RequestType::setBusiness_Process_Parameters()
     * @uses Impair_Asset_RequestType::setImpair_Asset_Data()
     * @uses Impair_Asset_RequestType::setVersion()
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Impair_Asset_WWS_DataType $impair_Asset_Data
     * @param string $version
     */
    public function __construct(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Impair_Asset_WWS_DataType $impair_Asset_Data = null, $version = null)
    {
        $this
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setImpair_Asset_Data($impair_Asset_Data)
            ->setVersion($version);
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Impair_Asset_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Impair_Asset_Data value
     * @return \StructType\Impair_Asset_WWS_DataType|null
     */
    public function getImpair_Asset_Data()
    {
        return $this->Impair_Asset_Data;
    }
    /**
     * Set Impair_Asset_Data value
     * @param \StructType\Impair_Asset_WWS_DataType $impair_Asset_Data
     * @return \StructType\Impair_Asset_RequestType
     */
    public function setImpair_Asset_Data(\StructType\Impair_Asset_WWS_DataType $impair_Asset_Data = null)
    {
        $this->Impair_Asset_Data = $impair_Asset_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Impair_Asset_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
