<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Hotel_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Hotel Response Data
 * @subpackage Structs
 */
class Hotel_Response_DataType extends AbstractStructBase
{
    /**
     * The Hotel
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HotelType[]
     */
    public $Hotel;
    /**
     * Constructor method for Hotel_Response_DataType
     * @uses Hotel_Response_DataType::setHotel()
     * @param \StructType\HotelType[] $hotel
     */
    public function __construct(array $hotel = array())
    {
        $this
            ->setHotel($hotel);
    }
    /**
     * Get Hotel value
     * @return \StructType\HotelType[]|null
     */
    public function getHotel()
    {
        return $this->Hotel;
    }
    /**
     * This method is responsible for validating the values passed to the setHotel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelForArrayConstraintsFromSetHotel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotel_Response_DataTypeHotelItem) {
            // validation for constraint: itemType
            if (!$hotel_Response_DataTypeHotelItem instanceof \StructType\HotelType) {
                $invalidValues[] = is_object($hotel_Response_DataTypeHotelItem) ? get_class($hotel_Response_DataTypeHotelItem) : sprintf('%s(%s)', gettype($hotel_Response_DataTypeHotelItem), var_export($hotel_Response_DataTypeHotelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Hotel property can only contain items of type \StructType\HotelType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelType[] $hotel
     * @return \StructType\Hotel_Response_DataType
     */
    public function setHotel(array $hotel = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelArrayErrorMessage = self::validateHotelForArrayConstraintsFromSetHotel($hotel))) {
            throw new \InvalidArgumentException($hotelArrayErrorMessage, __LINE__);
        }
        $this->Hotel = $hotel;
        return $this;
    }
    /**
     * Add item to Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelType $item
     * @return \StructType\Hotel_Response_DataType
     */
    public function addToHotel(\StructType\HotelType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelType) {
            throw new \InvalidArgumentException(sprintf('The Hotel property can only contain items of type \StructType\HotelType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Hotel[] = $item;
        return $this;
    }
}
