<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Guest_Listing_File_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing Guest Listing Response Data for requested references or criteria and for requested response group.
 * @subpackage Structs
 */
class Guest_Listing_File_Response_DataType extends AbstractStructBase
{
    /**
     * The Guest_Listing_File
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element that includes Guest Listing File instance and data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Guest_Listing_File_WWSType[]
     */
    public $Guest_Listing_File;
    /**
     * Constructor method for Guest_Listing_File_Response_DataType
     * @uses Guest_Listing_File_Response_DataType::setGuest_Listing_File()
     * @param \StructType\Guest_Listing_File_WWSType[] $guest_Listing_File
     */
    public function __construct(array $guest_Listing_File = array())
    {
        $this
            ->setGuest_Listing_File($guest_Listing_File);
    }
    /**
     * Get Guest_Listing_File value
     * @return \StructType\Guest_Listing_File_WWSType[]|null
     */
    public function getGuest_Listing_File()
    {
        return $this->Guest_Listing_File;
    }
    /**
     * This method is responsible for validating the values passed to the setGuest_Listing_File method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuest_Listing_File method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuest_Listing_FileForArrayConstraintsFromSetGuest_Listing_File(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guest_Listing_File_Response_DataTypeGuest_Listing_FileItem) {
            // validation for constraint: itemType
            if (!$guest_Listing_File_Response_DataTypeGuest_Listing_FileItem instanceof \StructType\Guest_Listing_File_WWSType) {
                $invalidValues[] = is_object($guest_Listing_File_Response_DataTypeGuest_Listing_FileItem) ? get_class($guest_Listing_File_Response_DataTypeGuest_Listing_FileItem) : sprintf('%s(%s)', gettype($guest_Listing_File_Response_DataTypeGuest_Listing_FileItem), var_export($guest_Listing_File_Response_DataTypeGuest_Listing_FileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Guest_Listing_File property can only contain items of type \StructType\Guest_Listing_File_WWSType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Guest_Listing_File value
     * @throws \InvalidArgumentException
     * @param \StructType\Guest_Listing_File_WWSType[] $guest_Listing_File
     * @return \StructType\Guest_Listing_File_Response_DataType
     */
    public function setGuest_Listing_File(array $guest_Listing_File = array())
    {
        // validation for constraint: array
        if ('' !== ($guest_Listing_FileArrayErrorMessage = self::validateGuest_Listing_FileForArrayConstraintsFromSetGuest_Listing_File($guest_Listing_File))) {
            throw new \InvalidArgumentException($guest_Listing_FileArrayErrorMessage, __LINE__);
        }
        $this->Guest_Listing_File = $guest_Listing_File;
        return $this;
    }
    /**
     * Add item to Guest_Listing_File value
     * @throws \InvalidArgumentException
     * @param \StructType\Guest_Listing_File_WWSType $item
     * @return \StructType\Guest_Listing_File_Response_DataType
     */
    public function addToGuest_Listing_File(\StructType\Guest_Listing_File_WWSType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Guest_Listing_File_WWSType) {
            throw new \InvalidArgumentException(sprintf('The Guest_Listing_File property can only contain items of type \StructType\Guest_Listing_File_WWSType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Guest_Listing_File[] = $item;
        return $this;
    }
}
