<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Get_Supplier_Invoice_Line_Additional_Data_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The element contains the Supplier Invoice Line additional data response data.
 * @subpackage Structs
 */
class Get_Supplier_Invoice_Line_Additional_Data_Response_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Line_Additional_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Line_Additional_DataType[]
     */
    public $Supplier_Invoice_Line_Additional_Data;
    /**
     * Constructor method for
     * Get_Supplier_Invoice_Line_Additional_Data_Response_DataType
     * @uses Get_Supplier_Invoice_Line_Additional_Data_Response_DataType::setSupplier_Invoice_Line_Additional_Data()
     * @param \StructType\Supplier_Invoice_Line_Additional_DataType[] $supplier_Invoice_Line_Additional_Data
     */
    public function __construct(array $supplier_Invoice_Line_Additional_Data = array())
    {
        $this
            ->setSupplier_Invoice_Line_Additional_Data($supplier_Invoice_Line_Additional_Data);
    }
    /**
     * Get Supplier_Invoice_Line_Additional_Data value
     * @return \StructType\Supplier_Invoice_Line_Additional_DataType[]|null
     */
    public function getSupplier_Invoice_Line_Additional_Data()
    {
        return $this->Supplier_Invoice_Line_Additional_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Line_Additional_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Line_Additional_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Line_Additional_DataForArrayConstraintsFromSetSupplier_Invoice_Line_Additional_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $get_Supplier_Invoice_Line_Additional_Data_Response_DataTypeSupplier_Invoice_Line_Additional_DataItem) {
            // validation for constraint: itemType
            if (!$get_Supplier_Invoice_Line_Additional_Data_Response_DataTypeSupplier_Invoice_Line_Additional_DataItem instanceof \StructType\Supplier_Invoice_Line_Additional_DataType) {
                $invalidValues[] = is_object($get_Supplier_Invoice_Line_Additional_Data_Response_DataTypeSupplier_Invoice_Line_Additional_DataItem) ? get_class($get_Supplier_Invoice_Line_Additional_Data_Response_DataTypeSupplier_Invoice_Line_Additional_DataItem) : sprintf('%s(%s)', gettype($get_Supplier_Invoice_Line_Additional_Data_Response_DataTypeSupplier_Invoice_Line_Additional_DataItem), var_export($get_Supplier_Invoice_Line_Additional_Data_Response_DataTypeSupplier_Invoice_Line_Additional_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Line_Additional_Data property can only contain items of type \StructType\Supplier_Invoice_Line_Additional_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Line_Additional_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Line_Additional_DataType[] $supplier_Invoice_Line_Additional_Data
     * @return \StructType\Get_Supplier_Invoice_Line_Additional_Data_Response_DataType
     */
    public function setSupplier_Invoice_Line_Additional_Data(array $supplier_Invoice_Line_Additional_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Line_Additional_DataArrayErrorMessage = self::validateSupplier_Invoice_Line_Additional_DataForArrayConstraintsFromSetSupplier_Invoice_Line_Additional_Data($supplier_Invoice_Line_Additional_Data))) {
            throw new \InvalidArgumentException($supplier_Invoice_Line_Additional_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Line_Additional_Data = $supplier_Invoice_Line_Additional_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Line_Additional_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Line_Additional_DataType $item
     * @return \StructType\Get_Supplier_Invoice_Line_Additional_Data_Response_DataType
     */
    public function addToSupplier_Invoice_Line_Additional_Data(\StructType\Supplier_Invoice_Line_Additional_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Line_Additional_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Line_Additional_Data property can only contain items of type \StructType\Supplier_Invoice_Line_Additional_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Line_Additional_Data[] = $item;
        return $this;
    }
}
