<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get_PO_Outbound_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains request reference for getting PO data
 * @subpackage Structs
 */
class Get_PO_Outbound_RequestType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order
     * - choice: Purchase_Order_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Purchase_OrderObjectType
     */
    public $Purchase_Order_Reference;
    /**
     * The Include_Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the attachment data within Purchase Order Data is to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Attachment_Data;
    /**
     * The Include_Service_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if Service Lines within a Purchase Order are to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Service_Line_Data;
    /**
     * The Zero_Or_Max_Number_If_Allow_Multiple_Address_Lines
     * Meta information extracted from the WSDL
     * - documentation: Number indicating whether to concatenate the first two lines of an address line in the response , or send the address lines individually without concatenation.If zero, we won't send out multiple street address lines in cXML PO
     * outbound. Instead we will concatenate the first two street lines for the address and send it as one line (default behavior)if > 0 will send out separate address lines, up to max specified, or up to the 9 stored (currently) in the system, whichever is
     * less.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 2
     * @var float
     */
    public $Zero_Or_Max_Number_If_Allow_Multiple_Address_Lines;
    /**
     * The Include_PO_Line_Worktags
     * Meta information extracted from the WSDL
     * - documentation: Set this flag to one, if the response message needs to include worktags from Purchase Order line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_PO_Line_Worktags;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Get_PO_Outbound_RequestType
     * @uses Get_PO_Outbound_RequestType::setPurchase_Order_Reference()
     * @uses Get_PO_Outbound_RequestType::setInclude_Attachment_Data()
     * @uses Get_PO_Outbound_RequestType::setInclude_Service_Line_Data()
     * @uses Get_PO_Outbound_RequestType::setZero_Or_Max_Number_If_Allow_Multiple_Address_Lines()
     * @uses Get_PO_Outbound_RequestType::setInclude_PO_Line_Worktags()
     * @uses Get_PO_Outbound_RequestType::setVersion()
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @param bool $include_Attachment_Data
     * @param bool $include_Service_Line_Data
     * @param float $zero_Or_Max_Number_If_Allow_Multiple_Address_Lines
     * @param bool $include_PO_Line_Worktags
     * @param string $version
     */
    public function __construct(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null, $include_Attachment_Data = null, $include_Service_Line_Data = null, $zero_Or_Max_Number_If_Allow_Multiple_Address_Lines = null, $include_PO_Line_Worktags = null, $version = null)
    {
        $this
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setInclude_Attachment_Data($include_Attachment_Data)
            ->setInclude_Service_Line_Data($include_Service_Line_Data)
            ->setZero_Or_Max_Number_If_Allow_Multiple_Address_Lines($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines)
            ->setInclude_PO_Line_Worktags($include_PO_Line_Worktags)
            ->setVersion($version);
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType|null
     */
    public function getPurchase_Order_Reference()
    {
        return isset($this->Purchase_Order_Reference) ? $this->Purchase_Order_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPurchase_Order_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePurchase_Order_ReferenceForChoiceConstraintsFromSetPurchase_Order_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Purchase_Order_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Purchase_Order_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Purchase_Order_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @return \StructType\Get_PO_Outbound_RequestType
     */
    public function setPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        // validation for constraint: choice(Purchase_Order_Reference)
        if ('' !== ($purchase_Order_ReferenceChoiceErrorMessage = self::validatePurchase_Order_ReferenceForChoiceConstraintsFromSetPurchase_Order_Reference($purchase_Order_Reference))) {
            throw new \InvalidArgumentException($purchase_Order_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($purchase_Order_Reference) || (is_array($purchase_Order_Reference) && empty($purchase_Order_Reference))) {
            unset($this->Purchase_Order_Reference);
        } else {
            $this->Purchase_Order_Reference = $purchase_Order_Reference;
        }
        return $this;
    }
    /**
     * Get Include_Attachment_Data value
     * @return bool|null
     */
    public function getInclude_Attachment_Data()
    {
        return $this->Include_Attachment_Data;
    }
    /**
     * Set Include_Attachment_Data value
     * @param bool $include_Attachment_Data
     * @return \StructType\Get_PO_Outbound_RequestType
     */
    public function setInclude_Attachment_Data($include_Attachment_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Attachment_Data) && !is_bool($include_Attachment_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Attachment_Data, true), gettype($include_Attachment_Data)), __LINE__);
        }
        $this->Include_Attachment_Data = $include_Attachment_Data;
        return $this;
    }
    /**
     * Get Include_Service_Line_Data value
     * @return bool|null
     */
    public function getInclude_Service_Line_Data()
    {
        return $this->Include_Service_Line_Data;
    }
    /**
     * Set Include_Service_Line_Data value
     * @param bool $include_Service_Line_Data
     * @return \StructType\Get_PO_Outbound_RequestType
     */
    public function setInclude_Service_Line_Data($include_Service_Line_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Service_Line_Data) && !is_bool($include_Service_Line_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Service_Line_Data, true), gettype($include_Service_Line_Data)), __LINE__);
        }
        $this->Include_Service_Line_Data = $include_Service_Line_Data;
        return $this;
    }
    /**
     * Get Zero_Or_Max_Number_If_Allow_Multiple_Address_Lines value
     * @return float|null
     */
    public function getZero_Or_Max_Number_If_Allow_Multiple_Address_Lines()
    {
        return $this->Zero_Or_Max_Number_If_Allow_Multiple_Address_Lines;
    }
    /**
     * Set Zero_Or_Max_Number_If_Allow_Multiple_Address_Lines value
     * @param float $zero_Or_Max_Number_If_Allow_Multiple_Address_Lines
     * @return \StructType\Get_PO_Outbound_RequestType
     */
    public function setZero_Or_Max_Number_If_Allow_Multiple_Address_Lines($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines = null)
    {
        // validation for constraint: float
        if (!is_null($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines) && !(is_float($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines) || is_numeric($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines, true), gettype($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines) && mb_strlen(mb_substr($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines, false !== mb_strpos($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines, '.') ? mb_strpos($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines, '.') + 1 : mb_strlen($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines, true), mb_strlen(mb_substr($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines, mb_strpos($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines) && $zero_Or_Max_Number_If_Allow_Multiple_Address_Lines < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines, true)), __LINE__);
        }
        // validation for constraint: totalDigits(2)
        if (!is_null($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines) && mb_strlen(preg_replace('/(\D)/', '', $zero_Or_Max_Number_If_Allow_Multiple_Address_Lines)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 2 digits, "%d" given', var_export($zero_Or_Max_Number_If_Allow_Multiple_Address_Lines, true), mb_strlen(preg_replace('/(\D)/', '', $zero_Or_Max_Number_If_Allow_Multiple_Address_Lines))), __LINE__);
        }
        $this->Zero_Or_Max_Number_If_Allow_Multiple_Address_Lines = $zero_Or_Max_Number_If_Allow_Multiple_Address_Lines;
        return $this;
    }
    /**
     * Get Include_PO_Line_Worktags value
     * @return bool|null
     */
    public function getInclude_PO_Line_Worktags()
    {
        return $this->Include_PO_Line_Worktags;
    }
    /**
     * Set Include_PO_Line_Worktags value
     * @param bool $include_PO_Line_Worktags
     * @return \StructType\Get_PO_Outbound_RequestType
     */
    public function setInclude_PO_Line_Worktags($include_PO_Line_Worktags = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_PO_Line_Worktags) && !is_bool($include_PO_Line_Worktags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_PO_Line_Worktags, true), gettype($include_PO_Line_Worktags)), __LINE__);
        }
        $this->Include_PO_Line_Worktags = $include_PO_Line_Worktags;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Get_PO_Outbound_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
