<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Report_Response_GroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element around a list of elements representing the amount of data that should be included in the Expense Report response. If this element is not included then ALL of the Response Groups are included in the response.
 * @subpackage Structs
 */
class Expense_Report_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the Expense Report Reference data is to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Include_Expense_Report_Data
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the Expense Report data is to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Expense_Report_Data;
    /**
     * The Include_Credit_Card_Transaction_Data
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the Credit Card Transaction data for Credit Card Transactions of the Expense Report is to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Credit_Card_Transaction_Data;
    /**
     * The Include_Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the attachment data within Expense Report Data is to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Attachment_Data;
    /**
     * Constructor method for Expense_Report_Response_GroupType
     * @uses Expense_Report_Response_GroupType::setInclude_Reference()
     * @uses Expense_Report_Response_GroupType::setInclude_Expense_Report_Data()
     * @uses Expense_Report_Response_GroupType::setInclude_Credit_Card_Transaction_Data()
     * @uses Expense_Report_Response_GroupType::setInclude_Attachment_Data()
     * @param bool $include_Reference
     * @param bool $include_Expense_Report_Data
     * @param bool $include_Credit_Card_Transaction_Data
     * @param bool $include_Attachment_Data
     */
    public function __construct($include_Reference = null, $include_Expense_Report_Data = null, $include_Credit_Card_Transaction_Data = null, $include_Attachment_Data = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setInclude_Expense_Report_Data($include_Expense_Report_Data)
            ->setInclude_Credit_Card_Transaction_Data($include_Credit_Card_Transaction_Data)
            ->setInclude_Attachment_Data($include_Attachment_Data);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Expense_Report_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Include_Expense_Report_Data value
     * @return bool|null
     */
    public function getInclude_Expense_Report_Data()
    {
        return $this->Include_Expense_Report_Data;
    }
    /**
     * Set Include_Expense_Report_Data value
     * @param bool $include_Expense_Report_Data
     * @return \StructType\Expense_Report_Response_GroupType
     */
    public function setInclude_Expense_Report_Data($include_Expense_Report_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Expense_Report_Data) && !is_bool($include_Expense_Report_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Expense_Report_Data, true), gettype($include_Expense_Report_Data)), __LINE__);
        }
        $this->Include_Expense_Report_Data = $include_Expense_Report_Data;
        return $this;
    }
    /**
     * Get Include_Credit_Card_Transaction_Data value
     * @return bool|null
     */
    public function getInclude_Credit_Card_Transaction_Data()
    {
        return $this->Include_Credit_Card_Transaction_Data;
    }
    /**
     * Set Include_Credit_Card_Transaction_Data value
     * @param bool $include_Credit_Card_Transaction_Data
     * @return \StructType\Expense_Report_Response_GroupType
     */
    public function setInclude_Credit_Card_Transaction_Data($include_Credit_Card_Transaction_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Credit_Card_Transaction_Data) && !is_bool($include_Credit_Card_Transaction_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Credit_Card_Transaction_Data, true), gettype($include_Credit_Card_Transaction_Data)), __LINE__);
        }
        $this->Include_Credit_Card_Transaction_Data = $include_Credit_Card_Transaction_Data;
        return $this;
    }
    /**
     * Get Include_Attachment_Data value
     * @return bool|null
     */
    public function getInclude_Attachment_Data()
    {
        return $this->Include_Attachment_Data;
    }
    /**
     * Set Include_Attachment_Data value
     * @param bool $include_Attachment_Data
     * @return \StructType\Expense_Report_Response_GroupType
     */
    public function setInclude_Attachment_Data($include_Attachment_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Attachment_Data) && !is_bool($include_Attachment_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Attachment_Data, true), gettype($include_Attachment_Data)), __LINE__);
        }
        $this->Include_Attachment_Data = $include_Attachment_Data;
        return $this;
    }
}
