<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Rate_Table_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Start of Range and End of Range cannot overlap or have gaps between Expense Rate Table lines. The gap between the End of Range on one line and the Start of Range on the next must be 0.1 when any of the End of Range values is a
 * decimal. | A Start of Range can only be used once for an Expense Rate Table line. | An End of Range can only be used once for an Expense Rate Table line. | The Start of Range and End of Range cannot overlap or have gaps between Expense Rate Table
 * lines. The gap between the End of Range on one line and the Start of Range on the next line must be 1. | Expense Rate Table with table type of Amount or Maximum can only have one Graduated Expense Rate per Expense Rate Table Line. | Only one criteria
 * for each type is allowed for each expense rate table line. | Expense Rate Table specifically use Expense Rate Table Rules and not any type of Condition Rule. | Element containing all Expense Rate Table Line data
 * @subpackage Structs
 */
class Expense_Rate_Table_Line_DataType extends AbstractStructBase
{
    /**
     * The Line_ID
     * Meta information extracted from the WSDL
     * - documentation: ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Line_ID;
    /**
     * The Line_Order
     * Meta information extracted from the WSDL
     * - documentation: Line order
     * - base: xsd:string
     * - maxLength: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Line_Order;
    /**
     * The Expense_Rate_Table_Rule_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Rate Table Rule
     * - choice: Expense_Rate_Table_Rule_Reference | Criteria_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Condition_RuleObjectType
     */
    public $Expense_Rate_Table_Rule_Reference;
    /**
     * The Criteria_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Spend Data
     * - choice: Expense_Rate_Table_Rule_Reference | Criteria_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Behavior_Spend_DataObjectType[]
     */
    public $Criteria_Reference;
    /**
     * The Graduated_Expense_Rate_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Graduated_Expense_Rate_DataType[]
     */
    public $Graduated_Expense_Rate_Data;
    /**
     * Constructor method for Expense_Rate_Table_Line_DataType
     * @uses Expense_Rate_Table_Line_DataType::setLine_ID()
     * @uses Expense_Rate_Table_Line_DataType::setLine_Order()
     * @uses Expense_Rate_Table_Line_DataType::setExpense_Rate_Table_Rule_Reference()
     * @uses Expense_Rate_Table_Line_DataType::setCriteria_Reference()
     * @uses Expense_Rate_Table_Line_DataType::setGraduated_Expense_Rate_Data()
     * @param string $line_ID
     * @param string $line_Order
     * @param \StructType\Condition_RuleObjectType $expense_Rate_Table_Rule_Reference
     * @param \StructType\Behavior_Spend_DataObjectType[] $criteria_Reference
     * @param \StructType\Graduated_Expense_Rate_DataType[] $graduated_Expense_Rate_Data
     */
    public function __construct($line_ID = null, $line_Order = null, \StructType\Condition_RuleObjectType $expense_Rate_Table_Rule_Reference = null, array $criteria_Reference = array(), array $graduated_Expense_Rate_Data = array())
    {
        $this
            ->setLine_ID($line_ID)
            ->setLine_Order($line_Order)
            ->setExpense_Rate_Table_Rule_Reference($expense_Rate_Table_Rule_Reference)
            ->setCriteria_Reference($criteria_Reference)
            ->setGraduated_Expense_Rate_Data($graduated_Expense_Rate_Data);
    }
    /**
     * Get Line_ID value
     * @return string|null
     */
    public function getLine_ID()
    {
        return $this->Line_ID;
    }
    /**
     * Set Line_ID value
     * @param string $line_ID
     * @return \StructType\Expense_Rate_Table_Line_DataType
     */
    public function setLine_ID($line_ID = null)
    {
        // validation for constraint: string
        if (!is_null($line_ID) && !is_string($line_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_ID, true), gettype($line_ID)), __LINE__);
        }
        $this->Line_ID = $line_ID;
        return $this;
    }
    /**
     * Get Line_Order value
     * @return string|null
     */
    public function getLine_Order()
    {
        return $this->Line_Order;
    }
    /**
     * Set Line_Order value
     * @param string $line_Order
     * @return \StructType\Expense_Rate_Table_Line_DataType
     */
    public function setLine_Order($line_Order = null)
    {
        // validation for constraint: string
        if (!is_null($line_Order) && !is_string($line_Order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_Order, true), gettype($line_Order)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($line_Order) && mb_strlen($line_Order) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($line_Order)), __LINE__);
        }
        $this->Line_Order = $line_Order;
        return $this;
    }
    /**
     * Get Expense_Rate_Table_Rule_Reference value
     * @return \StructType\Condition_RuleObjectType|null
     */
    public function getExpense_Rate_Table_Rule_Reference()
    {
        return isset($this->Expense_Rate_Table_Rule_Reference) ? $this->Expense_Rate_Table_Rule_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setExpense_Rate_Table_Rule_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Rate_Table_Rule_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateExpense_Rate_Table_Rule_ReferenceForChoiceConstraintsFromSetExpense_Rate_Table_Rule_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Criteria_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Expense_Rate_Table_Rule_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Expense_Rate_Table_Rule_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Expense_Rate_Table_Rule_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Condition_RuleObjectType $expense_Rate_Table_Rule_Reference
     * @return \StructType\Expense_Rate_Table_Line_DataType
     */
    public function setExpense_Rate_Table_Rule_Reference(\StructType\Condition_RuleObjectType $expense_Rate_Table_Rule_Reference = null)
    {
        // validation for constraint: choice(Expense_Rate_Table_Rule_Reference, Criteria_Reference)
        if ('' !== ($expense_Rate_Table_Rule_ReferenceChoiceErrorMessage = self::validateExpense_Rate_Table_Rule_ReferenceForChoiceConstraintsFromSetExpense_Rate_Table_Rule_Reference($expense_Rate_Table_Rule_Reference))) {
            throw new \InvalidArgumentException($expense_Rate_Table_Rule_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($expense_Rate_Table_Rule_Reference) || (is_array($expense_Rate_Table_Rule_Reference) && empty($expense_Rate_Table_Rule_Reference))) {
            unset($this->Expense_Rate_Table_Rule_Reference);
        } else {
            $this->Expense_Rate_Table_Rule_Reference = $expense_Rate_Table_Rule_Reference;
        }
        return $this;
    }
    /**
     * Get Criteria_Reference value
     * @return \StructType\Behavior_Spend_DataObjectType[]|null
     */
    public function getCriteria_Reference()
    {
        return isset($this->Criteria_Reference) ? $this->Criteria_Reference : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCriteria_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCriteria_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCriteria_ReferenceForArrayConstraintsFromSetCriteria_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Rate_Table_Line_DataTypeCriteria_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Rate_Table_Line_DataTypeCriteria_ReferenceItem instanceof \StructType\Behavior_Spend_DataObjectType) {
                $invalidValues[] = is_object($expense_Rate_Table_Line_DataTypeCriteria_ReferenceItem) ? get_class($expense_Rate_Table_Line_DataTypeCriteria_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Rate_Table_Line_DataTypeCriteria_ReferenceItem), var_export($expense_Rate_Table_Line_DataTypeCriteria_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Criteria_Reference property can only contain items of type \StructType\Behavior_Spend_DataObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setCriteria_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCriteria_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCriteria_ReferenceForChoiceConstraintsFromSetCriteria_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Expense_Rate_Table_Rule_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Criteria_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Criteria_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Criteria_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Behavior_Spend_DataObjectType[] $criteria_Reference
     * @return \StructType\Expense_Rate_Table_Line_DataType
     */
    public function setCriteria_Reference(array $criteria_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($criteria_ReferenceArrayErrorMessage = self::validateCriteria_ReferenceForArrayConstraintsFromSetCriteria_Reference($criteria_Reference))) {
            throw new \InvalidArgumentException($criteria_ReferenceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Expense_Rate_Table_Rule_Reference, Criteria_Reference)
        if ('' !== ($criteria_ReferenceChoiceErrorMessage = self::validateCriteria_ReferenceForChoiceConstraintsFromSetCriteria_Reference($criteria_Reference))) {
            throw new \InvalidArgumentException($criteria_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($criteria_Reference) || (is_array($criteria_Reference) && empty($criteria_Reference))) {
            unset($this->Criteria_Reference);
        } else {
            $this->Criteria_Reference = $criteria_Reference;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToCriteria_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToCriteria_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToCriteria_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Expense_Rate_Table_Rule_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Criteria_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Criteria_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Criteria_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Behavior_Spend_DataObjectType $item
     * @return \StructType\Expense_Rate_Table_Line_DataType
     */
    public function addToCriteria_Reference(\StructType\Behavior_Spend_DataObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Behavior_Spend_DataObjectType) {
            throw new \InvalidArgumentException(sprintf('The Criteria_Reference property can only contain items of type \StructType\Behavior_Spend_DataObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Expense_Rate_Table_Rule_Reference, Criteria_Reference)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToCriteria_Reference($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Criteria_Reference[] = $item;
        return $this;
    }
    /**
     * Get Graduated_Expense_Rate_Data value
     * @return \StructType\Graduated_Expense_Rate_DataType[]|null
     */
    public function getGraduated_Expense_Rate_Data()
    {
        return $this->Graduated_Expense_Rate_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setGraduated_Expense_Rate_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGraduated_Expense_Rate_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGraduated_Expense_Rate_DataForArrayConstraintsFromSetGraduated_Expense_Rate_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Rate_Table_Line_DataTypeGraduated_Expense_Rate_DataItem) {
            // validation for constraint: itemType
            if (!$expense_Rate_Table_Line_DataTypeGraduated_Expense_Rate_DataItem instanceof \StructType\Graduated_Expense_Rate_DataType) {
                $invalidValues[] = is_object($expense_Rate_Table_Line_DataTypeGraduated_Expense_Rate_DataItem) ? get_class($expense_Rate_Table_Line_DataTypeGraduated_Expense_Rate_DataItem) : sprintf('%s(%s)', gettype($expense_Rate_Table_Line_DataTypeGraduated_Expense_Rate_DataItem), var_export($expense_Rate_Table_Line_DataTypeGraduated_Expense_Rate_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Graduated_Expense_Rate_Data property can only contain items of type \StructType\Graduated_Expense_Rate_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Graduated_Expense_Rate_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Graduated_Expense_Rate_DataType[] $graduated_Expense_Rate_Data
     * @return \StructType\Expense_Rate_Table_Line_DataType
     */
    public function setGraduated_Expense_Rate_Data(array $graduated_Expense_Rate_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($graduated_Expense_Rate_DataArrayErrorMessage = self::validateGraduated_Expense_Rate_DataForArrayConstraintsFromSetGraduated_Expense_Rate_Data($graduated_Expense_Rate_Data))) {
            throw new \InvalidArgumentException($graduated_Expense_Rate_DataArrayErrorMessage, __LINE__);
        }
        $this->Graduated_Expense_Rate_Data = $graduated_Expense_Rate_Data;
        return $this;
    }
    /**
     * Add item to Graduated_Expense_Rate_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Graduated_Expense_Rate_DataType $item
     * @return \StructType\Expense_Rate_Table_Line_DataType
     */
    public function addToGraduated_Expense_Rate_Data(\StructType\Graduated_Expense_Rate_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Graduated_Expense_Rate_DataType) {
            throw new \InvalidArgumentException(sprintf('The Graduated_Expense_Rate_Data property can only contain items of type \StructType\Graduated_Expense_Rate_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Graduated_Expense_Rate_Data[] = $item;
        return $this;
    }
}
