<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Policy_Group_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Expense Policy Group Instance and Data
 * @subpackage Structs
 */
class Expense_Policy_Group_Response_DataType extends AbstractStructBase
{
    /**
     * The Expense_Policy_Group
     * Meta information extracted from the WSDL
     * - documentation: Expense Policy Group
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_Policy_GroupType[]
     */
    public $Expense_Policy_Group;
    /**
     * Constructor method for Expense_Policy_Group_Response_DataType
     * @uses Expense_Policy_Group_Response_DataType::setExpense_Policy_Group()
     * @param \StructType\Expense_Policy_GroupType[] $expense_Policy_Group
     */
    public function __construct(array $expense_Policy_Group = array())
    {
        $this
            ->setExpense_Policy_Group($expense_Policy_Group);
    }
    /**
     * Get Expense_Policy_Group value
     * @return \StructType\Expense_Policy_GroupType[]|null
     */
    public function getExpense_Policy_Group()
    {
        return $this->Expense_Policy_Group;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Policy_Group method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Policy_Group method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Policy_GroupForArrayConstraintsFromSetExpense_Policy_Group(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Policy_Group_Response_DataTypeExpense_Policy_GroupItem) {
            // validation for constraint: itemType
            if (!$expense_Policy_Group_Response_DataTypeExpense_Policy_GroupItem instanceof \StructType\Expense_Policy_GroupType) {
                $invalidValues[] = is_object($expense_Policy_Group_Response_DataTypeExpense_Policy_GroupItem) ? get_class($expense_Policy_Group_Response_DataTypeExpense_Policy_GroupItem) : sprintf('%s(%s)', gettype($expense_Policy_Group_Response_DataTypeExpense_Policy_GroupItem), var_export($expense_Policy_Group_Response_DataTypeExpense_Policy_GroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Policy_Group property can only contain items of type \StructType\Expense_Policy_GroupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Policy_Group value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Policy_GroupType[] $expense_Policy_Group
     * @return \StructType\Expense_Policy_Group_Response_DataType
     */
    public function setExpense_Policy_Group(array $expense_Policy_Group = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Policy_GroupArrayErrorMessage = self::validateExpense_Policy_GroupForArrayConstraintsFromSetExpense_Policy_Group($expense_Policy_Group))) {
            throw new \InvalidArgumentException($expense_Policy_GroupArrayErrorMessage, __LINE__);
        }
        $this->Expense_Policy_Group = $expense_Policy_Group;
        return $this;
    }
    /**
     * Add item to Expense_Policy_Group value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Policy_GroupType $item
     * @return \StructType\Expense_Policy_Group_Response_DataType
     */
    public function addToExpense_Policy_Group(\StructType\Expense_Policy_GroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_Policy_GroupType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Policy_Group property can only contain items of type \StructType\Expense_Policy_GroupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Policy_Group[] = $item;
        return $this;
    }
}
