<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Policy_Group_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for Expense Policy Group
 * @subpackage Structs
 */
class Expense_Policy_Group_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Expense_Policy_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Policy Group
     * - maxOccurs: unbounded
     * @var \StructType\Expense_Policy_GroupObjectType[]
     */
    public $Expense_Policy_Group_Reference;
    /**
     * Constructor method for Expense_Policy_Group_Request_ReferencesType
     * @uses Expense_Policy_Group_Request_ReferencesType::setExpense_Policy_Group_Reference()
     * @param \StructType\Expense_Policy_GroupObjectType[] $expense_Policy_Group_Reference
     */
    public function __construct(array $expense_Policy_Group_Reference = array())
    {
        $this
            ->setExpense_Policy_Group_Reference($expense_Policy_Group_Reference);
    }
    /**
     * Get Expense_Policy_Group_Reference value
     * @return \StructType\Expense_Policy_GroupObjectType[]|null
     */
    public function getExpense_Policy_Group_Reference()
    {
        return $this->Expense_Policy_Group_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Policy_Group_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Policy_Group_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Policy_Group_ReferenceForArrayConstraintsFromSetExpense_Policy_Group_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Policy_Group_Request_ReferencesTypeExpense_Policy_Group_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Policy_Group_Request_ReferencesTypeExpense_Policy_Group_ReferenceItem instanceof \StructType\Expense_Policy_GroupObjectType) {
                $invalidValues[] = is_object($expense_Policy_Group_Request_ReferencesTypeExpense_Policy_Group_ReferenceItem) ? get_class($expense_Policy_Group_Request_ReferencesTypeExpense_Policy_Group_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Policy_Group_Request_ReferencesTypeExpense_Policy_Group_ReferenceItem), var_export($expense_Policy_Group_Request_ReferencesTypeExpense_Policy_Group_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Policy_Group_Reference property can only contain items of type \StructType\Expense_Policy_GroupObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Policy_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Policy_GroupObjectType[] $expense_Policy_Group_Reference
     * @return \StructType\Expense_Policy_Group_Request_ReferencesType
     */
    public function setExpense_Policy_Group_Reference(array $expense_Policy_Group_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Policy_Group_ReferenceArrayErrorMessage = self::validateExpense_Policy_Group_ReferenceForArrayConstraintsFromSetExpense_Policy_Group_Reference($expense_Policy_Group_Reference))) {
            throw new \InvalidArgumentException($expense_Policy_Group_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Policy_Group_Reference = $expense_Policy_Group_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Policy_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Policy_GroupObjectType $item
     * @return \StructType\Expense_Policy_Group_Request_ReferencesType
     */
    public function addToExpense_Policy_Group_Reference(\StructType\Expense_Policy_GroupObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_Policy_GroupObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Policy_Group_Reference property can only contain items of type \StructType\Expense_Policy_GroupObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Policy_Group_Reference[] = $item;
        return $this;
    }
}
