<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Item_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You can’t specify distance-based expense items as child expense items. | Select either Item Unit Price or Expense Rate Table for the expense item. | You can only select Expense Accumulator on fixed expense items that use an expense
 * rate table. | Set Arrival Time and Departure Time to required. The expense item uses rate table conditions based on start or end travel times. | Expense items set to Maximum Line Expense or Maximum Daily Expense can't use adjustment rate tables. |
 * Set only 1 of these options for Expense Item Amount Type: Based on Allowance Plan, Fixed Expense, Maximum Daily Expense, or Maximum Line Expense. | To select Allow Overage, you must also select either Maximum Line Expense, Maximum Daily Expense, or
 * Based on Allowance Plan. | With Enable Travel Journal selected, you can't set these expense item amount types: Maximum Line Expense, Maximum Daily Expense, or Based on Allowance Plan. | You can only define Non Editable Number of Hours on expense
 * items with an enabled travel journal. | You can only define Travel Journal Type on expense items with an enabled travel journal. | You can only define Rounding Option for Hours on expense items with an enabled travel journal. | Set Arrival Time and
 * Departure Time to required for travel journal expense items using 24-hour periods. | All Expense Item Attributes evaluated by the Expense Rate Table should be added to the Expense Item and displayed to the user. | Enable Rate Tables on Spend
 * Authorizations can't be selected when the expense item is not using a base rate table, is an Actual Expense or Based on Allowance Plan, or it contains a Travel Journal. | Arrival Date and Departure Date Expense Item Attributes need to be set to
 * required for a Travel Journal Expense Item. | If Travel Journal is enabled, then a Travel Journal Item must also be specified. | Arrival Date and Departure Date Expense Item Attributes need to be set to required for a Hotel Itemization Expense Item.
 * | An Expense Item that doesn't use Expense Rate Table cannot be adjusted. | If the item unit price is specified, then the currency must also be specified. | Element containing all Expense Item data
 * @subpackage Structs
 */
class Expense_Item_DataType extends AbstractStructBase
{
    /**
     * The Expense_Item_ID
     * Meta information extracted from the WSDL
     * - documentation: Expense Item ID. This is the Expense Item unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Item_ID;
    /**
     * The Item_Name
     * Meta information extracted from the WSDL
     * - documentation: Expense Item Name is already used. | Free form text field for meaningful Expense Item Name
     * - maxOccurs: 1
     * @var string
     */
    public $Item_Name;
    /**
     * The Resource_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value of the spend category. A spend category is a classification of items and services that drive the accounting. All expense items are associated with a Spend Category and sales items are associated with a
     * Revenue Category.If a value is provided for sales item, revenue category will default so it is recommended to provide a value for either sales item or revenue category but not both. It is required if sales item is blank.
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Resource_Category_Reference;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Free form text field to provide detailed description of the Expense Item
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Description;
    /**
     * The Synonyms_and_Keywords
     * Meta information extracted from the WSDL
     * - documentation: Synonyms and Key words which are similar to the Expense Item name. These will allow an infrequent user to type in something reasonable and find the correct expense item.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Synonyms_and_Keywords;
    /**
     * The Per_Diem_Expense
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag indicating if the Expense Item is a Per Diem Expense. Used for reporting purposes only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Per_Diem_Expense;
    /**
     * The Item_Unit_Price
     * Meta information extracted from the WSDL
     * - documentation: Currency field for Item Unit Price | Unit Price.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Item_Unit_Price;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the currency of the company. If entered, this field is not processed on inbound Workday Web Services requests.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Instructional_Text
     * Meta information extracted from the WSDL
     * - documentation: Free form Rich Text field to enter instructions for users creating expense reports.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Instructional_Text;
    /**
     * The Expense_Policy_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Policy Group. Assigning expense item to policy groups is done to make it easier for an administrator to search for and select items for segmented security setup.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_Policy_GroupObjectType[]
     */
    public $Expense_Policy_Group_Reference;
    /**
     * The Expense_Item_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Item Group. Assigning expense items to item groups is done to make it easier to search for and select items. Expense items can belong to multiple groups.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_Item_GroupObjectType[]
     */
    public $Expense_Item_Group_Reference;
    /**
     * The Job_Profile_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Job Profile. Workers in this Job Profile can use this Expense Item.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_ProfileObjectType[]
     */
    public $Job_Profile_Reference;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Unit of Measure
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Tax_Applicability_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Tax Applicability
     * - minOccurs: 0
     * @var \StructType\Tax_ApplicabilityObjectType
     */
    public $Tax_Applicability_Reference;
    /**
     * The Travel_Journal
     * Meta information extracted from the WSDL
     * - documentation: This boolean will enable travel journal entry on the expense report line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Travel_Journal;
    /**
     * The Travel_Journal_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Expense Item used for daily travel journal entry.
     * - minOccurs: 0
     * @var \StructType\Expense_ItemObjectType
     */
    public $Travel_Journal_Item_Reference;
    /**
     * The Travel_Journal_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Defines Travel Journal configuration type for Expense Item.
     * - minOccurs: 0
     * @var \StructType\Travel_Journal_TypeObjectType
     */
    public $Travel_Journal_Type_Reference;
    /**
     * The Rounding_Option_for_Hours_Reference
     * Meta information extracted from the WSDL
     * - documentation: Rounding option for the "Number of Hours" attribute defined on TJ Expense Item
     * - minOccurs: 0
     * @var \StructType\Rounding_OptionObjectType
     */
    public $Rounding_Option_for_Hours_Reference;
    /**
     * The Non_Editable_Number_of_Hours
     * Meta information extracted from the WSDL
     * - documentation: This boolean will make the Number of Hours not enterable on the Travel Journal lines.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Non_Editable_Number_of_Hours;
    /**
     * The Quantity_and_Per_Unit_Amount_Not_Enterable
     * Meta information extracted from the WSDL
     * - documentation: This boolean will make the Amount and Quantity not enterable on the expense report line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Quantity_and_Per_Unit_Amount_Not_Enterable;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag indicating if the Expense Item is Inactive. Set for expense items that should no longer be selected on Expense Report Lines
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Fixed_Expense
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag indicating if the Expense Item is a Fixed Expense. Set for expenses that are always the same amount, for example, a fixed rate for mileage.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Fixed_Expense;
    /**
     * The Maximum_Line_Expense
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag indicating if the Expense Item has a Maximum Expense. Set for expenses where you want to establish a maximum amount that can't be exceeded, such as the maximum amount for one night at a hotel.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Maximum_Line_Expense;
    /**
     * The Maximum_Daily_Expense
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag indicating if the Expense Item has a Maximum Daily Expense. Set for expenses where you want to establish a maximum daily amount that can't be exceeded, such as the maximum daily amount per meal.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Maximum_Daily_Expense;
    /**
     * The Allow_Overage
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag indicating if a Maximum Expense Item will allow overages. Set for expenses where you want to give the user a warning that they have surpassed the maximum amount allowed for the expense item rather than giving the user an
     * error.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Allow_Overage;
    /**
     * The Based_on_Allowance_Plan
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag indicating if the Expense Item is based on an Allowance Plan. Set for expenses that would have a Tuition Allowance Plan for example.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Based_on_Allowance_Plan;
    /**
     * The Memo_Required
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag indicating if a Memo is Required by the user when entering the expense item.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Memo_Required;
    /**
     * The Display_Arrival_Date_before_Departure_Date
     * Meta information extracted from the WSDL
     * - documentation: Display Arrival Date before Departure Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Display_Arrival_Date_before_Departure_Date;
    /**
     * The Non_Editable_Number_of_Days
     * Meta information extracted from the WSDL
     * - documentation: This boolean will make the Number of Days not enterable on the expense report lines.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Non_Editable_Number_of_Days;
    /**
     * The Expense_Item_Attribute_Data
     * Meta information extracted from the WSDL
     * - documentation: List of Expense Item Attributes
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType[]
     */
    public $Expense_Item_Attribute_Data;
    /**
     * The Expense_Accumulator_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Accumulator. This will determine if an accumulated quantity of all the expense report lines of the expense payee with this expense item will be evaluated by the base rate table. This should only be
     * selected in conjunction with an Expense Rate Table.
     * - minOccurs: 0
     * @var \StructType\Expense_AccumulatorObjectType
     */
    public $Expense_Accumulator_Reference;
    /**
     * The Expense_Rate_Table_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Rate Table. The Expense Rate Table is used to determine the base fixed or maximum amount of the Expense Item based on additional data entered by the user on the expense item details of an expense
     * report line.
     * - minOccurs: 0
     * @var \StructType\Expense_Rate_TableObjectType
     */
    public $Expense_Rate_Table_Reference;
    /**
     * The Enable_Rate_Tables_for_Spend_Authorizations
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag, Enable Rate Tables on Spend Authorizations, that allows rate tables to be enforced on the spend authorization line using the expense item. This boolean will force all expense item attributes required by the related rate
     * table to be displayed on required on spend authorizations. This boolean will only be available when a base rate table exists on the expense item.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Enable_Rate_Tables_for_Spend_Authorizations;
    /**
     * The Multiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization
     * Meta information extracted from the WSDL
     * - documentation: Multiply Per Diem by Number of Days on Spend Authorization is selectable only if Per Diem and Enable Rate Tables for Spend Authorizations are also selected. Workday sets the field to false, irrespective of the value set on it, if
     * either of the other 2 fields are set to false.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Multiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization;
    /**
     * The Expense_Adjustment_Calculation_Method_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_Adjustment_Calculation_Method_DataType[]
     */
    public $Expense_Adjustment_Calculation_Method_Data;
    /**
     * The Hotel_Itemization_Mapping_Data
     * Meta information extracted from the WSDL
     * - documentation: Hotel Itemization Mapping table for Expense Item.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Hotel_Itemization_Mapping_DataType[]
     */
    public $Hotel_Itemization_Mapping_Data;
    /**
     * The Expense_Item_Distance_Calculation_Configuration_Data
     * Meta information extracted from the WSDL
     * - documentation: The configuration data for the distance calculation of expense items.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_Item_Distance_Calculation_Configuration_DataType[]
     */
    public $Expense_Item_Distance_Calculation_Configuration_Data;
    /**
     * The Related_Worktags_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Related_Worktag_Widget_DataType[]
     */
    public $Related_Worktags_Data;
    /**
     * Constructor method for Expense_Item_DataType
     * @uses Expense_Item_DataType::setExpense_Item_ID()
     * @uses Expense_Item_DataType::setItem_Name()
     * @uses Expense_Item_DataType::setResource_Category_Reference()
     * @uses Expense_Item_DataType::setItem_Description()
     * @uses Expense_Item_DataType::setSynonyms_and_Keywords()
     * @uses Expense_Item_DataType::setPer_Diem_Expense()
     * @uses Expense_Item_DataType::setItem_Unit_Price()
     * @uses Expense_Item_DataType::setCurrency_Reference()
     * @uses Expense_Item_DataType::setInstructional_Text()
     * @uses Expense_Item_DataType::setExpense_Policy_Group_Reference()
     * @uses Expense_Item_DataType::setExpense_Item_Group_Reference()
     * @uses Expense_Item_DataType::setJob_Profile_Reference()
     * @uses Expense_Item_DataType::setUnit_of_Measure_Reference()
     * @uses Expense_Item_DataType::setTax_Applicability_Reference()
     * @uses Expense_Item_DataType::setTravel_Journal()
     * @uses Expense_Item_DataType::setTravel_Journal_Item_Reference()
     * @uses Expense_Item_DataType::setTravel_Journal_Type_Reference()
     * @uses Expense_Item_DataType::setRounding_Option_for_Hours_Reference()
     * @uses Expense_Item_DataType::setNon_Editable_Number_of_Hours()
     * @uses Expense_Item_DataType::setQuantity_and_Per_Unit_Amount_Not_Enterable()
     * @uses Expense_Item_DataType::setInactive()
     * @uses Expense_Item_DataType::setFixed_Expense()
     * @uses Expense_Item_DataType::setMaximum_Line_Expense()
     * @uses Expense_Item_DataType::setMaximum_Daily_Expense()
     * @uses Expense_Item_DataType::setAllow_Overage()
     * @uses Expense_Item_DataType::setBased_on_Allowance_Plan()
     * @uses Expense_Item_DataType::setMemo_Required()
     * @uses Expense_Item_DataType::setDisplay_Arrival_Date_before_Departure_Date()
     * @uses Expense_Item_DataType::setNon_Editable_Number_of_Days()
     * @uses Expense_Item_DataType::setExpense_Item_Attribute_Data()
     * @uses Expense_Item_DataType::setExpense_Accumulator_Reference()
     * @uses Expense_Item_DataType::setExpense_Rate_Table_Reference()
     * @uses Expense_Item_DataType::setEnable_Rate_Tables_for_Spend_Authorizations()
     * @uses Expense_Item_DataType::setMultiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization()
     * @uses Expense_Item_DataType::setExpense_Adjustment_Calculation_Method_Data()
     * @uses Expense_Item_DataType::setHotel_Itemization_Mapping_Data()
     * @uses Expense_Item_DataType::setExpense_Item_Distance_Calculation_Configuration_Data()
     * @uses Expense_Item_DataType::setRelated_Worktags_Data()
     * @param string $expense_Item_ID
     * @param string $item_Name
     * @param \StructType\Spend_CategoryObjectType $resource_Category_Reference
     * @param string $item_Description
     * @param string $synonyms_and_Keywords
     * @param bool $per_Diem_Expense
     * @param float $item_Unit_Price
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param string $instructional_Text
     * @param \StructType\Expense_Policy_GroupObjectType[] $expense_Policy_Group_Reference
     * @param \StructType\Expense_Item_GroupObjectType[] $expense_Item_Group_Reference
     * @param \StructType\Job_ProfileObjectType[] $job_Profile_Reference
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @param bool $travel_Journal
     * @param \StructType\Expense_ItemObjectType $travel_Journal_Item_Reference
     * @param \StructType\Travel_Journal_TypeObjectType $travel_Journal_Type_Reference
     * @param \StructType\Rounding_OptionObjectType $rounding_Option_for_Hours_Reference
     * @param bool $non_Editable_Number_of_Hours
     * @param bool $quantity_and_Per_Unit_Amount_Not_Enterable
     * @param bool $inactive
     * @param bool $fixed_Expense
     * @param bool $maximum_Line_Expense
     * @param bool $maximum_Daily_Expense
     * @param bool $allow_Overage
     * @param bool $based_on_Allowance_Plan
     * @param bool $memo_Required
     * @param bool $display_Arrival_Date_before_Departure_Date
     * @param bool $non_Editable_Number_of_Days
     * @param \StructType\Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType[] $expense_Item_Attribute_Data
     * @param \StructType\Expense_AccumulatorObjectType $expense_Accumulator_Reference
     * @param \StructType\Expense_Rate_TableObjectType $expense_Rate_Table_Reference
     * @param bool $enable_Rate_Tables_for_Spend_Authorizations
     * @param bool $multiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization
     * @param \StructType\Expense_Adjustment_Calculation_Method_DataType[] $expense_Adjustment_Calculation_Method_Data
     * @param \StructType\Hotel_Itemization_Mapping_DataType[] $hotel_Itemization_Mapping_Data
     * @param \StructType\Expense_Item_Distance_Calculation_Configuration_DataType[] $expense_Item_Distance_Calculation_Configuration_Data
     * @param \StructType\Related_Worktag_Widget_DataType[] $related_Worktags_Data
     */
    public function __construct($expense_Item_ID = null, $item_Name = null, \StructType\Spend_CategoryObjectType $resource_Category_Reference = null, $item_Description = null, $synonyms_and_Keywords = null, $per_Diem_Expense = null, $item_Unit_Price = null, \StructType\CurrencyObjectType $currency_Reference = null, $instructional_Text = null, array $expense_Policy_Group_Reference = array(), array $expense_Item_Group_Reference = array(), array $job_Profile_Reference = array(), \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null, $travel_Journal = null, \StructType\Expense_ItemObjectType $travel_Journal_Item_Reference = null, \StructType\Travel_Journal_TypeObjectType $travel_Journal_Type_Reference = null, \StructType\Rounding_OptionObjectType $rounding_Option_for_Hours_Reference = null, $non_Editable_Number_of_Hours = null, $quantity_and_Per_Unit_Amount_Not_Enterable = null, $inactive = null, $fixed_Expense = null, $maximum_Line_Expense = null, $maximum_Daily_Expense = null, $allow_Overage = null, $based_on_Allowance_Plan = null, $memo_Required = null, $display_Arrival_Date_before_Departure_Date = null, $non_Editable_Number_of_Days = null, array $expense_Item_Attribute_Data = array(), \StructType\Expense_AccumulatorObjectType $expense_Accumulator_Reference = null, \StructType\Expense_Rate_TableObjectType $expense_Rate_Table_Reference = null, $enable_Rate_Tables_for_Spend_Authorizations = null, $multiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization = null, array $expense_Adjustment_Calculation_Method_Data = array(), array $hotel_Itemization_Mapping_Data = array(), array $expense_Item_Distance_Calculation_Configuration_Data = array(), array $related_Worktags_Data = array())
    {
        $this
            ->setExpense_Item_ID($expense_Item_ID)
            ->setItem_Name($item_Name)
            ->setResource_Category_Reference($resource_Category_Reference)
            ->setItem_Description($item_Description)
            ->setSynonyms_and_Keywords($synonyms_and_Keywords)
            ->setPer_Diem_Expense($per_Diem_Expense)
            ->setItem_Unit_Price($item_Unit_Price)
            ->setCurrency_Reference($currency_Reference)
            ->setInstructional_Text($instructional_Text)
            ->setExpense_Policy_Group_Reference($expense_Policy_Group_Reference)
            ->setExpense_Item_Group_Reference($expense_Item_Group_Reference)
            ->setJob_Profile_Reference($job_Profile_Reference)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setTax_Applicability_Reference($tax_Applicability_Reference)
            ->setTravel_Journal($travel_Journal)
            ->setTravel_Journal_Item_Reference($travel_Journal_Item_Reference)
            ->setTravel_Journal_Type_Reference($travel_Journal_Type_Reference)
            ->setRounding_Option_for_Hours_Reference($rounding_Option_for_Hours_Reference)
            ->setNon_Editable_Number_of_Hours($non_Editable_Number_of_Hours)
            ->setQuantity_and_Per_Unit_Amount_Not_Enterable($quantity_and_Per_Unit_Amount_Not_Enterable)
            ->setInactive($inactive)
            ->setFixed_Expense($fixed_Expense)
            ->setMaximum_Line_Expense($maximum_Line_Expense)
            ->setMaximum_Daily_Expense($maximum_Daily_Expense)
            ->setAllow_Overage($allow_Overage)
            ->setBased_on_Allowance_Plan($based_on_Allowance_Plan)
            ->setMemo_Required($memo_Required)
            ->setDisplay_Arrival_Date_before_Departure_Date($display_Arrival_Date_before_Departure_Date)
            ->setNon_Editable_Number_of_Days($non_Editable_Number_of_Days)
            ->setExpense_Item_Attribute_Data($expense_Item_Attribute_Data)
            ->setExpense_Accumulator_Reference($expense_Accumulator_Reference)
            ->setExpense_Rate_Table_Reference($expense_Rate_Table_Reference)
            ->setEnable_Rate_Tables_for_Spend_Authorizations($enable_Rate_Tables_for_Spend_Authorizations)
            ->setMultiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization($multiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization)
            ->setExpense_Adjustment_Calculation_Method_Data($expense_Adjustment_Calculation_Method_Data)
            ->setHotel_Itemization_Mapping_Data($hotel_Itemization_Mapping_Data)
            ->setExpense_Item_Distance_Calculation_Configuration_Data($expense_Item_Distance_Calculation_Configuration_Data)
            ->setRelated_Worktags_Data($related_Worktags_Data);
    }
    /**
     * Get Expense_Item_ID value
     * @return string|null
     */
    public function getExpense_Item_ID()
    {
        return $this->Expense_Item_ID;
    }
    /**
     * Set Expense_Item_ID value
     * @param string $expense_Item_ID
     * @return \StructType\Expense_Item_DataType
     */
    public function setExpense_Item_ID($expense_Item_ID = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Item_ID) && !is_string($expense_Item_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Item_ID, true), gettype($expense_Item_ID)), __LINE__);
        }
        $this->Expense_Item_ID = $expense_Item_ID;
        return $this;
    }
    /**
     * Get Item_Name value
     * @return string|null
     */
    public function getItem_Name()
    {
        return $this->Item_Name;
    }
    /**
     * Set Item_Name value
     * @param string $item_Name
     * @return \StructType\Expense_Item_DataType
     */
    public function setItem_Name($item_Name = null)
    {
        // validation for constraint: string
        if (!is_null($item_Name) && !is_string($item_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Name, true), gettype($item_Name)), __LINE__);
        }
        $this->Item_Name = $item_Name;
        return $this;
    }
    /**
     * Get Resource_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getResource_Category_Reference()
    {
        return $this->Resource_Category_Reference;
    }
    /**
     * Set Resource_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $resource_Category_Reference
     * @return \StructType\Expense_Item_DataType
     */
    public function setResource_Category_Reference(\StructType\Spend_CategoryObjectType $resource_Category_Reference = null)
    {
        $this->Resource_Category_Reference = $resource_Category_Reference;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Expense_Item_DataType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get Synonyms_and_Keywords value
     * @return string|null
     */
    public function getSynonyms_and_Keywords()
    {
        return $this->Synonyms_and_Keywords;
    }
    /**
     * Set Synonyms_and_Keywords value
     * @param string $synonyms_and_Keywords
     * @return \StructType\Expense_Item_DataType
     */
    public function setSynonyms_and_Keywords($synonyms_and_Keywords = null)
    {
        // validation for constraint: string
        if (!is_null($synonyms_and_Keywords) && !is_string($synonyms_and_Keywords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($synonyms_and_Keywords, true), gettype($synonyms_and_Keywords)), __LINE__);
        }
        $this->Synonyms_and_Keywords = $synonyms_and_Keywords;
        return $this;
    }
    /**
     * Get Per_Diem_Expense value
     * @return bool|null
     */
    public function getPer_Diem_Expense()
    {
        return $this->Per_Diem_Expense;
    }
    /**
     * Set Per_Diem_Expense value
     * @param bool $per_Diem_Expense
     * @return \StructType\Expense_Item_DataType
     */
    public function setPer_Diem_Expense($per_Diem_Expense = null)
    {
        // validation for constraint: boolean
        if (!is_null($per_Diem_Expense) && !is_bool($per_Diem_Expense)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($per_Diem_Expense, true), gettype($per_Diem_Expense)), __LINE__);
        }
        $this->Per_Diem_Expense = $per_Diem_Expense;
        return $this;
    }
    /**
     * Get Item_Unit_Price value
     * @return float|null
     */
    public function getItem_Unit_Price()
    {
        return $this->Item_Unit_Price;
    }
    /**
     * Set Item_Unit_Price value
     * @param float $item_Unit_Price
     * @return \StructType\Expense_Item_DataType
     */
    public function setItem_Unit_Price($item_Unit_Price = null)
    {
        // validation for constraint: float
        if (!is_null($item_Unit_Price) && !(is_float($item_Unit_Price) || is_numeric($item_Unit_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($item_Unit_Price, true), gettype($item_Unit_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($item_Unit_Price) && mb_strlen(mb_substr($item_Unit_Price, false !== mb_strpos($item_Unit_Price, '.') ? mb_strpos($item_Unit_Price, '.') + 1 : mb_strlen($item_Unit_Price))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($item_Unit_Price, true), mb_strlen(mb_substr($item_Unit_Price, mb_strpos($item_Unit_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($item_Unit_Price) && mb_strlen(preg_replace('/(\D)/', '', $item_Unit_Price)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($item_Unit_Price, true), mb_strlen(preg_replace('/(\D)/', '', $item_Unit_Price))), __LINE__);
        }
        $this->Item_Unit_Price = $item_Unit_Price;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Expense_Item_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Instructional_Text value
     * @return string|null
     */
    public function getInstructional_Text()
    {
        return $this->Instructional_Text;
    }
    /**
     * Set Instructional_Text value
     * @param string $instructional_Text
     * @return \StructType\Expense_Item_DataType
     */
    public function setInstructional_Text($instructional_Text = null)
    {
        // validation for constraint: string
        if (!is_null($instructional_Text) && !is_string($instructional_Text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instructional_Text, true), gettype($instructional_Text)), __LINE__);
        }
        $this->Instructional_Text = $instructional_Text;
        return $this;
    }
    /**
     * Get Expense_Policy_Group_Reference value
     * @return \StructType\Expense_Policy_GroupObjectType[]|null
     */
    public function getExpense_Policy_Group_Reference()
    {
        return $this->Expense_Policy_Group_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Policy_Group_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Policy_Group_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Policy_Group_ReferenceForArrayConstraintsFromSetExpense_Policy_Group_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Item_DataTypeExpense_Policy_Group_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Item_DataTypeExpense_Policy_Group_ReferenceItem instanceof \StructType\Expense_Policy_GroupObjectType) {
                $invalidValues[] = is_object($expense_Item_DataTypeExpense_Policy_Group_ReferenceItem) ? get_class($expense_Item_DataTypeExpense_Policy_Group_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Item_DataTypeExpense_Policy_Group_ReferenceItem), var_export($expense_Item_DataTypeExpense_Policy_Group_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Policy_Group_Reference property can only contain items of type \StructType\Expense_Policy_GroupObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Policy_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Policy_GroupObjectType[] $expense_Policy_Group_Reference
     * @return \StructType\Expense_Item_DataType
     */
    public function setExpense_Policy_Group_Reference(array $expense_Policy_Group_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Policy_Group_ReferenceArrayErrorMessage = self::validateExpense_Policy_Group_ReferenceForArrayConstraintsFromSetExpense_Policy_Group_Reference($expense_Policy_Group_Reference))) {
            throw new \InvalidArgumentException($expense_Policy_Group_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Policy_Group_Reference = $expense_Policy_Group_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Policy_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Policy_GroupObjectType $item
     * @return \StructType\Expense_Item_DataType
     */
    public function addToExpense_Policy_Group_Reference(\StructType\Expense_Policy_GroupObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_Policy_GroupObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Policy_Group_Reference property can only contain items of type \StructType\Expense_Policy_GroupObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Policy_Group_Reference[] = $item;
        return $this;
    }
    /**
     * Get Expense_Item_Group_Reference value
     * @return \StructType\Expense_Item_GroupObjectType[]|null
     */
    public function getExpense_Item_Group_Reference()
    {
        return $this->Expense_Item_Group_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Item_Group_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Item_Group_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Item_Group_ReferenceForArrayConstraintsFromSetExpense_Item_Group_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Item_DataTypeExpense_Item_Group_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Item_DataTypeExpense_Item_Group_ReferenceItem instanceof \StructType\Expense_Item_GroupObjectType) {
                $invalidValues[] = is_object($expense_Item_DataTypeExpense_Item_Group_ReferenceItem) ? get_class($expense_Item_DataTypeExpense_Item_Group_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Item_DataTypeExpense_Item_Group_ReferenceItem), var_export($expense_Item_DataTypeExpense_Item_Group_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Item_Group_Reference property can only contain items of type \StructType\Expense_Item_GroupObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Item_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Item_GroupObjectType[] $expense_Item_Group_Reference
     * @return \StructType\Expense_Item_DataType
     */
    public function setExpense_Item_Group_Reference(array $expense_Item_Group_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Item_Group_ReferenceArrayErrorMessage = self::validateExpense_Item_Group_ReferenceForArrayConstraintsFromSetExpense_Item_Group_Reference($expense_Item_Group_Reference))) {
            throw new \InvalidArgumentException($expense_Item_Group_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Item_Group_Reference = $expense_Item_Group_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Item_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Item_GroupObjectType $item
     * @return \StructType\Expense_Item_DataType
     */
    public function addToExpense_Item_Group_Reference(\StructType\Expense_Item_GroupObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_Item_GroupObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Item_Group_Reference property can only contain items of type \StructType\Expense_Item_GroupObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Item_Group_Reference[] = $item;
        return $this;
    }
    /**
     * Get Job_Profile_Reference value
     * @return \StructType\Job_ProfileObjectType[]|null
     */
    public function getJob_Profile_Reference()
    {
        return $this->Job_Profile_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Profile_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Profile_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Profile_ReferenceForArrayConstraintsFromSetJob_Profile_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Item_DataTypeJob_Profile_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Item_DataTypeJob_Profile_ReferenceItem instanceof \StructType\Job_ProfileObjectType) {
                $invalidValues[] = is_object($expense_Item_DataTypeJob_Profile_ReferenceItem) ? get_class($expense_Item_DataTypeJob_Profile_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Item_DataTypeJob_Profile_ReferenceItem), var_export($expense_Item_DataTypeJob_Profile_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Profile_Reference property can only contain items of type \StructType\Job_ProfileObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Profile_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_ProfileObjectType[] $job_Profile_Reference
     * @return \StructType\Expense_Item_DataType
     */
    public function setJob_Profile_Reference(array $job_Profile_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Profile_ReferenceArrayErrorMessage = self::validateJob_Profile_ReferenceForArrayConstraintsFromSetJob_Profile_Reference($job_Profile_Reference))) {
            throw new \InvalidArgumentException($job_Profile_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Job_Profile_Reference = $job_Profile_Reference;
        return $this;
    }
    /**
     * Add item to Job_Profile_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_ProfileObjectType $item
     * @return \StructType\Expense_Item_DataType
     */
    public function addToJob_Profile_Reference(\StructType\Job_ProfileObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_ProfileObjectType) {
            throw new \InvalidArgumentException(sprintf('The Job_Profile_Reference property can only contain items of type \StructType\Job_ProfileObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Profile_Reference[] = $item;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Expense_Item_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Tax_Applicability_Reference value
     * @return \StructType\Tax_ApplicabilityObjectType|null
     */
    public function getTax_Applicability_Reference()
    {
        return $this->Tax_Applicability_Reference;
    }
    /**
     * Set Tax_Applicability_Reference value
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @return \StructType\Expense_Item_DataType
     */
    public function setTax_Applicability_Reference(\StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null)
    {
        $this->Tax_Applicability_Reference = $tax_Applicability_Reference;
        return $this;
    }
    /**
     * Get Travel_Journal value
     * @return bool|null
     */
    public function getTravel_Journal()
    {
        return $this->Travel_Journal;
    }
    /**
     * Set Travel_Journal value
     * @param bool $travel_Journal
     * @return \StructType\Expense_Item_DataType
     */
    public function setTravel_Journal($travel_Journal = null)
    {
        // validation for constraint: boolean
        if (!is_null($travel_Journal) && !is_bool($travel_Journal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($travel_Journal, true), gettype($travel_Journal)), __LINE__);
        }
        $this->Travel_Journal = $travel_Journal;
        return $this;
    }
    /**
     * Get Travel_Journal_Item_Reference value
     * @return \StructType\Expense_ItemObjectType|null
     */
    public function getTravel_Journal_Item_Reference()
    {
        return $this->Travel_Journal_Item_Reference;
    }
    /**
     * Set Travel_Journal_Item_Reference value
     * @param \StructType\Expense_ItemObjectType $travel_Journal_Item_Reference
     * @return \StructType\Expense_Item_DataType
     */
    public function setTravel_Journal_Item_Reference(\StructType\Expense_ItemObjectType $travel_Journal_Item_Reference = null)
    {
        $this->Travel_Journal_Item_Reference = $travel_Journal_Item_Reference;
        return $this;
    }
    /**
     * Get Travel_Journal_Type_Reference value
     * @return \StructType\Travel_Journal_TypeObjectType|null
     */
    public function getTravel_Journal_Type_Reference()
    {
        return $this->Travel_Journal_Type_Reference;
    }
    /**
     * Set Travel_Journal_Type_Reference value
     * @param \StructType\Travel_Journal_TypeObjectType $travel_Journal_Type_Reference
     * @return \StructType\Expense_Item_DataType
     */
    public function setTravel_Journal_Type_Reference(\StructType\Travel_Journal_TypeObjectType $travel_Journal_Type_Reference = null)
    {
        $this->Travel_Journal_Type_Reference = $travel_Journal_Type_Reference;
        return $this;
    }
    /**
     * Get Rounding_Option_for_Hours_Reference value
     * @return \StructType\Rounding_OptionObjectType|null
     */
    public function getRounding_Option_for_Hours_Reference()
    {
        return $this->Rounding_Option_for_Hours_Reference;
    }
    /**
     * Set Rounding_Option_for_Hours_Reference value
     * @param \StructType\Rounding_OptionObjectType $rounding_Option_for_Hours_Reference
     * @return \StructType\Expense_Item_DataType
     */
    public function setRounding_Option_for_Hours_Reference(\StructType\Rounding_OptionObjectType $rounding_Option_for_Hours_Reference = null)
    {
        $this->Rounding_Option_for_Hours_Reference = $rounding_Option_for_Hours_Reference;
        return $this;
    }
    /**
     * Get Non_Editable_Number_of_Hours value
     * @return bool|null
     */
    public function getNon_Editable_Number_of_Hours()
    {
        return $this->Non_Editable_Number_of_Hours;
    }
    /**
     * Set Non_Editable_Number_of_Hours value
     * @param bool $non_Editable_Number_of_Hours
     * @return \StructType\Expense_Item_DataType
     */
    public function setNon_Editable_Number_of_Hours($non_Editable_Number_of_Hours = null)
    {
        // validation for constraint: boolean
        if (!is_null($non_Editable_Number_of_Hours) && !is_bool($non_Editable_Number_of_Hours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($non_Editable_Number_of_Hours, true), gettype($non_Editable_Number_of_Hours)), __LINE__);
        }
        $this->Non_Editable_Number_of_Hours = $non_Editable_Number_of_Hours;
        return $this;
    }
    /**
     * Get Quantity_and_Per_Unit_Amount_Not_Enterable value
     * @return bool|null
     */
    public function getQuantity_and_Per_Unit_Amount_Not_Enterable()
    {
        return $this->Quantity_and_Per_Unit_Amount_Not_Enterable;
    }
    /**
     * Set Quantity_and_Per_Unit_Amount_Not_Enterable value
     * @param bool $quantity_and_Per_Unit_Amount_Not_Enterable
     * @return \StructType\Expense_Item_DataType
     */
    public function setQuantity_and_Per_Unit_Amount_Not_Enterable($quantity_and_Per_Unit_Amount_Not_Enterable = null)
    {
        // validation for constraint: boolean
        if (!is_null($quantity_and_Per_Unit_Amount_Not_Enterable) && !is_bool($quantity_and_Per_Unit_Amount_Not_Enterable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($quantity_and_Per_Unit_Amount_Not_Enterable, true), gettype($quantity_and_Per_Unit_Amount_Not_Enterable)), __LINE__);
        }
        $this->Quantity_and_Per_Unit_Amount_Not_Enterable = $quantity_and_Per_Unit_Amount_Not_Enterable;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Expense_Item_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Fixed_Expense value
     * @return bool|null
     */
    public function getFixed_Expense()
    {
        return $this->Fixed_Expense;
    }
    /**
     * Set Fixed_Expense value
     * @param bool $fixed_Expense
     * @return \StructType\Expense_Item_DataType
     */
    public function setFixed_Expense($fixed_Expense = null)
    {
        // validation for constraint: boolean
        if (!is_null($fixed_Expense) && !is_bool($fixed_Expense)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fixed_Expense, true), gettype($fixed_Expense)), __LINE__);
        }
        $this->Fixed_Expense = $fixed_Expense;
        return $this;
    }
    /**
     * Get Maximum_Line_Expense value
     * @return bool|null
     */
    public function getMaximum_Line_Expense()
    {
        return $this->Maximum_Line_Expense;
    }
    /**
     * Set Maximum_Line_Expense value
     * @param bool $maximum_Line_Expense
     * @return \StructType\Expense_Item_DataType
     */
    public function setMaximum_Line_Expense($maximum_Line_Expense = null)
    {
        // validation for constraint: boolean
        if (!is_null($maximum_Line_Expense) && !is_bool($maximum_Line_Expense)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($maximum_Line_Expense, true), gettype($maximum_Line_Expense)), __LINE__);
        }
        $this->Maximum_Line_Expense = $maximum_Line_Expense;
        return $this;
    }
    /**
     * Get Maximum_Daily_Expense value
     * @return bool|null
     */
    public function getMaximum_Daily_Expense()
    {
        return $this->Maximum_Daily_Expense;
    }
    /**
     * Set Maximum_Daily_Expense value
     * @param bool $maximum_Daily_Expense
     * @return \StructType\Expense_Item_DataType
     */
    public function setMaximum_Daily_Expense($maximum_Daily_Expense = null)
    {
        // validation for constraint: boolean
        if (!is_null($maximum_Daily_Expense) && !is_bool($maximum_Daily_Expense)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($maximum_Daily_Expense, true), gettype($maximum_Daily_Expense)), __LINE__);
        }
        $this->Maximum_Daily_Expense = $maximum_Daily_Expense;
        return $this;
    }
    /**
     * Get Allow_Overage value
     * @return bool|null
     */
    public function getAllow_Overage()
    {
        return $this->Allow_Overage;
    }
    /**
     * Set Allow_Overage value
     * @param bool $allow_Overage
     * @return \StructType\Expense_Item_DataType
     */
    public function setAllow_Overage($allow_Overage = null)
    {
        // validation for constraint: boolean
        if (!is_null($allow_Overage) && !is_bool($allow_Overage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allow_Overage, true), gettype($allow_Overage)), __LINE__);
        }
        $this->Allow_Overage = $allow_Overage;
        return $this;
    }
    /**
     * Get Based_on_Allowance_Plan value
     * @return bool|null
     */
    public function getBased_on_Allowance_Plan()
    {
        return $this->Based_on_Allowance_Plan;
    }
    /**
     * Set Based_on_Allowance_Plan value
     * @param bool $based_on_Allowance_Plan
     * @return \StructType\Expense_Item_DataType
     */
    public function setBased_on_Allowance_Plan($based_on_Allowance_Plan = null)
    {
        // validation for constraint: boolean
        if (!is_null($based_on_Allowance_Plan) && !is_bool($based_on_Allowance_Plan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($based_on_Allowance_Plan, true), gettype($based_on_Allowance_Plan)), __LINE__);
        }
        $this->Based_on_Allowance_Plan = $based_on_Allowance_Plan;
        return $this;
    }
    /**
     * Get Memo_Required value
     * @return bool|null
     */
    public function getMemo_Required()
    {
        return $this->Memo_Required;
    }
    /**
     * Set Memo_Required value
     * @param bool $memo_Required
     * @return \StructType\Expense_Item_DataType
     */
    public function setMemo_Required($memo_Required = null)
    {
        // validation for constraint: boolean
        if (!is_null($memo_Required) && !is_bool($memo_Required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($memo_Required, true), gettype($memo_Required)), __LINE__);
        }
        $this->Memo_Required = $memo_Required;
        return $this;
    }
    /**
     * Get Display_Arrival_Date_before_Departure_Date value
     * @return bool|null
     */
    public function getDisplay_Arrival_Date_before_Departure_Date()
    {
        return $this->Display_Arrival_Date_before_Departure_Date;
    }
    /**
     * Set Display_Arrival_Date_before_Departure_Date value
     * @param bool $display_Arrival_Date_before_Departure_Date
     * @return \StructType\Expense_Item_DataType
     */
    public function setDisplay_Arrival_Date_before_Departure_Date($display_Arrival_Date_before_Departure_Date = null)
    {
        // validation for constraint: boolean
        if (!is_null($display_Arrival_Date_before_Departure_Date) && !is_bool($display_Arrival_Date_before_Departure_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($display_Arrival_Date_before_Departure_Date, true), gettype($display_Arrival_Date_before_Departure_Date)), __LINE__);
        }
        $this->Display_Arrival_Date_before_Departure_Date = $display_Arrival_Date_before_Departure_Date;
        return $this;
    }
    /**
     * Get Non_Editable_Number_of_Days value
     * @return bool|null
     */
    public function getNon_Editable_Number_of_Days()
    {
        return $this->Non_Editable_Number_of_Days;
    }
    /**
     * Set Non_Editable_Number_of_Days value
     * @param bool $non_Editable_Number_of_Days
     * @return \StructType\Expense_Item_DataType
     */
    public function setNon_Editable_Number_of_Days($non_Editable_Number_of_Days = null)
    {
        // validation for constraint: boolean
        if (!is_null($non_Editable_Number_of_Days) && !is_bool($non_Editable_Number_of_Days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($non_Editable_Number_of_Days, true), gettype($non_Editable_Number_of_Days)), __LINE__);
        }
        $this->Non_Editable_Number_of_Days = $non_Editable_Number_of_Days;
        return $this;
    }
    /**
     * Get Expense_Item_Attribute_Data value
     * @return \StructType\Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType[]|null
     */
    public function getExpense_Item_Attribute_Data()
    {
        return $this->Expense_Item_Attribute_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Item_Attribute_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Item_Attribute_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Item_Attribute_DataForArrayConstraintsFromSetExpense_Item_Attribute_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Item_DataTypeExpense_Item_Attribute_DataItem) {
            // validation for constraint: itemType
            if (!$expense_Item_DataTypeExpense_Item_Attribute_DataItem instanceof \StructType\Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType) {
                $invalidValues[] = is_object($expense_Item_DataTypeExpense_Item_Attribute_DataItem) ? get_class($expense_Item_DataTypeExpense_Item_Attribute_DataItem) : sprintf('%s(%s)', gettype($expense_Item_DataTypeExpense_Item_Attribute_DataItem), var_export($expense_Item_DataTypeExpense_Item_Attribute_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Item_Attribute_Data property can only contain items of type \StructType\Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Item_Attribute_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType[] $expense_Item_Attribute_Data
     * @return \StructType\Expense_Item_DataType
     */
    public function setExpense_Item_Attribute_Data(array $expense_Item_Attribute_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Item_Attribute_DataArrayErrorMessage = self::validateExpense_Item_Attribute_DataForArrayConstraintsFromSetExpense_Item_Attribute_Data($expense_Item_Attribute_Data))) {
            throw new \InvalidArgumentException($expense_Item_Attribute_DataArrayErrorMessage, __LINE__);
        }
        $this->Expense_Item_Attribute_Data = $expense_Item_Attribute_Data;
        return $this;
    }
    /**
     * Add item to Expense_Item_Attribute_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType $item
     * @return \StructType\Expense_Item_DataType
     */
    public function addToExpense_Item_Attribute_Data(\StructType\Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Item_Attribute_Data property can only contain items of type \StructType\Expense_Item_Attribute_and_Type_Subedit_Web_ServiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Item_Attribute_Data[] = $item;
        return $this;
    }
    /**
     * Get Expense_Accumulator_Reference value
     * @return \StructType\Expense_AccumulatorObjectType|null
     */
    public function getExpense_Accumulator_Reference()
    {
        return $this->Expense_Accumulator_Reference;
    }
    /**
     * Set Expense_Accumulator_Reference value
     * @param \StructType\Expense_AccumulatorObjectType $expense_Accumulator_Reference
     * @return \StructType\Expense_Item_DataType
     */
    public function setExpense_Accumulator_Reference(\StructType\Expense_AccumulatorObjectType $expense_Accumulator_Reference = null)
    {
        $this->Expense_Accumulator_Reference = $expense_Accumulator_Reference;
        return $this;
    }
    /**
     * Get Expense_Rate_Table_Reference value
     * @return \StructType\Expense_Rate_TableObjectType|null
     */
    public function getExpense_Rate_Table_Reference()
    {
        return $this->Expense_Rate_Table_Reference;
    }
    /**
     * Set Expense_Rate_Table_Reference value
     * @param \StructType\Expense_Rate_TableObjectType $expense_Rate_Table_Reference
     * @return \StructType\Expense_Item_DataType
     */
    public function setExpense_Rate_Table_Reference(\StructType\Expense_Rate_TableObjectType $expense_Rate_Table_Reference = null)
    {
        $this->Expense_Rate_Table_Reference = $expense_Rate_Table_Reference;
        return $this;
    }
    /**
     * Get Enable_Rate_Tables_for_Spend_Authorizations value
     * @return bool|null
     */
    public function getEnable_Rate_Tables_for_Spend_Authorizations()
    {
        return $this->Enable_Rate_Tables_for_Spend_Authorizations;
    }
    /**
     * Set Enable_Rate_Tables_for_Spend_Authorizations value
     * @param bool $enable_Rate_Tables_for_Spend_Authorizations
     * @return \StructType\Expense_Item_DataType
     */
    public function setEnable_Rate_Tables_for_Spend_Authorizations($enable_Rate_Tables_for_Spend_Authorizations = null)
    {
        // validation for constraint: boolean
        if (!is_null($enable_Rate_Tables_for_Spend_Authorizations) && !is_bool($enable_Rate_Tables_for_Spend_Authorizations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enable_Rate_Tables_for_Spend_Authorizations, true), gettype($enable_Rate_Tables_for_Spend_Authorizations)), __LINE__);
        }
        $this->Enable_Rate_Tables_for_Spend_Authorizations = $enable_Rate_Tables_for_Spend_Authorizations;
        return $this;
    }
    /**
     * Get Multiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization value
     * @return bool|null
     */
    public function getMultiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization()
    {
        return $this->Multiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization;
    }
    /**
     * Set Multiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization value
     * @param bool $multiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization
     * @return \StructType\Expense_Item_DataType
     */
    public function setMultiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization($multiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization = null)
    {
        // validation for constraint: boolean
        if (!is_null($multiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization) && !is_bool($multiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization, true), gettype($multiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization)), __LINE__);
        }
        $this->Multiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization = $multiply_Per_Diem_by_Number_of_Days_on_Spend_Authorization;
        return $this;
    }
    /**
     * Get Expense_Adjustment_Calculation_Method_Data value
     * @return \StructType\Expense_Adjustment_Calculation_Method_DataType[]|null
     */
    public function getExpense_Adjustment_Calculation_Method_Data()
    {
        return $this->Expense_Adjustment_Calculation_Method_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Adjustment_Calculation_Method_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Adjustment_Calculation_Method_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Adjustment_Calculation_Method_DataForArrayConstraintsFromSetExpense_Adjustment_Calculation_Method_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Item_DataTypeExpense_Adjustment_Calculation_Method_DataItem) {
            // validation for constraint: itemType
            if (!$expense_Item_DataTypeExpense_Adjustment_Calculation_Method_DataItem instanceof \StructType\Expense_Adjustment_Calculation_Method_DataType) {
                $invalidValues[] = is_object($expense_Item_DataTypeExpense_Adjustment_Calculation_Method_DataItem) ? get_class($expense_Item_DataTypeExpense_Adjustment_Calculation_Method_DataItem) : sprintf('%s(%s)', gettype($expense_Item_DataTypeExpense_Adjustment_Calculation_Method_DataItem), var_export($expense_Item_DataTypeExpense_Adjustment_Calculation_Method_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Adjustment_Calculation_Method_Data property can only contain items of type \StructType\Expense_Adjustment_Calculation_Method_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Adjustment_Calculation_Method_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Adjustment_Calculation_Method_DataType[] $expense_Adjustment_Calculation_Method_Data
     * @return \StructType\Expense_Item_DataType
     */
    public function setExpense_Adjustment_Calculation_Method_Data(array $expense_Adjustment_Calculation_Method_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Adjustment_Calculation_Method_DataArrayErrorMessage = self::validateExpense_Adjustment_Calculation_Method_DataForArrayConstraintsFromSetExpense_Adjustment_Calculation_Method_Data($expense_Adjustment_Calculation_Method_Data))) {
            throw new \InvalidArgumentException($expense_Adjustment_Calculation_Method_DataArrayErrorMessage, __LINE__);
        }
        $this->Expense_Adjustment_Calculation_Method_Data = $expense_Adjustment_Calculation_Method_Data;
        return $this;
    }
    /**
     * Add item to Expense_Adjustment_Calculation_Method_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Adjustment_Calculation_Method_DataType $item
     * @return \StructType\Expense_Item_DataType
     */
    public function addToExpense_Adjustment_Calculation_Method_Data(\StructType\Expense_Adjustment_Calculation_Method_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_Adjustment_Calculation_Method_DataType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Adjustment_Calculation_Method_Data property can only contain items of type \StructType\Expense_Adjustment_Calculation_Method_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Adjustment_Calculation_Method_Data[] = $item;
        return $this;
    }
    /**
     * Get Hotel_Itemization_Mapping_Data value
     * @return \StructType\Hotel_Itemization_Mapping_DataType[]|null
     */
    public function getHotel_Itemization_Mapping_Data()
    {
        return $this->Hotel_Itemization_Mapping_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setHotel_Itemization_Mapping_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotel_Itemization_Mapping_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotel_Itemization_Mapping_DataForArrayConstraintsFromSetHotel_Itemization_Mapping_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Item_DataTypeHotel_Itemization_Mapping_DataItem) {
            // validation for constraint: itemType
            if (!$expense_Item_DataTypeHotel_Itemization_Mapping_DataItem instanceof \StructType\Hotel_Itemization_Mapping_DataType) {
                $invalidValues[] = is_object($expense_Item_DataTypeHotel_Itemization_Mapping_DataItem) ? get_class($expense_Item_DataTypeHotel_Itemization_Mapping_DataItem) : sprintf('%s(%s)', gettype($expense_Item_DataTypeHotel_Itemization_Mapping_DataItem), var_export($expense_Item_DataTypeHotel_Itemization_Mapping_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Hotel_Itemization_Mapping_Data property can only contain items of type \StructType\Hotel_Itemization_Mapping_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Hotel_Itemization_Mapping_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Hotel_Itemization_Mapping_DataType[] $hotel_Itemization_Mapping_Data
     * @return \StructType\Expense_Item_DataType
     */
    public function setHotel_Itemization_Mapping_Data(array $hotel_Itemization_Mapping_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($hotel_Itemization_Mapping_DataArrayErrorMessage = self::validateHotel_Itemization_Mapping_DataForArrayConstraintsFromSetHotel_Itemization_Mapping_Data($hotel_Itemization_Mapping_Data))) {
            throw new \InvalidArgumentException($hotel_Itemization_Mapping_DataArrayErrorMessage, __LINE__);
        }
        $this->Hotel_Itemization_Mapping_Data = $hotel_Itemization_Mapping_Data;
        return $this;
    }
    /**
     * Add item to Hotel_Itemization_Mapping_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Hotel_Itemization_Mapping_DataType $item
     * @return \StructType\Expense_Item_DataType
     */
    public function addToHotel_Itemization_Mapping_Data(\StructType\Hotel_Itemization_Mapping_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Hotel_Itemization_Mapping_DataType) {
            throw new \InvalidArgumentException(sprintf('The Hotel_Itemization_Mapping_Data property can only contain items of type \StructType\Hotel_Itemization_Mapping_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Hotel_Itemization_Mapping_Data[] = $item;
        return $this;
    }
    /**
     * Get Expense_Item_Distance_Calculation_Configuration_Data value
     * @return \StructType\Expense_Item_Distance_Calculation_Configuration_DataType[]|null
     */
    public function getExpense_Item_Distance_Calculation_Configuration_Data()
    {
        return $this->Expense_Item_Distance_Calculation_Configuration_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Item_Distance_Calculation_Configuration_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Item_Distance_Calculation_Configuration_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Item_Distance_Calculation_Configuration_DataForArrayConstraintsFromSetExpense_Item_Distance_Calculation_Configuration_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Item_DataTypeExpense_Item_Distance_Calculation_Configuration_DataItem) {
            // validation for constraint: itemType
            if (!$expense_Item_DataTypeExpense_Item_Distance_Calculation_Configuration_DataItem instanceof \StructType\Expense_Item_Distance_Calculation_Configuration_DataType) {
                $invalidValues[] = is_object($expense_Item_DataTypeExpense_Item_Distance_Calculation_Configuration_DataItem) ? get_class($expense_Item_DataTypeExpense_Item_Distance_Calculation_Configuration_DataItem) : sprintf('%s(%s)', gettype($expense_Item_DataTypeExpense_Item_Distance_Calculation_Configuration_DataItem), var_export($expense_Item_DataTypeExpense_Item_Distance_Calculation_Configuration_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Item_Distance_Calculation_Configuration_Data property can only contain items of type \StructType\Expense_Item_Distance_Calculation_Configuration_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Item_Distance_Calculation_Configuration_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Item_Distance_Calculation_Configuration_DataType[] $expense_Item_Distance_Calculation_Configuration_Data
     * @return \StructType\Expense_Item_DataType
     */
    public function setExpense_Item_Distance_Calculation_Configuration_Data(array $expense_Item_Distance_Calculation_Configuration_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Item_Distance_Calculation_Configuration_DataArrayErrorMessage = self::validateExpense_Item_Distance_Calculation_Configuration_DataForArrayConstraintsFromSetExpense_Item_Distance_Calculation_Configuration_Data($expense_Item_Distance_Calculation_Configuration_Data))) {
            throw new \InvalidArgumentException($expense_Item_Distance_Calculation_Configuration_DataArrayErrorMessage, __LINE__);
        }
        $this->Expense_Item_Distance_Calculation_Configuration_Data = $expense_Item_Distance_Calculation_Configuration_Data;
        return $this;
    }
    /**
     * Add item to Expense_Item_Distance_Calculation_Configuration_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Item_Distance_Calculation_Configuration_DataType $item
     * @return \StructType\Expense_Item_DataType
     */
    public function addToExpense_Item_Distance_Calculation_Configuration_Data(\StructType\Expense_Item_Distance_Calculation_Configuration_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_Item_Distance_Calculation_Configuration_DataType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Item_Distance_Calculation_Configuration_Data property can only contain items of type \StructType\Expense_Item_Distance_Calculation_Configuration_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Item_Distance_Calculation_Configuration_Data[] = $item;
        return $this;
    }
    /**
     * Get Related_Worktags_Data value
     * @return \StructType\Related_Worktag_Widget_DataType[]|null
     */
    public function getRelated_Worktags_Data()
    {
        return $this->Related_Worktags_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRelated_Worktags_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelated_Worktags_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelated_Worktags_DataForArrayConstraintsFromSetRelated_Worktags_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Item_DataTypeRelated_Worktags_DataItem) {
            // validation for constraint: itemType
            if (!$expense_Item_DataTypeRelated_Worktags_DataItem instanceof \StructType\Related_Worktag_Widget_DataType) {
                $invalidValues[] = is_object($expense_Item_DataTypeRelated_Worktags_DataItem) ? get_class($expense_Item_DataTypeRelated_Worktags_DataItem) : sprintf('%s(%s)', gettype($expense_Item_DataTypeRelated_Worktags_DataItem), var_export($expense_Item_DataTypeRelated_Worktags_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Related_Worktags_Data property can only contain items of type \StructType\Related_Worktag_Widget_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Related_Worktags_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Related_Worktag_Widget_DataType[] $related_Worktags_Data
     * @return \StructType\Expense_Item_DataType
     */
    public function setRelated_Worktags_Data(array $related_Worktags_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($related_Worktags_DataArrayErrorMessage = self::validateRelated_Worktags_DataForArrayConstraintsFromSetRelated_Worktags_Data($related_Worktags_Data))) {
            throw new \InvalidArgumentException($related_Worktags_DataArrayErrorMessage, __LINE__);
        }
        $this->Related_Worktags_Data = $related_Worktags_Data;
        return $this;
    }
    /**
     * Add item to Related_Worktags_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Related_Worktag_Widget_DataType $item
     * @return \StructType\Expense_Item_DataType
     */
    public function addToRelated_Worktags_Data(\StructType\Related_Worktag_Widget_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Related_Worktag_Widget_DataType) {
            throw new \InvalidArgumentException(sprintf('The Related_Worktags_Data property can only contain items of type \StructType\Related_Worktag_Widget_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Related_Worktags_Data[] = $item;
        return $this;
    }
}
