<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Credit_Card_Transaction_Response_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing Expense Credit Card Transaction response data for requested references or criteria and for requested response group
 * @subpackage Structs
 */
class Expense_Credit_Card_Transaction_Response_DataType extends AbstractStructBase
{
    /**
     * The Expense_Credit_Card_Transaction
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element that includes Expense Credit Card Transaction instance and data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_Credit_Card_TransactionType[]
     */
    public $Expense_Credit_Card_Transaction;
    /**
     * Constructor method for Expense_Credit_Card_Transaction_Response_DataType
     * @uses Expense_Credit_Card_Transaction_Response_DataType::setExpense_Credit_Card_Transaction()
     * @param \StructType\Expense_Credit_Card_TransactionType[] $expense_Credit_Card_Transaction
     */
    public function __construct(array $expense_Credit_Card_Transaction = array())
    {
        $this
            ->setExpense_Credit_Card_Transaction($expense_Credit_Card_Transaction);
    }
    /**
     * Get Expense_Credit_Card_Transaction value
     * @return \StructType\Expense_Credit_Card_TransactionType[]|null
     */
    public function getExpense_Credit_Card_Transaction()
    {
        return $this->Expense_Credit_Card_Transaction;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Credit_Card_Transaction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Credit_Card_Transaction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Credit_Card_TransactionForArrayConstraintsFromSetExpense_Credit_Card_Transaction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Credit_Card_Transaction_Response_DataTypeExpense_Credit_Card_TransactionItem) {
            // validation for constraint: itemType
            if (!$expense_Credit_Card_Transaction_Response_DataTypeExpense_Credit_Card_TransactionItem instanceof \StructType\Expense_Credit_Card_TransactionType) {
                $invalidValues[] = is_object($expense_Credit_Card_Transaction_Response_DataTypeExpense_Credit_Card_TransactionItem) ? get_class($expense_Credit_Card_Transaction_Response_DataTypeExpense_Credit_Card_TransactionItem) : sprintf('%s(%s)', gettype($expense_Credit_Card_Transaction_Response_DataTypeExpense_Credit_Card_TransactionItem), var_export($expense_Credit_Card_Transaction_Response_DataTypeExpense_Credit_Card_TransactionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Credit_Card_Transaction property can only contain items of type \StructType\Expense_Credit_Card_TransactionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Credit_Card_Transaction value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Credit_Card_TransactionType[] $expense_Credit_Card_Transaction
     * @return \StructType\Expense_Credit_Card_Transaction_Response_DataType
     */
    public function setExpense_Credit_Card_Transaction(array $expense_Credit_Card_Transaction = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Credit_Card_TransactionArrayErrorMessage = self::validateExpense_Credit_Card_TransactionForArrayConstraintsFromSetExpense_Credit_Card_Transaction($expense_Credit_Card_Transaction))) {
            throw new \InvalidArgumentException($expense_Credit_Card_TransactionArrayErrorMessage, __LINE__);
        }
        $this->Expense_Credit_Card_Transaction = $expense_Credit_Card_Transaction;
        return $this;
    }
    /**
     * Add item to Expense_Credit_Card_Transaction value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Credit_Card_TransactionType $item
     * @return \StructType\Expense_Credit_Card_Transaction_Response_DataType
     */
    public function addToExpense_Credit_Card_Transaction(\StructType\Expense_Credit_Card_TransactionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_Credit_Card_TransactionType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Credit_Card_Transaction property can only contain items of type \StructType\Expense_Credit_Card_TransactionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Credit_Card_Transaction[] = $item;
        return $this;
    }
}
