<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Adjustment_Calculation_Method_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You can't use an adjustment rate table on multiple expense items. | All Expense Item Attributes evaluated by the Expense Rate Table should be added to the Expense Item and displayed to the user. | Element containing all Expense
 * Adjustment Calculation Method data
 * @subpackage Structs
 */
class Expense_Adjustment_Calculation_Method_DataType extends AbstractStructBase
{
    /**
     * The Arithmetic_Operator_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Arithmetic Operator, limited to either Add or Subtract.
     * - minOccurs: 0
     * @var \StructType\Arithmetic_OperatorObjectType
     */
    public $Arithmetic_Operator_Reference;
    /**
     * The Expense_Rate_Table_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Rate Table. The result of the expense rate table will be used to adjust the result of the base expense rate table.
     * - minOccurs: 0
     * @var \StructType\Expense_Rate_TableObjectType
     */
    public $Expense_Rate_Table_Reference;
    /**
     * The Multiply_Result_by_Quantity_
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag indicating if the quantity entered on the expense report line is a factor in the adjustment calculation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Multiply_Result_by_Quantity_;
    /**
     * Constructor method for Expense_Adjustment_Calculation_Method_DataType
     * @uses Expense_Adjustment_Calculation_Method_DataType::setArithmetic_Operator_Reference()
     * @uses Expense_Adjustment_Calculation_Method_DataType::setExpense_Rate_Table_Reference()
     * @uses Expense_Adjustment_Calculation_Method_DataType::setMultiply_Result_by_Quantity_()
     * @param \StructType\Arithmetic_OperatorObjectType $arithmetic_Operator_Reference
     * @param \StructType\Expense_Rate_TableObjectType $expense_Rate_Table_Reference
     * @param bool $multiply_Result_by_Quantity_
     */
    public function __construct(\StructType\Arithmetic_OperatorObjectType $arithmetic_Operator_Reference = null, \StructType\Expense_Rate_TableObjectType $expense_Rate_Table_Reference = null, $multiply_Result_by_Quantity_ = null)
    {
        $this
            ->setArithmetic_Operator_Reference($arithmetic_Operator_Reference)
            ->setExpense_Rate_Table_Reference($expense_Rate_Table_Reference)
            ->setMultiply_Result_by_Quantity_($multiply_Result_by_Quantity_);
    }
    /**
     * Get Arithmetic_Operator_Reference value
     * @return \StructType\Arithmetic_OperatorObjectType|null
     */
    public function getArithmetic_Operator_Reference()
    {
        return $this->Arithmetic_Operator_Reference;
    }
    /**
     * Set Arithmetic_Operator_Reference value
     * @param \StructType\Arithmetic_OperatorObjectType $arithmetic_Operator_Reference
     * @return \StructType\Expense_Adjustment_Calculation_Method_DataType
     */
    public function setArithmetic_Operator_Reference(\StructType\Arithmetic_OperatorObjectType $arithmetic_Operator_Reference = null)
    {
        $this->Arithmetic_Operator_Reference = $arithmetic_Operator_Reference;
        return $this;
    }
    /**
     * Get Expense_Rate_Table_Reference value
     * @return \StructType\Expense_Rate_TableObjectType|null
     */
    public function getExpense_Rate_Table_Reference()
    {
        return $this->Expense_Rate_Table_Reference;
    }
    /**
     * Set Expense_Rate_Table_Reference value
     * @param \StructType\Expense_Rate_TableObjectType $expense_Rate_Table_Reference
     * @return \StructType\Expense_Adjustment_Calculation_Method_DataType
     */
    public function setExpense_Rate_Table_Reference(\StructType\Expense_Rate_TableObjectType $expense_Rate_Table_Reference = null)
    {
        $this->Expense_Rate_Table_Reference = $expense_Rate_Table_Reference;
        return $this;
    }
    /**
     * Get Multiply_Result_by_Quantity_ value
     * @return bool|null
     */
    public function getMultiply_Result_by_Quantity_()
    {
        return $this->Multiply_Result_by_Quantity_;
    }
    /**
     * Set Multiply_Result_by_Quantity_ value
     * @param bool $multiply_Result_by_Quantity_
     * @return \StructType\Expense_Adjustment_Calculation_Method_DataType
     */
    public function setMultiply_Result_by_Quantity_($multiply_Result_by_Quantity_ = null)
    {
        // validation for constraint: boolean
        if (!is_null($multiply_Result_by_Quantity_) && !is_bool($multiply_Result_by_Quantity_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multiply_Result_by_Quantity_, true), gettype($multiply_Result_by_Quantity_)), __LINE__);
        }
        $this->Multiply_Result_by_Quantity_ = $multiply_Result_by_Quantity_;
        return $this;
    }
}
