<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Discrete_Child_ComponentType StructType
 * Meta information extracted from the WSDL
 * - documentation: References to child component assets when the parent is Discrete Composite Asset
 * @subpackage Structs
 */
class Discrete_Child_ComponentType extends AbstractStructBase
{
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Deletes the component
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Delete;
    /**
     * The Component_Asset_ID
     * Meta information extracted from the WSDL
     * - documentation: Component Asset Id
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Component_Asset_ID;
    /**
     * The Asset_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Asset Identifier. This field cannot be edited.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Identifier;
    /**
     * The Supplier_Reference_Number
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference Number. This field cannot be edited.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Reference_Number;
    /**
     * The Manufacturer
     * Meta information extracted from the WSDL
     * - documentation: Manufacturer. This field cannot be edited.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Manufacturer;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item Reference. This field cannot be edited.
     * - minOccurs: 0
     * @var \StructType\Item_DescriptorObjectType
     */
    public $Item_Reference;
    /**
     * The Asset_Name
     * Meta information extracted from the WSDL
     * - documentation: Asset Name. This field cannot be edited.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Name;
    /**
     * The PO_Number
     * Meta information extracted from the WSDL
     * - documentation: PO Number. This field cannot be edited.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PO_Number;
    /**
     * The Receipt_Number
     * Meta information extracted from the WSDL
     * - documentation: Receipt Number. This field cannot be edited.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receipt_Number;
    /**
     * The XMLNAME__Project__Number
     * Meta information extracted from the WSDL
     * - documentation: Project Number. This field cannot be edited.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $XMLNAME__Project__Number;
    /**
     * The Supplier_Invoice_Number
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Number. This field cannot be edited.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_Number;
    /**
     * The External_Contract_Number
     * Meta information extracted from the WSDL
     * - documentation: External Contract Number. This field cannot be edited.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Contract_Number;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo. This field cannot be edited.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * Constructor method for Discrete_Child_ComponentType
     * @uses Discrete_Child_ComponentType::setDelete()
     * @uses Discrete_Child_ComponentType::setComponent_Asset_ID()
     * @uses Discrete_Child_ComponentType::setAsset_Identifier()
     * @uses Discrete_Child_ComponentType::setSupplier_Reference_Number()
     * @uses Discrete_Child_ComponentType::setManufacturer()
     * @uses Discrete_Child_ComponentType::setItem_Reference()
     * @uses Discrete_Child_ComponentType::setAsset_Name()
     * @uses Discrete_Child_ComponentType::setPO_Number()
     * @uses Discrete_Child_ComponentType::setReceipt_Number()
     * @uses Discrete_Child_ComponentType::setXMLNAME__Project__Number()
     * @uses Discrete_Child_ComponentType::setSupplier_Invoice_Number()
     * @uses Discrete_Child_ComponentType::setExternal_Contract_Number()
     * @uses Discrete_Child_ComponentType::setMemo()
     * @param bool $delete
     * @param string $component_Asset_ID
     * @param string $asset_Identifier
     * @param string $supplier_Reference_Number
     * @param string $manufacturer
     * @param \StructType\Item_DescriptorObjectType $item_Reference
     * @param string $asset_Name
     * @param string $pO_Number
     * @param string $receipt_Number
     * @param string $xMLNAME__Project__Number
     * @param string $supplier_Invoice_Number
     * @param string $external_Contract_Number
     * @param string $memo
     */
    public function __construct($delete = null, $component_Asset_ID = null, $asset_Identifier = null, $supplier_Reference_Number = null, $manufacturer = null, \StructType\Item_DescriptorObjectType $item_Reference = null, $asset_Name = null, $pO_Number = null, $receipt_Number = null, $xMLNAME__Project__Number = null, $supplier_Invoice_Number = null, $external_Contract_Number = null, $memo = null)
    {
        $this
            ->setDelete($delete)
            ->setComponent_Asset_ID($component_Asset_ID)
            ->setAsset_Identifier($asset_Identifier)
            ->setSupplier_Reference_Number($supplier_Reference_Number)
            ->setManufacturer($manufacturer)
            ->setItem_Reference($item_Reference)
            ->setAsset_Name($asset_Name)
            ->setPO_Number($pO_Number)
            ->setReceipt_Number($receipt_Number)
            ->setXMLNAME__Project__Number($xMLNAME__Project__Number)
            ->setSupplier_Invoice_Number($supplier_Invoice_Number)
            ->setExternal_Contract_Number($external_Contract_Number)
            ->setMemo($memo);
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Discrete_Child_ComponentType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Get Component_Asset_ID value
     * @return string|null
     */
    public function getComponent_Asset_ID()
    {
        return $this->Component_Asset_ID;
    }
    /**
     * Set Component_Asset_ID value
     * @param string $component_Asset_ID
     * @return \StructType\Discrete_Child_ComponentType
     */
    public function setComponent_Asset_ID($component_Asset_ID = null)
    {
        // validation for constraint: string
        if (!is_null($component_Asset_ID) && !is_string($component_Asset_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($component_Asset_ID, true), gettype($component_Asset_ID)), __LINE__);
        }
        $this->Component_Asset_ID = $component_Asset_ID;
        return $this;
    }
    /**
     * Get Asset_Identifier value
     * @return string|null
     */
    public function getAsset_Identifier()
    {
        return $this->Asset_Identifier;
    }
    /**
     * Set Asset_Identifier value
     * @param string $asset_Identifier
     * @return \StructType\Discrete_Child_ComponentType
     */
    public function setAsset_Identifier($asset_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Identifier) && !is_string($asset_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Identifier, true), gettype($asset_Identifier)), __LINE__);
        }
        $this->Asset_Identifier = $asset_Identifier;
        return $this;
    }
    /**
     * Get Supplier_Reference_Number value
     * @return string|null
     */
    public function getSupplier_Reference_Number()
    {
        return $this->Supplier_Reference_Number;
    }
    /**
     * Set Supplier_Reference_Number value
     * @param string $supplier_Reference_Number
     * @return \StructType\Discrete_Child_ComponentType
     */
    public function setSupplier_Reference_Number($supplier_Reference_Number = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Reference_Number) && !is_string($supplier_Reference_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Reference_Number, true), gettype($supplier_Reference_Number)), __LINE__);
        }
        $this->Supplier_Reference_Number = $supplier_Reference_Number;
        return $this;
    }
    /**
     * Get Manufacturer value
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->Manufacturer;
    }
    /**
     * Set Manufacturer value
     * @param string $manufacturer
     * @return \StructType\Discrete_Child_ComponentType
     */
    public function setManufacturer($manufacturer = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturer) && !is_string($manufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturer, true), gettype($manufacturer)), __LINE__);
        }
        $this->Manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Item_DescriptorObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Item_DescriptorObjectType $item_Reference
     * @return \StructType\Discrete_Child_ComponentType
     */
    public function setItem_Reference(\StructType\Item_DescriptorObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Asset_Name value
     * @return string|null
     */
    public function getAsset_Name()
    {
        return $this->Asset_Name;
    }
    /**
     * Set Asset_Name value
     * @param string $asset_Name
     * @return \StructType\Discrete_Child_ComponentType
     */
    public function setAsset_Name($asset_Name = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Name) && !is_string($asset_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Name, true), gettype($asset_Name)), __LINE__);
        }
        $this->Asset_Name = $asset_Name;
        return $this;
    }
    /**
     * Get PO_Number value
     * @return string|null
     */
    public function getPO_Number()
    {
        return $this->PO_Number;
    }
    /**
     * Set PO_Number value
     * @param string $pO_Number
     * @return \StructType\Discrete_Child_ComponentType
     */
    public function setPO_Number($pO_Number = null)
    {
        // validation for constraint: string
        if (!is_null($pO_Number) && !is_string($pO_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pO_Number, true), gettype($pO_Number)), __LINE__);
        }
        $this->PO_Number = $pO_Number;
        return $this;
    }
    /**
     * Get Receipt_Number value
     * @return string|null
     */
    public function getReceipt_Number()
    {
        return $this->Receipt_Number;
    }
    /**
     * Set Receipt_Number value
     * @param string $receipt_Number
     * @return \StructType\Discrete_Child_ComponentType
     */
    public function setReceipt_Number($receipt_Number = null)
    {
        // validation for constraint: string
        if (!is_null($receipt_Number) && !is_string($receipt_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receipt_Number, true), gettype($receipt_Number)), __LINE__);
        }
        $this->Receipt_Number = $receipt_Number;
        return $this;
    }
    /**
     * Get XMLNAME__Project__Number value
     * @return string|null
     */
    public function getXMLNAME__Project__Number()
    {
        return $this->XMLNAME__Project__Number;
    }
    /**
     * Set XMLNAME__Project__Number value
     * @param string $xMLNAME__Project__Number
     * @return \StructType\Discrete_Child_ComponentType
     */
    public function setXMLNAME__Project__Number($xMLNAME__Project__Number = null)
    {
        // validation for constraint: string
        if (!is_null($xMLNAME__Project__Number) && !is_string($xMLNAME__Project__Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xMLNAME__Project__Number, true), gettype($xMLNAME__Project__Number)), __LINE__);
        }
        $this->XMLNAME__Project__Number = $xMLNAME__Project__Number;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Number value
     * @return string|null
     */
    public function getSupplier_Invoice_Number()
    {
        return $this->Supplier_Invoice_Number;
    }
    /**
     * Set Supplier_Invoice_Number value
     * @param string $supplier_Invoice_Number
     * @return \StructType\Discrete_Child_ComponentType
     */
    public function setSupplier_Invoice_Number($supplier_Invoice_Number = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_Number) && !is_string($supplier_Invoice_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_Number, true), gettype($supplier_Invoice_Number)), __LINE__);
        }
        $this->Supplier_Invoice_Number = $supplier_Invoice_Number;
        return $this;
    }
    /**
     * Get External_Contract_Number value
     * @return string|null
     */
    public function getExternal_Contract_Number()
    {
        return $this->External_Contract_Number;
    }
    /**
     * Set External_Contract_Number value
     * @param string $external_Contract_Number
     * @return \StructType\Discrete_Child_ComponentType
     */
    public function setExternal_Contract_Number($external_Contract_Number = null)
    {
        // validation for constraint: string
        if (!is_null($external_Contract_Number) && !is_string($external_Contract_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Contract_Number, true), gettype($external_Contract_Number)), __LINE__);
        }
        $this->External_Contract_Number = $external_Contract_Number;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Discrete_Child_ComponentType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
}
