<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Credit_Card_Transaction_File_Response_GroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element around a list of elements representing the amount of data that should be included in the Expense Credit Card Transaction File response. If this element is not included then ALL of the Response Groups are included in
 * the response.
 * @subpackage Structs
 */
class Credit_Card_Transaction_File_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the Expense Credit Card Transaction File Reference data is to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Include_Expense_Credit_Card_Transaction_File_Data
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the Expense Credit Card Transaction File Data is to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Expense_Credit_Card_Transaction_File_Data;
    /**
     * Constructor method for Credit_Card_Transaction_File_Response_GroupType
     * @uses Credit_Card_Transaction_File_Response_GroupType::setInclude_Reference()
     * @uses Credit_Card_Transaction_File_Response_GroupType::setInclude_Expense_Credit_Card_Transaction_File_Data()
     * @param bool $include_Reference
     * @param bool $include_Expense_Credit_Card_Transaction_File_Data
     */
    public function __construct($include_Reference = null, $include_Expense_Credit_Card_Transaction_File_Data = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setInclude_Expense_Credit_Card_Transaction_File_Data($include_Expense_Credit_Card_Transaction_File_Data);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Credit_Card_Transaction_File_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Include_Expense_Credit_Card_Transaction_File_Data value
     * @return bool|null
     */
    public function getInclude_Expense_Credit_Card_Transaction_File_Data()
    {
        return $this->Include_Expense_Credit_Card_Transaction_File_Data;
    }
    /**
     * Set Include_Expense_Credit_Card_Transaction_File_Data value
     * @param bool $include_Expense_Credit_Card_Transaction_File_Data
     * @return \StructType\Credit_Card_Transaction_File_Response_GroupType
     */
    public function setInclude_Expense_Credit_Card_Transaction_File_Data($include_Expense_Credit_Card_Transaction_File_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Expense_Credit_Card_Transaction_File_Data) && !is_bool($include_Expense_Credit_Card_Transaction_File_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Expense_Credit_Card_Transaction_File_Data, true), gettype($include_Expense_Credit_Card_Transaction_File_Data)), __LINE__);
        }
        $this->Include_Expense_Credit_Card_Transaction_File_Data = $include_Expense_Credit_Card_Transaction_File_Data;
        return $this;
    }
}
