<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Credit_Card_Transaction_File_Request_ReferencesType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Expense Credit Card Transaction File Reference element contains the specific instance set containing the requested Expense Credit Card Transaction File.
 * @subpackage Structs
 */
class Credit_Card_Transaction_File_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Expense_Credit_Card_Transaction_File_Reference
     * Meta information extracted from the WSDL
     * - documentation: Instance set containing the Expense Credit Card Transaction File object.
     * - maxOccurs: unbounded
     * @var \StructType\Credit_Card_Transaction_FileObjectType[]
     */
    public $Expense_Credit_Card_Transaction_File_Reference;
    /**
     * Constructor method for Credit_Card_Transaction_File_Request_ReferencesType
     * @uses Credit_Card_Transaction_File_Request_ReferencesType::setExpense_Credit_Card_Transaction_File_Reference()
     * @param \StructType\Credit_Card_Transaction_FileObjectType[] $expense_Credit_Card_Transaction_File_Reference
     */
    public function __construct(array $expense_Credit_Card_Transaction_File_Reference = array())
    {
        $this
            ->setExpense_Credit_Card_Transaction_File_Reference($expense_Credit_Card_Transaction_File_Reference);
    }
    /**
     * Get Expense_Credit_Card_Transaction_File_Reference value
     * @return \StructType\Credit_Card_Transaction_FileObjectType[]|null
     */
    public function getExpense_Credit_Card_Transaction_File_Reference()
    {
        return $this->Expense_Credit_Card_Transaction_File_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Credit_Card_Transaction_File_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Credit_Card_Transaction_File_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Credit_Card_Transaction_File_ReferenceForArrayConstraintsFromSetExpense_Credit_Card_Transaction_File_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $credit_Card_Transaction_File_Request_ReferencesTypeExpense_Credit_Card_Transaction_File_ReferenceItem) {
            // validation for constraint: itemType
            if (!$credit_Card_Transaction_File_Request_ReferencesTypeExpense_Credit_Card_Transaction_File_ReferenceItem instanceof \StructType\Credit_Card_Transaction_FileObjectType) {
                $invalidValues[] = is_object($credit_Card_Transaction_File_Request_ReferencesTypeExpense_Credit_Card_Transaction_File_ReferenceItem) ? get_class($credit_Card_Transaction_File_Request_ReferencesTypeExpense_Credit_Card_Transaction_File_ReferenceItem) : sprintf('%s(%s)', gettype($credit_Card_Transaction_File_Request_ReferencesTypeExpense_Credit_Card_Transaction_File_ReferenceItem), var_export($credit_Card_Transaction_File_Request_ReferencesTypeExpense_Credit_Card_Transaction_File_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Credit_Card_Transaction_File_Reference property can only contain items of type \StructType\Credit_Card_Transaction_FileObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Credit_Card_Transaction_File_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Credit_Card_Transaction_FileObjectType[] $expense_Credit_Card_Transaction_File_Reference
     * @return \StructType\Credit_Card_Transaction_File_Request_ReferencesType
     */
    public function setExpense_Credit_Card_Transaction_File_Reference(array $expense_Credit_Card_Transaction_File_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Credit_Card_Transaction_File_ReferenceArrayErrorMessage = self::validateExpense_Credit_Card_Transaction_File_ReferenceForArrayConstraintsFromSetExpense_Credit_Card_Transaction_File_Reference($expense_Credit_Card_Transaction_File_Reference))) {
            throw new \InvalidArgumentException($expense_Credit_Card_Transaction_File_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Credit_Card_Transaction_File_Reference = $expense_Credit_Card_Transaction_File_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Credit_Card_Transaction_File_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Credit_Card_Transaction_FileObjectType $item
     * @return \StructType\Credit_Card_Transaction_File_Request_ReferencesType
     */
    public function addToExpense_Credit_Card_Transaction_File_Reference(\StructType\Credit_Card_Transaction_FileObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Credit_Card_Transaction_FileObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Credit_Card_Transaction_File_Reference property can only contain items of type \StructType\Credit_Card_Transaction_FileObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Credit_Card_Transaction_File_Reference[] = $item;
        return $this;
    }
}
