<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Credit_Card_Transaction_FileType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element that includes Expense Credit Card Transaction File instance and data
 * @subpackage Structs
 */
class Credit_Card_Transaction_FileType extends AbstractStructBase
{
    /**
     * The Credit_Card_Transaction_File_Reference
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Transaction File Reference
     * - minOccurs: 0
     * @var \StructType\Credit_Card_Transaction_FileObjectType
     */
    public $Credit_Card_Transaction_File_Reference;
    /**
     * The Credit_Card_Transaction_File_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing all Credit Card Transaction File data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Credit_Card_Transaction_File_DataType[]
     */
    public $Credit_Card_Transaction_File_Data;
    /**
     * Constructor method for Credit_Card_Transaction_FileType
     * @uses Credit_Card_Transaction_FileType::setCredit_Card_Transaction_File_Reference()
     * @uses Credit_Card_Transaction_FileType::setCredit_Card_Transaction_File_Data()
     * @param \StructType\Credit_Card_Transaction_FileObjectType $credit_Card_Transaction_File_Reference
     * @param \StructType\Credit_Card_Transaction_File_DataType[] $credit_Card_Transaction_File_Data
     */
    public function __construct(\StructType\Credit_Card_Transaction_FileObjectType $credit_Card_Transaction_File_Reference = null, array $credit_Card_Transaction_File_Data = array())
    {
        $this
            ->setCredit_Card_Transaction_File_Reference($credit_Card_Transaction_File_Reference)
            ->setCredit_Card_Transaction_File_Data($credit_Card_Transaction_File_Data);
    }
    /**
     * Get Credit_Card_Transaction_File_Reference value
     * @return \StructType\Credit_Card_Transaction_FileObjectType|null
     */
    public function getCredit_Card_Transaction_File_Reference()
    {
        return $this->Credit_Card_Transaction_File_Reference;
    }
    /**
     * Set Credit_Card_Transaction_File_Reference value
     * @param \StructType\Credit_Card_Transaction_FileObjectType $credit_Card_Transaction_File_Reference
     * @return \StructType\Credit_Card_Transaction_FileType
     */
    public function setCredit_Card_Transaction_File_Reference(\StructType\Credit_Card_Transaction_FileObjectType $credit_Card_Transaction_File_Reference = null)
    {
        $this->Credit_Card_Transaction_File_Reference = $credit_Card_Transaction_File_Reference;
        return $this;
    }
    /**
     * Get Credit_Card_Transaction_File_Data value
     * @return \StructType\Credit_Card_Transaction_File_DataType[]|null
     */
    public function getCredit_Card_Transaction_File_Data()
    {
        return $this->Credit_Card_Transaction_File_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCredit_Card_Transaction_File_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCredit_Card_Transaction_File_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCredit_Card_Transaction_File_DataForArrayConstraintsFromSetCredit_Card_Transaction_File_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $credit_Card_Transaction_FileTypeCredit_Card_Transaction_File_DataItem) {
            // validation for constraint: itemType
            if (!$credit_Card_Transaction_FileTypeCredit_Card_Transaction_File_DataItem instanceof \StructType\Credit_Card_Transaction_File_DataType) {
                $invalidValues[] = is_object($credit_Card_Transaction_FileTypeCredit_Card_Transaction_File_DataItem) ? get_class($credit_Card_Transaction_FileTypeCredit_Card_Transaction_File_DataItem) : sprintf('%s(%s)', gettype($credit_Card_Transaction_FileTypeCredit_Card_Transaction_File_DataItem), var_export($credit_Card_Transaction_FileTypeCredit_Card_Transaction_File_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Credit_Card_Transaction_File_Data property can only contain items of type \StructType\Credit_Card_Transaction_File_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Credit_Card_Transaction_File_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Credit_Card_Transaction_File_DataType[] $credit_Card_Transaction_File_Data
     * @return \StructType\Credit_Card_Transaction_FileType
     */
    public function setCredit_Card_Transaction_File_Data(array $credit_Card_Transaction_File_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($credit_Card_Transaction_File_DataArrayErrorMessage = self::validateCredit_Card_Transaction_File_DataForArrayConstraintsFromSetCredit_Card_Transaction_File_Data($credit_Card_Transaction_File_Data))) {
            throw new \InvalidArgumentException($credit_Card_Transaction_File_DataArrayErrorMessage, __LINE__);
        }
        $this->Credit_Card_Transaction_File_Data = $credit_Card_Transaction_File_Data;
        return $this;
    }
    /**
     * Add item to Credit_Card_Transaction_File_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Credit_Card_Transaction_File_DataType $item
     * @return \StructType\Credit_Card_Transaction_FileType
     */
    public function addToCredit_Card_Transaction_File_Data(\StructType\Credit_Card_Transaction_File_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Credit_Card_Transaction_File_DataType) {
            throw new \InvalidArgumentException(sprintf('The Credit_Card_Transaction_File_Data property can only contain items of type \StructType\Credit_Card_Transaction_File_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Credit_Card_Transaction_File_Data[] = $item;
        return $this;
    }
}
