<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Credit_Card_Transaction_Billing_Currency_Conversion_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all the credit card transaction billing currency conversion data for the expense report line
 * @subpackage Structs
 */
class Credit_Card_Transaction_Billing_Currency_Conversion_DataType extends AbstractStructBase
{
    /**
     * The Currency_Exchange_Rate
     * Meta information extracted from the WSDL
     * - documentation: Currency exchange rate from the transaction currency to the billing currency | Expense Credit Card Currency Exchange Rate
     * - base: xsd:decimal
     * - fractionDigits: 12
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 32
     * @var float
     */
    public $Currency_Exchange_Rate;
    /**
     * The Billing_Amount
     * Meta information extracted from the WSDL
     * - documentation: Total amount in the billing currency.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Billing_Amount;
    /**
     * The Non_Personal_Billing_Amount
     * Meta information extracted from the WSDL
     * - documentation: Total amount not marked as personal expense in the billing currency.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Non_Personal_Billing_Amount;
    /**
     * The Billing_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the billing currency.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Billing_Currency_Reference;
    /**
     * Constructor method for
     * Credit_Card_Transaction_Billing_Currency_Conversion_DataType
     * @uses Credit_Card_Transaction_Billing_Currency_Conversion_DataType::setCurrency_Exchange_Rate()
     * @uses Credit_Card_Transaction_Billing_Currency_Conversion_DataType::setBilling_Amount()
     * @uses Credit_Card_Transaction_Billing_Currency_Conversion_DataType::setNon_Personal_Billing_Amount()
     * @uses Credit_Card_Transaction_Billing_Currency_Conversion_DataType::setBilling_Currency_Reference()
     * @param float $currency_Exchange_Rate
     * @param float $billing_Amount
     * @param float $non_Personal_Billing_Amount
     * @param \StructType\CurrencyObjectType $billing_Currency_Reference
     */
    public function __construct($currency_Exchange_Rate = null, $billing_Amount = null, $non_Personal_Billing_Amount = null, \StructType\CurrencyObjectType $billing_Currency_Reference = null)
    {
        $this
            ->setCurrency_Exchange_Rate($currency_Exchange_Rate)
            ->setBilling_Amount($billing_Amount)
            ->setNon_Personal_Billing_Amount($non_Personal_Billing_Amount)
            ->setBilling_Currency_Reference($billing_Currency_Reference);
    }
    /**
     * Get Currency_Exchange_Rate value
     * @return float|null
     */
    public function getCurrency_Exchange_Rate()
    {
        return $this->Currency_Exchange_Rate;
    }
    /**
     * Set Currency_Exchange_Rate value
     * @param float $currency_Exchange_Rate
     * @return \StructType\Credit_Card_Transaction_Billing_Currency_Conversion_DataType
     */
    public function setCurrency_Exchange_Rate($currency_Exchange_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($currency_Exchange_Rate) && !(is_float($currency_Exchange_Rate) || is_numeric($currency_Exchange_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currency_Exchange_Rate, true), gettype($currency_Exchange_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(12)
        if (!is_null($currency_Exchange_Rate) && mb_strlen(mb_substr($currency_Exchange_Rate, false !== mb_strpos($currency_Exchange_Rate, '.') ? mb_strpos($currency_Exchange_Rate, '.') + 1 : mb_strlen($currency_Exchange_Rate))) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 12 fraction digits, %d given', var_export($currency_Exchange_Rate, true), mb_strlen(mb_substr($currency_Exchange_Rate, mb_strpos($currency_Exchange_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($currency_Exchange_Rate) && $currency_Exchange_Rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($currency_Exchange_Rate, true)), __LINE__);
        }
        // validation for constraint: totalDigits(32)
        if (!is_null($currency_Exchange_Rate) && mb_strlen(preg_replace('/(\D)/', '', $currency_Exchange_Rate)) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 32 digits, "%d" given', var_export($currency_Exchange_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $currency_Exchange_Rate))), __LINE__);
        }
        $this->Currency_Exchange_Rate = $currency_Exchange_Rate;
        return $this;
    }
    /**
     * Get Billing_Amount value
     * @return float|null
     */
    public function getBilling_Amount()
    {
        return $this->Billing_Amount;
    }
    /**
     * Set Billing_Amount value
     * @param float $billing_Amount
     * @return \StructType\Credit_Card_Transaction_Billing_Currency_Conversion_DataType
     */
    public function setBilling_Amount($billing_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($billing_Amount) && !(is_float($billing_Amount) || is_numeric($billing_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($billing_Amount, true), gettype($billing_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($billing_Amount) && mb_strlen(mb_substr($billing_Amount, false !== mb_strpos($billing_Amount, '.') ? mb_strpos($billing_Amount, '.') + 1 : mb_strlen($billing_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($billing_Amount, true), mb_strlen(mb_substr($billing_Amount, mb_strpos($billing_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($billing_Amount) && mb_strlen(preg_replace('/(\D)/', '', $billing_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($billing_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $billing_Amount))), __LINE__);
        }
        $this->Billing_Amount = $billing_Amount;
        return $this;
    }
    /**
     * Get Non_Personal_Billing_Amount value
     * @return float|null
     */
    public function getNon_Personal_Billing_Amount()
    {
        return $this->{'Non-Personal_Billing_Amount'};
    }
    /**
     * Set Non_Personal_Billing_Amount value
     * @param float $non_Personal_Billing_Amount
     * @return \StructType\Credit_Card_Transaction_Billing_Currency_Conversion_DataType
     */
    public function setNon_Personal_Billing_Amount($non_Personal_Billing_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($non_Personal_Billing_Amount) && !(is_float($non_Personal_Billing_Amount) || is_numeric($non_Personal_Billing_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($non_Personal_Billing_Amount, true), gettype($non_Personal_Billing_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($non_Personal_Billing_Amount) && mb_strlen(mb_substr($non_Personal_Billing_Amount, false !== mb_strpos($non_Personal_Billing_Amount, '.') ? mb_strpos($non_Personal_Billing_Amount, '.') + 1 : mb_strlen($non_Personal_Billing_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($non_Personal_Billing_Amount, true), mb_strlen(mb_substr($non_Personal_Billing_Amount, mb_strpos($non_Personal_Billing_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($non_Personal_Billing_Amount) && mb_strlen(preg_replace('/(\D)/', '', $non_Personal_Billing_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($non_Personal_Billing_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $non_Personal_Billing_Amount))), __LINE__);
        }
        $this->Non_Personal_Billing_Amount = $this->{'Non-Personal_Billing_Amount'} = $non_Personal_Billing_Amount;
        return $this;
    }
    /**
     * Get Billing_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getBilling_Currency_Reference()
    {
        return $this->Billing_Currency_Reference;
    }
    /**
     * Set Billing_Currency_Reference value
     * @param \StructType\CurrencyObjectType $billing_Currency_Reference
     * @return \StructType\Credit_Card_Transaction_Billing_Currency_Conversion_DataType
     */
    public function setBilling_Currency_Reference(\StructType\CurrencyObjectType $billing_Currency_Reference = null)
    {
        $this->Billing_Currency_Reference = $billing_Currency_Reference;
        return $this;
    }
}
