<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Corporate_Credit_Card_Account_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Country, Billing Currency, and Integration System are required if Produce Remittance File is true. | Editable dates only apply on credit card transactions for expenses. | The Spend Category is required when the Usage is configured. |
 * If the usage is Expenses and worktag balancing is configured for your tenant, you may also need to configure a balancing worktag. | The Company is required when the Usage is configured. | The balancing worktag is not allowed when the tenant is not
 * configured to handle them. | The Corporate Credit Card Account Number cannot be changed for a Corporate Credit Card Account that has Expense Credit Card(s) or Expense Credit Card Transaction(s). | A Corporate Credit Card Account can only be
 * associated with one active Settlement Bank Account. | Settlement Bank Account information needs to be provided for certain default payment types. | The Corporate Payment Responsibility cannot be changed for a Corporate Credit Card Account that has
 * Expense Credit Card(s) or Expense Credit Card Transaction(s). | Element containing all Corporate Credit Card Account data.
 * @subpackage Structs
 */
class Corporate_Credit_Card_Account_DataType extends AbstractStructBase
{
    /**
     * The Corporate_Credit_Card_Account_ID
     * Meta information extracted from the WSDL
     * - documentation: The Corporate Credit Card ID has already been used. | This is the Corporate Credit Card Account unique identifier.
     * - maxOccurs: 1
     * @var string
     */
    public $Corporate_Credit_Card_Account_ID;
    /**
     * The Corporate_Credit_Card_Account_Name
     * Meta information extracted from the WSDL
     * - documentation: Name of the Corporate Credit Card Account.
     * - maxOccurs: 1
     * @var string
     */
    public $Corporate_Credit_Card_Account_Name;
    /**
     * The Financial_Institution_Reference
     * Meta information extracted from the WSDL
     * - documentation: Financial Institution.
     * - minOccurs: 0
     * @var \StructType\Financial_InstitutionObjectType
     */
    public $Financial_Institution_Reference;
    /**
     * The Credit_Card_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Type for credit cards using this Corporate Credit Card Account. e.g. AMEX, Visa, MasterCard, etc.
     * @var \StructType\Credit_Card_TypeObjectType
     */
    public $Credit_Card_Type_Reference;
    /**
     * The Usage_Reference
     * Meta information extracted from the WSDL
     * - documentation: The account type can't switch from Expenses to Procurement as it has credit cards assigned to external committee members or contingent worker(s). You can only assign Procurement cards to employee(s). | Ensure Corporate Credit Card
     * Accounts used for Procurement Credit Cards can only have a Corporate payment responsibility. | Usage indicator of credit cards assigned to this Corporate Credit Card Account. e.g. Expenses, Procurement.
     * @var \StructType\Credit_Card_Account_Usage_IndicatorObjectType
     */
    public $Usage_Reference;
    /**
     * The Corporate_Payment_Responsibility_Reference
     * Meta information extracted from the WSDL
     * - documentation: Corporate Payment Responsibility of this Corporate Credit Card Account. e.g. Corporate, Shared, Individual
     * @var \StructType\Corporate_Payment_ResponsibilityObjectType
     */
    public $Corporate_Payment_Responsibility_Reference;
    /**
     * The Expense_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Restrict usage of this Corporate Credit Card Account to specific Expense Items when filing an Expense Report with a Credit Card Transaction. Leave blank to allow any Expense Item to be used with this Corporate Credit Card Account on
     * an Expense Report line.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_ItemObjectType[]
     */
    public $Expense_Item_Reference;
    /**
     * The Electronic_Load_Only
     * Meta information extracted from the WSDL
     * - documentation: To enable Use Company on Credit Card Account for Expense Accounting, you must also enable Electronic Load Only. | To enable Pay Unapproved Expense Credit Card Transactions, you must also enable Electronic Load Only. | Ensure
     * Corporate Credit Card Accounts used for Procurement Credit Cards cannot be used to enter manual credit card transactions. | If left false, credit card transactions can be entered "manually" by users on Expense Report lines, by specifying the Credit
     * Card on the Expense Report line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Electronic_Load_Only;
    /**
     * The Allow_Negative_Reimbursable_Total
     * Meta information extracted from the WSDL
     * - documentation: Whether or not the Reimbursable Total amount for the Corporate Credit Card Account can be negative on a given Expense Report.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Allow_Negative_Reimbursable_Total;
    /**
     * The Pay_Unapproved_Credit_Card_Transactions
     * Meta information extracted from the WSDL
     * - documentation: Ensure the Pay Unapproved Credit Card Transactions flag is not set to true when the usage indicator is not Procurement. | When this flag is set to true, credit card transactions can be paid before being approved. This is only
     * available for corporate credit card accounts used for Procurement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Pay_Unapproved_Credit_Card_Transactions;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: The company of a Corporate Credit Card Accounts cannot be changed if there are already associated Credit Card Transactions. | The Company to be used for the Corporate Credit Card Account.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Spend Category to be used for the Corporate Credit Card Account.
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Balancing_Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: The worktag of a Corporate Credit Card Accounts cannot be changed if there are already associated Credit Card Transactions. | The worktag of the Corporate Credit Card Accounts can't be added or updated if Company doesn't have a
     * Balancing Worktag configured. | Ensure the Balancing Worktag specified is used for Accounting purposes. | The Balancing Worktag to be used for the Corporate Credit Card Account.
     * - minOccurs: 0
     * @var \StructType\Balancing_WorktagObjectType
     */
    public $Balancing_Worktag_Reference;
    /**
     * The Optional_Balancing_Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Ensure the Optional Balancing Worktags are enabled in the tenant. | Ensure there is only one worktag of each type specified in the Optional Balancing Worktags. | The Optional Balancing Worktags to be used for the Corporate Credit
     * Card Account
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Optional_Balancing_Worktags_Reference;
    /**
     * The Default_Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Duplicate worktag entries found. You can configure a worktag only once for either Balancing Worktags, Optional Worktags, or Default Worktags. | To add Default Worktags, you must first enable Pay Unapproved Expense Card Transactions.
     * | Default Worktag
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Audited_Accounting_WorktagObjectType[]
     */
    public $Default_Worktag_Reference;
    /**
     * The Is_Inactive
     * Meta information extracted from the WSDL
     * - documentation: Read-Only; Returns true if corporate credit card account has been inactivated.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Is_Inactive;
    /**
     * The Only_pay_Transactions_from_Expense_Reports_already_paid_to_Worker
     * Meta information extracted from the WSDL
     * - documentation: Only pay transactions on Expense Reports already paid to worker
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Only_pay_Transactions_from_Expense_Reports_already_paid_to_Worker;
    /**
     * The Pay_Unapproved_Expense_Card_Transactions
     * Meta information extracted from the WSDL
     * - documentation: To enable Pay Unapproved Expense Card Transactions, you must configure the Usage as Expenses. | To enable Pay Unapproved Expense Card Transactions, you must configure the Payment Responsibility as Corporate. | Pay Unapproved Expense
     * Card Transactions
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Pay_Unapproved_Expense_Card_Transactions;
    /**
     * The Use_Company_on_Credit_Card_Account_for_Expense_Accounting
     * Meta information extracted from the WSDL
     * - documentation: To enable Pay Unapproved Expense Card Transactions, you must configure the Usage as Expenses. | To enable Pay Unapproved Expense Card Transactions, you must configure the Payment Responsibility as Corporate or Shared. | To enable Pay
     * Unapproved Expense Card Transactions, you must first enable Use Company on Credit Card Account for Expense Accounting. | Use Company on Credit Card Account for Expense Accounting
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Company_on_Credit_Card_Account_for_Expense_Accounting;
    /**
     * The Self_service_Users_Can_t_Close_Transactions
     * Meta information extracted from the WSDL
     * - documentation: To enable Pay Unapproved Expense Card Transactions, you must first enable Self-Service Users Can't Close Transactions. | Whether or not self-service users can include these Credit Card Transactions on Expense Reports.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Self_service_Users_Can_t_Close_Transactions;
    /**
     * The
     * Enable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transa
     * ctions
     * Meta information extracted from the WSDL
     * - documentation: Display a Receipt Date field on expense report lines with credit card transactions.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Enable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transactions;
    /**
     * The Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Billing currency of the Corporate Credit Card Account to support internal reporting requirements.
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType
     */
    public $Payment_Type_Reference;
    /**
     * The Produce_Remittance_File
     * Meta information extracted from the WSDL
     * - documentation: Whether or not a Remittance File will be produced.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Produce_Remittance_File;
    /**
     * The Market_Code
     * Meta information extracted from the WSDL
     * - documentation: Enter the financial institution provided market code to be used in the Workday generated remittance data.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Market_Code;
    /**
     * The Load_Number
     * Meta information extracted from the WSDL
     * - documentation: Enter the financial institution provided load number to be used in the Workday generated remittance data.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Load_Number;
    /**
     * The Country_Reference
     * Meta information extracted from the WSDL
     * - documentation: Country visible in the Payment Details of the Corporate Credit Card Account.
     * - minOccurs: 0
     * @var \StructType\CountryObjectType
     */
    public $Country_Reference;
    /**
     * The Billing_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency visible in the Payment Details of the Corporate Credit Card Account.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Billing_Currency_Reference;
    /**
     * The Integration_System_Reference
     * Meta information extracted from the WSDL
     * - documentation: Remittance Integration System visible in the Payment Details of the Corporate Credit Card Account.
     * - minOccurs: 0
     * @var \StructType\Integration_System__Audited_ObjectType
     */
    public $Integration_System_Reference;
    /**
     * The Contact_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Contact_Information_DataType
     */
    public $Contact_Data;
    /**
     * The Settlement_Account_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Settlement_Account_WWS_DataType[]
     */
    public $Settlement_Account_Data;
    /**
     * The Alternate_Name_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Entity_Alternate_Name_DataType[]
     */
    public $Alternate_Name_Data;
    /**
     * The Payment_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Enter the financial institution provided payment identifier to be used in credit card payment files. For American Express, this value can be Load Number, Corporate Identifier (CID), Deposit ID or Book Number.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Payment_Identifier;
    /**
     * Constructor method for Corporate_Credit_Card_Account_DataType
     * @uses Corporate_Credit_Card_Account_DataType::setCorporate_Credit_Card_Account_ID()
     * @uses Corporate_Credit_Card_Account_DataType::setCorporate_Credit_Card_Account_Name()
     * @uses Corporate_Credit_Card_Account_DataType::setFinancial_Institution_Reference()
     * @uses Corporate_Credit_Card_Account_DataType::setCredit_Card_Type_Reference()
     * @uses Corporate_Credit_Card_Account_DataType::setUsage_Reference()
     * @uses Corporate_Credit_Card_Account_DataType::setCorporate_Payment_Responsibility_Reference()
     * @uses Corporate_Credit_Card_Account_DataType::setExpense_Item_Reference()
     * @uses Corporate_Credit_Card_Account_DataType::setElectronic_Load_Only()
     * @uses Corporate_Credit_Card_Account_DataType::setAllow_Negative_Reimbursable_Total()
     * @uses Corporate_Credit_Card_Account_DataType::setPay_Unapproved_Credit_Card_Transactions()
     * @uses Corporate_Credit_Card_Account_DataType::setCompany_Reference()
     * @uses Corporate_Credit_Card_Account_DataType::setSpend_Category_Reference()
     * @uses Corporate_Credit_Card_Account_DataType::setBalancing_Worktag_Reference()
     * @uses Corporate_Credit_Card_Account_DataType::setOptional_Balancing_Worktags_Reference()
     * @uses Corporate_Credit_Card_Account_DataType::setDefault_Worktag_Reference()
     * @uses Corporate_Credit_Card_Account_DataType::setIs_Inactive()
     * @uses Corporate_Credit_Card_Account_DataType::setOnly_pay_Transactions_from_Expense_Reports_already_paid_to_Worker()
     * @uses Corporate_Credit_Card_Account_DataType::setPay_Unapproved_Expense_Card_Transactions()
     * @uses Corporate_Credit_Card_Account_DataType::setUse_Company_on_Credit_Card_Account_for_Expense_Accounting()
     * @uses Corporate_Credit_Card_Account_DataType::setSelf_service_Users_Can_t_Close_Transactions()
     * @uses Corporate_Credit_Card_Account_DataType::setEnable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transactions()
     * @uses Corporate_Credit_Card_Account_DataType::setPayment_Type_Reference()
     * @uses Corporate_Credit_Card_Account_DataType::setProduce_Remittance_File()
     * @uses Corporate_Credit_Card_Account_DataType::setMarket_Code()
     * @uses Corporate_Credit_Card_Account_DataType::setLoad_Number()
     * @uses Corporate_Credit_Card_Account_DataType::setCountry_Reference()
     * @uses Corporate_Credit_Card_Account_DataType::setBilling_Currency_Reference()
     * @uses Corporate_Credit_Card_Account_DataType::setIntegration_System_Reference()
     * @uses Corporate_Credit_Card_Account_DataType::setContact_Data()
     * @uses Corporate_Credit_Card_Account_DataType::setSettlement_Account_Data()
     * @uses Corporate_Credit_Card_Account_DataType::setAlternate_Name_Data()
     * @uses Corporate_Credit_Card_Account_DataType::setPayment_Identifier()
     * @param string $corporate_Credit_Card_Account_ID
     * @param string $corporate_Credit_Card_Account_Name
     * @param \StructType\Financial_InstitutionObjectType $financial_Institution_Reference
     * @param \StructType\Credit_Card_TypeObjectType $credit_Card_Type_Reference
     * @param \StructType\Credit_Card_Account_Usage_IndicatorObjectType $usage_Reference
     * @param \StructType\Corporate_Payment_ResponsibilityObjectType $corporate_Payment_Responsibility_Reference
     * @param \StructType\Expense_ItemObjectType[] $expense_Item_Reference
     * @param bool $electronic_Load_Only
     * @param bool $allow_Negative_Reimbursable_Total
     * @param bool $pay_Unapproved_Credit_Card_Transactions
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param \StructType\Balancing_WorktagObjectType $balancing_Worktag_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $optional_Balancing_Worktags_Reference
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $default_Worktag_Reference
     * @param bool $is_Inactive
     * @param bool $only_pay_Transactions_from_Expense_Reports_already_paid_to_Worker
     * @param bool $pay_Unapproved_Expense_Card_Transactions
     * @param bool $use_Company_on_Credit_Card_Account_for_Expense_Accounting
     * @param bool $self_service_Users_Can_t_Close_Transactions
     * @param bool $enable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transactions
     * @param \StructType\Payment_TypeObjectType $payment_Type_Reference
     * @param bool $produce_Remittance_File
     * @param string $market_Code
     * @param string $load_Number
     * @param \StructType\CountryObjectType $country_Reference
     * @param \StructType\CurrencyObjectType $billing_Currency_Reference
     * @param \StructType\Integration_System__Audited_ObjectType $integration_System_Reference
     * @param \StructType\Contact_Information_DataType $contact_Data
     * @param \StructType\Settlement_Account_WWS_DataType[] $settlement_Account_Data
     * @param \StructType\Business_Entity_Alternate_Name_DataType[] $alternate_Name_Data
     * @param string $payment_Identifier
     */
    public function __construct($corporate_Credit_Card_Account_ID = null, $corporate_Credit_Card_Account_Name = null, \StructType\Financial_InstitutionObjectType $financial_Institution_Reference = null, \StructType\Credit_Card_TypeObjectType $credit_Card_Type_Reference = null, \StructType\Credit_Card_Account_Usage_IndicatorObjectType $usage_Reference = null, \StructType\Corporate_Payment_ResponsibilityObjectType $corporate_Payment_Responsibility_Reference = null, array $expense_Item_Reference = array(), $electronic_Load_Only = null, $allow_Negative_Reimbursable_Total = null, $pay_Unapproved_Credit_Card_Transactions = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, \StructType\Balancing_WorktagObjectType $balancing_Worktag_Reference = null, array $optional_Balancing_Worktags_Reference = array(), array $default_Worktag_Reference = array(), $is_Inactive = null, $only_pay_Transactions_from_Expense_Reports_already_paid_to_Worker = null, $pay_Unapproved_Expense_Card_Transactions = null, $use_Company_on_Credit_Card_Account_for_Expense_Accounting = null, $self_service_Users_Can_t_Close_Transactions = null, $enable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transactions = null, \StructType\Payment_TypeObjectType $payment_Type_Reference = null, $produce_Remittance_File = null, $market_Code = null, $load_Number = null, \StructType\CountryObjectType $country_Reference = null, \StructType\CurrencyObjectType $billing_Currency_Reference = null, \StructType\Integration_System__Audited_ObjectType $integration_System_Reference = null, \StructType\Contact_Information_DataType $contact_Data = null, array $settlement_Account_Data = array(), array $alternate_Name_Data = array(), $payment_Identifier = null)
    {
        $this
            ->setCorporate_Credit_Card_Account_ID($corporate_Credit_Card_Account_ID)
            ->setCorporate_Credit_Card_Account_Name($corporate_Credit_Card_Account_Name)
            ->setFinancial_Institution_Reference($financial_Institution_Reference)
            ->setCredit_Card_Type_Reference($credit_Card_Type_Reference)
            ->setUsage_Reference($usage_Reference)
            ->setCorporate_Payment_Responsibility_Reference($corporate_Payment_Responsibility_Reference)
            ->setExpense_Item_Reference($expense_Item_Reference)
            ->setElectronic_Load_Only($electronic_Load_Only)
            ->setAllow_Negative_Reimbursable_Total($allow_Negative_Reimbursable_Total)
            ->setPay_Unapproved_Credit_Card_Transactions($pay_Unapproved_Credit_Card_Transactions)
            ->setCompany_Reference($company_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setBalancing_Worktag_Reference($balancing_Worktag_Reference)
            ->setOptional_Balancing_Worktags_Reference($optional_Balancing_Worktags_Reference)
            ->setDefault_Worktag_Reference($default_Worktag_Reference)
            ->setIs_Inactive($is_Inactive)
            ->setOnly_pay_Transactions_from_Expense_Reports_already_paid_to_Worker($only_pay_Transactions_from_Expense_Reports_already_paid_to_Worker)
            ->setPay_Unapproved_Expense_Card_Transactions($pay_Unapproved_Expense_Card_Transactions)
            ->setUse_Company_on_Credit_Card_Account_for_Expense_Accounting($use_Company_on_Credit_Card_Account_for_Expense_Accounting)
            ->setSelf_service_Users_Can_t_Close_Transactions($self_service_Users_Can_t_Close_Transactions)
            ->setEnable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transactions($enable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transactions)
            ->setPayment_Type_Reference($payment_Type_Reference)
            ->setProduce_Remittance_File($produce_Remittance_File)
            ->setMarket_Code($market_Code)
            ->setLoad_Number($load_Number)
            ->setCountry_Reference($country_Reference)
            ->setBilling_Currency_Reference($billing_Currency_Reference)
            ->setIntegration_System_Reference($integration_System_Reference)
            ->setContact_Data($contact_Data)
            ->setSettlement_Account_Data($settlement_Account_Data)
            ->setAlternate_Name_Data($alternate_Name_Data)
            ->setPayment_Identifier($payment_Identifier);
    }
    /**
     * Get Corporate_Credit_Card_Account_ID value
     * @return string|null
     */
    public function getCorporate_Credit_Card_Account_ID()
    {
        return $this->Corporate_Credit_Card_Account_ID;
    }
    /**
     * Set Corporate_Credit_Card_Account_ID value
     * @param string $corporate_Credit_Card_Account_ID
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setCorporate_Credit_Card_Account_ID($corporate_Credit_Card_Account_ID = null)
    {
        // validation for constraint: string
        if (!is_null($corporate_Credit_Card_Account_ID) && !is_string($corporate_Credit_Card_Account_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corporate_Credit_Card_Account_ID, true), gettype($corporate_Credit_Card_Account_ID)), __LINE__);
        }
        $this->Corporate_Credit_Card_Account_ID = $corporate_Credit_Card_Account_ID;
        return $this;
    }
    /**
     * Get Corporate_Credit_Card_Account_Name value
     * @return string|null
     */
    public function getCorporate_Credit_Card_Account_Name()
    {
        return $this->Corporate_Credit_Card_Account_Name;
    }
    /**
     * Set Corporate_Credit_Card_Account_Name value
     * @param string $corporate_Credit_Card_Account_Name
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setCorporate_Credit_Card_Account_Name($corporate_Credit_Card_Account_Name = null)
    {
        // validation for constraint: string
        if (!is_null($corporate_Credit_Card_Account_Name) && !is_string($corporate_Credit_Card_Account_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corporate_Credit_Card_Account_Name, true), gettype($corporate_Credit_Card_Account_Name)), __LINE__);
        }
        $this->Corporate_Credit_Card_Account_Name = $corporate_Credit_Card_Account_Name;
        return $this;
    }
    /**
     * Get Financial_Institution_Reference value
     * @return \StructType\Financial_InstitutionObjectType|null
     */
    public function getFinancial_Institution_Reference()
    {
        return $this->Financial_Institution_Reference;
    }
    /**
     * Set Financial_Institution_Reference value
     * @param \StructType\Financial_InstitutionObjectType $financial_Institution_Reference
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setFinancial_Institution_Reference(\StructType\Financial_InstitutionObjectType $financial_Institution_Reference = null)
    {
        $this->Financial_Institution_Reference = $financial_Institution_Reference;
        return $this;
    }
    /**
     * Get Credit_Card_Type_Reference value
     * @return \StructType\Credit_Card_TypeObjectType|null
     */
    public function getCredit_Card_Type_Reference()
    {
        return $this->Credit_Card_Type_Reference;
    }
    /**
     * Set Credit_Card_Type_Reference value
     * @param \StructType\Credit_Card_TypeObjectType $credit_Card_Type_Reference
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setCredit_Card_Type_Reference(\StructType\Credit_Card_TypeObjectType $credit_Card_Type_Reference = null)
    {
        $this->Credit_Card_Type_Reference = $credit_Card_Type_Reference;
        return $this;
    }
    /**
     * Get Usage_Reference value
     * @return \StructType\Credit_Card_Account_Usage_IndicatorObjectType|null
     */
    public function getUsage_Reference()
    {
        return $this->Usage_Reference;
    }
    /**
     * Set Usage_Reference value
     * @param \StructType\Credit_Card_Account_Usage_IndicatorObjectType $usage_Reference
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setUsage_Reference(\StructType\Credit_Card_Account_Usage_IndicatorObjectType $usage_Reference = null)
    {
        $this->Usage_Reference = $usage_Reference;
        return $this;
    }
    /**
     * Get Corporate_Payment_Responsibility_Reference value
     * @return \StructType\Corporate_Payment_ResponsibilityObjectType|null
     */
    public function getCorporate_Payment_Responsibility_Reference()
    {
        return $this->Corporate_Payment_Responsibility_Reference;
    }
    /**
     * Set Corporate_Payment_Responsibility_Reference value
     * @param \StructType\Corporate_Payment_ResponsibilityObjectType $corporate_Payment_Responsibility_Reference
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setCorporate_Payment_Responsibility_Reference(\StructType\Corporate_Payment_ResponsibilityObjectType $corporate_Payment_Responsibility_Reference = null)
    {
        $this->Corporate_Payment_Responsibility_Reference = $corporate_Payment_Responsibility_Reference;
        return $this;
    }
    /**
     * Get Expense_Item_Reference value
     * @return \StructType\Expense_ItemObjectType[]|null
     */
    public function getExpense_Item_Reference()
    {
        return $this->Expense_Item_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Item_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Item_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Item_ReferenceForArrayConstraintsFromSetExpense_Item_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $corporate_Credit_Card_Account_DataTypeExpense_Item_ReferenceItem) {
            // validation for constraint: itemType
            if (!$corporate_Credit_Card_Account_DataTypeExpense_Item_ReferenceItem instanceof \StructType\Expense_ItemObjectType) {
                $invalidValues[] = is_object($corporate_Credit_Card_Account_DataTypeExpense_Item_ReferenceItem) ? get_class($corporate_Credit_Card_Account_DataTypeExpense_Item_ReferenceItem) : sprintf('%s(%s)', gettype($corporate_Credit_Card_Account_DataTypeExpense_Item_ReferenceItem), var_export($corporate_Credit_Card_Account_DataTypeExpense_Item_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Item_Reference property can only contain items of type \StructType\Expense_ItemObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_ItemObjectType[] $expense_Item_Reference
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setExpense_Item_Reference(array $expense_Item_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Item_ReferenceArrayErrorMessage = self::validateExpense_Item_ReferenceForArrayConstraintsFromSetExpense_Item_Reference($expense_Item_Reference))) {
            throw new \InvalidArgumentException($expense_Item_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Item_Reference = $expense_Item_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_ItemObjectType $item
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function addToExpense_Item_Reference(\StructType\Expense_ItemObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_ItemObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Item_Reference property can only contain items of type \StructType\Expense_ItemObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Item_Reference[] = $item;
        return $this;
    }
    /**
     * Get Electronic_Load_Only value
     * @return bool|null
     */
    public function getElectronic_Load_Only()
    {
        return $this->Electronic_Load_Only;
    }
    /**
     * Set Electronic_Load_Only value
     * @param bool $electronic_Load_Only
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setElectronic_Load_Only($electronic_Load_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($electronic_Load_Only) && !is_bool($electronic_Load_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($electronic_Load_Only, true), gettype($electronic_Load_Only)), __LINE__);
        }
        $this->Electronic_Load_Only = $electronic_Load_Only;
        return $this;
    }
    /**
     * Get Allow_Negative_Reimbursable_Total value
     * @return bool|null
     */
    public function getAllow_Negative_Reimbursable_Total()
    {
        return $this->Allow_Negative_Reimbursable_Total;
    }
    /**
     * Set Allow_Negative_Reimbursable_Total value
     * @param bool $allow_Negative_Reimbursable_Total
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setAllow_Negative_Reimbursable_Total($allow_Negative_Reimbursable_Total = null)
    {
        // validation for constraint: boolean
        if (!is_null($allow_Negative_Reimbursable_Total) && !is_bool($allow_Negative_Reimbursable_Total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allow_Negative_Reimbursable_Total, true), gettype($allow_Negative_Reimbursable_Total)), __LINE__);
        }
        $this->Allow_Negative_Reimbursable_Total = $allow_Negative_Reimbursable_Total;
        return $this;
    }
    /**
     * Get Pay_Unapproved_Credit_Card_Transactions value
     * @return bool|null
     */
    public function getPay_Unapproved_Credit_Card_Transactions()
    {
        return $this->Pay_Unapproved_Credit_Card_Transactions;
    }
    /**
     * Set Pay_Unapproved_Credit_Card_Transactions value
     * @param bool $pay_Unapproved_Credit_Card_Transactions
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setPay_Unapproved_Credit_Card_Transactions($pay_Unapproved_Credit_Card_Transactions = null)
    {
        // validation for constraint: boolean
        if (!is_null($pay_Unapproved_Credit_Card_Transactions) && !is_bool($pay_Unapproved_Credit_Card_Transactions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pay_Unapproved_Credit_Card_Transactions, true), gettype($pay_Unapproved_Credit_Card_Transactions)), __LINE__);
        }
        $this->Pay_Unapproved_Credit_Card_Transactions = $pay_Unapproved_Credit_Card_Transactions;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Balancing_Worktag_Reference value
     * @return \StructType\Balancing_WorktagObjectType|null
     */
    public function getBalancing_Worktag_Reference()
    {
        return $this->Balancing_Worktag_Reference;
    }
    /**
     * Set Balancing_Worktag_Reference value
     * @param \StructType\Balancing_WorktagObjectType $balancing_Worktag_Reference
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setBalancing_Worktag_Reference(\StructType\Balancing_WorktagObjectType $balancing_Worktag_Reference = null)
    {
        $this->Balancing_Worktag_Reference = $balancing_Worktag_Reference;
        return $this;
    }
    /**
     * Get Optional_Balancing_Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getOptional_Balancing_Worktags_Reference()
    {
        return $this->Optional_Balancing_Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setOptional_Balancing_Worktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOptional_Balancing_Worktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOptional_Balancing_Worktags_ReferenceForArrayConstraintsFromSetOptional_Balancing_Worktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $corporate_Credit_Card_Account_DataTypeOptional_Balancing_Worktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$corporate_Credit_Card_Account_DataTypeOptional_Balancing_Worktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($corporate_Credit_Card_Account_DataTypeOptional_Balancing_Worktags_ReferenceItem) ? get_class($corporate_Credit_Card_Account_DataTypeOptional_Balancing_Worktags_ReferenceItem) : sprintf('%s(%s)', gettype($corporate_Credit_Card_Account_DataTypeOptional_Balancing_Worktags_ReferenceItem), var_export($corporate_Credit_Card_Account_DataTypeOptional_Balancing_Worktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Optional_Balancing_Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Optional_Balancing_Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $optional_Balancing_Worktags_Reference
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setOptional_Balancing_Worktags_Reference(array $optional_Balancing_Worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($optional_Balancing_Worktags_ReferenceArrayErrorMessage = self::validateOptional_Balancing_Worktags_ReferenceForArrayConstraintsFromSetOptional_Balancing_Worktags_Reference($optional_Balancing_Worktags_Reference))) {
            throw new \InvalidArgumentException($optional_Balancing_Worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Optional_Balancing_Worktags_Reference = $optional_Balancing_Worktags_Reference;
        return $this;
    }
    /**
     * Add item to Optional_Balancing_Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function addToOptional_Balancing_Worktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Optional_Balancing_Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Optional_Balancing_Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Default_Worktag_Reference value
     * @return \StructType\Audited_Accounting_WorktagObjectType[]|null
     */
    public function getDefault_Worktag_Reference()
    {
        return $this->Default_Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setDefault_Worktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDefault_Worktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDefault_Worktag_ReferenceForArrayConstraintsFromSetDefault_Worktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $corporate_Credit_Card_Account_DataTypeDefault_Worktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$corporate_Credit_Card_Account_DataTypeDefault_Worktag_ReferenceItem instanceof \StructType\Audited_Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($corporate_Credit_Card_Account_DataTypeDefault_Worktag_ReferenceItem) ? get_class($corporate_Credit_Card_Account_DataTypeDefault_Worktag_ReferenceItem) : sprintf('%s(%s)', gettype($corporate_Credit_Card_Account_DataTypeDefault_Worktag_ReferenceItem), var_export($corporate_Credit_Card_Account_DataTypeDefault_Worktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Default_Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Default_Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $default_Worktag_Reference
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setDefault_Worktag_Reference(array $default_Worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($default_Worktag_ReferenceArrayErrorMessage = self::validateDefault_Worktag_ReferenceForArrayConstraintsFromSetDefault_Worktag_Reference($default_Worktag_Reference))) {
            throw new \InvalidArgumentException($default_Worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Default_Worktag_Reference = $default_Worktag_Reference;
        return $this;
    }
    /**
     * Add item to Default_Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType $item
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function addToDefault_Worktag_Reference(\StructType\Audited_Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Audited_Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Default_Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Default_Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Is_Inactive value
     * @return bool|null
     */
    public function getIs_Inactive()
    {
        return $this->Is_Inactive;
    }
    /**
     * Set Is_Inactive value
     * @param bool $is_Inactive
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setIs_Inactive($is_Inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_Inactive) && !is_bool($is_Inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_Inactive, true), gettype($is_Inactive)), __LINE__);
        }
        $this->Is_Inactive = $is_Inactive;
        return $this;
    }
    /**
     * Get Only_pay_Transactions_from_Expense_Reports_already_paid_to_Worker value
     * @return bool|null
     */
    public function getOnly_pay_Transactions_from_Expense_Reports_already_paid_to_Worker()
    {
        return $this->Only_pay_Transactions_from_Expense_Reports_already_paid_to_Worker;
    }
    /**
     * Set Only_pay_Transactions_from_Expense_Reports_already_paid_to_Worker value
     * @param bool $only_pay_Transactions_from_Expense_Reports_already_paid_to_Worker
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setOnly_pay_Transactions_from_Expense_Reports_already_paid_to_Worker($only_pay_Transactions_from_Expense_Reports_already_paid_to_Worker = null)
    {
        // validation for constraint: boolean
        if (!is_null($only_pay_Transactions_from_Expense_Reports_already_paid_to_Worker) && !is_bool($only_pay_Transactions_from_Expense_Reports_already_paid_to_Worker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($only_pay_Transactions_from_Expense_Reports_already_paid_to_Worker, true), gettype($only_pay_Transactions_from_Expense_Reports_already_paid_to_Worker)), __LINE__);
        }
        $this->Only_pay_Transactions_from_Expense_Reports_already_paid_to_Worker = $only_pay_Transactions_from_Expense_Reports_already_paid_to_Worker;
        return $this;
    }
    /**
     * Get Pay_Unapproved_Expense_Card_Transactions value
     * @return bool|null
     */
    public function getPay_Unapproved_Expense_Card_Transactions()
    {
        return $this->Pay_Unapproved_Expense_Card_Transactions;
    }
    /**
     * Set Pay_Unapproved_Expense_Card_Transactions value
     * @param bool $pay_Unapproved_Expense_Card_Transactions
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setPay_Unapproved_Expense_Card_Transactions($pay_Unapproved_Expense_Card_Transactions = null)
    {
        // validation for constraint: boolean
        if (!is_null($pay_Unapproved_Expense_Card_Transactions) && !is_bool($pay_Unapproved_Expense_Card_Transactions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pay_Unapproved_Expense_Card_Transactions, true), gettype($pay_Unapproved_Expense_Card_Transactions)), __LINE__);
        }
        $this->Pay_Unapproved_Expense_Card_Transactions = $pay_Unapproved_Expense_Card_Transactions;
        return $this;
    }
    /**
     * Get Use_Company_on_Credit_Card_Account_for_Expense_Accounting value
     * @return bool|null
     */
    public function getUse_Company_on_Credit_Card_Account_for_Expense_Accounting()
    {
        return $this->Use_Company_on_Credit_Card_Account_for_Expense_Accounting;
    }
    /**
     * Set Use_Company_on_Credit_Card_Account_for_Expense_Accounting value
     * @param bool $use_Company_on_Credit_Card_Account_for_Expense_Accounting
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setUse_Company_on_Credit_Card_Account_for_Expense_Accounting($use_Company_on_Credit_Card_Account_for_Expense_Accounting = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Company_on_Credit_Card_Account_for_Expense_Accounting) && !is_bool($use_Company_on_Credit_Card_Account_for_Expense_Accounting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Company_on_Credit_Card_Account_for_Expense_Accounting, true), gettype($use_Company_on_Credit_Card_Account_for_Expense_Accounting)), __LINE__);
        }
        $this->Use_Company_on_Credit_Card_Account_for_Expense_Accounting = $use_Company_on_Credit_Card_Account_for_Expense_Accounting;
        return $this;
    }
    /**
     * Get Self_service_Users_Can_t_Close_Transactions value
     * @return bool|null
     */
    public function getSelf_service_Users_Can_t_Close_Transactions()
    {
        return $this->{'Self-service_Users_Can_t_Close_Transactions'};
    }
    /**
     * Set Self_service_Users_Can_t_Close_Transactions value
     * @param bool $self_service_Users_Can_t_Close_Transactions
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setSelf_service_Users_Can_t_Close_Transactions($self_service_Users_Can_t_Close_Transactions = null)
    {
        // validation for constraint: boolean
        if (!is_null($self_service_Users_Can_t_Close_Transactions) && !is_bool($self_service_Users_Can_t_Close_Transactions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($self_service_Users_Can_t_Close_Transactions, true), gettype($self_service_Users_Can_t_Close_Transactions)), __LINE__);
        }
        $this->Self_service_Users_Can_t_Close_Transactions = $this->{'Self-service_Users_Can_t_Close_Transactions'} = $self_service_Users_Can_t_Close_Transactions;
        return $this;
    }
    /**
     * Get
     * Enable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transa
     * ctions value
     * @return bool|null
     */
    public function getEnable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transactions()
    {
        return $this->Enable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transactions;
    }
    /**
     * Set
     * Enable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transa
     * ctions value
     * @param bool $enable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transactions
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setEnable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transactions($enable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transactions = null)
    {
        // validation for constraint: boolean
        if (!is_null($enable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transactions) && !is_bool($enable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transactions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transactions, true), gettype($enable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transactions)), __LINE__);
        }
        $this->Enable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transactions = $enable_Editing_on_the_Date_Field_on_Expense_Report_Lines_with_Credit_Card_Transactions;
        return $this;
    }
    /**
     * Get Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getPayment_Type_Reference()
    {
        return $this->Payment_Type_Reference;
    }
    /**
     * Set Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $payment_Type_Reference
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setPayment_Type_Reference(\StructType\Payment_TypeObjectType $payment_Type_Reference = null)
    {
        $this->Payment_Type_Reference = $payment_Type_Reference;
        return $this;
    }
    /**
     * Get Produce_Remittance_File value
     * @return bool|null
     */
    public function getProduce_Remittance_File()
    {
        return $this->Produce_Remittance_File;
    }
    /**
     * Set Produce_Remittance_File value
     * @param bool $produce_Remittance_File
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setProduce_Remittance_File($produce_Remittance_File = null)
    {
        // validation for constraint: boolean
        if (!is_null($produce_Remittance_File) && !is_bool($produce_Remittance_File)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($produce_Remittance_File, true), gettype($produce_Remittance_File)), __LINE__);
        }
        $this->Produce_Remittance_File = $produce_Remittance_File;
        return $this;
    }
    /**
     * Get Market_Code value
     * @return string|null
     */
    public function getMarket_Code()
    {
        return $this->Market_Code;
    }
    /**
     * Set Market_Code value
     * @param string $market_Code
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setMarket_Code($market_Code = null)
    {
        // validation for constraint: string
        if (!is_null($market_Code) && !is_string($market_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($market_Code, true), gettype($market_Code)), __LINE__);
        }
        $this->Market_Code = $market_Code;
        return $this;
    }
    /**
     * Get Load_Number value
     * @return string|null
     */
    public function getLoad_Number()
    {
        return $this->Load_Number;
    }
    /**
     * Set Load_Number value
     * @param string $load_Number
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setLoad_Number($load_Number = null)
    {
        // validation for constraint: string
        if (!is_null($load_Number) && !is_string($load_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($load_Number, true), gettype($load_Number)), __LINE__);
        }
        $this->Load_Number = $load_Number;
        return $this;
    }
    /**
     * Get Country_Reference value
     * @return \StructType\CountryObjectType|null
     */
    public function getCountry_Reference()
    {
        return $this->Country_Reference;
    }
    /**
     * Set Country_Reference value
     * @param \StructType\CountryObjectType $country_Reference
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setCountry_Reference(\StructType\CountryObjectType $country_Reference = null)
    {
        $this->Country_Reference = $country_Reference;
        return $this;
    }
    /**
     * Get Billing_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getBilling_Currency_Reference()
    {
        return $this->Billing_Currency_Reference;
    }
    /**
     * Set Billing_Currency_Reference value
     * @param \StructType\CurrencyObjectType $billing_Currency_Reference
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setBilling_Currency_Reference(\StructType\CurrencyObjectType $billing_Currency_Reference = null)
    {
        $this->Billing_Currency_Reference = $billing_Currency_Reference;
        return $this;
    }
    /**
     * Get Integration_System_Reference value
     * @return \StructType\Integration_System__Audited_ObjectType|null
     */
    public function getIntegration_System_Reference()
    {
        return $this->Integration_System_Reference;
    }
    /**
     * Set Integration_System_Reference value
     * @param \StructType\Integration_System__Audited_ObjectType $integration_System_Reference
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setIntegration_System_Reference(\StructType\Integration_System__Audited_ObjectType $integration_System_Reference = null)
    {
        $this->Integration_System_Reference = $integration_System_Reference;
        return $this;
    }
    /**
     * Get Contact_Data value
     * @return \StructType\Contact_Information_DataType|null
     */
    public function getContact_Data()
    {
        return $this->Contact_Data;
    }
    /**
     * Set Contact_Data value
     * @param \StructType\Contact_Information_DataType $contact_Data
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setContact_Data(\StructType\Contact_Information_DataType $contact_Data = null)
    {
        $this->Contact_Data = $contact_Data;
        return $this;
    }
    /**
     * Get Settlement_Account_Data value
     * @return \StructType\Settlement_Account_WWS_DataType[]|null
     */
    public function getSettlement_Account_Data()
    {
        return $this->Settlement_Account_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSettlement_Account_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSettlement_Account_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSettlement_Account_DataForArrayConstraintsFromSetSettlement_Account_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $corporate_Credit_Card_Account_DataTypeSettlement_Account_DataItem) {
            // validation for constraint: itemType
            if (!$corporate_Credit_Card_Account_DataTypeSettlement_Account_DataItem instanceof \StructType\Settlement_Account_WWS_DataType) {
                $invalidValues[] = is_object($corporate_Credit_Card_Account_DataTypeSettlement_Account_DataItem) ? get_class($corporate_Credit_Card_Account_DataTypeSettlement_Account_DataItem) : sprintf('%s(%s)', gettype($corporate_Credit_Card_Account_DataTypeSettlement_Account_DataItem), var_export($corporate_Credit_Card_Account_DataTypeSettlement_Account_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Settlement_Account_Data property can only contain items of type \StructType\Settlement_Account_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Settlement_Account_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Settlement_Account_WWS_DataType[] $settlement_Account_Data
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setSettlement_Account_Data(array $settlement_Account_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($settlement_Account_DataArrayErrorMessage = self::validateSettlement_Account_DataForArrayConstraintsFromSetSettlement_Account_Data($settlement_Account_Data))) {
            throw new \InvalidArgumentException($settlement_Account_DataArrayErrorMessage, __LINE__);
        }
        $this->Settlement_Account_Data = $settlement_Account_Data;
        return $this;
    }
    /**
     * Add item to Settlement_Account_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Settlement_Account_WWS_DataType $item
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function addToSettlement_Account_Data(\StructType\Settlement_Account_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Settlement_Account_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Settlement_Account_Data property can only contain items of type \StructType\Settlement_Account_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Settlement_Account_Data[] = $item;
        return $this;
    }
    /**
     * Get Alternate_Name_Data value
     * @return \StructType\Business_Entity_Alternate_Name_DataType[]|null
     */
    public function getAlternate_Name_Data()
    {
        return $this->Alternate_Name_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternate_Name_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternate_Name_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternate_Name_DataForArrayConstraintsFromSetAlternate_Name_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $corporate_Credit_Card_Account_DataTypeAlternate_Name_DataItem) {
            // validation for constraint: itemType
            if (!$corporate_Credit_Card_Account_DataTypeAlternate_Name_DataItem instanceof \StructType\Business_Entity_Alternate_Name_DataType) {
                $invalidValues[] = is_object($corporate_Credit_Card_Account_DataTypeAlternate_Name_DataItem) ? get_class($corporate_Credit_Card_Account_DataTypeAlternate_Name_DataItem) : sprintf('%s(%s)', gettype($corporate_Credit_Card_Account_DataTypeAlternate_Name_DataItem), var_export($corporate_Credit_Card_Account_DataTypeAlternate_Name_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alternate_Name_Data property can only contain items of type \StructType\Business_Entity_Alternate_Name_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alternate_Name_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Entity_Alternate_Name_DataType[] $alternate_Name_Data
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setAlternate_Name_Data(array $alternate_Name_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($alternate_Name_DataArrayErrorMessage = self::validateAlternate_Name_DataForArrayConstraintsFromSetAlternate_Name_Data($alternate_Name_Data))) {
            throw new \InvalidArgumentException($alternate_Name_DataArrayErrorMessage, __LINE__);
        }
        $this->Alternate_Name_Data = $alternate_Name_Data;
        return $this;
    }
    /**
     * Add item to Alternate_Name_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Entity_Alternate_Name_DataType $item
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function addToAlternate_Name_Data(\StructType\Business_Entity_Alternate_Name_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Entity_Alternate_Name_DataType) {
            throw new \InvalidArgumentException(sprintf('The Alternate_Name_Data property can only contain items of type \StructType\Business_Entity_Alternate_Name_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alternate_Name_Data[] = $item;
        return $this;
    }
    /**
     * Get Payment_Identifier value
     * @return string|null
     */
    public function getPayment_Identifier()
    {
        return $this->Payment_Identifier;
    }
    /**
     * Set Payment_Identifier value
     * @param string $payment_Identifier
     * @return \StructType\Corporate_Credit_Card_Account_DataType
     */
    public function setPayment_Identifier($payment_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($payment_Identifier) && !is_string($payment_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payment_Identifier, true), gettype($payment_Identifier)), __LINE__);
        }
        $this->Payment_Identifier = $payment_Identifier;
        return $this;
    }
}
