<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contingent_Worker_Receipt_Line_Replacement_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Purchase Order Line cannot be used because it has been Canceled. | The Purchase Order Line referenced is from a PO that is Closed or Pending Close. | Contingent Worker Receipt Line Replacement Data. For logging time worked.
 * @subpackage Structs
 */
class Contingent_Worker_Receipt_Line_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Line associated with the Contingent Worker Receipt Line
     * @var \StructType\Purchase_Order_LineObjectType
     */
    public $Purchase_Order_Line_Reference;
    /**
     * The Period_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start Date for the Period defined.
     * - maxOccurs: 1
     * @var string
     */
    public $Period_Start_Date;
    /**
     * The Period_End_Date
     * Meta information extracted from the WSDL
     * - documentation: End Date for the Period defined.
     * - maxOccurs: 1
     * @var string
     */
    public $Period_End_Date;
    /**
     * The Hours_Worked_Data
     * Meta information extracted from the WSDL
     * - documentation: Hours Worked details.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Hours_Worked_DataType[]
     */
    public $Hours_Worked_Data;
    /**
     * The Additional_Amount
     * Meta information extracted from the WSDL
     * - documentation: Additional amount, if any, for the Receipt Line which is not associated with Hours Worked.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Additional_Amount;
    /**
     * The Amount_to_Receive
     * Meta information extracted from the WSDL
     * - documentation: Calculated Amount to Receive based on sum of Hours Worked Data plus Additional Amount (if any). The Hours Worked Amount is calculated based on the Time Code Rate Multiplier and the Contract Pay Rate on the Purchase Order Line.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Amount_to_Receive;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Receipt Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * Constructor method for Contingent_Worker_Receipt_Line_Replacement_DataType
     * @uses Contingent_Worker_Receipt_Line_Replacement_DataType::setPurchase_Order_Line_Reference()
     * @uses Contingent_Worker_Receipt_Line_Replacement_DataType::setPeriod_Start_Date()
     * @uses Contingent_Worker_Receipt_Line_Replacement_DataType::setPeriod_End_Date()
     * @uses Contingent_Worker_Receipt_Line_Replacement_DataType::setHours_Worked_Data()
     * @uses Contingent_Worker_Receipt_Line_Replacement_DataType::setAdditional_Amount()
     * @uses Contingent_Worker_Receipt_Line_Replacement_DataType::setAmount_to_Receive()
     * @uses Contingent_Worker_Receipt_Line_Replacement_DataType::setMemo()
     * @param \StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference
     * @param string $period_Start_Date
     * @param string $period_End_Date
     * @param \StructType\Hours_Worked_DataType[] $hours_Worked_Data
     * @param float $additional_Amount
     * @param float $amount_to_Receive
     * @param string $memo
     */
    public function __construct(\StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference = null, $period_Start_Date = null, $period_End_Date = null, array $hours_Worked_Data = array(), $additional_Amount = null, $amount_to_Receive = null, $memo = null)
    {
        $this
            ->setPurchase_Order_Line_Reference($purchase_Order_Line_Reference)
            ->setPeriod_Start_Date($period_Start_Date)
            ->setPeriod_End_Date($period_End_Date)
            ->setHours_Worked_Data($hours_Worked_Data)
            ->setAdditional_Amount($additional_Amount)
            ->setAmount_to_Receive($amount_to_Receive)
            ->setMemo($memo);
    }
    /**
     * Get Purchase_Order_Line_Reference value
     * @return \StructType\Purchase_Order_LineObjectType|null
     */
    public function getPurchase_Order_Line_Reference()
    {
        return $this->Purchase_Order_Line_Reference;
    }
    /**
     * Set Purchase_Order_Line_Reference value
     * @param \StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference
     * @return \StructType\Contingent_Worker_Receipt_Line_Replacement_DataType
     */
    public function setPurchase_Order_Line_Reference(\StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference = null)
    {
        $this->Purchase_Order_Line_Reference = $purchase_Order_Line_Reference;
        return $this;
    }
    /**
     * Get Period_Start_Date value
     * @return string|null
     */
    public function getPeriod_Start_Date()
    {
        return $this->Period_Start_Date;
    }
    /**
     * Set Period_Start_Date value
     * @param string $period_Start_Date
     * @return \StructType\Contingent_Worker_Receipt_Line_Replacement_DataType
     */
    public function setPeriod_Start_Date($period_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($period_Start_Date) && !is_string($period_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($period_Start_Date, true), gettype($period_Start_Date)), __LINE__);
        }
        $this->Period_Start_Date = $period_Start_Date;
        return $this;
    }
    /**
     * Get Period_End_Date value
     * @return string|null
     */
    public function getPeriod_End_Date()
    {
        return $this->Period_End_Date;
    }
    /**
     * Set Period_End_Date value
     * @param string $period_End_Date
     * @return \StructType\Contingent_Worker_Receipt_Line_Replacement_DataType
     */
    public function setPeriod_End_Date($period_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($period_End_Date) && !is_string($period_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($period_End_Date, true), gettype($period_End_Date)), __LINE__);
        }
        $this->Period_End_Date = $period_End_Date;
        return $this;
    }
    /**
     * Get Hours_Worked_Data value
     * @return \StructType\Hours_Worked_DataType[]|null
     */
    public function getHours_Worked_Data()
    {
        return $this->Hours_Worked_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setHours_Worked_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHours_Worked_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHours_Worked_DataForArrayConstraintsFromSetHours_Worked_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contingent_Worker_Receipt_Line_Replacement_DataTypeHours_Worked_DataItem) {
            // validation for constraint: itemType
            if (!$contingent_Worker_Receipt_Line_Replacement_DataTypeHours_Worked_DataItem instanceof \StructType\Hours_Worked_DataType) {
                $invalidValues[] = is_object($contingent_Worker_Receipt_Line_Replacement_DataTypeHours_Worked_DataItem) ? get_class($contingent_Worker_Receipt_Line_Replacement_DataTypeHours_Worked_DataItem) : sprintf('%s(%s)', gettype($contingent_Worker_Receipt_Line_Replacement_DataTypeHours_Worked_DataItem), var_export($contingent_Worker_Receipt_Line_Replacement_DataTypeHours_Worked_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Hours_Worked_Data property can only contain items of type \StructType\Hours_Worked_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Hours_Worked_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Hours_Worked_DataType[] $hours_Worked_Data
     * @return \StructType\Contingent_Worker_Receipt_Line_Replacement_DataType
     */
    public function setHours_Worked_Data(array $hours_Worked_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($hours_Worked_DataArrayErrorMessage = self::validateHours_Worked_DataForArrayConstraintsFromSetHours_Worked_Data($hours_Worked_Data))) {
            throw new \InvalidArgumentException($hours_Worked_DataArrayErrorMessage, __LINE__);
        }
        $this->Hours_Worked_Data = $hours_Worked_Data;
        return $this;
    }
    /**
     * Add item to Hours_Worked_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Hours_Worked_DataType $item
     * @return \StructType\Contingent_Worker_Receipt_Line_Replacement_DataType
     */
    public function addToHours_Worked_Data(\StructType\Hours_Worked_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Hours_Worked_DataType) {
            throw new \InvalidArgumentException(sprintf('The Hours_Worked_Data property can only contain items of type \StructType\Hours_Worked_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Hours_Worked_Data[] = $item;
        return $this;
    }
    /**
     * Get Additional_Amount value
     * @return float|null
     */
    public function getAdditional_Amount()
    {
        return $this->Additional_Amount;
    }
    /**
     * Set Additional_Amount value
     * @param float $additional_Amount
     * @return \StructType\Contingent_Worker_Receipt_Line_Replacement_DataType
     */
    public function setAdditional_Amount($additional_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($additional_Amount) && !(is_float($additional_Amount) || is_numeric($additional_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($additional_Amount, true), gettype($additional_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($additional_Amount) && mb_strlen(mb_substr($additional_Amount, false !== mb_strpos($additional_Amount, '.') ? mb_strpos($additional_Amount, '.') + 1 : mb_strlen($additional_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($additional_Amount, true), mb_strlen(mb_substr($additional_Amount, mb_strpos($additional_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($additional_Amount) && $additional_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($additional_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($additional_Amount) && mb_strlen(preg_replace('/(\D)/', '', $additional_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($additional_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $additional_Amount))), __LINE__);
        }
        $this->Additional_Amount = $additional_Amount;
        return $this;
    }
    /**
     * Get Amount_to_Receive value
     * @return float|null
     */
    public function getAmount_to_Receive()
    {
        return $this->Amount_to_Receive;
    }
    /**
     * Set Amount_to_Receive value
     * @param float $amount_to_Receive
     * @return \StructType\Contingent_Worker_Receipt_Line_Replacement_DataType
     */
    public function setAmount_to_Receive($amount_to_Receive = null)
    {
        // validation for constraint: float
        if (!is_null($amount_to_Receive) && !(is_float($amount_to_Receive) || is_numeric($amount_to_Receive))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount_to_Receive, true), gettype($amount_to_Receive)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amount_to_Receive) && mb_strlen(mb_substr($amount_to_Receive, false !== mb_strpos($amount_to_Receive, '.') ? mb_strpos($amount_to_Receive, '.') + 1 : mb_strlen($amount_to_Receive))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amount_to_Receive, true), mb_strlen(mb_substr($amount_to_Receive, mb_strpos($amount_to_Receive, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($amount_to_Receive) && mb_strlen(preg_replace('/(\D)/', '', $amount_to_Receive)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($amount_to_Receive, true), mb_strlen(preg_replace('/(\D)/', '', $amount_to_Receive))), __LINE__);
        }
        $this->Amount_to_Receive = $amount_to_Receive;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Contingent_Worker_Receipt_Line_Replacement_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
}
