<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contingent_Worker_Order_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Contingent Worker Order Line data. A Purchase Order may only have one contingent worker order line data.
 * @subpackage Structs
 */
class Contingent_Worker_Order_Line_DataType extends AbstractStructBase
{
    /**
     * The Line_Number
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $Line_Number;
    /**
     * The Contingent_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Contingent Worker.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Contingent_Worker_Reference;
    /**
     * The Position_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Position.
     * - minOccurs: 0
     * @var \StructType\PositionObjectType
     */
    public $Position_Reference;
    /**
     * The Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Location.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Location_Reference;
    /**
     * The Position_Time_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Position Time Type.
     * - minOccurs: 0
     * @var \StructType\Position_Time_TypeObjectType
     */
    public $Position_Time_Type_Reference;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: The hire or start date for the contingent worker of the purchase order line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: The contract end date for the contingent worker of the purchase order line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Scheduled_Hours
     * Meta information extracted from the WSDL
     * - documentation: Scheduled Hours | The scheduled work hours for the contingent worker of the purchase order line.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Scheduled_Hours;
    /**
     * The Contract_Pay_Rate
     * Meta information extracted from the WSDL
     * - documentation: Contract Pay Rate | The contract pay rate for the contingent worker of the purchase order line.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Contract_Pay_Rate;
    /**
     * The Time_Code_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Time_Card_Factor_DataType[]
     */
    public $Time_Code_Data;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Payment_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payment Status for Purchase Order Line. This field is read-only and ignored on Submit.
     * - minOccurs: 0
     * @var \StructType\Document_Payment_StatusObjectType
     */
    public $Payment_Status_Reference;
    /**
     * The Invoice_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Invoice Status for Purchase Order Line. This field is read-only and ignored on Submit.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Invoice_Status_Reference;
    /**
     * The Receiving_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Receiving Status for Purchase Order Line. This field is read-only and ignored on Submit.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Receiving_Status_Reference;
    /**
     * The Resource_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Spend Category.
     * - minOccurs: 0
     * @var \StructType\Accounting_CategoryObjectType
     */
    public $Resource_Category_Reference;
    /**
     * The Tax_Applicability_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Tax Applicability.
     * - minOccurs: 0
     * @var \StructType\Tax_ApplicabilityObjectType
     */
    public $Tax_Applicability_Reference;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: You can't specify a third party tax code in the transaction tax code reference. | Reference to an existing Tax Code.
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Tax_Rate_Recoverabilities_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tax_Rate_Options_DataType[]
     */
    public $Tax_Rate_Recoverabilities_Data;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for each worktag type and is subject to configurable validation
     * when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Audited_Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Purchase Order Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * Constructor method for Contingent_Worker_Order_Line_DataType
     * @uses Contingent_Worker_Order_Line_DataType::setLine_Number()
     * @uses Contingent_Worker_Order_Line_DataType::setContingent_Worker_Reference()
     * @uses Contingent_Worker_Order_Line_DataType::setPosition_Reference()
     * @uses Contingent_Worker_Order_Line_DataType::setLocation_Reference()
     * @uses Contingent_Worker_Order_Line_DataType::setPosition_Time_Type_Reference()
     * @uses Contingent_Worker_Order_Line_DataType::setStart_Date()
     * @uses Contingent_Worker_Order_Line_DataType::setEnd_Date()
     * @uses Contingent_Worker_Order_Line_DataType::setScheduled_Hours()
     * @uses Contingent_Worker_Order_Line_DataType::setContract_Pay_Rate()
     * @uses Contingent_Worker_Order_Line_DataType::setTime_Code_Data()
     * @uses Contingent_Worker_Order_Line_DataType::setExtended_Amount()
     * @uses Contingent_Worker_Order_Line_DataType::setPayment_Status_Reference()
     * @uses Contingent_Worker_Order_Line_DataType::setInvoice_Status_Reference()
     * @uses Contingent_Worker_Order_Line_DataType::setReceiving_Status_Reference()
     * @uses Contingent_Worker_Order_Line_DataType::setResource_Category_Reference()
     * @uses Contingent_Worker_Order_Line_DataType::setTax_Applicability_Reference()
     * @uses Contingent_Worker_Order_Line_DataType::setTax_Code_Reference()
     * @uses Contingent_Worker_Order_Line_DataType::setTax_Rate_Recoverabilities_Data()
     * @uses Contingent_Worker_Order_Line_DataType::setWorktags_Reference()
     * @uses Contingent_Worker_Order_Line_DataType::setMemo()
     * @param float $line_Number
     * @param \StructType\WorkerObjectType $contingent_Worker_Reference
     * @param \StructType\PositionObjectType $position_Reference
     * @param \StructType\LocationObjectType $location_Reference
     * @param \StructType\Position_Time_TypeObjectType $position_Time_Type_Reference
     * @param string $start_Date
     * @param string $end_Date
     * @param float $scheduled_Hours
     * @param float $contract_Pay_Rate
     * @param \StructType\Time_Card_Factor_DataType[] $time_Code_Data
     * @param float $extended_Amount
     * @param \StructType\Document_Payment_StatusObjectType $payment_Status_Reference
     * @param \StructType\Document_StatusObjectType $invoice_Status_Reference
     * @param \StructType\Document_StatusObjectType $receiving_Status_Reference
     * @param \StructType\Accounting_CategoryObjectType $resource_Category_Reference
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param \StructType\Tax_Rate_Options_DataType[] $tax_Rate_Recoverabilities_Data
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktags_Reference
     * @param string $memo
     */
    public function __construct($line_Number = null, \StructType\WorkerObjectType $contingent_Worker_Reference = null, \StructType\PositionObjectType $position_Reference = null, \StructType\LocationObjectType $location_Reference = null, \StructType\Position_Time_TypeObjectType $position_Time_Type_Reference = null, $start_Date = null, $end_Date = null, $scheduled_Hours = null, $contract_Pay_Rate = null, array $time_Code_Data = array(), $extended_Amount = null, \StructType\Document_Payment_StatusObjectType $payment_Status_Reference = null, \StructType\Document_StatusObjectType $invoice_Status_Reference = null, \StructType\Document_StatusObjectType $receiving_Status_Reference = null, \StructType\Accounting_CategoryObjectType $resource_Category_Reference = null, \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, array $tax_Rate_Recoverabilities_Data = array(), array $worktags_Reference = array(), $memo = null)
    {
        $this
            ->setLine_Number($line_Number)
            ->setContingent_Worker_Reference($contingent_Worker_Reference)
            ->setPosition_Reference($position_Reference)
            ->setLocation_Reference($location_Reference)
            ->setPosition_Time_Type_Reference($position_Time_Type_Reference)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setScheduled_Hours($scheduled_Hours)
            ->setContract_Pay_Rate($contract_Pay_Rate)
            ->setTime_Code_Data($time_Code_Data)
            ->setExtended_Amount($extended_Amount)
            ->setPayment_Status_Reference($payment_Status_Reference)
            ->setInvoice_Status_Reference($invoice_Status_Reference)
            ->setReceiving_Status_Reference($receiving_Status_Reference)
            ->setResource_Category_Reference($resource_Category_Reference)
            ->setTax_Applicability_Reference($tax_Applicability_Reference)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setTax_Rate_Recoverabilities_Data($tax_Rate_Recoverabilities_Data)
            ->setWorktags_Reference($worktags_Reference)
            ->setMemo($memo);
    }
    /**
     * Get Line_Number value
     * @return float|null
     */
    public function getLine_Number()
    {
        return $this->Line_Number;
    }
    /**
     * Set Line_Number value
     * @param float $line_Number
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setLine_Number($line_Number = null)
    {
        // validation for constraint: float
        if (!is_null($line_Number) && !(is_float($line_Number) || is_numeric($line_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($line_Number, true), gettype($line_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($line_Number) && mb_strlen(mb_substr($line_Number, false !== mb_strpos($line_Number, '.') ? mb_strpos($line_Number, '.') + 1 : mb_strlen($line_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($line_Number, true), mb_strlen(mb_substr($line_Number, mb_strpos($line_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($line_Number) && $line_Number < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($line_Number, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($line_Number) && mb_strlen(preg_replace('/(\D)/', '', $line_Number)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($line_Number, true), mb_strlen(preg_replace('/(\D)/', '', $line_Number))), __LINE__);
        }
        $this->Line_Number = $line_Number;
        return $this;
    }
    /**
     * Get Contingent_Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getContingent_Worker_Reference()
    {
        return $this->Contingent_Worker_Reference;
    }
    /**
     * Set Contingent_Worker_Reference value
     * @param \StructType\WorkerObjectType $contingent_Worker_Reference
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setContingent_Worker_Reference(\StructType\WorkerObjectType $contingent_Worker_Reference = null)
    {
        $this->Contingent_Worker_Reference = $contingent_Worker_Reference;
        return $this;
    }
    /**
     * Get Position_Reference value
     * @return \StructType\PositionObjectType|null
     */
    public function getPosition_Reference()
    {
        return $this->Position_Reference;
    }
    /**
     * Set Position_Reference value
     * @param \StructType\PositionObjectType $position_Reference
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setPosition_Reference(\StructType\PositionObjectType $position_Reference = null)
    {
        $this->Position_Reference = $position_Reference;
        return $this;
    }
    /**
     * Get Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getLocation_Reference()
    {
        return $this->Location_Reference;
    }
    /**
     * Set Location_Reference value
     * @param \StructType\LocationObjectType $location_Reference
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setLocation_Reference(\StructType\LocationObjectType $location_Reference = null)
    {
        $this->Location_Reference = $location_Reference;
        return $this;
    }
    /**
     * Get Position_Time_Type_Reference value
     * @return \StructType\Position_Time_TypeObjectType|null
     */
    public function getPosition_Time_Type_Reference()
    {
        return $this->Position_Time_Type_Reference;
    }
    /**
     * Set Position_Time_Type_Reference value
     * @param \StructType\Position_Time_TypeObjectType $position_Time_Type_Reference
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setPosition_Time_Type_Reference(\StructType\Position_Time_TypeObjectType $position_Time_Type_Reference = null)
    {
        $this->Position_Time_Type_Reference = $position_Time_Type_Reference;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Scheduled_Hours value
     * @return float|null
     */
    public function getScheduled_Hours()
    {
        return $this->Scheduled_Hours;
    }
    /**
     * Set Scheduled_Hours value
     * @param float $scheduled_Hours
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setScheduled_Hours($scheduled_Hours = null)
    {
        // validation for constraint: float
        if (!is_null($scheduled_Hours) && !(is_float($scheduled_Hours) || is_numeric($scheduled_Hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($scheduled_Hours, true), gettype($scheduled_Hours)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($scheduled_Hours) && mb_strlen(mb_substr($scheduled_Hours, false !== mb_strpos($scheduled_Hours, '.') ? mb_strpos($scheduled_Hours, '.') + 1 : mb_strlen($scheduled_Hours))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($scheduled_Hours, true), mb_strlen(mb_substr($scheduled_Hours, mb_strpos($scheduled_Hours, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($scheduled_Hours) && $scheduled_Hours < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($scheduled_Hours, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($scheduled_Hours) && mb_strlen(preg_replace('/(\D)/', '', $scheduled_Hours)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($scheduled_Hours, true), mb_strlen(preg_replace('/(\D)/', '', $scheduled_Hours))), __LINE__);
        }
        $this->Scheduled_Hours = $scheduled_Hours;
        return $this;
    }
    /**
     * Get Contract_Pay_Rate value
     * @return float|null
     */
    public function getContract_Pay_Rate()
    {
        return $this->Contract_Pay_Rate;
    }
    /**
     * Set Contract_Pay_Rate value
     * @param float $contract_Pay_Rate
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setContract_Pay_Rate($contract_Pay_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($contract_Pay_Rate) && !(is_float($contract_Pay_Rate) || is_numeric($contract_Pay_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($contract_Pay_Rate, true), gettype($contract_Pay_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($contract_Pay_Rate) && mb_strlen(mb_substr($contract_Pay_Rate, false !== mb_strpos($contract_Pay_Rate, '.') ? mb_strpos($contract_Pay_Rate, '.') + 1 : mb_strlen($contract_Pay_Rate))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($contract_Pay_Rate, true), mb_strlen(mb_substr($contract_Pay_Rate, mb_strpos($contract_Pay_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($contract_Pay_Rate) && mb_strlen(preg_replace('/(\D)/', '', $contract_Pay_Rate)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($contract_Pay_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $contract_Pay_Rate))), __LINE__);
        }
        $this->Contract_Pay_Rate = $contract_Pay_Rate;
        return $this;
    }
    /**
     * Get Time_Code_Data value
     * @return \StructType\Time_Card_Factor_DataType[]|null
     */
    public function getTime_Code_Data()
    {
        return $this->Time_Code_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTime_Code_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTime_Code_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTime_Code_DataForArrayConstraintsFromSetTime_Code_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contingent_Worker_Order_Line_DataTypeTime_Code_DataItem) {
            // validation for constraint: itemType
            if (!$contingent_Worker_Order_Line_DataTypeTime_Code_DataItem instanceof \StructType\Time_Card_Factor_DataType) {
                $invalidValues[] = is_object($contingent_Worker_Order_Line_DataTypeTime_Code_DataItem) ? get_class($contingent_Worker_Order_Line_DataTypeTime_Code_DataItem) : sprintf('%s(%s)', gettype($contingent_Worker_Order_Line_DataTypeTime_Code_DataItem), var_export($contingent_Worker_Order_Line_DataTypeTime_Code_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Time_Code_Data property can only contain items of type \StructType\Time_Card_Factor_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Time_Code_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Time_Card_Factor_DataType[] $time_Code_Data
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setTime_Code_Data(array $time_Code_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($time_Code_DataArrayErrorMessage = self::validateTime_Code_DataForArrayConstraintsFromSetTime_Code_Data($time_Code_Data))) {
            throw new \InvalidArgumentException($time_Code_DataArrayErrorMessage, __LINE__);
        }
        $this->Time_Code_Data = $time_Code_Data;
        return $this;
    }
    /**
     * Add item to Time_Code_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Time_Card_Factor_DataType $item
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function addToTime_Code_Data(\StructType\Time_Card_Factor_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Time_Card_Factor_DataType) {
            throw new \InvalidArgumentException(sprintf('The Time_Code_Data property can only contain items of type \StructType\Time_Card_Factor_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Time_Code_Data[] = $item;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Payment_Status_Reference value
     * @return \StructType\Document_Payment_StatusObjectType|null
     */
    public function getPayment_Status_Reference()
    {
        return $this->Payment_Status_Reference;
    }
    /**
     * Set Payment_Status_Reference value
     * @param \StructType\Document_Payment_StatusObjectType $payment_Status_Reference
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setPayment_Status_Reference(\StructType\Document_Payment_StatusObjectType $payment_Status_Reference = null)
    {
        $this->Payment_Status_Reference = $payment_Status_Reference;
        return $this;
    }
    /**
     * Get Invoice_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getInvoice_Status_Reference()
    {
        return $this->Invoice_Status_Reference;
    }
    /**
     * Set Invoice_Status_Reference value
     * @param \StructType\Document_StatusObjectType $invoice_Status_Reference
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setInvoice_Status_Reference(\StructType\Document_StatusObjectType $invoice_Status_Reference = null)
    {
        $this->Invoice_Status_Reference = $invoice_Status_Reference;
        return $this;
    }
    /**
     * Get Receiving_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getReceiving_Status_Reference()
    {
        return $this->Receiving_Status_Reference;
    }
    /**
     * Set Receiving_Status_Reference value
     * @param \StructType\Document_StatusObjectType $receiving_Status_Reference
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setReceiving_Status_Reference(\StructType\Document_StatusObjectType $receiving_Status_Reference = null)
    {
        $this->Receiving_Status_Reference = $receiving_Status_Reference;
        return $this;
    }
    /**
     * Get Resource_Category_Reference value
     * @return \StructType\Accounting_CategoryObjectType|null
     */
    public function getResource_Category_Reference()
    {
        return $this->Resource_Category_Reference;
    }
    /**
     * Set Resource_Category_Reference value
     * @param \StructType\Accounting_CategoryObjectType $resource_Category_Reference
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setResource_Category_Reference(\StructType\Accounting_CategoryObjectType $resource_Category_Reference = null)
    {
        $this->Resource_Category_Reference = $resource_Category_Reference;
        return $this;
    }
    /**
     * Get Tax_Applicability_Reference value
     * @return \StructType\Tax_ApplicabilityObjectType|null
     */
    public function getTax_Applicability_Reference()
    {
        return $this->Tax_Applicability_Reference;
    }
    /**
     * Set Tax_Applicability_Reference value
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setTax_Applicability_Reference(\StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null)
    {
        $this->Tax_Applicability_Reference = $tax_Applicability_Reference;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Tax_Rate_Recoverabilities_Data value
     * @return \StructType\Tax_Rate_Options_DataType[]|null
     */
    public function getTax_Rate_Recoverabilities_Data()
    {
        return $this->Tax_Rate_Recoverabilities_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTax_Rate_Recoverabilities_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax_Rate_Recoverabilities_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTax_Rate_Recoverabilities_DataForArrayConstraintsFromSetTax_Rate_Recoverabilities_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contingent_Worker_Order_Line_DataTypeTax_Rate_Recoverabilities_DataItem) {
            // validation for constraint: itemType
            if (!$contingent_Worker_Order_Line_DataTypeTax_Rate_Recoverabilities_DataItem instanceof \StructType\Tax_Rate_Options_DataType) {
                $invalidValues[] = is_object($contingent_Worker_Order_Line_DataTypeTax_Rate_Recoverabilities_DataItem) ? get_class($contingent_Worker_Order_Line_DataTypeTax_Rate_Recoverabilities_DataItem) : sprintf('%s(%s)', gettype($contingent_Worker_Order_Line_DataTypeTax_Rate_Recoverabilities_DataItem), var_export($contingent_Worker_Order_Line_DataTypeTax_Rate_Recoverabilities_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax_Rate_Recoverabilities_Data property can only contain items of type \StructType\Tax_Rate_Options_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax_Rate_Recoverabilities_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_Rate_Options_DataType[] $tax_Rate_Recoverabilities_Data
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setTax_Rate_Recoverabilities_Data(array $tax_Rate_Recoverabilities_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($tax_Rate_Recoverabilities_DataArrayErrorMessage = self::validateTax_Rate_Recoverabilities_DataForArrayConstraintsFromSetTax_Rate_Recoverabilities_Data($tax_Rate_Recoverabilities_Data))) {
            throw new \InvalidArgumentException($tax_Rate_Recoverabilities_DataArrayErrorMessage, __LINE__);
        }
        $this->Tax_Rate_Recoverabilities_Data = $tax_Rate_Recoverabilities_Data;
        return $this;
    }
    /**
     * Add item to Tax_Rate_Recoverabilities_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_Rate_Options_DataType $item
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function addToTax_Rate_Recoverabilities_Data(\StructType\Tax_Rate_Options_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tax_Rate_Options_DataType) {
            throw new \InvalidArgumentException(sprintf('The Tax_Rate_Recoverabilities_Data property can only contain items of type \StructType\Tax_Rate_Options_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax_Rate_Recoverabilities_Data[] = $item;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Audited_Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contingent_Worker_Order_Line_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$contingent_Worker_Order_Line_DataTypeWorktags_ReferenceItem instanceof \StructType\Audited_Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($contingent_Worker_Order_Line_DataTypeWorktags_ReferenceItem) ? get_class($contingent_Worker_Order_Line_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($contingent_Worker_Order_Line_DataTypeWorktags_ReferenceItem), var_export($contingent_Worker_Order_Line_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType $item
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function addToWorktags_Reference(\StructType\Audited_Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Audited_Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Contingent_Worker_Order_Line_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
}
