<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Condition_Item_Data_WWSType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing data for each Condition Item.
 * @subpackage Structs
 */
class Condition_Item_Data_WWSType extends AbstractStructBase
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: Text value for order of Condition Item. | Order
     * - base: xsd:string
     * - maxLength: 6
     * - maxOccurs: 1
     * @var string
     */
    public $Order;
    /**
     * The And_Or_Operator_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the And Or Operator used on this Condition Item.
     * @var \StructType\And_Or_OperatorsObjectType
     */
    public $And_Or_Operator_Reference;
    /**
     * The Open_Parentheses
     * Meta information extracted from the WSDL
     * - documentation: The Open Parenthesis field can contain only "(" characters. | Specify an Open Parentheses for the Condition Item by placing the "(" character here.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Open_Parentheses;
    /**
     * The Relational_Operator_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Relational Operator to use for this Condition Item.
     * @var \StructType\Relational_OperatorObjectType
     */
    public $Relational_Operator_Reference;
    /**
     * The Condition_Entry_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Condition Entry Option to use for this Condition Item.
     * - minOccurs: 0
     * @var \StructType\Condition_Entry_OptionObjectType
     */
    public $Condition_Entry_Option_Reference;
    /**
     * The Close_Parentheses
     * Meta information extracted from the WSDL
     * - documentation: Specify an Close Parentheses for the Condition Item by placing the ")" character here.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Close_Parentheses;
    /**
     * The Source_External_Field_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the External Field to use as the source for this Condition Item.
     * - choice: Source_External_Field_Reference | Source_Condition_Rule_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\External_FieldObjectType
     */
    public $Source_External_Field_Reference;
    /**
     * The Source_Condition_Rule_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Condition Rule to use as the source for this Condition Item.
     * - choice: Source_External_Field_Reference | Source_Condition_Rule_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Condition_RuleObjectType
     */
    public $Source_Condition_Rule_Reference;
    /**
     * The Filter_Boolean
     * Meta information extracted from the WSDL
     * - documentation: Boolean value for Filter.
     * - choice: Filter_Boolean | Filter_Date | Filter_DateTimeZone | Filter_Time | Filter_Number | Filter_Text | Target_External_Field_Reference | Target_Instance_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Filter_Boolean;
    /**
     * The Filter_Date
     * Meta information extracted from the WSDL
     * - documentation: Date value for Filter.
     * - choice: Filter_Boolean | Filter_Date | Filter_DateTimeZone | Filter_Time | Filter_Number | Filter_Text | Target_External_Field_Reference | Target_Instance_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Filter_Date;
    /**
     * The Filter_DateTimeZone
     * Meta information extracted from the WSDL
     * - documentation: DateTimeZone value for filter.
     * - choice: Filter_Boolean | Filter_Date | Filter_DateTimeZone | Filter_Time | Filter_Number | Filter_Text | Target_External_Field_Reference | Target_Instance_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Filter_DateTimeZone_DataType
     */
    public $Filter_DateTimeZone;
    /**
     * The Filter_Time
     * Meta information extracted from the WSDL
     * - documentation: Time value for filter.
     * - choice: Filter_Boolean | Filter_Date | Filter_DateTimeZone | Filter_Time | Filter_Number | Filter_Text | Target_External_Field_Reference | Target_Instance_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Filter_Time;
    /**
     * The Filter_Number
     * Meta information extracted from the WSDL
     * - documentation: Numeric value for Filter Number.
     * - base: xsd:decimal
     * - choice: Filter_Boolean | Filter_Date | Filter_DateTimeZone | Filter_Time | Filter_Number | Filter_Text | Target_External_Field_Reference | Target_Instance_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 16
     * @var float
     */
    public $Filter_Number;
    /**
     * The Filter_Text
     * Meta information extracted from the WSDL
     * - documentation: Text value for Filter.
     * - choice: Filter_Boolean | Filter_Date | Filter_DateTimeZone | Filter_Time | Filter_Number | Filter_Text | Target_External_Field_Reference | Target_Instance_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Filter_Text;
    /**
     * The Target_External_Field_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Target External Field for this Condition Item..
     * - choice: Filter_Boolean | Filter_Date | Filter_DateTimeZone | Filter_Time | Filter_Number | Filter_Text | Target_External_Field_Reference | Target_Instance_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\External_FieldObjectType
     */
    public $Target_External_Field_Reference;
    /**
     * The Target_Instance_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to specific object to be used in filter for this Condition Rule.
     * - choice: Filter_Boolean | Filter_Date | Filter_DateTimeZone | Filter_Time | Filter_Number | Filter_Text | Target_External_Field_Reference | Target_Instance_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InstanceObjectType[]
     */
    public $Target_Instance_Reference;
    /**
     * Constructor method for Condition_Item_Data_WWSType
     * @uses Condition_Item_Data_WWSType::setOrder()
     * @uses Condition_Item_Data_WWSType::setAnd_Or_Operator_Reference()
     * @uses Condition_Item_Data_WWSType::setOpen_Parentheses()
     * @uses Condition_Item_Data_WWSType::setRelational_Operator_Reference()
     * @uses Condition_Item_Data_WWSType::setCondition_Entry_Option_Reference()
     * @uses Condition_Item_Data_WWSType::setClose_Parentheses()
     * @uses Condition_Item_Data_WWSType::setSource_External_Field_Reference()
     * @uses Condition_Item_Data_WWSType::setSource_Condition_Rule_Reference()
     * @uses Condition_Item_Data_WWSType::setFilter_Boolean()
     * @uses Condition_Item_Data_WWSType::setFilter_Date()
     * @uses Condition_Item_Data_WWSType::setFilter_DateTimeZone()
     * @uses Condition_Item_Data_WWSType::setFilter_Time()
     * @uses Condition_Item_Data_WWSType::setFilter_Number()
     * @uses Condition_Item_Data_WWSType::setFilter_Text()
     * @uses Condition_Item_Data_WWSType::setTarget_External_Field_Reference()
     * @uses Condition_Item_Data_WWSType::setTarget_Instance_Reference()
     * @param string $order
     * @param \StructType\And_Or_OperatorsObjectType $and_Or_Operator_Reference
     * @param string $open_Parentheses
     * @param \StructType\Relational_OperatorObjectType $relational_Operator_Reference
     * @param \StructType\Condition_Entry_OptionObjectType $condition_Entry_Option_Reference
     * @param string $close_Parentheses
     * @param \StructType\External_FieldObjectType $source_External_Field_Reference
     * @param \StructType\Condition_RuleObjectType $source_Condition_Rule_Reference
     * @param bool $filter_Boolean
     * @param string $filter_Date
     * @param \StructType\Filter_DateTimeZone_DataType $filter_DateTimeZone
     * @param string $filter_Time
     * @param float $filter_Number
     * @param string $filter_Text
     * @param \StructType\External_FieldObjectType $target_External_Field_Reference
     * @param \StructType\InstanceObjectType[] $target_Instance_Reference
     */
    public function __construct($order = null, \StructType\And_Or_OperatorsObjectType $and_Or_Operator_Reference = null, $open_Parentheses = null, \StructType\Relational_OperatorObjectType $relational_Operator_Reference = null, \StructType\Condition_Entry_OptionObjectType $condition_Entry_Option_Reference = null, $close_Parentheses = null, \StructType\External_FieldObjectType $source_External_Field_Reference = null, \StructType\Condition_RuleObjectType $source_Condition_Rule_Reference = null, $filter_Boolean = null, $filter_Date = null, \StructType\Filter_DateTimeZone_DataType $filter_DateTimeZone = null, $filter_Time = null, $filter_Number = null, $filter_Text = null, \StructType\External_FieldObjectType $target_External_Field_Reference = null, array $target_Instance_Reference = array())
    {
        $this
            ->setOrder($order)
            ->setAnd_Or_Operator_Reference($and_Or_Operator_Reference)
            ->setOpen_Parentheses($open_Parentheses)
            ->setRelational_Operator_Reference($relational_Operator_Reference)
            ->setCondition_Entry_Option_Reference($condition_Entry_Option_Reference)
            ->setClose_Parentheses($close_Parentheses)
            ->setSource_External_Field_Reference($source_External_Field_Reference)
            ->setSource_Condition_Rule_Reference($source_Condition_Rule_Reference)
            ->setFilter_Boolean($filter_Boolean)
            ->setFilter_Date($filter_Date)
            ->setFilter_DateTimeZone($filter_DateTimeZone)
            ->setFilter_Time($filter_Time)
            ->setFilter_Number($filter_Number)
            ->setFilter_Text($filter_Text)
            ->setTarget_External_Field_Reference($target_External_Field_Reference)
            ->setTarget_Instance_Reference($target_Instance_Reference);
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Condition_Item_Data_WWSType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($order) && mb_strlen($order) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get And_Or_Operator_Reference value
     * @return \StructType\And_Or_OperatorsObjectType|null
     */
    public function getAnd_Or_Operator_Reference()
    {
        return $this->And_Or_Operator_Reference;
    }
    /**
     * Set And_Or_Operator_Reference value
     * @param \StructType\And_Or_OperatorsObjectType $and_Or_Operator_Reference
     * @return \StructType\Condition_Item_Data_WWSType
     */
    public function setAnd_Or_Operator_Reference(\StructType\And_Or_OperatorsObjectType $and_Or_Operator_Reference = null)
    {
        $this->And_Or_Operator_Reference = $and_Or_Operator_Reference;
        return $this;
    }
    /**
     * Get Open_Parentheses value
     * @return string|null
     */
    public function getOpen_Parentheses()
    {
        return $this->Open_Parentheses;
    }
    /**
     * Set Open_Parentheses value
     * @param string $open_Parentheses
     * @return \StructType\Condition_Item_Data_WWSType
     */
    public function setOpen_Parentheses($open_Parentheses = null)
    {
        // validation for constraint: string
        if (!is_null($open_Parentheses) && !is_string($open_Parentheses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($open_Parentheses, true), gettype($open_Parentheses)), __LINE__);
        }
        $this->Open_Parentheses = $open_Parentheses;
        return $this;
    }
    /**
     * Get Relational_Operator_Reference value
     * @return \StructType\Relational_OperatorObjectType|null
     */
    public function getRelational_Operator_Reference()
    {
        return $this->Relational_Operator_Reference;
    }
    /**
     * Set Relational_Operator_Reference value
     * @param \StructType\Relational_OperatorObjectType $relational_Operator_Reference
     * @return \StructType\Condition_Item_Data_WWSType
     */
    public function setRelational_Operator_Reference(\StructType\Relational_OperatorObjectType $relational_Operator_Reference = null)
    {
        $this->Relational_Operator_Reference = $relational_Operator_Reference;
        return $this;
    }
    /**
     * Get Condition_Entry_Option_Reference value
     * @return \StructType\Condition_Entry_OptionObjectType|null
     */
    public function getCondition_Entry_Option_Reference()
    {
        return $this->Condition_Entry_Option_Reference;
    }
    /**
     * Set Condition_Entry_Option_Reference value
     * @param \StructType\Condition_Entry_OptionObjectType $condition_Entry_Option_Reference
     * @return \StructType\Condition_Item_Data_WWSType
     */
    public function setCondition_Entry_Option_Reference(\StructType\Condition_Entry_OptionObjectType $condition_Entry_Option_Reference = null)
    {
        $this->Condition_Entry_Option_Reference = $condition_Entry_Option_Reference;
        return $this;
    }
    /**
     * Get Close_Parentheses value
     * @return string|null
     */
    public function getClose_Parentheses()
    {
        return $this->Close_Parentheses;
    }
    /**
     * Set Close_Parentheses value
     * @param string $close_Parentheses
     * @return \StructType\Condition_Item_Data_WWSType
     */
    public function setClose_Parentheses($close_Parentheses = null)
    {
        // validation for constraint: string
        if (!is_null($close_Parentheses) && !is_string($close_Parentheses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($close_Parentheses, true), gettype($close_Parentheses)), __LINE__);
        }
        $this->Close_Parentheses = $close_Parentheses;
        return $this;
    }
    /**
     * Get Source_External_Field_Reference value
     * @return \StructType\External_FieldObjectType|null
     */
    public function getSource_External_Field_Reference()
    {
        return isset($this->Source_External_Field_Reference) ? $this->Source_External_Field_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSource_External_Field_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSource_External_Field_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSource_External_Field_ReferenceForChoiceConstraintsFromSetSource_External_Field_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Source_Condition_Rule_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Source_External_Field_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Source_External_Field_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Source_External_Field_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\External_FieldObjectType $source_External_Field_Reference
     * @return \StructType\Condition_Item_Data_WWSType
     */
    public function setSource_External_Field_Reference(\StructType\External_FieldObjectType $source_External_Field_Reference = null)
    {
        // validation for constraint: choice(Source_External_Field_Reference, Source_Condition_Rule_Reference)
        if ('' !== ($source_External_Field_ReferenceChoiceErrorMessage = self::validateSource_External_Field_ReferenceForChoiceConstraintsFromSetSource_External_Field_Reference($source_External_Field_Reference))) {
            throw new \InvalidArgumentException($source_External_Field_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($source_External_Field_Reference) || (is_array($source_External_Field_Reference) && empty($source_External_Field_Reference))) {
            unset($this->Source_External_Field_Reference);
        } else {
            $this->Source_External_Field_Reference = $source_External_Field_Reference;
        }
        return $this;
    }
    /**
     * Get Source_Condition_Rule_Reference value
     * @return \StructType\Condition_RuleObjectType|null
     */
    public function getSource_Condition_Rule_Reference()
    {
        return isset($this->Source_Condition_Rule_Reference) ? $this->Source_Condition_Rule_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSource_Condition_Rule_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSource_Condition_Rule_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSource_Condition_Rule_ReferenceForChoiceConstraintsFromSetSource_Condition_Rule_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Source_External_Field_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Source_Condition_Rule_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Source_Condition_Rule_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Source_Condition_Rule_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Condition_RuleObjectType $source_Condition_Rule_Reference
     * @return \StructType\Condition_Item_Data_WWSType
     */
    public function setSource_Condition_Rule_Reference(\StructType\Condition_RuleObjectType $source_Condition_Rule_Reference = null)
    {
        // validation for constraint: choice(Source_External_Field_Reference, Source_Condition_Rule_Reference)
        if ('' !== ($source_Condition_Rule_ReferenceChoiceErrorMessage = self::validateSource_Condition_Rule_ReferenceForChoiceConstraintsFromSetSource_Condition_Rule_Reference($source_Condition_Rule_Reference))) {
            throw new \InvalidArgumentException($source_Condition_Rule_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($source_Condition_Rule_Reference) || (is_array($source_Condition_Rule_Reference) && empty($source_Condition_Rule_Reference))) {
            unset($this->Source_Condition_Rule_Reference);
        } else {
            $this->Source_Condition_Rule_Reference = $source_Condition_Rule_Reference;
        }
        return $this;
    }
    /**
     * Get Filter_Boolean value
     * @return bool|null
     */
    public function getFilter_Boolean()
    {
        return isset($this->Filter_Boolean) ? $this->Filter_Boolean : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFilter_Boolean method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFilter_Boolean method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFilter_BooleanForChoiceConstraintsFromSetFilter_Boolean($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Filter_Date',
            'Filter_DateTimeZone',
            'Filter_Time',
            'Filter_Number',
            'Filter_Text',
            'Target_External_Field_Reference',
            'Target_Instance_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Filter_Boolean can\'t be set as the property %s is already set. Only one property must be set among these properties: Filter_Boolean, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Filter_Boolean value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $filter_Boolean
     * @return \StructType\Condition_Item_Data_WWSType
     */
    public function setFilter_Boolean($filter_Boolean = null)
    {
        // validation for constraint: boolean
        if (!is_null($filter_Boolean) && !is_bool($filter_Boolean)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filter_Boolean, true), gettype($filter_Boolean)), __LINE__);
        }
        // validation for constraint: choice(Filter_Boolean, Filter_Date, Filter_DateTimeZone, Filter_Time, Filter_Number, Filter_Text, Target_External_Field_Reference, Target_Instance_Reference)
        if ('' !== ($filter_BooleanChoiceErrorMessage = self::validateFilter_BooleanForChoiceConstraintsFromSetFilter_Boolean($filter_Boolean))) {
            throw new \InvalidArgumentException($filter_BooleanChoiceErrorMessage, __LINE__);
        }
        if (is_null($filter_Boolean) || (is_array($filter_Boolean) && empty($filter_Boolean))) {
            unset($this->Filter_Boolean);
        } else {
            $this->Filter_Boolean = $filter_Boolean;
        }
        return $this;
    }
    /**
     * Get Filter_Date value
     * @return string|null
     */
    public function getFilter_Date()
    {
        return isset($this->Filter_Date) ? $this->Filter_Date : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFilter_Date method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFilter_Date method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFilter_DateForChoiceConstraintsFromSetFilter_Date($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Filter_Boolean',
            'Filter_DateTimeZone',
            'Filter_Time',
            'Filter_Number',
            'Filter_Text',
            'Target_External_Field_Reference',
            'Target_Instance_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Filter_Date can\'t be set as the property %s is already set. Only one property must be set among these properties: Filter_Date, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Filter_Date value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $filter_Date
     * @return \StructType\Condition_Item_Data_WWSType
     */
    public function setFilter_Date($filter_Date = null)
    {
        // validation for constraint: string
        if (!is_null($filter_Date) && !is_string($filter_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filter_Date, true), gettype($filter_Date)), __LINE__);
        }
        // validation for constraint: choice(Filter_Boolean, Filter_Date, Filter_DateTimeZone, Filter_Time, Filter_Number, Filter_Text, Target_External_Field_Reference, Target_Instance_Reference)
        if ('' !== ($filter_DateChoiceErrorMessage = self::validateFilter_DateForChoiceConstraintsFromSetFilter_Date($filter_Date))) {
            throw new \InvalidArgumentException($filter_DateChoiceErrorMessage, __LINE__);
        }
        if (is_null($filter_Date) || (is_array($filter_Date) && empty($filter_Date))) {
            unset($this->Filter_Date);
        } else {
            $this->Filter_Date = $filter_Date;
        }
        return $this;
    }
    /**
     * Get Filter_DateTimeZone value
     * @return \StructType\Filter_DateTimeZone_DataType|null
     */
    public function getFilter_DateTimeZone()
    {
        return isset($this->Filter_DateTimeZone) ? $this->Filter_DateTimeZone : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFilter_DateTimeZone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFilter_DateTimeZone method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFilter_DateTimeZoneForChoiceConstraintsFromSetFilter_DateTimeZone($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Filter_Boolean',
            'Filter_Date',
            'Filter_Time',
            'Filter_Number',
            'Filter_Text',
            'Target_External_Field_Reference',
            'Target_Instance_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Filter_DateTimeZone can\'t be set as the property %s is already set. Only one property must be set among these properties: Filter_DateTimeZone, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Filter_DateTimeZone value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Filter_DateTimeZone_DataType $filter_DateTimeZone
     * @return \StructType\Condition_Item_Data_WWSType
     */
    public function setFilter_DateTimeZone(\StructType\Filter_DateTimeZone_DataType $filter_DateTimeZone = null)
    {
        // validation for constraint: choice(Filter_Boolean, Filter_Date, Filter_DateTimeZone, Filter_Time, Filter_Number, Filter_Text, Target_External_Field_Reference, Target_Instance_Reference)
        if ('' !== ($filter_DateTimeZoneChoiceErrorMessage = self::validateFilter_DateTimeZoneForChoiceConstraintsFromSetFilter_DateTimeZone($filter_DateTimeZone))) {
            throw new \InvalidArgumentException($filter_DateTimeZoneChoiceErrorMessage, __LINE__);
        }
        if (is_null($filter_DateTimeZone) || (is_array($filter_DateTimeZone) && empty($filter_DateTimeZone))) {
            unset($this->Filter_DateTimeZone);
        } else {
            $this->Filter_DateTimeZone = $filter_DateTimeZone;
        }
        return $this;
    }
    /**
     * Get Filter_Time value
     * @return string|null
     */
    public function getFilter_Time()
    {
        return isset($this->Filter_Time) ? $this->Filter_Time : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFilter_Time method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFilter_Time method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFilter_TimeForChoiceConstraintsFromSetFilter_Time($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Filter_Boolean',
            'Filter_Date',
            'Filter_DateTimeZone',
            'Filter_Number',
            'Filter_Text',
            'Target_External_Field_Reference',
            'Target_Instance_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Filter_Time can\'t be set as the property %s is already set. Only one property must be set among these properties: Filter_Time, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Filter_Time value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $filter_Time
     * @return \StructType\Condition_Item_Data_WWSType
     */
    public function setFilter_Time($filter_Time = null)
    {
        // validation for constraint: string
        if (!is_null($filter_Time) && !is_string($filter_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filter_Time, true), gettype($filter_Time)), __LINE__);
        }
        // validation for constraint: choice(Filter_Boolean, Filter_Date, Filter_DateTimeZone, Filter_Time, Filter_Number, Filter_Text, Target_External_Field_Reference, Target_Instance_Reference)
        if ('' !== ($filter_TimeChoiceErrorMessage = self::validateFilter_TimeForChoiceConstraintsFromSetFilter_Time($filter_Time))) {
            throw new \InvalidArgumentException($filter_TimeChoiceErrorMessage, __LINE__);
        }
        if (is_null($filter_Time) || (is_array($filter_Time) && empty($filter_Time))) {
            unset($this->Filter_Time);
        } else {
            $this->Filter_Time = $filter_Time;
        }
        return $this;
    }
    /**
     * Get Filter_Number value
     * @return float|null
     */
    public function getFilter_Number()
    {
        return isset($this->Filter_Number) ? $this->Filter_Number : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFilter_Number method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFilter_Number method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFilter_NumberForChoiceConstraintsFromSetFilter_Number($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Filter_Boolean',
            'Filter_Date',
            'Filter_DateTimeZone',
            'Filter_Time',
            'Filter_Text',
            'Target_External_Field_Reference',
            'Target_Instance_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Filter_Number can\'t be set as the property %s is already set. Only one property must be set among these properties: Filter_Number, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Filter_Number value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $filter_Number
     * @return \StructType\Condition_Item_Data_WWSType
     */
    public function setFilter_Number($filter_Number = null)
    {
        // validation for constraint: float
        if (!is_null($filter_Number) && !(is_float($filter_Number) || is_numeric($filter_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($filter_Number, true), gettype($filter_Number)), __LINE__);
        }
        // validation for constraint: choice(Filter_Boolean, Filter_Date, Filter_DateTimeZone, Filter_Time, Filter_Number, Filter_Text, Target_External_Field_Reference, Target_Instance_Reference)
        if ('' !== ($filter_NumberChoiceErrorMessage = self::validateFilter_NumberForChoiceConstraintsFromSetFilter_Number($filter_Number))) {
            throw new \InvalidArgumentException($filter_NumberChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($filter_Number) && mb_strlen(mb_substr($filter_Number, false !== mb_strpos($filter_Number, '.') ? mb_strpos($filter_Number, '.') + 1 : mb_strlen($filter_Number))) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($filter_Number, true), mb_strlen(mb_substr($filter_Number, mb_strpos($filter_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(16)
        if (!is_null($filter_Number) && mb_strlen(preg_replace('/(\D)/', '', $filter_Number)) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 16 digits, "%d" given', var_export($filter_Number, true), mb_strlen(preg_replace('/(\D)/', '', $filter_Number))), __LINE__);
        }
        if (is_null($filter_Number) || (is_array($filter_Number) && empty($filter_Number))) {
            unset($this->Filter_Number);
        } else {
            $this->Filter_Number = $filter_Number;
        }
        return $this;
    }
    /**
     * Get Filter_Text value
     * @return string|null
     */
    public function getFilter_Text()
    {
        return isset($this->Filter_Text) ? $this->Filter_Text : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFilter_Text method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFilter_Text method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFilter_TextForChoiceConstraintsFromSetFilter_Text($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Filter_Boolean',
            'Filter_Date',
            'Filter_DateTimeZone',
            'Filter_Time',
            'Filter_Number',
            'Target_External_Field_Reference',
            'Target_Instance_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Filter_Text can\'t be set as the property %s is already set. Only one property must be set among these properties: Filter_Text, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Filter_Text value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $filter_Text
     * @return \StructType\Condition_Item_Data_WWSType
     */
    public function setFilter_Text($filter_Text = null)
    {
        // validation for constraint: string
        if (!is_null($filter_Text) && !is_string($filter_Text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filter_Text, true), gettype($filter_Text)), __LINE__);
        }
        // validation for constraint: choice(Filter_Boolean, Filter_Date, Filter_DateTimeZone, Filter_Time, Filter_Number, Filter_Text, Target_External_Field_Reference, Target_Instance_Reference)
        if ('' !== ($filter_TextChoiceErrorMessage = self::validateFilter_TextForChoiceConstraintsFromSetFilter_Text($filter_Text))) {
            throw new \InvalidArgumentException($filter_TextChoiceErrorMessage, __LINE__);
        }
        if (is_null($filter_Text) || (is_array($filter_Text) && empty($filter_Text))) {
            unset($this->Filter_Text);
        } else {
            $this->Filter_Text = $filter_Text;
        }
        return $this;
    }
    /**
     * Get Target_External_Field_Reference value
     * @return \StructType\External_FieldObjectType|null
     */
    public function getTarget_External_Field_Reference()
    {
        return isset($this->Target_External_Field_Reference) ? $this->Target_External_Field_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTarget_External_Field_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTarget_External_Field_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTarget_External_Field_ReferenceForChoiceConstraintsFromSetTarget_External_Field_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Filter_Boolean',
            'Filter_Date',
            'Filter_DateTimeZone',
            'Filter_Time',
            'Filter_Number',
            'Filter_Text',
            'Target_Instance_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Target_External_Field_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Target_External_Field_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Target_External_Field_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\External_FieldObjectType $target_External_Field_Reference
     * @return \StructType\Condition_Item_Data_WWSType
     */
    public function setTarget_External_Field_Reference(\StructType\External_FieldObjectType $target_External_Field_Reference = null)
    {
        // validation for constraint: choice(Filter_Boolean, Filter_Date, Filter_DateTimeZone, Filter_Time, Filter_Number, Filter_Text, Target_External_Field_Reference, Target_Instance_Reference)
        if ('' !== ($target_External_Field_ReferenceChoiceErrorMessage = self::validateTarget_External_Field_ReferenceForChoiceConstraintsFromSetTarget_External_Field_Reference($target_External_Field_Reference))) {
            throw new \InvalidArgumentException($target_External_Field_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($target_External_Field_Reference) || (is_array($target_External_Field_Reference) && empty($target_External_Field_Reference))) {
            unset($this->Target_External_Field_Reference);
        } else {
            $this->Target_External_Field_Reference = $target_External_Field_Reference;
        }
        return $this;
    }
    /**
     * Get Target_Instance_Reference value
     * @return \StructType\InstanceObjectType[]|null
     */
    public function getTarget_Instance_Reference()
    {
        return isset($this->Target_Instance_Reference) ? $this->Target_Instance_Reference : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTarget_Instance_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTarget_Instance_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTarget_Instance_ReferenceForArrayConstraintsFromSetTarget_Instance_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $condition_Item_Data_WWSTypeTarget_Instance_ReferenceItem) {
            // validation for constraint: itemType
            if (!$condition_Item_Data_WWSTypeTarget_Instance_ReferenceItem instanceof \StructType\InstanceObjectType) {
                $invalidValues[] = is_object($condition_Item_Data_WWSTypeTarget_Instance_ReferenceItem) ? get_class($condition_Item_Data_WWSTypeTarget_Instance_ReferenceItem) : sprintf('%s(%s)', gettype($condition_Item_Data_WWSTypeTarget_Instance_ReferenceItem), var_export($condition_Item_Data_WWSTypeTarget_Instance_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Target_Instance_Reference property can only contain items of type \StructType\InstanceObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setTarget_Instance_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTarget_Instance_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTarget_Instance_ReferenceForChoiceConstraintsFromSetTarget_Instance_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Filter_Boolean',
            'Filter_Date',
            'Filter_DateTimeZone',
            'Filter_Time',
            'Filter_Number',
            'Filter_Text',
            'Target_External_Field_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Target_Instance_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Target_Instance_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Target_Instance_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\InstanceObjectType[] $target_Instance_Reference
     * @return \StructType\Condition_Item_Data_WWSType
     */
    public function setTarget_Instance_Reference(array $target_Instance_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($target_Instance_ReferenceArrayErrorMessage = self::validateTarget_Instance_ReferenceForArrayConstraintsFromSetTarget_Instance_Reference($target_Instance_Reference))) {
            throw new \InvalidArgumentException($target_Instance_ReferenceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Filter_Boolean, Filter_Date, Filter_DateTimeZone, Filter_Time, Filter_Number, Filter_Text, Target_External_Field_Reference, Target_Instance_Reference)
        if ('' !== ($target_Instance_ReferenceChoiceErrorMessage = self::validateTarget_Instance_ReferenceForChoiceConstraintsFromSetTarget_Instance_Reference($target_Instance_Reference))) {
            throw new \InvalidArgumentException($target_Instance_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($target_Instance_Reference) || (is_array($target_Instance_Reference) && empty($target_Instance_Reference))) {
            unset($this->Target_Instance_Reference);
        } else {
            $this->Target_Instance_Reference = $target_Instance_Reference;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToTarget_Instance_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToTarget_Instance_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToTarget_Instance_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Filter_Boolean',
            'Filter_Date',
            'Filter_DateTimeZone',
            'Filter_Time',
            'Filter_Number',
            'Filter_Text',
            'Target_External_Field_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Target_Instance_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Target_Instance_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Target_Instance_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\InstanceObjectType $item
     * @return \StructType\Condition_Item_Data_WWSType
     */
    public function addToTarget_Instance_Reference(\StructType\InstanceObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InstanceObjectType) {
            throw new \InvalidArgumentException(sprintf('The Target_Instance_Reference property can only contain items of type \StructType\InstanceObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Filter_Boolean, Filter_Date, Filter_DateTimeZone, Filter_Time, Filter_Number, Filter_Text, Target_External_Field_Reference, Target_Instance_Reference)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToTarget_Instance_Reference($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Target_Instance_Reference[] = $item;
        return $this;
    }
}
