<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Company_for_Issue_Purchase_Order_Outbound_Sub_ViewType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Company Name
 * @subpackage Structs
 */
class Company_for_Issue_Purchase_Order_Outbound_Sub_ViewType extends AbstractStructBase
{
    /**
     * The Company_Name
     * Meta information extracted from the WSDL
     * - documentation: Company Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Company_Name;
    /**
     * The Company_Industry_Code_Data
     * Meta information extracted from the WSDL
     * - documentation: Company Industry Code Data element to specify 1 or more Industry Codes for a company.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Company_Industry_Code_DataType[]
     */
    public $Company_Industry_Code_Data;
    /**
     * Constructor method for Company_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     * @uses Company_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setCompany_Name()
     * @uses Company_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setCompany_Industry_Code_Data()
     * @param string $company_Name
     * @param \StructType\Company_Industry_Code_DataType[] $company_Industry_Code_Data
     */
    public function __construct($company_Name = null, array $company_Industry_Code_Data = array())
    {
        $this
            ->setCompany_Name($company_Name)
            ->setCompany_Industry_Code_Data($company_Industry_Code_Data);
    }
    /**
     * Get Company_Name value
     * @return string|null
     */
    public function getCompany_Name()
    {
        return $this->Company_Name;
    }
    /**
     * Set Company_Name value
     * @param string $company_Name
     * @return \StructType\Company_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setCompany_Name($company_Name = null)
    {
        // validation for constraint: string
        if (!is_null($company_Name) && !is_string($company_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company_Name, true), gettype($company_Name)), __LINE__);
        }
        $this->Company_Name = $company_Name;
        return $this;
    }
    /**
     * Get Company_Industry_Code_Data value
     * @return \StructType\Company_Industry_Code_DataType[]|null
     */
    public function getCompany_Industry_Code_Data()
    {
        return $this->Company_Industry_Code_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Industry_Code_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Industry_Code_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_Industry_Code_DataForArrayConstraintsFromSetCompany_Industry_Code_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $company_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeCompany_Industry_Code_DataItem) {
            // validation for constraint: itemType
            if (!$company_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeCompany_Industry_Code_DataItem instanceof \StructType\Company_Industry_Code_DataType) {
                $invalidValues[] = is_object($company_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeCompany_Industry_Code_DataItem) ? get_class($company_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeCompany_Industry_Code_DataItem) : sprintf('%s(%s)', gettype($company_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeCompany_Industry_Code_DataItem), var_export($company_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeCompany_Industry_Code_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Industry_Code_Data property can only contain items of type \StructType\Company_Industry_Code_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Industry_Code_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Company_Industry_Code_DataType[] $company_Industry_Code_Data
     * @return \StructType\Company_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setCompany_Industry_Code_Data(array $company_Industry_Code_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($company_Industry_Code_DataArrayErrorMessage = self::validateCompany_Industry_Code_DataForArrayConstraintsFromSetCompany_Industry_Code_Data($company_Industry_Code_Data))) {
            throw new \InvalidArgumentException($company_Industry_Code_DataArrayErrorMessage, __LINE__);
        }
        $this->Company_Industry_Code_Data = $company_Industry_Code_Data;
        return $this;
    }
    /**
     * Add item to Company_Industry_Code_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Company_Industry_Code_DataType $item
     * @return \StructType\Company_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function addToCompany_Industry_Code_Data(\StructType\Company_Industry_Code_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Company_Industry_Code_DataType) {
            throw new \InvalidArgumentException(sprintf('The Company_Industry_Code_Data property can only contain items of type \StructType\Company_Industry_Code_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Industry_Code_Data[] = $item;
        return $this;
    }
}
