<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Company_Asset_Book_Restrictions_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element for create, update, or delete Company Asset Book Restrictions by Company.
 * @subpackage Structs
 */
class Company_Asset_Book_Restrictions_DataType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company reference for company asset book restrictions
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Company_Asset_Book_Restriction_Replacement_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Company Asset Book Restriction replacement data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Company_Asset_Book_Restriction_Replacement_DataType[]
     */
    public $Company_Asset_Book_Restriction_Replacement_Data;
    /**
     * Constructor method for Company_Asset_Book_Restrictions_DataType
     * @uses Company_Asset_Book_Restrictions_DataType::setCompany_Reference()
     * @uses Company_Asset_Book_Restrictions_DataType::setCompany_Asset_Book_Restriction_Replacement_Data()
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Company_Asset_Book_Restriction_Replacement_DataType[] $company_Asset_Book_Restriction_Replacement_Data
     */
    public function __construct(\StructType\CompanyObjectType $company_Reference = null, array $company_Asset_Book_Restriction_Replacement_Data = array())
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setCompany_Asset_Book_Restriction_Replacement_Data($company_Asset_Book_Restriction_Replacement_Data);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Company_Asset_Book_Restrictions_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Company_Asset_Book_Restriction_Replacement_Data value
     * @return \StructType\Company_Asset_Book_Restriction_Replacement_DataType[]|null
     */
    public function getCompany_Asset_Book_Restriction_Replacement_Data()
    {
        return $this->Company_Asset_Book_Restriction_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Asset_Book_Restriction_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Asset_Book_Restriction_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_Asset_Book_Restriction_Replacement_DataForArrayConstraintsFromSetCompany_Asset_Book_Restriction_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $company_Asset_Book_Restrictions_DataTypeCompany_Asset_Book_Restriction_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$company_Asset_Book_Restrictions_DataTypeCompany_Asset_Book_Restriction_Replacement_DataItem instanceof \StructType\Company_Asset_Book_Restriction_Replacement_DataType) {
                $invalidValues[] = is_object($company_Asset_Book_Restrictions_DataTypeCompany_Asset_Book_Restriction_Replacement_DataItem) ? get_class($company_Asset_Book_Restrictions_DataTypeCompany_Asset_Book_Restriction_Replacement_DataItem) : sprintf('%s(%s)', gettype($company_Asset_Book_Restrictions_DataTypeCompany_Asset_Book_Restriction_Replacement_DataItem), var_export($company_Asset_Book_Restrictions_DataTypeCompany_Asset_Book_Restriction_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Asset_Book_Restriction_Replacement_Data property can only contain items of type \StructType\Company_Asset_Book_Restriction_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Asset_Book_Restriction_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Company_Asset_Book_Restriction_Replacement_DataType[] $company_Asset_Book_Restriction_Replacement_Data
     * @return \StructType\Company_Asset_Book_Restrictions_DataType
     */
    public function setCompany_Asset_Book_Restriction_Replacement_Data(array $company_Asset_Book_Restriction_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($company_Asset_Book_Restriction_Replacement_DataArrayErrorMessage = self::validateCompany_Asset_Book_Restriction_Replacement_DataForArrayConstraintsFromSetCompany_Asset_Book_Restriction_Replacement_Data($company_Asset_Book_Restriction_Replacement_Data))) {
            throw new \InvalidArgumentException($company_Asset_Book_Restriction_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Company_Asset_Book_Restriction_Replacement_Data = $company_Asset_Book_Restriction_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Company_Asset_Book_Restriction_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Company_Asset_Book_Restriction_Replacement_DataType $item
     * @return \StructType\Company_Asset_Book_Restrictions_DataType
     */
    public function addToCompany_Asset_Book_Restriction_Replacement_Data(\StructType\Company_Asset_Book_Restriction_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Company_Asset_Book_Restriction_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Company_Asset_Book_Restriction_Replacement_Data property can only contain items of type \StructType\Company_Asset_Book_Restriction_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Asset_Book_Restriction_Replacement_Data[] = $item;
        return $this;
    }
}
