<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Change_Order_Item_Order_Line_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Inventory Replenishment is not a valid delivery type if either the header or line company is enabled for Alternate Ledger Currency | Enter only stocked items on External Warehouse type purchase orders. | Leave the Delivery Type field
 * blank. You can't enter a Delivery Type for External Warehouse type purchase orders. | Remove lines with ad hoc noncatalog items. You can't enter ad hoc noncatalog items on External Warehouse type purchase orders. | Enter a catalog item associated to
 * a purchase item. Workday doesn't support catalog items that aren't associated to purchase items on consignment purchase orders. | Item Reference is not allowed if the Purchase Order Line Reference is for a Web Item. This is because characteristics
 * such as Supplier Item Identifier will be coming from the Web Item and not the Item Reference. | Supplier Item Identifiers cannot be set or updated for lines with no items or having non-catalog items. Catalog Items also have Supplier Item Identifiers,
 * but we cannot change the existing value using this web service. For this web service, the value will not be changed (but will not fire an error) if there is a Web Item (punchout item) associated with the Purchase Order Line Reference and the Supplier
 * Item Identifier is different. | Element containing Goods Purchase Order Line data. Specify only lines that need to be changed / added.
 * @subpackage Structs
 */
class Change_Order_Item_Order_Line_WWS_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: ID of Purcahse Order Line that is being changed
     * - minOccurs: 0
     * @var \StructType\Item_Order_LineObjectType
     */
    public $Purchase_Order_Line_Reference;
    /**
     * The Change_Order_Line_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Line Reference ID on the change order. If provided, this ID needs to be different from the Reference ID on the purchase order line being changed
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Change_Order_Line_Reference_ID;
    /**
     * The Cancel_PO_Line
     * Meta information extracted from the WSDL
     * - documentation: The Purchase Order Line will be canceled
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Cancel_PO_Line;
    /**
     * The Goods_Purchase_Order_Line_ID
     * Meta information extracted from the WSDL
     * - documentation: This value becomes Purchase Order Line Reference ID of the Purchase Order Line when change order is approved.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Goods_Purchase_Order_Line_ID;
    /**
     * The Line_Number
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $Line_Number;
    /**
     * The Line_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: The company of the Purchase Order Line.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Line_Company_Reference;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing purchase item. Specifying the purchase item will default values for the Item Description, Spend Category, Tax Applicability, Unit of Measure, and Unit Cost if these options are defined on the purchase item
     * itself.
     * - minOccurs: 0
     * @var \StructType\Procurement_ItemObjectType
     */
    public $Item_Reference;
    /**
     * The Supplier_Item_Identifier
     * Meta information extracted from the WSDL
     * - documentation: The Supplier Item Identifier for a Change Order Goods Line. If the Item Reference is for a Catalog Item or the Requisition Line Reference is for a Web Item, the entered value will be ignored and Supplier Item Identifier from that
     * Item will be used (even if it is blank)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Item_Identifier;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Free form text description of the purchase item. The description will default from the item if the description is left blank.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Description;
    /**
     * The Commodity_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: The commodity code on spend transactions lines. This is a standard code that identifies a type of good or service you order. For example, the United Nations Standard Products and Services Code (UNSPSC) or the National Institute for
     * Governmental Purchasing (NIGP) code. For purchase items and catalog items, you can only submit active commodity codes already associated to the item. For ad hoc based lines, you can submit any active commodity code.
     * - minOccurs: 0
     * @var \StructType\Commodity_CodeObjectType
     */
    public $Commodity_Code_Reference;
    /**
     * The Resource_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Spend Category. The Spend Category will default from the Purchase Item if the item is specified. This Spend Category must match the Spend Category for the Purchase Item.
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Resource_Category_Reference;
    /**
     * The Tax_Applicability_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Tax Applicability for the Purchase Item. If the item has Tax Code defined, then the Tax Applicability is required.
     * - minOccurs: 0
     * @var \StructType\Tax_ApplicabilityObjectType
     */
    public $Tax_Applicability_Reference;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Tax Code for the Purchase Item. The Tax Code is defaulted from the Change Order Header if one is specified.
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Tax_Rate_Options_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Tax_Rate_Options_DataType
     */
    public $Tax_Rate_Options_Data;
    /**
     * The Packaging_String
     * Meta information extracted from the WSDL
     * - documentation: Packaging String associated with the Item specified on the Line. This information is for outbound purposes only and is not processed on inbound Workday Web Services requests.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Packaging_String;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of the Unit Of Measure for the Purchase Item. The Unit Of Measure will be defaulted based on the Purchase Item if one is specified.
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The Requested_as_No_Charge
     * Meta information extracted from the WSDL
     * - documentation: No Charge field on Purchase Order Change Order Goods Line. This is a read-only field which is ignored when you submit inbound web services.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Requested_as_No_Charge;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Lot_Serial_Information_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Lot_Serial_Information_DataType
     */
    public $Lot_Serial_Information_Data;
    /**
     * The Due_Date
     * Meta information extracted from the WSDL
     * - documentation: The anticipated date by which the Purchase Order Line should be fulfilled.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Due_Date;
    /**
     * The Delivery_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of the Delivery Type for the Purchase Items with Inventory Spend Category
     * - minOccurs: 0
     * @var \StructType\Delivery_TypeObjectType
     */
    public $Delivery_Type_Reference;
    /**
     * The Retention_Line
     * Meta information extracted from the WSDL
     * - documentation: Retention flag at the Line level
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Retention_Line;
    /**
     * The Requested_Delivery_Date
     * Meta information extracted from the WSDL
     * - documentation: The requested delivery date from the related requisition line for the current purchase order or purchase order change order line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Requested_Delivery_Date;
    /**
     * The Budget_Date
     * Meta information extracted from the WSDL
     * - documentation: Use this field to override the Budget Date on a change order line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Budget_Date;
    /**
     * The Prepaid
     * Meta information extracted from the WSDL
     * - documentation: Prepaid flag at the Line level
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Prepaid;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Purchase Order Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contains a reference instance or a Address Reference ID for an existing address
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Ship_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: The ship-to contact worker associated to the line item.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Ship_To_Contact_Reference;
    /**
     * The Deliver_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: The location where the items will be delivered.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Deliver_To_Location_Reference;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: This field is only enabled for Companies and Tenants which are Opted-In to Consolidate Requisition Lines by Supplier regardless of Supplier Contract.Use this field to assign a specific Supplier Contract to this Spend Line.
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Storage_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing location for the item.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Storage_Location_Reference;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for each worktag type and is subject to configurable validation
     * when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Remove_Line_Splits
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the splits for the Purchase Order Line will be removed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Remove_Line_Splits;
    /**
     * The Change_Order_Goods_Line_Split_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Change_Order_Line_Split_WWS_DataType[]
     */
    public $Change_Order_Goods_Line_Split_Data;
    /**
     * Constructor method for Change_Order_Item_Order_Line_WWS_DataType
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setPurchase_Order_Line_Reference()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setChange_Order_Line_Reference_ID()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setCancel_PO_Line()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setGoods_Purchase_Order_Line_ID()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setLine_Number()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setLine_Company_Reference()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setItem_Reference()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setSupplier_Item_Identifier()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setItem_Description()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setCommodity_Code_Reference()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setResource_Category_Reference()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setTax_Applicability_Reference()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setTax_Code_Reference()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setTax_Rate_Options_Data()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setPackaging_String()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setQuantity()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setUnit_of_Measure_Reference()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setUnit_Cost()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setRequested_as_No_Charge()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setExtended_Amount()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setLot_Serial_Information_Data()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setDue_Date()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setDelivery_Type_Reference()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setRetention_Line()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setRequested_Delivery_Date()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setBudget_Date()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setPrepaid()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setMemo()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setShip_To_Address_Reference()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setShip_To_Contact_Reference()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setDeliver_To_Location_Reference()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setSupplier_Contract_Reference()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setStorage_Location_Reference()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setWorktags_Reference()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setRemove_Line_Splits()
     * @uses Change_Order_Item_Order_Line_WWS_DataType::setChange_Order_Goods_Line_Split_Data()
     * @param \StructType\Item_Order_LineObjectType $purchase_Order_Line_Reference
     * @param string $change_Order_Line_Reference_ID
     * @param bool $cancel_PO_Line
     * @param string $goods_Purchase_Order_Line_ID
     * @param float $line_Number
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @param string $supplier_Item_Identifier
     * @param string $item_Description
     * @param \StructType\Commodity_CodeObjectType $commodity_Code_Reference
     * @param \StructType\Spend_CategoryObjectType $resource_Category_Reference
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data
     * @param string $packaging_String
     * @param float $quantity
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $unit_Cost
     * @param bool $requested_as_No_Charge
     * @param float $extended_Amount
     * @param \StructType\Lot_Serial_Information_DataType $lot_Serial_Information_Data
     * @param string $due_Date
     * @param \StructType\Delivery_TypeObjectType $delivery_Type_Reference
     * @param bool $retention_Line
     * @param string $requested_Delivery_Date
     * @param string $budget_Date
     * @param bool $prepaid
     * @param string $memo
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param \StructType\LocationObjectType $storage_Location_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @param bool $remove_Line_Splits
     * @param \StructType\Change_Order_Line_Split_WWS_DataType[] $change_Order_Goods_Line_Split_Data
     */
    public function __construct(\StructType\Item_Order_LineObjectType $purchase_Order_Line_Reference = null, $change_Order_Line_Reference_ID = null, $cancel_PO_Line = null, $goods_Purchase_Order_Line_ID = null, $line_Number = null, \StructType\CompanyObjectType $line_Company_Reference = null, \StructType\Procurement_ItemObjectType $item_Reference = null, $supplier_Item_Identifier = null, $item_Description = null, \StructType\Commodity_CodeObjectType $commodity_Code_Reference = null, \StructType\Spend_CategoryObjectType $resource_Category_Reference = null, \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, \StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data = null, $packaging_String = null, $quantity = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $unit_Cost = null, $requested_as_No_Charge = null, $extended_Amount = null, \StructType\Lot_Serial_Information_DataType $lot_Serial_Information_Data = null, $due_Date = null, \StructType\Delivery_TypeObjectType $delivery_Type_Reference = null, $retention_Line = null, $requested_Delivery_Date = null, $budget_Date = null, $prepaid = null, $memo = null, \StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null, \StructType\WorkerObjectType $ship_To_Contact_Reference = null, \StructType\LocationObjectType $deliver_To_Location_Reference = null, \StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, \StructType\LocationObjectType $storage_Location_Reference = null, array $worktags_Reference = array(), $remove_Line_Splits = null, array $change_Order_Goods_Line_Split_Data = array())
    {
        $this
            ->setPurchase_Order_Line_Reference($purchase_Order_Line_Reference)
            ->setChange_Order_Line_Reference_ID($change_Order_Line_Reference_ID)
            ->setCancel_PO_Line($cancel_PO_Line)
            ->setGoods_Purchase_Order_Line_ID($goods_Purchase_Order_Line_ID)
            ->setLine_Number($line_Number)
            ->setLine_Company_Reference($line_Company_Reference)
            ->setItem_Reference($item_Reference)
            ->setSupplier_Item_Identifier($supplier_Item_Identifier)
            ->setItem_Description($item_Description)
            ->setCommodity_Code_Reference($commodity_Code_Reference)
            ->setResource_Category_Reference($resource_Category_Reference)
            ->setTax_Applicability_Reference($tax_Applicability_Reference)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setTax_Rate_Options_Data($tax_Rate_Options_Data)
            ->setPackaging_String($packaging_String)
            ->setQuantity($quantity)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setUnit_Cost($unit_Cost)
            ->setRequested_as_No_Charge($requested_as_No_Charge)
            ->setExtended_Amount($extended_Amount)
            ->setLot_Serial_Information_Data($lot_Serial_Information_Data)
            ->setDue_Date($due_Date)
            ->setDelivery_Type_Reference($delivery_Type_Reference)
            ->setRetention_Line($retention_Line)
            ->setRequested_Delivery_Date($requested_Delivery_Date)
            ->setBudget_Date($budget_Date)
            ->setPrepaid($prepaid)
            ->setMemo($memo)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setShip_To_Contact_Reference($ship_To_Contact_Reference)
            ->setDeliver_To_Location_Reference($deliver_To_Location_Reference)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setStorage_Location_Reference($storage_Location_Reference)
            ->setWorktags_Reference($worktags_Reference)
            ->setRemove_Line_Splits($remove_Line_Splits)
            ->setChange_Order_Goods_Line_Split_Data($change_Order_Goods_Line_Split_Data);
    }
    /**
     * Get Purchase_Order_Line_Reference value
     * @return \StructType\Item_Order_LineObjectType|null
     */
    public function getPurchase_Order_Line_Reference()
    {
        return $this->Purchase_Order_Line_Reference;
    }
    /**
     * Set Purchase_Order_Line_Reference value
     * @param \StructType\Item_Order_LineObjectType $purchase_Order_Line_Reference
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setPurchase_Order_Line_Reference(\StructType\Item_Order_LineObjectType $purchase_Order_Line_Reference = null)
    {
        $this->Purchase_Order_Line_Reference = $purchase_Order_Line_Reference;
        return $this;
    }
    /**
     * Get Change_Order_Line_Reference_ID value
     * @return string|null
     */
    public function getChange_Order_Line_Reference_ID()
    {
        return $this->Change_Order_Line_Reference_ID;
    }
    /**
     * Set Change_Order_Line_Reference_ID value
     * @param string $change_Order_Line_Reference_ID
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setChange_Order_Line_Reference_ID($change_Order_Line_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($change_Order_Line_Reference_ID) && !is_string($change_Order_Line_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($change_Order_Line_Reference_ID, true), gettype($change_Order_Line_Reference_ID)), __LINE__);
        }
        $this->Change_Order_Line_Reference_ID = $change_Order_Line_Reference_ID;
        return $this;
    }
    /**
     * Get Cancel_PO_Line value
     * @return bool|null
     */
    public function getCancel_PO_Line()
    {
        return $this->Cancel_PO_Line;
    }
    /**
     * Set Cancel_PO_Line value
     * @param bool $cancel_PO_Line
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setCancel_PO_Line($cancel_PO_Line = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancel_PO_Line) && !is_bool($cancel_PO_Line)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancel_PO_Line, true), gettype($cancel_PO_Line)), __LINE__);
        }
        $this->Cancel_PO_Line = $cancel_PO_Line;
        return $this;
    }
    /**
     * Get Goods_Purchase_Order_Line_ID value
     * @return string|null
     */
    public function getGoods_Purchase_Order_Line_ID()
    {
        return $this->Goods_Purchase_Order_Line_ID;
    }
    /**
     * Set Goods_Purchase_Order_Line_ID value
     * @param string $goods_Purchase_Order_Line_ID
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setGoods_Purchase_Order_Line_ID($goods_Purchase_Order_Line_ID = null)
    {
        // validation for constraint: string
        if (!is_null($goods_Purchase_Order_Line_ID) && !is_string($goods_Purchase_Order_Line_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($goods_Purchase_Order_Line_ID, true), gettype($goods_Purchase_Order_Line_ID)), __LINE__);
        }
        $this->Goods_Purchase_Order_Line_ID = $goods_Purchase_Order_Line_ID;
        return $this;
    }
    /**
     * Get Line_Number value
     * @return float|null
     */
    public function getLine_Number()
    {
        return $this->Line_Number;
    }
    /**
     * Set Line_Number value
     * @param float $line_Number
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setLine_Number($line_Number = null)
    {
        // validation for constraint: float
        if (!is_null($line_Number) && !(is_float($line_Number) || is_numeric($line_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($line_Number, true), gettype($line_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($line_Number) && mb_strlen(mb_substr($line_Number, false !== mb_strpos($line_Number, '.') ? mb_strpos($line_Number, '.') + 1 : mb_strlen($line_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($line_Number, true), mb_strlen(mb_substr($line_Number, mb_strpos($line_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($line_Number) && $line_Number < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($line_Number, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($line_Number) && mb_strlen(preg_replace('/(\D)/', '', $line_Number)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($line_Number, true), mb_strlen(preg_replace('/(\D)/', '', $line_Number))), __LINE__);
        }
        $this->Line_Number = $line_Number;
        return $this;
    }
    /**
     * Get Line_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getLine_Company_Reference()
    {
        return $this->Line_Company_Reference;
    }
    /**
     * Set Line_Company_Reference value
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setLine_Company_Reference(\StructType\CompanyObjectType $line_Company_Reference = null)
    {
        $this->Line_Company_Reference = $line_Company_Reference;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Procurement_ItemObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setItem_Reference(\StructType\Procurement_ItemObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Supplier_Item_Identifier value
     * @return string|null
     */
    public function getSupplier_Item_Identifier()
    {
        return $this->Supplier_Item_Identifier;
    }
    /**
     * Set Supplier_Item_Identifier value
     * @param string $supplier_Item_Identifier
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setSupplier_Item_Identifier($supplier_Item_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Item_Identifier) && !is_string($supplier_Item_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Item_Identifier, true), gettype($supplier_Item_Identifier)), __LINE__);
        }
        $this->Supplier_Item_Identifier = $supplier_Item_Identifier;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get Commodity_Code_Reference value
     * @return \StructType\Commodity_CodeObjectType|null
     */
    public function getCommodity_Code_Reference()
    {
        return $this->Commodity_Code_Reference;
    }
    /**
     * Set Commodity_Code_Reference value
     * @param \StructType\Commodity_CodeObjectType $commodity_Code_Reference
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setCommodity_Code_Reference(\StructType\Commodity_CodeObjectType $commodity_Code_Reference = null)
    {
        $this->Commodity_Code_Reference = $commodity_Code_Reference;
        return $this;
    }
    /**
     * Get Resource_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getResource_Category_Reference()
    {
        return $this->Resource_Category_Reference;
    }
    /**
     * Set Resource_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $resource_Category_Reference
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setResource_Category_Reference(\StructType\Spend_CategoryObjectType $resource_Category_Reference = null)
    {
        $this->Resource_Category_Reference = $resource_Category_Reference;
        return $this;
    }
    /**
     * Get Tax_Applicability_Reference value
     * @return \StructType\Tax_ApplicabilityObjectType|null
     */
    public function getTax_Applicability_Reference()
    {
        return $this->Tax_Applicability_Reference;
    }
    /**
     * Set Tax_Applicability_Reference value
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setTax_Applicability_Reference(\StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null)
    {
        $this->Tax_Applicability_Reference = $tax_Applicability_Reference;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Tax_Rate_Options_Data value
     * @return \StructType\Tax_Rate_Options_DataType|null
     */
    public function getTax_Rate_Options_Data()
    {
        return $this->Tax_Rate_Options_Data;
    }
    /**
     * Set Tax_Rate_Options_Data value
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setTax_Rate_Options_Data(\StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data = null)
    {
        $this->Tax_Rate_Options_Data = $tax_Rate_Options_Data;
        return $this;
    }
    /**
     * Get Packaging_String value
     * @return string|null
     */
    public function getPackaging_String()
    {
        return $this->Packaging_String;
    }
    /**
     * Set Packaging_String value
     * @param string $packaging_String
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setPackaging_String($packaging_String = null)
    {
        // validation for constraint: string
        if (!is_null($packaging_String) && !is_string($packaging_String)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packaging_String, true), gettype($packaging_String)), __LINE__);
        }
        $this->Packaging_String = $packaging_String;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get Requested_as_No_Charge value
     * @return bool|null
     */
    public function getRequested_as_No_Charge()
    {
        return $this->Requested_as_No_Charge;
    }
    /**
     * Set Requested_as_No_Charge value
     * @param bool $requested_as_No_Charge
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setRequested_as_No_Charge($requested_as_No_Charge = null)
    {
        // validation for constraint: boolean
        if (!is_null($requested_as_No_Charge) && !is_bool($requested_as_No_Charge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requested_as_No_Charge, true), gettype($requested_as_No_Charge)), __LINE__);
        }
        $this->Requested_as_No_Charge = $requested_as_No_Charge;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Lot_Serial_Information_Data value
     * @return \StructType\Lot_Serial_Information_DataType|null
     */
    public function getLot_Serial_Information_Data()
    {
        return $this->Lot_Serial_Information_Data;
    }
    /**
     * Set Lot_Serial_Information_Data value
     * @param \StructType\Lot_Serial_Information_DataType $lot_Serial_Information_Data
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setLot_Serial_Information_Data(\StructType\Lot_Serial_Information_DataType $lot_Serial_Information_Data = null)
    {
        $this->Lot_Serial_Information_Data = $lot_Serial_Information_Data;
        return $this;
    }
    /**
     * Get Due_Date value
     * @return string|null
     */
    public function getDue_Date()
    {
        return $this->Due_Date;
    }
    /**
     * Set Due_Date value
     * @param string $due_Date
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setDue_Date($due_Date = null)
    {
        // validation for constraint: string
        if (!is_null($due_Date) && !is_string($due_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($due_Date, true), gettype($due_Date)), __LINE__);
        }
        $this->Due_Date = $due_Date;
        return $this;
    }
    /**
     * Get Delivery_Type_Reference value
     * @return \StructType\Delivery_TypeObjectType|null
     */
    public function getDelivery_Type_Reference()
    {
        return $this->Delivery_Type_Reference;
    }
    /**
     * Set Delivery_Type_Reference value
     * @param \StructType\Delivery_TypeObjectType $delivery_Type_Reference
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setDelivery_Type_Reference(\StructType\Delivery_TypeObjectType $delivery_Type_Reference = null)
    {
        $this->Delivery_Type_Reference = $delivery_Type_Reference;
        return $this;
    }
    /**
     * Get Retention_Line value
     * @return bool|null
     */
    public function getRetention_Line()
    {
        return $this->Retention_Line;
    }
    /**
     * Set Retention_Line value
     * @param bool $retention_Line
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setRetention_Line($retention_Line = null)
    {
        // validation for constraint: boolean
        if (!is_null($retention_Line) && !is_bool($retention_Line)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retention_Line, true), gettype($retention_Line)), __LINE__);
        }
        $this->Retention_Line = $retention_Line;
        return $this;
    }
    /**
     * Get Requested_Delivery_Date value
     * @return string|null
     */
    public function getRequested_Delivery_Date()
    {
        return $this->Requested_Delivery_Date;
    }
    /**
     * Set Requested_Delivery_Date value
     * @param string $requested_Delivery_Date
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setRequested_Delivery_Date($requested_Delivery_Date = null)
    {
        // validation for constraint: string
        if (!is_null($requested_Delivery_Date) && !is_string($requested_Delivery_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requested_Delivery_Date, true), gettype($requested_Delivery_Date)), __LINE__);
        }
        $this->Requested_Delivery_Date = $requested_Delivery_Date;
        return $this;
    }
    /**
     * Get Budget_Date value
     * @return string|null
     */
    public function getBudget_Date()
    {
        return $this->Budget_Date;
    }
    /**
     * Set Budget_Date value
     * @param string $budget_Date
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setBudget_Date($budget_Date = null)
    {
        // validation for constraint: string
        if (!is_null($budget_Date) && !is_string($budget_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($budget_Date, true), gettype($budget_Date)), __LINE__);
        }
        $this->Budget_Date = $budget_Date;
        return $this;
    }
    /**
     * Get Prepaid value
     * @return bool|null
     */
    public function getPrepaid()
    {
        return $this->Prepaid;
    }
    /**
     * Set Prepaid value
     * @param bool $prepaid
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setPrepaid($prepaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($prepaid) && !is_bool($prepaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prepaid, true), gettype($prepaid)), __LINE__);
        }
        $this->Prepaid = $prepaid;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->Ship_To_Address_Reference;
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setShip_To_Address_Reference(\StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getShip_To_Contact_Reference()
    {
        return $this->Ship_To_Contact_Reference;
    }
    /**
     * Set Ship_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setShip_To_Contact_Reference(\StructType\WorkerObjectType $ship_To_Contact_Reference = null)
    {
        $this->Ship_To_Contact_Reference = $ship_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Deliver_To_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getDeliver_To_Location_Reference()
    {
        return $this->Deliver_To_Location_Reference;
    }
    /**
     * Set Deliver_To_Location_Reference value
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setDeliver_To_Location_Reference(\StructType\LocationObjectType $deliver_To_Location_Reference = null)
    {
        $this->Deliver_To_Location_Reference = $deliver_To_Location_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Storage_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getStorage_Location_Reference()
    {
        return $this->Storage_Location_Reference;
    }
    /**
     * Set Storage_Location_Reference value
     * @param \StructType\LocationObjectType $storage_Location_Reference
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setStorage_Location_Reference(\StructType\LocationObjectType $storage_Location_Reference = null)
    {
        $this->Storage_Location_Reference = $storage_Location_Reference;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $change_Order_Item_Order_Line_WWS_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$change_Order_Item_Order_Line_WWS_DataTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($change_Order_Item_Order_Line_WWS_DataTypeWorktags_ReferenceItem) ? get_class($change_Order_Item_Order_Line_WWS_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($change_Order_Item_Order_Line_WWS_DataTypeWorktags_ReferenceItem), var_export($change_Order_Item_Order_Line_WWS_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Remove_Line_Splits value
     * @return bool|null
     */
    public function getRemove_Line_Splits()
    {
        return $this->Remove_Line_Splits;
    }
    /**
     * Set Remove_Line_Splits value
     * @param bool $remove_Line_Splits
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setRemove_Line_Splits($remove_Line_Splits = null)
    {
        // validation for constraint: boolean
        if (!is_null($remove_Line_Splits) && !is_bool($remove_Line_Splits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($remove_Line_Splits, true), gettype($remove_Line_Splits)), __LINE__);
        }
        $this->Remove_Line_Splits = $remove_Line_Splits;
        return $this;
    }
    /**
     * Get Change_Order_Goods_Line_Split_Data value
     * @return \StructType\Change_Order_Line_Split_WWS_DataType[]|null
     */
    public function getChange_Order_Goods_Line_Split_Data()
    {
        return $this->Change_Order_Goods_Line_Split_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setChange_Order_Goods_Line_Split_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChange_Order_Goods_Line_Split_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChange_Order_Goods_Line_Split_DataForArrayConstraintsFromSetChange_Order_Goods_Line_Split_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $change_Order_Item_Order_Line_WWS_DataTypeChange_Order_Goods_Line_Split_DataItem) {
            // validation for constraint: itemType
            if (!$change_Order_Item_Order_Line_WWS_DataTypeChange_Order_Goods_Line_Split_DataItem instanceof \StructType\Change_Order_Line_Split_WWS_DataType) {
                $invalidValues[] = is_object($change_Order_Item_Order_Line_WWS_DataTypeChange_Order_Goods_Line_Split_DataItem) ? get_class($change_Order_Item_Order_Line_WWS_DataTypeChange_Order_Goods_Line_Split_DataItem) : sprintf('%s(%s)', gettype($change_Order_Item_Order_Line_WWS_DataTypeChange_Order_Goods_Line_Split_DataItem), var_export($change_Order_Item_Order_Line_WWS_DataTypeChange_Order_Goods_Line_Split_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Change_Order_Goods_Line_Split_Data property can only contain items of type \StructType\Change_Order_Line_Split_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Change_Order_Goods_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Change_Order_Line_Split_WWS_DataType[] $change_Order_Goods_Line_Split_Data
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function setChange_Order_Goods_Line_Split_Data(array $change_Order_Goods_Line_Split_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($change_Order_Goods_Line_Split_DataArrayErrorMessage = self::validateChange_Order_Goods_Line_Split_DataForArrayConstraintsFromSetChange_Order_Goods_Line_Split_Data($change_Order_Goods_Line_Split_Data))) {
            throw new \InvalidArgumentException($change_Order_Goods_Line_Split_DataArrayErrorMessage, __LINE__);
        }
        $this->Change_Order_Goods_Line_Split_Data = $change_Order_Goods_Line_Split_Data;
        return $this;
    }
    /**
     * Add item to Change_Order_Goods_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Change_Order_Line_Split_WWS_DataType $item
     * @return \StructType\Change_Order_Item_Order_Line_WWS_DataType
     */
    public function addToChange_Order_Goods_Line_Split_Data(\StructType\Change_Order_Line_Split_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Change_Order_Line_Split_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Change_Order_Goods_Line_Split_Data property can only contain items of type \StructType\Change_Order_Line_Split_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Change_Order_Goods_Line_Split_Data[] = $item;
        return $this;
    }
}
