<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Catalog_Load_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Catalog Load Data
 * @subpackage Structs
 */
class Catalog_Load_DataType extends AbstractStructBase
{
    /**
     * The Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Catalog Effective Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Effective_Date;
    /**
     * The Supplier_Catalog_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Catalog for Catalog Load
     * - minOccurs: 0
     * @var \StructType\Abstract_Procurement_CatalogObjectType
     */
    public $Supplier_Catalog_Reference;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Contract
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Default_Lead_Time_in_Days
     * Meta information extracted from the WSDL
     * - documentation: Catalog Load Default Catalog Load Item Lead Time in Days
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Default_Lead_Time_in_Days;
    /**
     * The Catalog_Load_Item_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Catalog Load Item data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Catalog_Load_Item_DataType[]
     */
    public $Catalog_Load_Item_Data;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: This transaction header memo will print on the delivered transaction. It is optional freeform text
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * Constructor method for Catalog_Load_DataType
     * @uses Catalog_Load_DataType::setEffective_Date()
     * @uses Catalog_Load_DataType::setSupplier_Catalog_Reference()
     * @uses Catalog_Load_DataType::setSupplier_Contract_Reference()
     * @uses Catalog_Load_DataType::setDefault_Lead_Time_in_Days()
     * @uses Catalog_Load_DataType::setCatalog_Load_Item_Data()
     * @uses Catalog_Load_DataType::setMemo()
     * @param string $effective_Date
     * @param \StructType\Abstract_Procurement_CatalogObjectType $supplier_Catalog_Reference
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param float $default_Lead_Time_in_Days
     * @param \StructType\Catalog_Load_Item_DataType[] $catalog_Load_Item_Data
     * @param string $memo
     */
    public function __construct($effective_Date = null, \StructType\Abstract_Procurement_CatalogObjectType $supplier_Catalog_Reference = null, \StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, $default_Lead_Time_in_Days = null, array $catalog_Load_Item_Data = array(), $memo = null)
    {
        $this
            ->setEffective_Date($effective_Date)
            ->setSupplier_Catalog_Reference($supplier_Catalog_Reference)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setDefault_Lead_Time_in_Days($default_Lead_Time_in_Days)
            ->setCatalog_Load_Item_Data($catalog_Load_Item_Data)
            ->setMemo($memo);
    }
    /**
     * Get Effective_Date value
     * @return string|null
     */
    public function getEffective_Date()
    {
        return $this->Effective_Date;
    }
    /**
     * Set Effective_Date value
     * @param string $effective_Date
     * @return \StructType\Catalog_Load_DataType
     */
    public function setEffective_Date($effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($effective_Date) && !is_string($effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effective_Date, true), gettype($effective_Date)), __LINE__);
        }
        $this->Effective_Date = $effective_Date;
        return $this;
    }
    /**
     * Get Supplier_Catalog_Reference value
     * @return \StructType\Abstract_Procurement_CatalogObjectType|null
     */
    public function getSupplier_Catalog_Reference()
    {
        return $this->Supplier_Catalog_Reference;
    }
    /**
     * Set Supplier_Catalog_Reference value
     * @param \StructType\Abstract_Procurement_CatalogObjectType $supplier_Catalog_Reference
     * @return \StructType\Catalog_Load_DataType
     */
    public function setSupplier_Catalog_Reference(\StructType\Abstract_Procurement_CatalogObjectType $supplier_Catalog_Reference = null)
    {
        $this->Supplier_Catalog_Reference = $supplier_Catalog_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Catalog_Load_DataType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Default_Lead_Time_in_Days value
     * @return float|null
     */
    public function getDefault_Lead_Time_in_Days()
    {
        return $this->Default_Lead_Time_in_Days;
    }
    /**
     * Set Default_Lead_Time_in_Days value
     * @param float $default_Lead_Time_in_Days
     * @return \StructType\Catalog_Load_DataType
     */
    public function setDefault_Lead_Time_in_Days($default_Lead_Time_in_Days = null)
    {
        // validation for constraint: float
        if (!is_null($default_Lead_Time_in_Days) && !(is_float($default_Lead_Time_in_Days) || is_numeric($default_Lead_Time_in_Days))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($default_Lead_Time_in_Days, true), gettype($default_Lead_Time_in_Days)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($default_Lead_Time_in_Days) && mb_strlen(mb_substr($default_Lead_Time_in_Days, false !== mb_strpos($default_Lead_Time_in_Days, '.') ? mb_strpos($default_Lead_Time_in_Days, '.') + 1 : mb_strlen($default_Lead_Time_in_Days))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($default_Lead_Time_in_Days, true), mb_strlen(mb_substr($default_Lead_Time_in_Days, mb_strpos($default_Lead_Time_in_Days, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($default_Lead_Time_in_Days) && $default_Lead_Time_in_Days < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($default_Lead_Time_in_Days, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($default_Lead_Time_in_Days) && mb_strlen(preg_replace('/(\D)/', '', $default_Lead_Time_in_Days)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($default_Lead_Time_in_Days, true), mb_strlen(preg_replace('/(\D)/', '', $default_Lead_Time_in_Days))), __LINE__);
        }
        $this->Default_Lead_Time_in_Days = $default_Lead_Time_in_Days;
        return $this;
    }
    /**
     * Get Catalog_Load_Item_Data value
     * @return \StructType\Catalog_Load_Item_DataType[]|null
     */
    public function getCatalog_Load_Item_Data()
    {
        return $this->Catalog_Load_Item_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCatalog_Load_Item_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCatalog_Load_Item_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCatalog_Load_Item_DataForArrayConstraintsFromSetCatalog_Load_Item_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $catalog_Load_DataTypeCatalog_Load_Item_DataItem) {
            // validation for constraint: itemType
            if (!$catalog_Load_DataTypeCatalog_Load_Item_DataItem instanceof \StructType\Catalog_Load_Item_DataType) {
                $invalidValues[] = is_object($catalog_Load_DataTypeCatalog_Load_Item_DataItem) ? get_class($catalog_Load_DataTypeCatalog_Load_Item_DataItem) : sprintf('%s(%s)', gettype($catalog_Load_DataTypeCatalog_Load_Item_DataItem), var_export($catalog_Load_DataTypeCatalog_Load_Item_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Catalog_Load_Item_Data property can only contain items of type \StructType\Catalog_Load_Item_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Catalog_Load_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Load_Item_DataType[] $catalog_Load_Item_Data
     * @return \StructType\Catalog_Load_DataType
     */
    public function setCatalog_Load_Item_Data(array $catalog_Load_Item_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($catalog_Load_Item_DataArrayErrorMessage = self::validateCatalog_Load_Item_DataForArrayConstraintsFromSetCatalog_Load_Item_Data($catalog_Load_Item_Data))) {
            throw new \InvalidArgumentException($catalog_Load_Item_DataArrayErrorMessage, __LINE__);
        }
        $this->Catalog_Load_Item_Data = $catalog_Load_Item_Data;
        return $this;
    }
    /**
     * Add item to Catalog_Load_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Load_Item_DataType $item
     * @return \StructType\Catalog_Load_DataType
     */
    public function addToCatalog_Load_Item_Data(\StructType\Catalog_Load_Item_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Catalog_Load_Item_DataType) {
            throw new \InvalidArgumentException(sprintf('The Catalog_Load_Item_Data property can only contain items of type \StructType\Catalog_Load_Item_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Catalog_Load_Item_Data[] = $item;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Catalog_Load_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
}
