<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Catalog_Item_for_Internal_Catalog_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Internal Catalog data.
 * @subpackage Structs
 */
class Catalog_Item_for_Internal_Catalog_DataType extends AbstractStructBase
{
    /**
     * The Catalog_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Reference
     * - minOccurs: 0
     * @var \StructType\Catalog_ItemObjectType
     */
    public $Catalog_Item_Reference;
    /**
     * The Item_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Internal Catalog Reference ID.
     * - maxOccurs: 1
     * @var string
     */
    public $Item_Identifier;
    /**
     * The Currently_Active
     * Meta information extracted from the WSDL
     * - documentation: Is the Catalog Item currently Active
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Currently_Active;
    /**
     * The Current_Default_Rate
     * Meta information extracted from the WSDL
     * - documentation: The current rate of the default ordering unit of measure for the internal service catalog item.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Current_Default_Rate;
    /**
     * The Default_Ordering_Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: The default ordering unit of measure for the catalog item.
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Default_Ordering_Unit_of_Measure_Reference;
    /**
     * The Base_Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Base Unit of Measure Reference
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Base_Unit_of_Measure_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Spend Category.
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Item Description
     * - maxOccurs: 1
     * @var string
     */
    public $Item_Description;
    /**
     * The Lead_Time
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Lead Time | Catalog or Supplier Item Lead Time | Lead time for the UOM of the Catalog Item. | Lead time for the UOM of the supplier item. | Lead time for the supplier item | Lead time for the JIT UOM of the Catalog or
     * Supplier Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase items. | Lead time for the Bulk UOM of the Catalog or Supplier
     * Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase items.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Lead_Time;
    /**
     * The Item_URL
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item URL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_URL;
    /**
     * The Purchase_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item Reference
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemObjectType
     */
    public $Purchase_Item_Reference;
    /**
     * The Primary_Image_Data
     * Meta information extracted from the WSDL
     * - documentation: Primary Image for Item
     * - minOccurs: 0
     * @var \StructType\Primary_Image_DataType
     */
    public $Primary_Image_Data;
    /**
     * The Additional_Image_Data
     * Meta information extracted from the WSDL
     * - documentation: Additional Image for Item
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Additional_Image_DataType[]
     */
    public $Additional_Image_Data;
    /**
     * The UOM_Pricing_History
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Catalog_Item_Data_for_Catalog_DataType[]
     */
    public $UOM_Pricing_History;
    /**
     * Constructor method for Catalog_Item_for_Internal_Catalog_DataType
     * @uses Catalog_Item_for_Internal_Catalog_DataType::setCatalog_Item_Reference()
     * @uses Catalog_Item_for_Internal_Catalog_DataType::setItem_Identifier()
     * @uses Catalog_Item_for_Internal_Catalog_DataType::setCurrently_Active()
     * @uses Catalog_Item_for_Internal_Catalog_DataType::setCurrent_Default_Rate()
     * @uses Catalog_Item_for_Internal_Catalog_DataType::setDefault_Ordering_Unit_of_Measure_Reference()
     * @uses Catalog_Item_for_Internal_Catalog_DataType::setBase_Unit_of_Measure_Reference()
     * @uses Catalog_Item_for_Internal_Catalog_DataType::setSpend_Category_Reference()
     * @uses Catalog_Item_for_Internal_Catalog_DataType::setItem_Description()
     * @uses Catalog_Item_for_Internal_Catalog_DataType::setLead_Time()
     * @uses Catalog_Item_for_Internal_Catalog_DataType::setItem_URL()
     * @uses Catalog_Item_for_Internal_Catalog_DataType::setPurchase_Item_Reference()
     * @uses Catalog_Item_for_Internal_Catalog_DataType::setPrimary_Image_Data()
     * @uses Catalog_Item_for_Internal_Catalog_DataType::setAdditional_Image_Data()
     * @uses Catalog_Item_for_Internal_Catalog_DataType::setUOM_Pricing_History()
     * @param \StructType\Catalog_ItemObjectType $catalog_Item_Reference
     * @param string $item_Identifier
     * @param bool $currently_Active
     * @param float $current_Default_Rate
     * @param \StructType\Unit_of_MeasureObjectType $default_Ordering_Unit_of_Measure_Reference
     * @param \StructType\Unit_of_MeasureObjectType $base_Unit_of_Measure_Reference
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param string $item_Description
     * @param float $lead_Time
     * @param string $item_URL
     * @param \StructType\Purchase_ItemObjectType $purchase_Item_Reference
     * @param \StructType\Primary_Image_DataType $primary_Image_Data
     * @param \StructType\Additional_Image_DataType[] $additional_Image_Data
     * @param \StructType\Catalog_Item_Data_for_Catalog_DataType[] $uOM_Pricing_History
     */
    public function __construct(\StructType\Catalog_ItemObjectType $catalog_Item_Reference = null, $item_Identifier = null, $currently_Active = null, $current_Default_Rate = null, \StructType\Unit_of_MeasureObjectType $default_Ordering_Unit_of_Measure_Reference = null, \StructType\Unit_of_MeasureObjectType $base_Unit_of_Measure_Reference = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, $item_Description = null, $lead_Time = null, $item_URL = null, \StructType\Purchase_ItemObjectType $purchase_Item_Reference = null, \StructType\Primary_Image_DataType $primary_Image_Data = null, array $additional_Image_Data = array(), array $uOM_Pricing_History = array())
    {
        $this
            ->setCatalog_Item_Reference($catalog_Item_Reference)
            ->setItem_Identifier($item_Identifier)
            ->setCurrently_Active($currently_Active)
            ->setCurrent_Default_Rate($current_Default_Rate)
            ->setDefault_Ordering_Unit_of_Measure_Reference($default_Ordering_Unit_of_Measure_Reference)
            ->setBase_Unit_of_Measure_Reference($base_Unit_of_Measure_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setItem_Description($item_Description)
            ->setLead_Time($lead_Time)
            ->setItem_URL($item_URL)
            ->setPurchase_Item_Reference($purchase_Item_Reference)
            ->setPrimary_Image_Data($primary_Image_Data)
            ->setAdditional_Image_Data($additional_Image_Data)
            ->setUOM_Pricing_History($uOM_Pricing_History);
    }
    /**
     * Get Catalog_Item_Reference value
     * @return \StructType\Catalog_ItemObjectType|null
     */
    public function getCatalog_Item_Reference()
    {
        return $this->Catalog_Item_Reference;
    }
    /**
     * Set Catalog_Item_Reference value
     * @param \StructType\Catalog_ItemObjectType $catalog_Item_Reference
     * @return \StructType\Catalog_Item_for_Internal_Catalog_DataType
     */
    public function setCatalog_Item_Reference(\StructType\Catalog_ItemObjectType $catalog_Item_Reference = null)
    {
        $this->Catalog_Item_Reference = $catalog_Item_Reference;
        return $this;
    }
    /**
     * Get Item_Identifier value
     * @return string|null
     */
    public function getItem_Identifier()
    {
        return $this->Item_Identifier;
    }
    /**
     * Set Item_Identifier value
     * @param string $item_Identifier
     * @return \StructType\Catalog_Item_for_Internal_Catalog_DataType
     */
    public function setItem_Identifier($item_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($item_Identifier) && !is_string($item_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Identifier, true), gettype($item_Identifier)), __LINE__);
        }
        $this->Item_Identifier = $item_Identifier;
        return $this;
    }
    /**
     * Get Currently_Active value
     * @return bool|null
     */
    public function getCurrently_Active()
    {
        return $this->Currently_Active;
    }
    /**
     * Set Currently_Active value
     * @param bool $currently_Active
     * @return \StructType\Catalog_Item_for_Internal_Catalog_DataType
     */
    public function setCurrently_Active($currently_Active = null)
    {
        // validation for constraint: boolean
        if (!is_null($currently_Active) && !is_bool($currently_Active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($currently_Active, true), gettype($currently_Active)), __LINE__);
        }
        $this->Currently_Active = $currently_Active;
        return $this;
    }
    /**
     * Get Current_Default_Rate value
     * @return float|null
     */
    public function getCurrent_Default_Rate()
    {
        return $this->Current_Default_Rate;
    }
    /**
     * Set Current_Default_Rate value
     * @param float $current_Default_Rate
     * @return \StructType\Catalog_Item_for_Internal_Catalog_DataType
     */
    public function setCurrent_Default_Rate($current_Default_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($current_Default_Rate) && !(is_float($current_Default_Rate) || is_numeric($current_Default_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($current_Default_Rate, true), gettype($current_Default_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($current_Default_Rate) && mb_strlen(mb_substr($current_Default_Rate, false !== mb_strpos($current_Default_Rate, '.') ? mb_strpos($current_Default_Rate, '.') + 1 : mb_strlen($current_Default_Rate))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($current_Default_Rate, true), mb_strlen(mb_substr($current_Default_Rate, mb_strpos($current_Default_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($current_Default_Rate) && mb_strlen(preg_replace('/(\D)/', '', $current_Default_Rate)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($current_Default_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $current_Default_Rate))), __LINE__);
        }
        $this->Current_Default_Rate = $current_Default_Rate;
        return $this;
    }
    /**
     * Get Default_Ordering_Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getDefault_Ordering_Unit_of_Measure_Reference()
    {
        return $this->Default_Ordering_Unit_of_Measure_Reference;
    }
    /**
     * Set Default_Ordering_Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $default_Ordering_Unit_of_Measure_Reference
     * @return \StructType\Catalog_Item_for_Internal_Catalog_DataType
     */
    public function setDefault_Ordering_Unit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $default_Ordering_Unit_of_Measure_Reference = null)
    {
        $this->Default_Ordering_Unit_of_Measure_Reference = $default_Ordering_Unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Base_Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getBase_Unit_of_Measure_Reference()
    {
        return $this->Base_Unit_of_Measure_Reference;
    }
    /**
     * Set Base_Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $base_Unit_of_Measure_Reference
     * @return \StructType\Catalog_Item_for_Internal_Catalog_DataType
     */
    public function setBase_Unit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $base_Unit_of_Measure_Reference = null)
    {
        $this->Base_Unit_of_Measure_Reference = $base_Unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Catalog_Item_for_Internal_Catalog_DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Catalog_Item_for_Internal_Catalog_DataType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get Lead_Time value
     * @return float|null
     */
    public function getLead_Time()
    {
        return $this->Lead_Time;
    }
    /**
     * Set Lead_Time value
     * @param float $lead_Time
     * @return \StructType\Catalog_Item_for_Internal_Catalog_DataType
     */
    public function setLead_Time($lead_Time = null)
    {
        // validation for constraint: float
        if (!is_null($lead_Time) && !(is_float($lead_Time) || is_numeric($lead_Time))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lead_Time, true), gettype($lead_Time)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($lead_Time) && mb_strlen(mb_substr($lead_Time, false !== mb_strpos($lead_Time, '.') ? mb_strpos($lead_Time, '.') + 1 : mb_strlen($lead_Time))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($lead_Time, true), mb_strlen(mb_substr($lead_Time, mb_strpos($lead_Time, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($lead_Time) && $lead_Time < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($lead_Time, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($lead_Time) && mb_strlen(preg_replace('/(\D)/', '', $lead_Time)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($lead_Time, true), mb_strlen(preg_replace('/(\D)/', '', $lead_Time))), __LINE__);
        }
        $this->Lead_Time = $lead_Time;
        return $this;
    }
    /**
     * Get Item_URL value
     * @return string|null
     */
    public function getItem_URL()
    {
        return $this->Item_URL;
    }
    /**
     * Set Item_URL value
     * @param string $item_URL
     * @return \StructType\Catalog_Item_for_Internal_Catalog_DataType
     */
    public function setItem_URL($item_URL = null)
    {
        // validation for constraint: string
        if (!is_null($item_URL) && !is_string($item_URL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_URL, true), gettype($item_URL)), __LINE__);
        }
        $this->Item_URL = $item_URL;
        return $this;
    }
    /**
     * Get Purchase_Item_Reference value
     * @return \StructType\Purchase_ItemObjectType|null
     */
    public function getPurchase_Item_Reference()
    {
        return $this->Purchase_Item_Reference;
    }
    /**
     * Set Purchase_Item_Reference value
     * @param \StructType\Purchase_ItemObjectType $purchase_Item_Reference
     * @return \StructType\Catalog_Item_for_Internal_Catalog_DataType
     */
    public function setPurchase_Item_Reference(\StructType\Purchase_ItemObjectType $purchase_Item_Reference = null)
    {
        $this->Purchase_Item_Reference = $purchase_Item_Reference;
        return $this;
    }
    /**
     * Get Primary_Image_Data value
     * @return \StructType\Primary_Image_DataType|null
     */
    public function getPrimary_Image_Data()
    {
        return $this->Primary_Image_Data;
    }
    /**
     * Set Primary_Image_Data value
     * @param \StructType\Primary_Image_DataType $primary_Image_Data
     * @return \StructType\Catalog_Item_for_Internal_Catalog_DataType
     */
    public function setPrimary_Image_Data(\StructType\Primary_Image_DataType $primary_Image_Data = null)
    {
        $this->Primary_Image_Data = $primary_Image_Data;
        return $this;
    }
    /**
     * Get Additional_Image_Data value
     * @return \StructType\Additional_Image_DataType[]|null
     */
    public function getAdditional_Image_Data()
    {
        return $this->Additional_Image_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditional_Image_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditional_Image_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditional_Image_DataForArrayConstraintsFromSetAdditional_Image_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $catalog_Item_for_Internal_Catalog_DataTypeAdditional_Image_DataItem) {
            // validation for constraint: itemType
            if (!$catalog_Item_for_Internal_Catalog_DataTypeAdditional_Image_DataItem instanceof \StructType\Additional_Image_DataType) {
                $invalidValues[] = is_object($catalog_Item_for_Internal_Catalog_DataTypeAdditional_Image_DataItem) ? get_class($catalog_Item_for_Internal_Catalog_DataTypeAdditional_Image_DataItem) : sprintf('%s(%s)', gettype($catalog_Item_for_Internal_Catalog_DataTypeAdditional_Image_DataItem), var_export($catalog_Item_for_Internal_Catalog_DataTypeAdditional_Image_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Additional_Image_Data property can only contain items of type \StructType\Additional_Image_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Additional_Image_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Additional_Image_DataType[] $additional_Image_Data
     * @return \StructType\Catalog_Item_for_Internal_Catalog_DataType
     */
    public function setAdditional_Image_Data(array $additional_Image_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($additional_Image_DataArrayErrorMessage = self::validateAdditional_Image_DataForArrayConstraintsFromSetAdditional_Image_Data($additional_Image_Data))) {
            throw new \InvalidArgumentException($additional_Image_DataArrayErrorMessage, __LINE__);
        }
        $this->Additional_Image_Data = $additional_Image_Data;
        return $this;
    }
    /**
     * Add item to Additional_Image_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Additional_Image_DataType $item
     * @return \StructType\Catalog_Item_for_Internal_Catalog_DataType
     */
    public function addToAdditional_Image_Data(\StructType\Additional_Image_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Additional_Image_DataType) {
            throw new \InvalidArgumentException(sprintf('The Additional_Image_Data property can only contain items of type \StructType\Additional_Image_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Additional_Image_Data[] = $item;
        return $this;
    }
    /**
     * Get UOM_Pricing_History value
     * @return \StructType\Catalog_Item_Data_for_Catalog_DataType[]|null
     */
    public function getUOM_Pricing_History()
    {
        return $this->UOM_Pricing_History;
    }
    /**
     * This method is responsible for validating the values passed to the setUOM_Pricing_History method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUOM_Pricing_History method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUOM_Pricing_HistoryForArrayConstraintsFromSetUOM_Pricing_History(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $catalog_Item_for_Internal_Catalog_DataTypeUOM_Pricing_HistoryItem) {
            // validation for constraint: itemType
            if (!$catalog_Item_for_Internal_Catalog_DataTypeUOM_Pricing_HistoryItem instanceof \StructType\Catalog_Item_Data_for_Catalog_DataType) {
                $invalidValues[] = is_object($catalog_Item_for_Internal_Catalog_DataTypeUOM_Pricing_HistoryItem) ? get_class($catalog_Item_for_Internal_Catalog_DataTypeUOM_Pricing_HistoryItem) : sprintf('%s(%s)', gettype($catalog_Item_for_Internal_Catalog_DataTypeUOM_Pricing_HistoryItem), var_export($catalog_Item_for_Internal_Catalog_DataTypeUOM_Pricing_HistoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UOM_Pricing_History property can only contain items of type \StructType\Catalog_Item_Data_for_Catalog_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UOM_Pricing_History value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Item_Data_for_Catalog_DataType[] $uOM_Pricing_History
     * @return \StructType\Catalog_Item_for_Internal_Catalog_DataType
     */
    public function setUOM_Pricing_History(array $uOM_Pricing_History = array())
    {
        // validation for constraint: array
        if ('' !== ($uOM_Pricing_HistoryArrayErrorMessage = self::validateUOM_Pricing_HistoryForArrayConstraintsFromSetUOM_Pricing_History($uOM_Pricing_History))) {
            throw new \InvalidArgumentException($uOM_Pricing_HistoryArrayErrorMessage, __LINE__);
        }
        $this->UOM_Pricing_History = $uOM_Pricing_History;
        return $this;
    }
    /**
     * Add item to UOM_Pricing_History value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Item_Data_for_Catalog_DataType $item
     * @return \StructType\Catalog_Item_for_Internal_Catalog_DataType
     */
    public function addToUOM_Pricing_History(\StructType\Catalog_Item_Data_for_Catalog_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Catalog_Item_Data_for_Catalog_DataType) {
            throw new \InvalidArgumentException(sprintf('The UOM_Pricing_History property can only contain items of type \StructType\Catalog_Item_Data_for_Catalog_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UOM_Pricing_History[] = $item;
        return $this;
    }
}
