<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Catalog_Item_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Catalog Item Request Criteria
 * @subpackage Structs
 */
class Catalog_Item_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Catalog_Item_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Catalog_Item_Identifier;
    /**
     * The Catalog_Item_Supplier_Order_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Order Contract for Catalog Items
     * - choice: Catalog_Item_Supplier_Order_Contract_Reference | Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference | Resource_Provider_for_Supplier_Order_Contract_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Catalog_Item_Supplier_Order_Contract_Reference;
    /**
     * The Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company or Company Hierarchy for Supplier Order Contracts for Catalog Items
     * - choice: Catalog_Item_Supplier_Order_Contract_Reference | Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference | Resource_Provider_for_Supplier_Order_Contract_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType
     */
    public $Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference;
    /**
     * The Resource_Provider_for_Supplier_Order_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resource Provider for Supplier Order Contracts for Catalog Items
     * - choice: Catalog_Item_Supplier_Order_Contract_Reference | Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference | Resource_Provider_for_Supplier_Order_Contract_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType[]
     */
    public $Resource_Provider_for_Supplier_Order_Contract_Reference;
    /**
     * The Supplier_Catalogs_for_Catalog_Items_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Catalogs for Catalog Items
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_CatalogObjectType[]
     */
    public $Supplier_Catalogs_for_Catalog_Items_Reference;
    /**
     * Constructor method for Catalog_Item_Request_CriteriaType
     * @uses Catalog_Item_Request_CriteriaType::setCatalog_Item_Identifier()
     * @uses Catalog_Item_Request_CriteriaType::setCatalog_Item_Supplier_Order_Contract_Reference()
     * @uses Catalog_Item_Request_CriteriaType::setCompany_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference()
     * @uses Catalog_Item_Request_CriteriaType::setResource_Provider_for_Supplier_Order_Contract_Reference()
     * @uses Catalog_Item_Request_CriteriaType::setSupplier_Catalogs_for_Catalog_Items_Reference()
     * @param string $catalog_Item_Identifier
     * @param \StructType\Supplier_ContractObjectType $catalog_Item_Supplier_Order_Contract_Reference
     * @param \StructType\OrganizationObjectType $company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference
     * @param \StructType\Resource_ProviderObjectType[] $resource_Provider_for_Supplier_Order_Contract_Reference
     * @param \StructType\Supplier_CatalogObjectType[] $supplier_Catalogs_for_Catalog_Items_Reference
     */
    public function __construct($catalog_Item_Identifier = null, \StructType\Supplier_ContractObjectType $catalog_Item_Supplier_Order_Contract_Reference = null, \StructType\OrganizationObjectType $company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference = null, array $resource_Provider_for_Supplier_Order_Contract_Reference = array(), array $supplier_Catalogs_for_Catalog_Items_Reference = array())
    {
        $this
            ->setCatalog_Item_Identifier($catalog_Item_Identifier)
            ->setCatalog_Item_Supplier_Order_Contract_Reference($catalog_Item_Supplier_Order_Contract_Reference)
            ->setCompany_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference($company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference)
            ->setResource_Provider_for_Supplier_Order_Contract_Reference($resource_Provider_for_Supplier_Order_Contract_Reference)
            ->setSupplier_Catalogs_for_Catalog_Items_Reference($supplier_Catalogs_for_Catalog_Items_Reference);
    }
    /**
     * Get Catalog_Item_Identifier value
     * @return string|null
     */
    public function getCatalog_Item_Identifier()
    {
        return $this->Catalog_Item_Identifier;
    }
    /**
     * Set Catalog_Item_Identifier value
     * @param string $catalog_Item_Identifier
     * @return \StructType\Catalog_Item_Request_CriteriaType
     */
    public function setCatalog_Item_Identifier($catalog_Item_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($catalog_Item_Identifier) && !is_string($catalog_Item_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catalog_Item_Identifier, true), gettype($catalog_Item_Identifier)), __LINE__);
        }
        $this->Catalog_Item_Identifier = $catalog_Item_Identifier;
        return $this;
    }
    /**
     * Get Catalog_Item_Supplier_Order_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getCatalog_Item_Supplier_Order_Contract_Reference()
    {
        return isset($this->Catalog_Item_Supplier_Order_Contract_Reference) ? $this->Catalog_Item_Supplier_Order_Contract_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCatalog_Item_Supplier_Order_Contract_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCatalog_Item_Supplier_Order_Contract_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCatalog_Item_Supplier_Order_Contract_ReferenceForChoiceConstraintsFromSetCatalog_Item_Supplier_Order_Contract_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference',
            'Resource_Provider_for_Supplier_Order_Contract_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Catalog_Item_Supplier_Order_Contract_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Catalog_Item_Supplier_Order_Contract_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Catalog_Item_Supplier_Order_Contract_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ContractObjectType $catalog_Item_Supplier_Order_Contract_Reference
     * @return \StructType\Catalog_Item_Request_CriteriaType
     */
    public function setCatalog_Item_Supplier_Order_Contract_Reference(\StructType\Supplier_ContractObjectType $catalog_Item_Supplier_Order_Contract_Reference = null)
    {
        // validation for constraint: choice(Catalog_Item_Supplier_Order_Contract_Reference, Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference, Resource_Provider_for_Supplier_Order_Contract_Reference)
        if ('' !== ($catalog_Item_Supplier_Order_Contract_ReferenceChoiceErrorMessage = self::validateCatalog_Item_Supplier_Order_Contract_ReferenceForChoiceConstraintsFromSetCatalog_Item_Supplier_Order_Contract_Reference($catalog_Item_Supplier_Order_Contract_Reference))) {
            throw new \InvalidArgumentException($catalog_Item_Supplier_Order_Contract_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($catalog_Item_Supplier_Order_Contract_Reference) || (is_array($catalog_Item_Supplier_Order_Contract_Reference) && empty($catalog_Item_Supplier_Order_Contract_Reference))) {
            unset($this->Catalog_Item_Supplier_Order_Contract_Reference);
        } else {
            $this->Catalog_Item_Supplier_Order_Contract_Reference = $catalog_Item_Supplier_Order_Contract_Reference;
        }
        return $this;
    }
    /**
     * Get Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference value
     * @return \StructType\OrganizationObjectType|null
     */
    public function getCompany_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference()
    {
        return isset($this->Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference) ? $this->Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCompany_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCompany_or_Company_Hierarchy_for_Supplier_Order_Contract_ReferenceForChoiceConstraintsFromSetCompany_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Catalog_Item_Supplier_Order_Contract_Reference',
            'Resource_Provider_for_Supplier_Order_Contract_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference
     * @return \StructType\Catalog_Item_Request_CriteriaType
     */
    public function setCompany_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference(\StructType\OrganizationObjectType $company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference = null)
    {
        // validation for constraint: choice(Catalog_Item_Supplier_Order_Contract_Reference, Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference, Resource_Provider_for_Supplier_Order_Contract_Reference)
        if ('' !== ($company_or_Company_Hierarchy_for_Supplier_Order_Contract_ReferenceChoiceErrorMessage = self::validateCompany_or_Company_Hierarchy_for_Supplier_Order_Contract_ReferenceForChoiceConstraintsFromSetCompany_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference($company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference))) {
            throw new \InvalidArgumentException($company_or_Company_Hierarchy_for_Supplier_Order_Contract_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference) || (is_array($company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference) && empty($company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference))) {
            unset($this->Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference);
        } else {
            $this->Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference = $company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference;
        }
        return $this;
    }
    /**
     * Get Resource_Provider_for_Supplier_Order_Contract_Reference value
     * @return \StructType\Resource_ProviderObjectType[]|null
     */
    public function getResource_Provider_for_Supplier_Order_Contract_Reference()
    {
        return isset($this->Resource_Provider_for_Supplier_Order_Contract_Reference) ? $this->Resource_Provider_for_Supplier_Order_Contract_Reference : null;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Provider_for_Supplier_Order_Contract_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Provider_for_Supplier_Order_Contract_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_Provider_for_Supplier_Order_Contract_ReferenceForArrayConstraintsFromSetResource_Provider_for_Supplier_Order_Contract_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $catalog_Item_Request_CriteriaTypeResource_Provider_for_Supplier_Order_Contract_ReferenceItem) {
            // validation for constraint: itemType
            if (!$catalog_Item_Request_CriteriaTypeResource_Provider_for_Supplier_Order_Contract_ReferenceItem instanceof \StructType\Resource_ProviderObjectType) {
                $invalidValues[] = is_object($catalog_Item_Request_CriteriaTypeResource_Provider_for_Supplier_Order_Contract_ReferenceItem) ? get_class($catalog_Item_Request_CriteriaTypeResource_Provider_for_Supplier_Order_Contract_ReferenceItem) : sprintf('%s(%s)', gettype($catalog_Item_Request_CriteriaTypeResource_Provider_for_Supplier_Order_Contract_ReferenceItem), var_export($catalog_Item_Request_CriteriaTypeResource_Provider_for_Supplier_Order_Contract_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Provider_for_Supplier_Order_Contract_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setResource_Provider_for_Supplier_Order_Contract_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Provider_for_Supplier_Order_Contract_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateResource_Provider_for_Supplier_Order_Contract_ReferenceForChoiceConstraintsFromSetResource_Provider_for_Supplier_Order_Contract_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Catalog_Item_Supplier_Order_Contract_Reference',
            'Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Resource_Provider_for_Supplier_Order_Contract_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Resource_Provider_for_Supplier_Order_Contract_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Resource_Provider_for_Supplier_Order_Contract_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType[] $resource_Provider_for_Supplier_Order_Contract_Reference
     * @return \StructType\Catalog_Item_Request_CriteriaType
     */
    public function setResource_Provider_for_Supplier_Order_Contract_Reference(array $resource_Provider_for_Supplier_Order_Contract_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_Provider_for_Supplier_Order_Contract_ReferenceArrayErrorMessage = self::validateResource_Provider_for_Supplier_Order_Contract_ReferenceForArrayConstraintsFromSetResource_Provider_for_Supplier_Order_Contract_Reference($resource_Provider_for_Supplier_Order_Contract_Reference))) {
            throw new \InvalidArgumentException($resource_Provider_for_Supplier_Order_Contract_ReferenceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Catalog_Item_Supplier_Order_Contract_Reference, Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference, Resource_Provider_for_Supplier_Order_Contract_Reference)
        if ('' !== ($resource_Provider_for_Supplier_Order_Contract_ReferenceChoiceErrorMessage = self::validateResource_Provider_for_Supplier_Order_Contract_ReferenceForChoiceConstraintsFromSetResource_Provider_for_Supplier_Order_Contract_Reference($resource_Provider_for_Supplier_Order_Contract_Reference))) {
            throw new \InvalidArgumentException($resource_Provider_for_Supplier_Order_Contract_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($resource_Provider_for_Supplier_Order_Contract_Reference) || (is_array($resource_Provider_for_Supplier_Order_Contract_Reference) && empty($resource_Provider_for_Supplier_Order_Contract_Reference))) {
            unset($this->Resource_Provider_for_Supplier_Order_Contract_Reference);
        } else {
            $this->Resource_Provider_for_Supplier_Order_Contract_Reference = $resource_Provider_for_Supplier_Order_Contract_Reference;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToResource_Provider_for_Supplier_Order_Contract_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToResource_Provider_for_Supplier_Order_Contract_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToResource_Provider_for_Supplier_Order_Contract_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Catalog_Item_Supplier_Order_Contract_Reference',
            'Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Resource_Provider_for_Supplier_Order_Contract_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Resource_Provider_for_Supplier_Order_Contract_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Resource_Provider_for_Supplier_Order_Contract_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType $item
     * @return \StructType\Catalog_Item_Request_CriteriaType
     */
    public function addToResource_Provider_for_Supplier_Order_Contract_Reference(\StructType\Resource_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Provider_for_Supplier_Order_Contract_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Catalog_Item_Supplier_Order_Contract_Reference, Company_or_Company_Hierarchy_for_Supplier_Order_Contract_Reference, Resource_Provider_for_Supplier_Order_Contract_Reference)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToResource_Provider_for_Supplier_Order_Contract_Reference($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Resource_Provider_for_Supplier_Order_Contract_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Catalogs_for_Catalog_Items_Reference value
     * @return \StructType\Supplier_CatalogObjectType[]|null
     */
    public function getSupplier_Catalogs_for_Catalog_Items_Reference()
    {
        return $this->Supplier_Catalogs_for_Catalog_Items_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Catalogs_for_Catalog_Items_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Catalogs_for_Catalog_Items_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Catalogs_for_Catalog_Items_ReferenceForArrayConstraintsFromSetSupplier_Catalogs_for_Catalog_Items_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $catalog_Item_Request_CriteriaTypeSupplier_Catalogs_for_Catalog_Items_ReferenceItem) {
            // validation for constraint: itemType
            if (!$catalog_Item_Request_CriteriaTypeSupplier_Catalogs_for_Catalog_Items_ReferenceItem instanceof \StructType\Supplier_CatalogObjectType) {
                $invalidValues[] = is_object($catalog_Item_Request_CriteriaTypeSupplier_Catalogs_for_Catalog_Items_ReferenceItem) ? get_class($catalog_Item_Request_CriteriaTypeSupplier_Catalogs_for_Catalog_Items_ReferenceItem) : sprintf('%s(%s)', gettype($catalog_Item_Request_CriteriaTypeSupplier_Catalogs_for_Catalog_Items_ReferenceItem), var_export($catalog_Item_Request_CriteriaTypeSupplier_Catalogs_for_Catalog_Items_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Catalogs_for_Catalog_Items_Reference property can only contain items of type \StructType\Supplier_CatalogObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Catalogs_for_Catalog_Items_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_CatalogObjectType[] $supplier_Catalogs_for_Catalog_Items_Reference
     * @return \StructType\Catalog_Item_Request_CriteriaType
     */
    public function setSupplier_Catalogs_for_Catalog_Items_Reference(array $supplier_Catalogs_for_Catalog_Items_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Catalogs_for_Catalog_Items_ReferenceArrayErrorMessage = self::validateSupplier_Catalogs_for_Catalog_Items_ReferenceForArrayConstraintsFromSetSupplier_Catalogs_for_Catalog_Items_Reference($supplier_Catalogs_for_Catalog_Items_Reference))) {
            throw new \InvalidArgumentException($supplier_Catalogs_for_Catalog_Items_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Catalogs_for_Catalog_Items_Reference = $supplier_Catalogs_for_Catalog_Items_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Catalogs_for_Catalog_Items_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_CatalogObjectType $item
     * @return \StructType\Catalog_Item_Request_CriteriaType
     */
    public function addToSupplier_Catalogs_for_Catalog_Items_Reference(\StructType\Supplier_CatalogObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_CatalogObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Catalogs_for_Catalog_Items_Reference property can only contain items of type \StructType\Supplier_CatalogObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Catalogs_for_Catalog_Items_Reference[] = $item;
        return $this;
    }
}
