<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cash_Advance_RepaymentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Cash Advance Repayment contains all of the information about a Cash Advance Repayment
 * @subpackage Structs
 */
class Cash_Advance_RepaymentType extends AbstractStructBase
{
    /**
     * The Cash_Advance_Repayment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a specific Cash Advance Repayment
     * - minOccurs: 0
     * @var \StructType\Cash_Advance_RepaymentObjectType
     */
    public $Cash_Advance_Repayment_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company for Cash Advance Repayment
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Spend_Authorization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Required field representing the Spend Authorization being repaid by the Cash Advance Repayment.
     * - minOccurs: 0
     * @var \StructType\Spend_AuthorizationObjectType
     */
    public $Spend_Authorization_Reference;
    /**
     * The Expense_Payee_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the person who the cash advance repayment is for.
     * - minOccurs: 0
     * @var \StructType\Expense_PayeeObjectType
     */
    public $Expense_Payee_Reference;
    /**
     * The Expense_Payee_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Expense Payee Type on the Spend Authorization - Employee, Contingent Worker, or External Committee Member.
     * - minOccurs: 0
     * @var \StructType\Payee_TypeObjectType
     */
    public $Expense_Payee_Type_Reference;
    /**
     * The Repayment_Date
     * Meta information extracted from the WSDL
     * - documentation: The date the Cash Advance Repayment is being recorded
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Repayment_Date;
    /**
     * The Repayment_Amount
     * Meta information extracted from the WSDL
     * - documentation: Amount being repaid with this Cash Advance Repayment | Repayment Amount
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Repayment_Amount;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency for the Cash Advance Repayment. Restricted to Company or Spend Authorization currency
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payment Type for the Cash Advance Repayment
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType
     */
    public $Payment_Type_Reference;
    /**
     * The Repayment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference information for the Cash Advance Repayment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Repayment_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for Cash Advance Repayment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Credit_to_Expense_Advance_Account
     * Meta information extracted from the WSDL
     * - documentation: Amount to Credit Expense Advance Account
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Credit_to_Expense_Advance_Account;
    /**
     * The Balancing_Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Balancing Worktag
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Audited_Accounting_WorktagObjectType[]
     */
    public $Balancing_Worktag_Reference;
    /**
     * The Currency_Exchange_Gain__Loss__to_Record
     * Meta information extracted from the WSDL
     * - documentation: Currency Gain (Loss) to Record
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency_Exchange_Gain__Loss__to_Record;
    /**
     * Constructor method for Cash_Advance_RepaymentType
     * @uses Cash_Advance_RepaymentType::setCash_Advance_Repayment_Reference()
     * @uses Cash_Advance_RepaymentType::setCompany_Reference()
     * @uses Cash_Advance_RepaymentType::setSpend_Authorization_Reference()
     * @uses Cash_Advance_RepaymentType::setExpense_Payee_Reference()
     * @uses Cash_Advance_RepaymentType::setExpense_Payee_Type_Reference()
     * @uses Cash_Advance_RepaymentType::setRepayment_Date()
     * @uses Cash_Advance_RepaymentType::setRepayment_Amount()
     * @uses Cash_Advance_RepaymentType::setCurrency_Reference()
     * @uses Cash_Advance_RepaymentType::setPayment_Type_Reference()
     * @uses Cash_Advance_RepaymentType::setRepayment_Reference()
     * @uses Cash_Advance_RepaymentType::setMemo()
     * @uses Cash_Advance_RepaymentType::setCredit_to_Expense_Advance_Account()
     * @uses Cash_Advance_RepaymentType::setBalancing_Worktag_Reference()
     * @uses Cash_Advance_RepaymentType::setCurrency_Exchange_Gain__Loss__to_Record()
     * @param \StructType\Cash_Advance_RepaymentObjectType $cash_Advance_Repayment_Reference
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference
     * @param \StructType\Expense_PayeeObjectType $expense_Payee_Reference
     * @param \StructType\Payee_TypeObjectType $expense_Payee_Type_Reference
     * @param string $repayment_Date
     * @param float $repayment_Amount
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Payment_TypeObjectType $payment_Type_Reference
     * @param string $repayment_Reference
     * @param string $memo
     * @param string $credit_to_Expense_Advance_Account
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $balancing_Worktag_Reference
     * @param string $currency_Exchange_Gain__Loss__to_Record
     */
    public function __construct(\StructType\Cash_Advance_RepaymentObjectType $cash_Advance_Repayment_Reference = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference = null, \StructType\Expense_PayeeObjectType $expense_Payee_Reference = null, \StructType\Payee_TypeObjectType $expense_Payee_Type_Reference = null, $repayment_Date = null, $repayment_Amount = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Payment_TypeObjectType $payment_Type_Reference = null, $repayment_Reference = null, $memo = null, $credit_to_Expense_Advance_Account = null, array $balancing_Worktag_Reference = array(), $currency_Exchange_Gain__Loss__to_Record = null)
    {
        $this
            ->setCash_Advance_Repayment_Reference($cash_Advance_Repayment_Reference)
            ->setCompany_Reference($company_Reference)
            ->setSpend_Authorization_Reference($spend_Authorization_Reference)
            ->setExpense_Payee_Reference($expense_Payee_Reference)
            ->setExpense_Payee_Type_Reference($expense_Payee_Type_Reference)
            ->setRepayment_Date($repayment_Date)
            ->setRepayment_Amount($repayment_Amount)
            ->setCurrency_Reference($currency_Reference)
            ->setPayment_Type_Reference($payment_Type_Reference)
            ->setRepayment_Reference($repayment_Reference)
            ->setMemo($memo)
            ->setCredit_to_Expense_Advance_Account($credit_to_Expense_Advance_Account)
            ->setBalancing_Worktag_Reference($balancing_Worktag_Reference)
            ->setCurrency_Exchange_Gain__Loss__to_Record($currency_Exchange_Gain__Loss__to_Record);
    }
    /**
     * Get Cash_Advance_Repayment_Reference value
     * @return \StructType\Cash_Advance_RepaymentObjectType|null
     */
    public function getCash_Advance_Repayment_Reference()
    {
        return $this->Cash_Advance_Repayment_Reference;
    }
    /**
     * Set Cash_Advance_Repayment_Reference value
     * @param \StructType\Cash_Advance_RepaymentObjectType $cash_Advance_Repayment_Reference
     * @return \StructType\Cash_Advance_RepaymentType
     */
    public function setCash_Advance_Repayment_Reference(\StructType\Cash_Advance_RepaymentObjectType $cash_Advance_Repayment_Reference = null)
    {
        $this->Cash_Advance_Repayment_Reference = $cash_Advance_Repayment_Reference;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Cash_Advance_RepaymentType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Spend_Authorization_Reference value
     * @return \StructType\Spend_AuthorizationObjectType|null
     */
    public function getSpend_Authorization_Reference()
    {
        return $this->Spend_Authorization_Reference;
    }
    /**
     * Set Spend_Authorization_Reference value
     * @param \StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference
     * @return \StructType\Cash_Advance_RepaymentType
     */
    public function setSpend_Authorization_Reference(\StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference = null)
    {
        $this->Spend_Authorization_Reference = $spend_Authorization_Reference;
        return $this;
    }
    /**
     * Get Expense_Payee_Reference value
     * @return \StructType\Expense_PayeeObjectType|null
     */
    public function getExpense_Payee_Reference()
    {
        return $this->Expense_Payee_Reference;
    }
    /**
     * Set Expense_Payee_Reference value
     * @param \StructType\Expense_PayeeObjectType $expense_Payee_Reference
     * @return \StructType\Cash_Advance_RepaymentType
     */
    public function setExpense_Payee_Reference(\StructType\Expense_PayeeObjectType $expense_Payee_Reference = null)
    {
        $this->Expense_Payee_Reference = $expense_Payee_Reference;
        return $this;
    }
    /**
     * Get Expense_Payee_Type_Reference value
     * @return \StructType\Payee_TypeObjectType|null
     */
    public function getExpense_Payee_Type_Reference()
    {
        return $this->Expense_Payee_Type_Reference;
    }
    /**
     * Set Expense_Payee_Type_Reference value
     * @param \StructType\Payee_TypeObjectType $expense_Payee_Type_Reference
     * @return \StructType\Cash_Advance_RepaymentType
     */
    public function setExpense_Payee_Type_Reference(\StructType\Payee_TypeObjectType $expense_Payee_Type_Reference = null)
    {
        $this->Expense_Payee_Type_Reference = $expense_Payee_Type_Reference;
        return $this;
    }
    /**
     * Get Repayment_Date value
     * @return string|null
     */
    public function getRepayment_Date()
    {
        return $this->Repayment_Date;
    }
    /**
     * Set Repayment_Date value
     * @param string $repayment_Date
     * @return \StructType\Cash_Advance_RepaymentType
     */
    public function setRepayment_Date($repayment_Date = null)
    {
        // validation for constraint: string
        if (!is_null($repayment_Date) && !is_string($repayment_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repayment_Date, true), gettype($repayment_Date)), __LINE__);
        }
        $this->Repayment_Date = $repayment_Date;
        return $this;
    }
    /**
     * Get Repayment_Amount value
     * @return float|null
     */
    public function getRepayment_Amount()
    {
        return $this->Repayment_Amount;
    }
    /**
     * Set Repayment_Amount value
     * @param float $repayment_Amount
     * @return \StructType\Cash_Advance_RepaymentType
     */
    public function setRepayment_Amount($repayment_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($repayment_Amount) && !(is_float($repayment_Amount) || is_numeric($repayment_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($repayment_Amount, true), gettype($repayment_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($repayment_Amount) && mb_strlen(mb_substr($repayment_Amount, false !== mb_strpos($repayment_Amount, '.') ? mb_strpos($repayment_Amount, '.') + 1 : mb_strlen($repayment_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($repayment_Amount, true), mb_strlen(mb_substr($repayment_Amount, mb_strpos($repayment_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($repayment_Amount) && $repayment_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($repayment_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($repayment_Amount) && mb_strlen(preg_replace('/(\D)/', '', $repayment_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($repayment_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $repayment_Amount))), __LINE__);
        }
        $this->Repayment_Amount = $repayment_Amount;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Cash_Advance_RepaymentType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getPayment_Type_Reference()
    {
        return $this->Payment_Type_Reference;
    }
    /**
     * Set Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $payment_Type_Reference
     * @return \StructType\Cash_Advance_RepaymentType
     */
    public function setPayment_Type_Reference(\StructType\Payment_TypeObjectType $payment_Type_Reference = null)
    {
        $this->Payment_Type_Reference = $payment_Type_Reference;
        return $this;
    }
    /**
     * Get Repayment_Reference value
     * @return string|null
     */
    public function getRepayment_Reference()
    {
        return $this->Repayment_Reference;
    }
    /**
     * Set Repayment_Reference value
     * @param string $repayment_Reference
     * @return \StructType\Cash_Advance_RepaymentType
     */
    public function setRepayment_Reference($repayment_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($repayment_Reference) && !is_string($repayment_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repayment_Reference, true), gettype($repayment_Reference)), __LINE__);
        }
        $this->Repayment_Reference = $repayment_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Cash_Advance_RepaymentType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Credit_to_Expense_Advance_Account value
     * @return string|null
     */
    public function getCredit_to_Expense_Advance_Account()
    {
        return $this->Credit_to_Expense_Advance_Account;
    }
    /**
     * Set Credit_to_Expense_Advance_Account value
     * @param string $credit_to_Expense_Advance_Account
     * @return \StructType\Cash_Advance_RepaymentType
     */
    public function setCredit_to_Expense_Advance_Account($credit_to_Expense_Advance_Account = null)
    {
        // validation for constraint: string
        if (!is_null($credit_to_Expense_Advance_Account) && !is_string($credit_to_Expense_Advance_Account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credit_to_Expense_Advance_Account, true), gettype($credit_to_Expense_Advance_Account)), __LINE__);
        }
        $this->Credit_to_Expense_Advance_Account = $credit_to_Expense_Advance_Account;
        return $this;
    }
    /**
     * Get Balancing_Worktag_Reference value
     * @return \StructType\Audited_Accounting_WorktagObjectType[]|null
     */
    public function getBalancing_Worktag_Reference()
    {
        return $this->Balancing_Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setBalancing_Worktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBalancing_Worktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBalancing_Worktag_ReferenceForArrayConstraintsFromSetBalancing_Worktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cash_Advance_RepaymentTypeBalancing_Worktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$cash_Advance_RepaymentTypeBalancing_Worktag_ReferenceItem instanceof \StructType\Audited_Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($cash_Advance_RepaymentTypeBalancing_Worktag_ReferenceItem) ? get_class($cash_Advance_RepaymentTypeBalancing_Worktag_ReferenceItem) : sprintf('%s(%s)', gettype($cash_Advance_RepaymentTypeBalancing_Worktag_ReferenceItem), var_export($cash_Advance_RepaymentTypeBalancing_Worktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Balancing_Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Balancing_Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $balancing_Worktag_Reference
     * @return \StructType\Cash_Advance_RepaymentType
     */
    public function setBalancing_Worktag_Reference(array $balancing_Worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($balancing_Worktag_ReferenceArrayErrorMessage = self::validateBalancing_Worktag_ReferenceForArrayConstraintsFromSetBalancing_Worktag_Reference($balancing_Worktag_Reference))) {
            throw new \InvalidArgumentException($balancing_Worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Balancing_Worktag_Reference = $balancing_Worktag_Reference;
        return $this;
    }
    /**
     * Add item to Balancing_Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType $item
     * @return \StructType\Cash_Advance_RepaymentType
     */
    public function addToBalancing_Worktag_Reference(\StructType\Audited_Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Audited_Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Balancing_Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Balancing_Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Currency_Exchange_Gain__Loss__to_Record value
     * @return string|null
     */
    public function getCurrency_Exchange_Gain__Loss__to_Record()
    {
        return $this->Currency_Exchange_Gain__Loss__to_Record;
    }
    /**
     * Set Currency_Exchange_Gain__Loss__to_Record value
     * @param string $currency_Exchange_Gain__Loss__to_Record
     * @return \StructType\Cash_Advance_RepaymentType
     */
    public function setCurrency_Exchange_Gain__Loss__to_Record($currency_Exchange_Gain__Loss__to_Record = null)
    {
        // validation for constraint: string
        if (!is_null($currency_Exchange_Gain__Loss__to_Record) && !is_string($currency_Exchange_Gain__Loss__to_Record)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency_Exchange_Gain__Loss__to_Record, true), gettype($currency_Exchange_Gain__Loss__to_Record)), __LINE__);
        }
        $this->Currency_Exchange_Gain__Loss__to_Record = $currency_Exchange_Gain__Loss__to_Record;
        return $this;
    }
}
