<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cancel_Purchase_Order_Acknowledgement_ResponseType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that shows the response of the Purchase Order Acknowledgement to be canceled
 * @subpackage Structs
 */
class Cancel_Purchase_Order_Acknowledgement_ResponseType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Acknowledgement_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Acknowledgement Data
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_AcknowledgementObjectType
     */
    public $Purchase_Order_Acknowledgement_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Cancel_Purchase_Order_Acknowledgement_ResponseType
     * @uses Cancel_Purchase_Order_Acknowledgement_ResponseType::setPurchase_Order_Acknowledgement_Reference()
     * @uses Cancel_Purchase_Order_Acknowledgement_ResponseType::setVersion()
     * @param \StructType\Purchase_Order_AcknowledgementObjectType $purchase_Order_Acknowledgement_Reference
     * @param string $version
     */
    public function __construct(\StructType\Purchase_Order_AcknowledgementObjectType $purchase_Order_Acknowledgement_Reference = null, $version = null)
    {
        $this
            ->setPurchase_Order_Acknowledgement_Reference($purchase_Order_Acknowledgement_Reference)
            ->setVersion($version);
    }
    /**
     * Get Purchase_Order_Acknowledgement_Reference value
     * @return \StructType\Purchase_Order_AcknowledgementObjectType|null
     */
    public function getPurchase_Order_Acknowledgement_Reference()
    {
        return $this->Purchase_Order_Acknowledgement_Reference;
    }
    /**
     * Set Purchase_Order_Acknowledgement_Reference value
     * @param \StructType\Purchase_Order_AcknowledgementObjectType $purchase_Order_Acknowledgement_Reference
     * @return \StructType\Cancel_Purchase_Order_Acknowledgement_ResponseType
     */
    public function setPurchase_Order_Acknowledgement_Reference(\StructType\Purchase_Order_AcknowledgementObjectType $purchase_Order_Acknowledgement_Reference = null)
    {
        $this->Purchase_Order_Acknowledgement_Reference = $purchase_Order_Acknowledgement_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Cancel_Purchase_Order_Acknowledgement_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
