<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Business_Entity_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Usage Type is Invalid for this Contactable. | Business Entity Data Element which is a wrapper for all business entity data of name and contract information
 * @subpackage Structs
 */
class Business_Entity_WWS_DataType extends AbstractStructBase
{
    /**
     * The Business_Entity_Name
     * Meta information extracted from the WSDL
     * - documentation: Business Entity Name is the name for the business entity. Business entities can not be duplicated across different business entity types, ie: a Customer can not have the same name as a Financial Institution unless they share the
     * Business Entity.
     * - maxOccurs: 1
     * @var string
     */
    public $Business_Entity_Name;
    /**
     * The Business_Entity_Phonetic_Name
     * Meta information extracted from the WSDL
     * - documentation: Business Entity Furigana
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Business_Entity_Phonetic_Name;
    /**
     * The Business_Entity_Tax_ID
     * Meta information extracted from the WSDL
     * - documentation: Business Entity Tax ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Business_Entity_Tax_ID;
    /**
     * The External_Entity_ID
     * Meta information extracted from the WSDL
     * - documentation: External Entity ID. The External Entity ID can be used as a non unique reference to the same Business Entity in an external system.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Entity_ID;
    /**
     * The Contact_Data
     * Meta information extracted from the WSDL
     * - documentation: Contact Information Data
     * - minOccurs: 0
     * @var \StructType\Contact_Information_DataType
     */
    public $Contact_Data;
    /**
     * The Business_Entity_Logo_Image_Data
     * Meta information extracted from the WSDL
     * - documentation: Business Entity Logo Image Data is the logo data for the Business entity including filename and mime formatted image
     * - minOccurs: 0
     * @var \StructType\Business_Entity_Logo_Image_DataType
     */
    public $Business_Entity_Logo_Image_Data;
    /**
     * Constructor method for Business_Entity_WWS_DataType
     * @uses Business_Entity_WWS_DataType::setBusiness_Entity_Name()
     * @uses Business_Entity_WWS_DataType::setBusiness_Entity_Phonetic_Name()
     * @uses Business_Entity_WWS_DataType::setBusiness_Entity_Tax_ID()
     * @uses Business_Entity_WWS_DataType::setExternal_Entity_ID()
     * @uses Business_Entity_WWS_DataType::setContact_Data()
     * @uses Business_Entity_WWS_DataType::setBusiness_Entity_Logo_Image_Data()
     * @param string $business_Entity_Name
     * @param string $business_Entity_Phonetic_Name
     * @param string $business_Entity_Tax_ID
     * @param string $external_Entity_ID
     * @param \StructType\Contact_Information_DataType $contact_Data
     * @param \StructType\Business_Entity_Logo_Image_DataType $business_Entity_Logo_Image_Data
     */
    public function __construct($business_Entity_Name = null, $business_Entity_Phonetic_Name = null, $business_Entity_Tax_ID = null, $external_Entity_ID = null, \StructType\Contact_Information_DataType $contact_Data = null, \StructType\Business_Entity_Logo_Image_DataType $business_Entity_Logo_Image_Data = null)
    {
        $this
            ->setBusiness_Entity_Name($business_Entity_Name)
            ->setBusiness_Entity_Phonetic_Name($business_Entity_Phonetic_Name)
            ->setBusiness_Entity_Tax_ID($business_Entity_Tax_ID)
            ->setExternal_Entity_ID($external_Entity_ID)
            ->setContact_Data($contact_Data)
            ->setBusiness_Entity_Logo_Image_Data($business_Entity_Logo_Image_Data);
    }
    /**
     * Get Business_Entity_Name value
     * @return string|null
     */
    public function getBusiness_Entity_Name()
    {
        return $this->Business_Entity_Name;
    }
    /**
     * Set Business_Entity_Name value
     * @param string $business_Entity_Name
     * @return \StructType\Business_Entity_WWS_DataType
     */
    public function setBusiness_Entity_Name($business_Entity_Name = null)
    {
        // validation for constraint: string
        if (!is_null($business_Entity_Name) && !is_string($business_Entity_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($business_Entity_Name, true), gettype($business_Entity_Name)), __LINE__);
        }
        $this->Business_Entity_Name = $business_Entity_Name;
        return $this;
    }
    /**
     * Get Business_Entity_Phonetic_Name value
     * @return string|null
     */
    public function getBusiness_Entity_Phonetic_Name()
    {
        return $this->Business_Entity_Phonetic_Name;
    }
    /**
     * Set Business_Entity_Phonetic_Name value
     * @param string $business_Entity_Phonetic_Name
     * @return \StructType\Business_Entity_WWS_DataType
     */
    public function setBusiness_Entity_Phonetic_Name($business_Entity_Phonetic_Name = null)
    {
        // validation for constraint: string
        if (!is_null($business_Entity_Phonetic_Name) && !is_string($business_Entity_Phonetic_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($business_Entity_Phonetic_Name, true), gettype($business_Entity_Phonetic_Name)), __LINE__);
        }
        $this->Business_Entity_Phonetic_Name = $business_Entity_Phonetic_Name;
        return $this;
    }
    /**
     * Get Business_Entity_Tax_ID value
     * @return string|null
     */
    public function getBusiness_Entity_Tax_ID()
    {
        return $this->Business_Entity_Tax_ID;
    }
    /**
     * Set Business_Entity_Tax_ID value
     * @param string $business_Entity_Tax_ID
     * @return \StructType\Business_Entity_WWS_DataType
     */
    public function setBusiness_Entity_Tax_ID($business_Entity_Tax_ID = null)
    {
        // validation for constraint: string
        if (!is_null($business_Entity_Tax_ID) && !is_string($business_Entity_Tax_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($business_Entity_Tax_ID, true), gettype($business_Entity_Tax_ID)), __LINE__);
        }
        $this->Business_Entity_Tax_ID = $business_Entity_Tax_ID;
        return $this;
    }
    /**
     * Get External_Entity_ID value
     * @return string|null
     */
    public function getExternal_Entity_ID()
    {
        return $this->External_Entity_ID;
    }
    /**
     * Set External_Entity_ID value
     * @param string $external_Entity_ID
     * @return \StructType\Business_Entity_WWS_DataType
     */
    public function setExternal_Entity_ID($external_Entity_ID = null)
    {
        // validation for constraint: string
        if (!is_null($external_Entity_ID) && !is_string($external_Entity_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Entity_ID, true), gettype($external_Entity_ID)), __LINE__);
        }
        $this->External_Entity_ID = $external_Entity_ID;
        return $this;
    }
    /**
     * Get Contact_Data value
     * @return \StructType\Contact_Information_DataType|null
     */
    public function getContact_Data()
    {
        return $this->Contact_Data;
    }
    /**
     * Set Contact_Data value
     * @param \StructType\Contact_Information_DataType $contact_Data
     * @return \StructType\Business_Entity_WWS_DataType
     */
    public function setContact_Data(\StructType\Contact_Information_DataType $contact_Data = null)
    {
        $this->Contact_Data = $contact_Data;
        return $this;
    }
    /**
     * Get Business_Entity_Logo_Image_Data value
     * @return \StructType\Business_Entity_Logo_Image_DataType|null
     */
    public function getBusiness_Entity_Logo_Image_Data()
    {
        return $this->Business_Entity_Logo_Image_Data;
    }
    /**
     * Set Business_Entity_Logo_Image_Data value
     * @param \StructType\Business_Entity_Logo_Image_DataType $business_Entity_Logo_Image_Data
     * @return \StructType\Business_Entity_WWS_DataType
     */
    public function setBusiness_Entity_Logo_Image_Data(\StructType\Business_Entity_Logo_Image_DataType $business_Entity_Logo_Image_Data = null)
    {
        $this->Business_Entity_Logo_Image_Data = $business_Entity_Logo_Image_Data;
        return $this;
    }
}
