<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Business_Assets_Detail_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: READ ONLY: Element containing the business asset data.
 * @subpackage Structs
 */
class Business_Assets_Detail_WWS_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: READ ONLY: Business Asset ID. This is the business asset unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Business_Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: READ ONLY: The business asset.
     * - minOccurs: 0
     * @var \StructType\Business_AssetObjectType
     */
    public $Business_Asset_Reference;
    /**
     * The Total_Cost
     * Meta information extracted from the WSDL
     * - documentation: Total Purchase Order AmountcXML Notes:Request/OrderRequest/OrderRequestHeader/Total/MoneyThis is the Sum of the Extended Amount of all of the Purchase Order Lines. | Total cost of the asset component. | READ ONLY: Total cost of the
     * business asset.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Cost;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: READ ONLY: Currency of the cost of the business asset.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: READ ONLY: Currency of the cost of the business asset.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Status_Reference;
    /**
     * Constructor method for Business_Assets_Detail_WWS_DataType
     * @uses Business_Assets_Detail_WWS_DataType::setID()
     * @uses Business_Assets_Detail_WWS_DataType::setBusiness_Asset_Reference()
     * @uses Business_Assets_Detail_WWS_DataType::setTotal_Cost()
     * @uses Business_Assets_Detail_WWS_DataType::setCurrency_Reference()
     * @uses Business_Assets_Detail_WWS_DataType::setStatus_Reference()
     * @param string $iD
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @param float $total_Cost
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Document_StatusObjectType $status_Reference
     */
    public function __construct($iD = null, \StructType\Business_AssetObjectType $business_Asset_Reference = null, $total_Cost = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Document_StatusObjectType $status_Reference = null)
    {
        $this
            ->setID($iD)
            ->setBusiness_Asset_Reference($business_Asset_Reference)
            ->setTotal_Cost($total_Cost)
            ->setCurrency_Reference($currency_Reference)
            ->setStatus_Reference($status_Reference);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Business_Assets_Detail_WWS_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Business_Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getBusiness_Asset_Reference()
    {
        return $this->Business_Asset_Reference;
    }
    /**
     * Set Business_Asset_Reference value
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @return \StructType\Business_Assets_Detail_WWS_DataType
     */
    public function setBusiness_Asset_Reference(\StructType\Business_AssetObjectType $business_Asset_Reference = null)
    {
        $this->Business_Asset_Reference = $business_Asset_Reference;
        return $this;
    }
    /**
     * Get Total_Cost value
     * @return float|null
     */
    public function getTotal_Cost()
    {
        return $this->Total_Cost;
    }
    /**
     * Set Total_Cost value
     * @param float $total_Cost
     * @return \StructType\Business_Assets_Detail_WWS_DataType
     */
    public function setTotal_Cost($total_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($total_Cost) && !(is_float($total_Cost) || is_numeric($total_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Cost, true), gettype($total_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Cost) && mb_strlen(mb_substr($total_Cost, false !== mb_strpos($total_Cost, '.') ? mb_strpos($total_Cost, '.') + 1 : mb_strlen($total_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Cost, true), mb_strlen(mb_substr($total_Cost, mb_strpos($total_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Cost) && mb_strlen(preg_replace('/(\D)/', '', $total_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $total_Cost))), __LINE__);
        }
        $this->Total_Cost = $total_Cost;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Business_Assets_Detail_WWS_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getStatus_Reference()
    {
        return $this->Status_Reference;
    }
    /**
     * Set Status_Reference value
     * @param \StructType\Document_StatusObjectType $status_Reference
     * @return \StructType\Business_Assets_Detail_WWS_DataType
     */
    public function setStatus_Reference(\StructType\Document_StatusObjectType $status_Reference = null)
    {
        $this->Status_Reference = $status_Reference;
        return $this;
    }
}
