<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Business_Asset_Cost_Adjustment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element contains Business Asset cost adjustment details
 * @subpackage Structs
 */
class Business_Asset_Cost_Adjustment_DataType extends AbstractStructBase
{
    /**
     * The Post_Acquisition_Adjustment
     * Meta information extracted from the WSDL
     * - documentation: Acquisition cost adjustment cannot be performed on assets with suspended periods | Since this asset was converted into Workday, depreciation for the adjustment will be calculated starting on the Depreciation Start Date set at time of
     * registration for any book with historical data | Indicator to whether to perform Acquisition Adjustment or Post Acquisition Adjustment. Enter 0 for Acquisition Adjustment or 1 for Post Acquisition Adjustment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Post_Acquisition_Adjustment;
    /**
     * The Transaction_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: The fiscal Period for the transaction date must exist in the fiscal schedule of every company asset book where this is a depreciable asset in order to do this transaction | Depreciation start date for cost adjustment cannot be
     * earlier than last resume date. | Ledger Period must exist for the Adjustment Date. | Adjustment Date cannot be less than Date Acquired of the Business Asset | Adjustment Date is required when Post Acquisition Adjustment is 1 (true). Similarly, Post
     * Acquisition Adjustment must be 1 when Adjustment Date is entered. | Date of cost adjustment (transaction effective date of the cost adjustment). This value is required if Post Acquisition Adjustment is 1.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transaction_Effective_Date;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Currency that are used by the asset book. Enter asset books currency if you want to restrict the adjustment to specific books. Otherwise, default currency will be primary currency.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Adjustment_Amount
     * Meta information extracted from the WSDL
     * - documentation: Adjustment amount. Can be positive or negative. Cannot bring total cost down to zero or negative | The adjustment amount isn't valid for the referenced supplier invoice line.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Adjustment_Amount;
    /**
     * The Adjustment_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Adjustment quantity can be positive or negative. You cannot bring total approved quantity to zero. You cannot bring total approved quantity to be less than consumed quantity. Quantity adjustments apply to all asset books. | Quantity
     * cannot be adjusted to be less than one.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Adjustment_Quantity;
    /**
     * The Adjustment_Residual_Value
     * Meta information extracted from the WSDL
     * - documentation: Adjustment residual value. Can be positive or negative but cannot bring down total residual to below 0.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Adjustment_Residual_Value;
    /**
     * The Accounting_Date
     * Meta information extracted from the WSDL
     * - documentation: Accounting Date cannot be less than Date Acquired of the Business Asset | Accounting date when transaction was recorded in the ledger. Not required if source transaction is provided.
     * - choice: Accounting_Date
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Accounting_Date;
    /**
     * The Restricted_to_Books_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to asset books that are used by the asset. Enter asset books if you want to restrict the adjustment to specific books. To adjust all asset books, leave this field blank.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_BookObjectType[]
     */
    public $Restricted_to_Books_Reference;
    /**
     * The Adjustment_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing adjustment reason
     * - minOccurs: 0
     * @var \StructType\Asset_Cost_Adjustment_ReasonObjectType
     */
    public $Adjustment_Reason_Reference;
    /**
     * The Supplier_Invoice_Line_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: A reference to a supplier invoice line, if there was one related to the cost adjustment associated with this asset, e.g. due to an improvement or installation cost.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_Line_Reference_ID;
    /**
     * Constructor method for Business_Asset_Cost_Adjustment_DataType
     * @uses Business_Asset_Cost_Adjustment_DataType::setPost_Acquisition_Adjustment()
     * @uses Business_Asset_Cost_Adjustment_DataType::setTransaction_Effective_Date()
     * @uses Business_Asset_Cost_Adjustment_DataType::setCurrency_Reference()
     * @uses Business_Asset_Cost_Adjustment_DataType::setAdjustment_Amount()
     * @uses Business_Asset_Cost_Adjustment_DataType::setAdjustment_Quantity()
     * @uses Business_Asset_Cost_Adjustment_DataType::setAdjustment_Residual_Value()
     * @uses Business_Asset_Cost_Adjustment_DataType::setAccounting_Date()
     * @uses Business_Asset_Cost_Adjustment_DataType::setRestricted_to_Books_Reference()
     * @uses Business_Asset_Cost_Adjustment_DataType::setAdjustment_Reason_Reference()
     * @uses Business_Asset_Cost_Adjustment_DataType::setSupplier_Invoice_Line_Reference_ID()
     * @param bool $post_Acquisition_Adjustment
     * @param string $transaction_Effective_Date
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param float $adjustment_Amount
     * @param float $adjustment_Quantity
     * @param float $adjustment_Residual_Value
     * @param string $accounting_Date
     * @param \StructType\Asset_BookObjectType[] $restricted_to_Books_Reference
     * @param \StructType\Asset_Cost_Adjustment_ReasonObjectType $adjustment_Reason_Reference
     * @param string $supplier_Invoice_Line_Reference_ID
     */
    public function __construct($post_Acquisition_Adjustment = null, $transaction_Effective_Date = null, \StructType\CurrencyObjectType $currency_Reference = null, $adjustment_Amount = null, $adjustment_Quantity = null, $adjustment_Residual_Value = null, $accounting_Date = null, array $restricted_to_Books_Reference = array(), \StructType\Asset_Cost_Adjustment_ReasonObjectType $adjustment_Reason_Reference = null, $supplier_Invoice_Line_Reference_ID = null)
    {
        $this
            ->setPost_Acquisition_Adjustment($post_Acquisition_Adjustment)
            ->setTransaction_Effective_Date($transaction_Effective_Date)
            ->setCurrency_Reference($currency_Reference)
            ->setAdjustment_Amount($adjustment_Amount)
            ->setAdjustment_Quantity($adjustment_Quantity)
            ->setAdjustment_Residual_Value($adjustment_Residual_Value)
            ->setAccounting_Date($accounting_Date)
            ->setRestricted_to_Books_Reference($restricted_to_Books_Reference)
            ->setAdjustment_Reason_Reference($adjustment_Reason_Reference)
            ->setSupplier_Invoice_Line_Reference_ID($supplier_Invoice_Line_Reference_ID);
    }
    /**
     * Get Post_Acquisition_Adjustment value
     * @return bool|null
     */
    public function getPost_Acquisition_Adjustment()
    {
        return $this->Post_Acquisition_Adjustment;
    }
    /**
     * Set Post_Acquisition_Adjustment value
     * @param bool $post_Acquisition_Adjustment
     * @return \StructType\Business_Asset_Cost_Adjustment_DataType
     */
    public function setPost_Acquisition_Adjustment($post_Acquisition_Adjustment = null)
    {
        // validation for constraint: boolean
        if (!is_null($post_Acquisition_Adjustment) && !is_bool($post_Acquisition_Adjustment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($post_Acquisition_Adjustment, true), gettype($post_Acquisition_Adjustment)), __LINE__);
        }
        $this->Post_Acquisition_Adjustment = $post_Acquisition_Adjustment;
        return $this;
    }
    /**
     * Get Transaction_Effective_Date value
     * @return string|null
     */
    public function getTransaction_Effective_Date()
    {
        return $this->Transaction_Effective_Date;
    }
    /**
     * Set Transaction_Effective_Date value
     * @param string $transaction_Effective_Date
     * @return \StructType\Business_Asset_Cost_Adjustment_DataType
     */
    public function setTransaction_Effective_Date($transaction_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Effective_Date) && !is_string($transaction_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Effective_Date, true), gettype($transaction_Effective_Date)), __LINE__);
        }
        $this->Transaction_Effective_Date = $transaction_Effective_Date;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Business_Asset_Cost_Adjustment_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Adjustment_Amount value
     * @return float|null
     */
    public function getAdjustment_Amount()
    {
        return $this->Adjustment_Amount;
    }
    /**
     * Set Adjustment_Amount value
     * @param float $adjustment_Amount
     * @return \StructType\Business_Asset_Cost_Adjustment_DataType
     */
    public function setAdjustment_Amount($adjustment_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($adjustment_Amount) && !(is_float($adjustment_Amount) || is_numeric($adjustment_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adjustment_Amount, true), gettype($adjustment_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($adjustment_Amount) && mb_strlen(mb_substr($adjustment_Amount, false !== mb_strpos($adjustment_Amount, '.') ? mb_strpos($adjustment_Amount, '.') + 1 : mb_strlen($adjustment_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($adjustment_Amount, true), mb_strlen(mb_substr($adjustment_Amount, mb_strpos($adjustment_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($adjustment_Amount) && mb_strlen(preg_replace('/(\D)/', '', $adjustment_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($adjustment_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $adjustment_Amount))), __LINE__);
        }
        $this->Adjustment_Amount = $adjustment_Amount;
        return $this;
    }
    /**
     * Get Adjustment_Quantity value
     * @return float|null
     */
    public function getAdjustment_Quantity()
    {
        return $this->Adjustment_Quantity;
    }
    /**
     * Set Adjustment_Quantity value
     * @param float $adjustment_Quantity
     * @return \StructType\Business_Asset_Cost_Adjustment_DataType
     */
    public function setAdjustment_Quantity($adjustment_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($adjustment_Quantity) && !(is_float($adjustment_Quantity) || is_numeric($adjustment_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adjustment_Quantity, true), gettype($adjustment_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($adjustment_Quantity) && mb_strlen(mb_substr($adjustment_Quantity, false !== mb_strpos($adjustment_Quantity, '.') ? mb_strpos($adjustment_Quantity, '.') + 1 : mb_strlen($adjustment_Quantity))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($adjustment_Quantity, true), mb_strlen(mb_substr($adjustment_Quantity, mb_strpos($adjustment_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($adjustment_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $adjustment_Quantity)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($adjustment_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $adjustment_Quantity))), __LINE__);
        }
        $this->Adjustment_Quantity = $adjustment_Quantity;
        return $this;
    }
    /**
     * Get Adjustment_Residual_Value value
     * @return float|null
     */
    public function getAdjustment_Residual_Value()
    {
        return $this->Adjustment_Residual_Value;
    }
    /**
     * Set Adjustment_Residual_Value value
     * @param float $adjustment_Residual_Value
     * @return \StructType\Business_Asset_Cost_Adjustment_DataType
     */
    public function setAdjustment_Residual_Value($adjustment_Residual_Value = null)
    {
        // validation for constraint: float
        if (!is_null($adjustment_Residual_Value) && !(is_float($adjustment_Residual_Value) || is_numeric($adjustment_Residual_Value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adjustment_Residual_Value, true), gettype($adjustment_Residual_Value)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($adjustment_Residual_Value) && mb_strlen(mb_substr($adjustment_Residual_Value, false !== mb_strpos($adjustment_Residual_Value, '.') ? mb_strpos($adjustment_Residual_Value, '.') + 1 : mb_strlen($adjustment_Residual_Value))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($adjustment_Residual_Value, true), mb_strlen(mb_substr($adjustment_Residual_Value, mb_strpos($adjustment_Residual_Value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($adjustment_Residual_Value) && mb_strlen(preg_replace('/(\D)/', '', $adjustment_Residual_Value)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($adjustment_Residual_Value, true), mb_strlen(preg_replace('/(\D)/', '', $adjustment_Residual_Value))), __LINE__);
        }
        $this->Adjustment_Residual_Value = $adjustment_Residual_Value;
        return $this;
    }
    /**
     * Get Accounting_Date value
     * @return string|null
     */
    public function getAccounting_Date()
    {
        return isset($this->Accounting_Date) ? $this->Accounting_Date : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAccounting_Date method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccounting_Date method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAccounting_DateForChoiceConstraintsFromSetAccounting_Date($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Accounting_Date can\'t be set as the property %s is already set. Only one property must be set among these properties: Accounting_Date, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Accounting_Date value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $accounting_Date
     * @return \StructType\Business_Asset_Cost_Adjustment_DataType
     */
    public function setAccounting_Date($accounting_Date = null)
    {
        // validation for constraint: string
        if (!is_null($accounting_Date) && !is_string($accounting_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounting_Date, true), gettype($accounting_Date)), __LINE__);
        }
        // validation for constraint: choice(Accounting_Date)
        if ('' !== ($accounting_DateChoiceErrorMessage = self::validateAccounting_DateForChoiceConstraintsFromSetAccounting_Date($accounting_Date))) {
            throw new \InvalidArgumentException($accounting_DateChoiceErrorMessage, __LINE__);
        }
        if (is_null($accounting_Date) || (is_array($accounting_Date) && empty($accounting_Date))) {
            unset($this->Accounting_Date);
        } else {
            $this->Accounting_Date = $accounting_Date;
        }
        return $this;
    }
    /**
     * Get Restricted_to_Books_Reference value
     * @return \StructType\Asset_BookObjectType[]|null
     */
    public function getRestricted_to_Books_Reference()
    {
        return $this->Restricted_to_Books_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRestricted_to_Books_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestricted_to_Books_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestricted_to_Books_ReferenceForArrayConstraintsFromSetRestricted_to_Books_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $business_Asset_Cost_Adjustment_DataTypeRestricted_to_Books_ReferenceItem) {
            // validation for constraint: itemType
            if (!$business_Asset_Cost_Adjustment_DataTypeRestricted_to_Books_ReferenceItem instanceof \StructType\Asset_BookObjectType) {
                $invalidValues[] = is_object($business_Asset_Cost_Adjustment_DataTypeRestricted_to_Books_ReferenceItem) ? get_class($business_Asset_Cost_Adjustment_DataTypeRestricted_to_Books_ReferenceItem) : sprintf('%s(%s)', gettype($business_Asset_Cost_Adjustment_DataTypeRestricted_to_Books_ReferenceItem), var_export($business_Asset_Cost_Adjustment_DataTypeRestricted_to_Books_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restricted_to_Books_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restricted_to_Books_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType[] $restricted_to_Books_Reference
     * @return \StructType\Business_Asset_Cost_Adjustment_DataType
     */
    public function setRestricted_to_Books_Reference(array $restricted_to_Books_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($restricted_to_Books_ReferenceArrayErrorMessage = self::validateRestricted_to_Books_ReferenceForArrayConstraintsFromSetRestricted_to_Books_Reference($restricted_to_Books_Reference))) {
            throw new \InvalidArgumentException($restricted_to_Books_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Restricted_to_Books_Reference = $restricted_to_Books_Reference;
        return $this;
    }
    /**
     * Add item to Restricted_to_Books_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType $item
     * @return \StructType\Business_Asset_Cost_Adjustment_DataType
     */
    public function addToRestricted_to_Books_Reference(\StructType\Asset_BookObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_BookObjectType) {
            throw new \InvalidArgumentException(sprintf('The Restricted_to_Books_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Restricted_to_Books_Reference[] = $item;
        return $this;
    }
    /**
     * Get Adjustment_Reason_Reference value
     * @return \StructType\Asset_Cost_Adjustment_ReasonObjectType|null
     */
    public function getAdjustment_Reason_Reference()
    {
        return $this->Adjustment_Reason_Reference;
    }
    /**
     * Set Adjustment_Reason_Reference value
     * @param \StructType\Asset_Cost_Adjustment_ReasonObjectType $adjustment_Reason_Reference
     * @return \StructType\Business_Asset_Cost_Adjustment_DataType
     */
    public function setAdjustment_Reason_Reference(\StructType\Asset_Cost_Adjustment_ReasonObjectType $adjustment_Reason_Reference = null)
    {
        $this->Adjustment_Reason_Reference = $adjustment_Reason_Reference;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Line_Reference_ID value
     * @return string|null
     */
    public function getSupplier_Invoice_Line_Reference_ID()
    {
        return $this->Supplier_Invoice_Line_Reference_ID;
    }
    /**
     * Set Supplier_Invoice_Line_Reference_ID value
     * @param string $supplier_Invoice_Line_Reference_ID
     * @return \StructType\Business_Asset_Cost_Adjustment_DataType
     */
    public function setSupplier_Invoice_Line_Reference_ID($supplier_Invoice_Line_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_Line_Reference_ID) && !is_string($supplier_Invoice_Line_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_Line_Reference_ID, true), gettype($supplier_Invoice_Line_Reference_ID)), __LINE__);
        }
        $this->Supplier_Invoice_Line_Reference_ID = $supplier_Invoice_Line_Reference_ID;
        return $this;
    }
}
