<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Share_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing the asset share response data
 * @subpackage Structs
 */
class Asset_Share_Response_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: This is a unique reference identifier to the asset share.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Share_Percent
     * Meta information extracted from the WSDL
     * - documentation: The percent of the asset share.
     * - base: xsd:decimal
     * - fractionDigits: 15
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Share_Percent;
    /**
     * The Asset_Share_Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount of the asset share.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Asset_Share_Amount;
    /**
     * The Asset_Class_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the asset class that the asset is shared by.
     * - minOccurs: 0
     * @var \StructType\Asset_ClassObjectType
     */
    public $Asset_Class_Reference;
    /**
     * The Asset_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the asset type that the asset is shared by
     * - minOccurs: 0
     * @var \StructType\Asset_TypeObjectType
     */
    public $Asset_Type_Reference;
    /**
     * The Asset_Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the worktags that the asset is shared by
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Asset_Worktags_Reference;
    /**
     * Constructor method for Asset_Share_Response_DataType
     * @uses Asset_Share_Response_DataType::setID()
     * @uses Asset_Share_Response_DataType::setShare_Percent()
     * @uses Asset_Share_Response_DataType::setAsset_Share_Amount()
     * @uses Asset_Share_Response_DataType::setAsset_Class_Reference()
     * @uses Asset_Share_Response_DataType::setAsset_Type_Reference()
     * @uses Asset_Share_Response_DataType::setAsset_Worktags_Reference()
     * @param string $iD
     * @param float $share_Percent
     * @param float $asset_Share_Amount
     * @param \StructType\Asset_ClassObjectType $asset_Class_Reference
     * @param \StructType\Asset_TypeObjectType $asset_Type_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $asset_Worktags_Reference
     */
    public function __construct($iD = null, $share_Percent = null, $asset_Share_Amount = null, \StructType\Asset_ClassObjectType $asset_Class_Reference = null, \StructType\Asset_TypeObjectType $asset_Type_Reference = null, array $asset_Worktags_Reference = array())
    {
        $this
            ->setID($iD)
            ->setShare_Percent($share_Percent)
            ->setAsset_Share_Amount($asset_Share_Amount)
            ->setAsset_Class_Reference($asset_Class_Reference)
            ->setAsset_Type_Reference($asset_Type_Reference)
            ->setAsset_Worktags_Reference($asset_Worktags_Reference);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Asset_Share_Response_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Share_Percent value
     * @return float|null
     */
    public function getShare_Percent()
    {
        return $this->Share_Percent;
    }
    /**
     * Set Share_Percent value
     * @param float $share_Percent
     * @return \StructType\Asset_Share_Response_DataType
     */
    public function setShare_Percent($share_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($share_Percent) && !(is_float($share_Percent) || is_numeric($share_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($share_Percent, true), gettype($share_Percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(15)
        if (!is_null($share_Percent) && mb_strlen(mb_substr($share_Percent, false !== mb_strpos($share_Percent, '.') ? mb_strpos($share_Percent, '.') + 1 : mb_strlen($share_Percent))) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 15 fraction digits, %d given', var_export($share_Percent, true), mb_strlen(mb_substr($share_Percent, mb_strpos($share_Percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($share_Percent) && $share_Percent < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($share_Percent, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($share_Percent) && mb_strlen(preg_replace('/(\D)/', '', $share_Percent)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($share_Percent, true), mb_strlen(preg_replace('/(\D)/', '', $share_Percent))), __LINE__);
        }
        $this->Share_Percent = $share_Percent;
        return $this;
    }
    /**
     * Get Asset_Share_Amount value
     * @return float|null
     */
    public function getAsset_Share_Amount()
    {
        return $this->Asset_Share_Amount;
    }
    /**
     * Set Asset_Share_Amount value
     * @param float $asset_Share_Amount
     * @return \StructType\Asset_Share_Response_DataType
     */
    public function setAsset_Share_Amount($asset_Share_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($asset_Share_Amount) && !(is_float($asset_Share_Amount) || is_numeric($asset_Share_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($asset_Share_Amount, true), gettype($asset_Share_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($asset_Share_Amount) && mb_strlen(mb_substr($asset_Share_Amount, false !== mb_strpos($asset_Share_Amount, '.') ? mb_strpos($asset_Share_Amount, '.') + 1 : mb_strlen($asset_Share_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($asset_Share_Amount, true), mb_strlen(mb_substr($asset_Share_Amount, mb_strpos($asset_Share_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($asset_Share_Amount) && mb_strlen(preg_replace('/(\D)/', '', $asset_Share_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($asset_Share_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $asset_Share_Amount))), __LINE__);
        }
        $this->Asset_Share_Amount = $asset_Share_Amount;
        return $this;
    }
    /**
     * Get Asset_Class_Reference value
     * @return \StructType\Asset_ClassObjectType|null
     */
    public function getAsset_Class_Reference()
    {
        return $this->Asset_Class_Reference;
    }
    /**
     * Set Asset_Class_Reference value
     * @param \StructType\Asset_ClassObjectType $asset_Class_Reference
     * @return \StructType\Asset_Share_Response_DataType
     */
    public function setAsset_Class_Reference(\StructType\Asset_ClassObjectType $asset_Class_Reference = null)
    {
        $this->Asset_Class_Reference = $asset_Class_Reference;
        return $this;
    }
    /**
     * Get Asset_Type_Reference value
     * @return \StructType\Asset_TypeObjectType|null
     */
    public function getAsset_Type_Reference()
    {
        return $this->Asset_Type_Reference;
    }
    /**
     * Set Asset_Type_Reference value
     * @param \StructType\Asset_TypeObjectType $asset_Type_Reference
     * @return \StructType\Asset_Share_Response_DataType
     */
    public function setAsset_Type_Reference(\StructType\Asset_TypeObjectType $asset_Type_Reference = null)
    {
        $this->Asset_Type_Reference = $asset_Type_Reference;
        return $this;
    }
    /**
     * Get Asset_Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getAsset_Worktags_Reference()
    {
        return $this->Asset_Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Worktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Worktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Worktags_ReferenceForArrayConstraintsFromSetAsset_Worktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Share_Response_DataTypeAsset_Worktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Share_Response_DataTypeAsset_Worktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($asset_Share_Response_DataTypeAsset_Worktags_ReferenceItem) ? get_class($asset_Share_Response_DataTypeAsset_Worktags_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Share_Response_DataTypeAsset_Worktags_ReferenceItem), var_export($asset_Share_Response_DataTypeAsset_Worktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $asset_Worktags_Reference
     * @return \StructType\Asset_Share_Response_DataType
     */
    public function setAsset_Worktags_Reference(array $asset_Worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Worktags_ReferenceArrayErrorMessage = self::validateAsset_Worktags_ReferenceForArrayConstraintsFromSetAsset_Worktags_Reference($asset_Worktags_Reference))) {
            throw new \InvalidArgumentException($asset_Worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Asset_Worktags_Reference = $asset_Worktags_Reference;
        return $this;
    }
    /**
     * Add item to Asset_Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Asset_Share_Response_DataType
     */
    public function addToAsset_Worktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Worktags_Reference[] = $item;
        return $this;
    }
}
