<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Share_Replacement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing asset share replacement data
 * @subpackage Structs
 */
class Asset_Share_Replacement_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: This is a unique reference identifier for the asset share.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Asset_Share_Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount of the asset share.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Asset_Share_Amount;
    /**
     * The Share_Percentage
     * Meta information extracted from the WSDL
     * - documentation: The percent of the asset share.
     * - base: xsd:decimal
     * - fractionDigits: 5
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 8
     * @var float
     */
    public $Share_Percentage;
    /**
     * The Asset_Class_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the asset class.
     * - minOccurs: 0
     * @var \StructType\Asset_ClassObjectType
     */
    public $Asset_Class_Reference;
    /**
     * The Asset_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the asset type.
     * - minOccurs: 0
     * @var \StructType\Asset_TypeObjectType
     */
    public $Asset_Type_Reference;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for each worktag type and is subject to configurable validation
     * when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * Constructor method for Asset_Share_Replacement_DataType
     * @uses Asset_Share_Replacement_DataType::setID()
     * @uses Asset_Share_Replacement_DataType::setAsset_Share_Amount()
     * @uses Asset_Share_Replacement_DataType::setShare_Percentage()
     * @uses Asset_Share_Replacement_DataType::setAsset_Class_Reference()
     * @uses Asset_Share_Replacement_DataType::setAsset_Type_Reference()
     * @uses Asset_Share_Replacement_DataType::setWorktags_Reference()
     * @param string $iD
     * @param float $asset_Share_Amount
     * @param float $share_Percentage
     * @param \StructType\Asset_ClassObjectType $asset_Class_Reference
     * @param \StructType\Asset_TypeObjectType $asset_Type_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     */
    public function __construct($iD = null, $asset_Share_Amount = null, $share_Percentage = null, \StructType\Asset_ClassObjectType $asset_Class_Reference = null, \StructType\Asset_TypeObjectType $asset_Type_Reference = null, array $worktags_Reference = array())
    {
        $this
            ->setID($iD)
            ->setAsset_Share_Amount($asset_Share_Amount)
            ->setShare_Percentage($share_Percentage)
            ->setAsset_Class_Reference($asset_Class_Reference)
            ->setAsset_Type_Reference($asset_Type_Reference)
            ->setWorktags_Reference($worktags_Reference);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Asset_Share_Replacement_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Asset_Share_Amount value
     * @return float|null
     */
    public function getAsset_Share_Amount()
    {
        return $this->Asset_Share_Amount;
    }
    /**
     * Set Asset_Share_Amount value
     * @param float $asset_Share_Amount
     * @return \StructType\Asset_Share_Replacement_DataType
     */
    public function setAsset_Share_Amount($asset_Share_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($asset_Share_Amount) && !(is_float($asset_Share_Amount) || is_numeric($asset_Share_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($asset_Share_Amount, true), gettype($asset_Share_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($asset_Share_Amount) && mb_strlen(mb_substr($asset_Share_Amount, false !== mb_strpos($asset_Share_Amount, '.') ? mb_strpos($asset_Share_Amount, '.') + 1 : mb_strlen($asset_Share_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($asset_Share_Amount, true), mb_strlen(mb_substr($asset_Share_Amount, mb_strpos($asset_Share_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($asset_Share_Amount) && mb_strlen(preg_replace('/(\D)/', '', $asset_Share_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($asset_Share_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $asset_Share_Amount))), __LINE__);
        }
        $this->Asset_Share_Amount = $asset_Share_Amount;
        return $this;
    }
    /**
     * Get Share_Percentage value
     * @return float|null
     */
    public function getShare_Percentage()
    {
        return $this->Share_Percentage;
    }
    /**
     * Set Share_Percentage value
     * @param float $share_Percentage
     * @return \StructType\Asset_Share_Replacement_DataType
     */
    public function setShare_Percentage($share_Percentage = null)
    {
        // validation for constraint: float
        if (!is_null($share_Percentage) && !(is_float($share_Percentage) || is_numeric($share_Percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($share_Percentage, true), gettype($share_Percentage)), __LINE__);
        }
        // validation for constraint: fractionDigits(5)
        if (!is_null($share_Percentage) && mb_strlen(mb_substr($share_Percentage, false !== mb_strpos($share_Percentage, '.') ? mb_strpos($share_Percentage, '.') + 1 : mb_strlen($share_Percentage))) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 5 fraction digits, %d given', var_export($share_Percentage, true), mb_strlen(mb_substr($share_Percentage, mb_strpos($share_Percentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($share_Percentage) && $share_Percentage < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($share_Percentage, true)), __LINE__);
        }
        // validation for constraint: totalDigits(8)
        if (!is_null($share_Percentage) && mb_strlen(preg_replace('/(\D)/', '', $share_Percentage)) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 8 digits, "%d" given', var_export($share_Percentage, true), mb_strlen(preg_replace('/(\D)/', '', $share_Percentage))), __LINE__);
        }
        $this->Share_Percentage = $share_Percentage;
        return $this;
    }
    /**
     * Get Asset_Class_Reference value
     * @return \StructType\Asset_ClassObjectType|null
     */
    public function getAsset_Class_Reference()
    {
        return $this->Asset_Class_Reference;
    }
    /**
     * Set Asset_Class_Reference value
     * @param \StructType\Asset_ClassObjectType $asset_Class_Reference
     * @return \StructType\Asset_Share_Replacement_DataType
     */
    public function setAsset_Class_Reference(\StructType\Asset_ClassObjectType $asset_Class_Reference = null)
    {
        $this->Asset_Class_Reference = $asset_Class_Reference;
        return $this;
    }
    /**
     * Get Asset_Type_Reference value
     * @return \StructType\Asset_TypeObjectType|null
     */
    public function getAsset_Type_Reference()
    {
        return $this->Asset_Type_Reference;
    }
    /**
     * Set Asset_Type_Reference value
     * @param \StructType\Asset_TypeObjectType $asset_Type_Reference
     * @return \StructType\Asset_Share_Replacement_DataType
     */
    public function setAsset_Type_Reference(\StructType\Asset_TypeObjectType $asset_Type_Reference = null)
    {
        $this->Asset_Type_Reference = $asset_Type_Reference;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Share_Replacement_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Share_Replacement_DataTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($asset_Share_Replacement_DataTypeWorktags_ReferenceItem) ? get_class($asset_Share_Replacement_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Share_Replacement_DataTypeWorktags_ReferenceItem), var_export($asset_Share_Replacement_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Asset_Share_Replacement_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Asset_Share_Replacement_DataType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
}
