<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Intercompany_Transfer_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains information about transfers to or from a different company for this asset.
 * @subpackage Structs
 */
class Asset_Intercompany_Transfer_WWS_DataType extends AbstractStructBase
{
    /**
     * The Transaction_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: The date the asset was transferred from or to a different company (the transaction effective date of the transfer).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transaction_Effective_Date;
    /**
     * The Transfer_To_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: If this asset was transferred to a different company, this is a reference to that company.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Transfer_To_Company_Reference;
    /**
     * The Transfer_From_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: If this asset was transferred FROM a different company, this is a reference to that company.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Transfer_From_Company_Reference;
    /**
     * The Accumulated_Depreciation
     * Meta information extracted from the WSDL
     * - documentation: Accumulated Depreciation | Accumulated Depreciation cannot be greater than Acquisition Cost minus Residual Value | The accumulated depreciation amount at the time the asset was transferred to a different company. | Numeric value
     * representing historical accumulated depreciation as of a day prior to depreciation start date. This value cannot be greater than historical cost minus historical residual value. Workday uses this accumulated depreciation value to determine
     * depreciable cost basis to generate the depreciation schedule for remaining useful life starting from depreciation start date. | Accumulated depreciation cannot be greater than cost minus residual value for the asset book | Accumulated depreciation
     * must be 0 when depreciation start date is blank | Accumulated depreciation is required when depreciation start date has a value | The accumulated depreciation entered has too many digits beyond the decimal point
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Accumulated_Depreciation;
    /**
     * The Transfer_To_Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the new Asset that was created as a result of transferring this Asset to a different Company.
     * - minOccurs: 0
     * @var \StructType\Business_AssetObjectType
     */
    public $Transfer_To_Asset_Reference;
    /**
     * Constructor method for Asset_Intercompany_Transfer_WWS_DataType
     * @uses Asset_Intercompany_Transfer_WWS_DataType::setTransaction_Effective_Date()
     * @uses Asset_Intercompany_Transfer_WWS_DataType::setTransfer_To_Company_Reference()
     * @uses Asset_Intercompany_Transfer_WWS_DataType::setTransfer_From_Company_Reference()
     * @uses Asset_Intercompany_Transfer_WWS_DataType::setAccumulated_Depreciation()
     * @uses Asset_Intercompany_Transfer_WWS_DataType::setTransfer_To_Asset_Reference()
     * @param string $transaction_Effective_Date
     * @param \StructType\CompanyObjectType $transfer_To_Company_Reference
     * @param \StructType\CompanyObjectType $transfer_From_Company_Reference
     * @param float $accumulated_Depreciation
     * @param \StructType\Business_AssetObjectType $transfer_To_Asset_Reference
     */
    public function __construct($transaction_Effective_Date = null, \StructType\CompanyObjectType $transfer_To_Company_Reference = null, \StructType\CompanyObjectType $transfer_From_Company_Reference = null, $accumulated_Depreciation = null, \StructType\Business_AssetObjectType $transfer_To_Asset_Reference = null)
    {
        $this
            ->setTransaction_Effective_Date($transaction_Effective_Date)
            ->setTransfer_To_Company_Reference($transfer_To_Company_Reference)
            ->setTransfer_From_Company_Reference($transfer_From_Company_Reference)
            ->setAccumulated_Depreciation($accumulated_Depreciation)
            ->setTransfer_To_Asset_Reference($transfer_To_Asset_Reference);
    }
    /**
     * Get Transaction_Effective_Date value
     * @return string|null
     */
    public function getTransaction_Effective_Date()
    {
        return $this->Transaction_Effective_Date;
    }
    /**
     * Set Transaction_Effective_Date value
     * @param string $transaction_Effective_Date
     * @return \StructType\Asset_Intercompany_Transfer_WWS_DataType
     */
    public function setTransaction_Effective_Date($transaction_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Effective_Date) && !is_string($transaction_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Effective_Date, true), gettype($transaction_Effective_Date)), __LINE__);
        }
        $this->Transaction_Effective_Date = $transaction_Effective_Date;
        return $this;
    }
    /**
     * Get Transfer_To_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getTransfer_To_Company_Reference()
    {
        return $this->Transfer_To_Company_Reference;
    }
    /**
     * Set Transfer_To_Company_Reference value
     * @param \StructType\CompanyObjectType $transfer_To_Company_Reference
     * @return \StructType\Asset_Intercompany_Transfer_WWS_DataType
     */
    public function setTransfer_To_Company_Reference(\StructType\CompanyObjectType $transfer_To_Company_Reference = null)
    {
        $this->Transfer_To_Company_Reference = $transfer_To_Company_Reference;
        return $this;
    }
    /**
     * Get Transfer_From_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getTransfer_From_Company_Reference()
    {
        return $this->Transfer_From_Company_Reference;
    }
    /**
     * Set Transfer_From_Company_Reference value
     * @param \StructType\CompanyObjectType $transfer_From_Company_Reference
     * @return \StructType\Asset_Intercompany_Transfer_WWS_DataType
     */
    public function setTransfer_From_Company_Reference(\StructType\CompanyObjectType $transfer_From_Company_Reference = null)
    {
        $this->Transfer_From_Company_Reference = $transfer_From_Company_Reference;
        return $this;
    }
    /**
     * Get Accumulated_Depreciation value
     * @return float|null
     */
    public function getAccumulated_Depreciation()
    {
        return $this->Accumulated_Depreciation;
    }
    /**
     * Set Accumulated_Depreciation value
     * @param float $accumulated_Depreciation
     * @return \StructType\Asset_Intercompany_Transfer_WWS_DataType
     */
    public function setAccumulated_Depreciation($accumulated_Depreciation = null)
    {
        // validation for constraint: float
        if (!is_null($accumulated_Depreciation) && !(is_float($accumulated_Depreciation) || is_numeric($accumulated_Depreciation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($accumulated_Depreciation, true), gettype($accumulated_Depreciation)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($accumulated_Depreciation) && mb_strlen(mb_substr($accumulated_Depreciation, false !== mb_strpos($accumulated_Depreciation, '.') ? mb_strpos($accumulated_Depreciation, '.') + 1 : mb_strlen($accumulated_Depreciation))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($accumulated_Depreciation, true), mb_strlen(mb_substr($accumulated_Depreciation, mb_strpos($accumulated_Depreciation, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($accumulated_Depreciation) && mb_strlen(preg_replace('/(\D)/', '', $accumulated_Depreciation)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($accumulated_Depreciation, true), mb_strlen(preg_replace('/(\D)/', '', $accumulated_Depreciation))), __LINE__);
        }
        $this->Accumulated_Depreciation = $accumulated_Depreciation;
        return $this;
    }
    /**
     * Get Transfer_To_Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getTransfer_To_Asset_Reference()
    {
        return $this->Transfer_To_Asset_Reference;
    }
    /**
     * Set Transfer_To_Asset_Reference value
     * @param \StructType\Business_AssetObjectType $transfer_To_Asset_Reference
     * @return \StructType\Asset_Intercompany_Transfer_WWS_DataType
     */
    public function setTransfer_To_Asset_Reference(\StructType\Business_AssetObjectType $transfer_To_Asset_Reference = null)
    {
        $this->Transfer_To_Asset_Reference = $transfer_To_Asset_Reference;
        return $this;
    }
}
