<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_In_Service_Schedule_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data the in-service schedule for this asset. This is present for each period of time the asset is in service, and can occur repeatedly if the asset is suspended, and later resumed.
 * @subpackage Structs
 */
class Asset_In_Service_Schedule_WWS_DataType extends AbstractStructBase
{
    /**
     * The In_Service_From_Date
     * Meta information extracted from the WSDL
     * - documentation: The start date for the in-service period for this asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $In_Service_From_Date;
    /**
     * The In_Service_To_Date
     * Meta information extracted from the WSDL
     * - documentation: The end date for the in-service period for this asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $In_Service_To_Date;
    /**
     * Constructor method for Asset_In_Service_Schedule_WWS_DataType
     * @uses Asset_In_Service_Schedule_WWS_DataType::setIn_Service_From_Date()
     * @uses Asset_In_Service_Schedule_WWS_DataType::setIn_Service_To_Date()
     * @param string $in_Service_From_Date
     * @param string $in_Service_To_Date
     */
    public function __construct($in_Service_From_Date = null, $in_Service_To_Date = null)
    {
        $this
            ->setIn_Service_From_Date($in_Service_From_Date)
            ->setIn_Service_To_Date($in_Service_To_Date);
    }
    /**
     * Get In_Service_From_Date value
     * @return string|null
     */
    public function getIn_Service_From_Date()
    {
        return $this->In_Service_From_Date;
    }
    /**
     * Set In_Service_From_Date value
     * @param string $in_Service_From_Date
     * @return \StructType\Asset_In_Service_Schedule_WWS_DataType
     */
    public function setIn_Service_From_Date($in_Service_From_Date = null)
    {
        // validation for constraint: string
        if (!is_null($in_Service_From_Date) && !is_string($in_Service_From_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($in_Service_From_Date, true), gettype($in_Service_From_Date)), __LINE__);
        }
        $this->In_Service_From_Date = $in_Service_From_Date;
        return $this;
    }
    /**
     * Get In_Service_To_Date value
     * @return string|null
     */
    public function getIn_Service_To_Date()
    {
        return $this->In_Service_To_Date;
    }
    /**
     * Set In_Service_To_Date value
     * @param string $in_Service_To_Date
     * @return \StructType\Asset_In_Service_Schedule_WWS_DataType
     */
    public function setIn_Service_To_Date($in_Service_To_Date = null)
    {
        // validation for constraint: string
        if (!is_null($in_Service_To_Date) && !is_string($in_Service_To_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($in_Service_To_Date, true), gettype($in_Service_To_Date)), __LINE__);
        }
        $this->In_Service_To_Date = $in_Service_To_Date;
        return $this;
    }
}
