<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Cost_Adjustment_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data for cost adjustment activity for this asset.
 * @subpackage Structs
 */
class Asset_Cost_Adjustment_WWS_DataType extends AbstractStructBase
{
    /**
     * The Transaction_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: The date of the asset cost adjustment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transaction_Effective_Date;
    /**
     * The Cost_Adjustment_Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount the asset's cost was adjusted.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Cost_Adjustment_Amount;
    /**
     * The Cost_Adjustment_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the reason the asset's cost was adjusted.
     * - minOccurs: 0
     * @var \StructType\Asset_Cost_Adjustment_ReasonObjectType
     */
    public $Cost_Adjustment_Reason_Reference;
    /**
     * The Residual_Value_Adjustment
     * Meta information extracted from the WSDL
     * - documentation: The amount the residual value of the asset was adjusted.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Residual_Value_Adjustment;
    /**
     * The Supplier_Invoice_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to a supplier invoice line, if there was one related to the cost adjustment associated with this asset, e.g. due to an improvement or installation cost.
     * - minOccurs: 0
     * @var \StructType\Business_Document_LineObjectType
     */
    public $Supplier_Invoice_Line_Reference;
    /**
     * Constructor method for Asset_Cost_Adjustment_WWS_DataType
     * @uses Asset_Cost_Adjustment_WWS_DataType::setTransaction_Effective_Date()
     * @uses Asset_Cost_Adjustment_WWS_DataType::setCost_Adjustment_Amount()
     * @uses Asset_Cost_Adjustment_WWS_DataType::setCost_Adjustment_Reason_Reference()
     * @uses Asset_Cost_Adjustment_WWS_DataType::setResidual_Value_Adjustment()
     * @uses Asset_Cost_Adjustment_WWS_DataType::setSupplier_Invoice_Line_Reference()
     * @param string $transaction_Effective_Date
     * @param float $cost_Adjustment_Amount
     * @param \StructType\Asset_Cost_Adjustment_ReasonObjectType $cost_Adjustment_Reason_Reference
     * @param float $residual_Value_Adjustment
     * @param \StructType\Business_Document_LineObjectType $supplier_Invoice_Line_Reference
     */
    public function __construct($transaction_Effective_Date = null, $cost_Adjustment_Amount = null, \StructType\Asset_Cost_Adjustment_ReasonObjectType $cost_Adjustment_Reason_Reference = null, $residual_Value_Adjustment = null, \StructType\Business_Document_LineObjectType $supplier_Invoice_Line_Reference = null)
    {
        $this
            ->setTransaction_Effective_Date($transaction_Effective_Date)
            ->setCost_Adjustment_Amount($cost_Adjustment_Amount)
            ->setCost_Adjustment_Reason_Reference($cost_Adjustment_Reason_Reference)
            ->setResidual_Value_Adjustment($residual_Value_Adjustment)
            ->setSupplier_Invoice_Line_Reference($supplier_Invoice_Line_Reference);
    }
    /**
     * Get Transaction_Effective_Date value
     * @return string|null
     */
    public function getTransaction_Effective_Date()
    {
        return $this->Transaction_Effective_Date;
    }
    /**
     * Set Transaction_Effective_Date value
     * @param string $transaction_Effective_Date
     * @return \StructType\Asset_Cost_Adjustment_WWS_DataType
     */
    public function setTransaction_Effective_Date($transaction_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Effective_Date) && !is_string($transaction_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Effective_Date, true), gettype($transaction_Effective_Date)), __LINE__);
        }
        $this->Transaction_Effective_Date = $transaction_Effective_Date;
        return $this;
    }
    /**
     * Get Cost_Adjustment_Amount value
     * @return float|null
     */
    public function getCost_Adjustment_Amount()
    {
        return $this->Cost_Adjustment_Amount;
    }
    /**
     * Set Cost_Adjustment_Amount value
     * @param float $cost_Adjustment_Amount
     * @return \StructType\Asset_Cost_Adjustment_WWS_DataType
     */
    public function setCost_Adjustment_Amount($cost_Adjustment_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($cost_Adjustment_Amount) && !(is_float($cost_Adjustment_Amount) || is_numeric($cost_Adjustment_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost_Adjustment_Amount, true), gettype($cost_Adjustment_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($cost_Adjustment_Amount) && mb_strlen(mb_substr($cost_Adjustment_Amount, false !== mb_strpos($cost_Adjustment_Amount, '.') ? mb_strpos($cost_Adjustment_Amount, '.') + 1 : mb_strlen($cost_Adjustment_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($cost_Adjustment_Amount, true), mb_strlen(mb_substr($cost_Adjustment_Amount, mb_strpos($cost_Adjustment_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($cost_Adjustment_Amount) && mb_strlen(preg_replace('/(\D)/', '', $cost_Adjustment_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($cost_Adjustment_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $cost_Adjustment_Amount))), __LINE__);
        }
        $this->Cost_Adjustment_Amount = $cost_Adjustment_Amount;
        return $this;
    }
    /**
     * Get Cost_Adjustment_Reason_Reference value
     * @return \StructType\Asset_Cost_Adjustment_ReasonObjectType|null
     */
    public function getCost_Adjustment_Reason_Reference()
    {
        return $this->Cost_Adjustment_Reason_Reference;
    }
    /**
     * Set Cost_Adjustment_Reason_Reference value
     * @param \StructType\Asset_Cost_Adjustment_ReasonObjectType $cost_Adjustment_Reason_Reference
     * @return \StructType\Asset_Cost_Adjustment_WWS_DataType
     */
    public function setCost_Adjustment_Reason_Reference(\StructType\Asset_Cost_Adjustment_ReasonObjectType $cost_Adjustment_Reason_Reference = null)
    {
        $this->Cost_Adjustment_Reason_Reference = $cost_Adjustment_Reason_Reference;
        return $this;
    }
    /**
     * Get Residual_Value_Adjustment value
     * @return float|null
     */
    public function getResidual_Value_Adjustment()
    {
        return $this->Residual_Value_Adjustment;
    }
    /**
     * Set Residual_Value_Adjustment value
     * @param float $residual_Value_Adjustment
     * @return \StructType\Asset_Cost_Adjustment_WWS_DataType
     */
    public function setResidual_Value_Adjustment($residual_Value_Adjustment = null)
    {
        // validation for constraint: float
        if (!is_null($residual_Value_Adjustment) && !(is_float($residual_Value_Adjustment) || is_numeric($residual_Value_Adjustment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($residual_Value_Adjustment, true), gettype($residual_Value_Adjustment)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($residual_Value_Adjustment) && mb_strlen(mb_substr($residual_Value_Adjustment, false !== mb_strpos($residual_Value_Adjustment, '.') ? mb_strpos($residual_Value_Adjustment, '.') + 1 : mb_strlen($residual_Value_Adjustment))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($residual_Value_Adjustment, true), mb_strlen(mb_substr($residual_Value_Adjustment, mb_strpos($residual_Value_Adjustment, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($residual_Value_Adjustment) && mb_strlen(preg_replace('/(\D)/', '', $residual_Value_Adjustment)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($residual_Value_Adjustment, true), mb_strlen(preg_replace('/(\D)/', '', $residual_Value_Adjustment))), __LINE__);
        }
        $this->Residual_Value_Adjustment = $residual_Value_Adjustment;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Line_Reference value
     * @return \StructType\Business_Document_LineObjectType|null
     */
    public function getSupplier_Invoice_Line_Reference()
    {
        return $this->Supplier_Invoice_Line_Reference;
    }
    /**
     * Set Supplier_Invoice_Line_Reference value
     * @param \StructType\Business_Document_LineObjectType $supplier_Invoice_Line_Reference
     * @return \StructType\Asset_Cost_Adjustment_WWS_DataType
     */
    public function setSupplier_Invoice_Line_Reference(\StructType\Business_Document_LineObjectType $supplier_Invoice_Line_Reference = null)
    {
        $this->Supplier_Invoice_Line_Reference = $supplier_Invoice_Line_Reference;
        return $this;
    }
}
