<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Book_Configurations_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Request Criteria is a wrapper element around a list of elements representing the operation specific criteria needed to search for asset depreciation schedules
 * @subpackage Structs
 */
class Asset_Book_Configurations_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more Company references to use to filter the asset depreciation schedules returned in the response.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType[]
     */
    public $Company_Reference;
    /**
     * The Asset_Name
     * Meta information extracted from the WSDL
     * - documentation: An Asset Name value to be used to return asset depreciation schedules for an existing asset with the matching Asset Name value.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Name;
    /**
     * The Asset_Book_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more Asset Books to return asset depreciation schedule for these books
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_BookObjectType[]
     */
    public $Asset_Book_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more Spend Category(s) of assets to return asset depreciation schedules for assets in those categories.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType[]
     */
    public $Spend_Category_Reference;
    /**
     * The Asset_Class_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more Asset Class(s) to return asset depreciation schedules for assets in those classes
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_ClassObjectType[]
     */
    public $Asset_Class_Reference;
    /**
     * The Asset_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more Asset Type(s) to return asset depreciation schedules for assets in those types
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_TypeObjectType[]
     */
    public $Asset_Type_Reference;
    /**
     * The Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more Locations to returns asset depreciation schedules for assets currently placed in those locations.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LocationObjectType[]
     */
    public $Location_Reference;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more Worktag references to be used to return asset depreciation schedules for Assets currently assigned any of these worktags. To filter based on Location, use the Location Reference element.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Acquired_From_Date
     * Meta information extracted from the WSDL
     * - documentation: Allows you to return asset depreciation schedule for assets by the date they were acquired. This is the From Date to find assets by acquisition date. This date is inclusive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Acquired_From_Date;
    /**
     * The Acquired_To_Date
     * Meta information extracted from the WSDL
     * - documentation: Allows you to return asset depreciation schedules for assets by the date they were acquired. This is the To Date to find assets by acquisition date. This date is inclusive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Acquired_To_Date;
    /**
     * The In_Service_From_Date
     * Meta information extracted from the WSDL
     * - documentation: Allows you to return asset depreciation schedules by the date they were placed in service. This is the From Date to find asset depreciation schedules by in service date. This date is inclusive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $In_Service_From_Date;
    /**
     * The In_Service_To_Date
     * Meta information extracted from the WSDL
     * - documentation: Allows you to return asset depreciation schedules by the date they were placed in service. This is the To Date to find asset depreciation schedules by in service date. This date is inclusive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $In_Service_To_Date;
    /**
     * The Asset_Depreciation_Schedule_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enter an Asset Depreciation Schedule Status reference to return schedules currently in that status. Valid values for depreciation schedule status is In Service, Registered and disposed. Don't enter a status reference to return
     * schedules in any status.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType[]
     */
    public $Asset_Depreciation_Schedule_Status_Reference;
    /**
     * The Acquisition_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more Acquisition Method references to return asset depreciation schedules for assets acquired using one of those methods.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Acquisition_MethodObjectType[]
     */
    public $Acquisition_Method_Reference;
    /**
     * The Accounting_Treatment_Reference
     * Meta information extracted from the WSDL
     * - documentation: One or more Accounting Treatment references to return asset depreciation schedules with those accounting treatments. A depreciation schedule can have accounting treatment of Expense, Depreciable, or Non-Depreciable.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_TreatmentObjectType[]
     */
    public $Accounting_Treatment_Reference;
    /**
     * The Exclude_Schedules_with_Historical_Information
     * Meta information extracted from the WSDL
     * - documentation: Allows you to return asset depreciation schedules with no historical information such as accumulated depreciation. Enter 1 to exclude asset depreciation schedules with historical information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude_Schedules_with_Historical_Information;
    /**
     * Constructor method for Asset_Book_Configurations_Request_CriteriaType
     * @uses Asset_Book_Configurations_Request_CriteriaType::setCompany_Reference()
     * @uses Asset_Book_Configurations_Request_CriteriaType::setAsset_Name()
     * @uses Asset_Book_Configurations_Request_CriteriaType::setAsset_Book_Reference()
     * @uses Asset_Book_Configurations_Request_CriteriaType::setSpend_Category_Reference()
     * @uses Asset_Book_Configurations_Request_CriteriaType::setAsset_Class_Reference()
     * @uses Asset_Book_Configurations_Request_CriteriaType::setAsset_Type_Reference()
     * @uses Asset_Book_Configurations_Request_CriteriaType::setLocation_Reference()
     * @uses Asset_Book_Configurations_Request_CriteriaType::setWorktags_Reference()
     * @uses Asset_Book_Configurations_Request_CriteriaType::setAcquired_From_Date()
     * @uses Asset_Book_Configurations_Request_CriteriaType::setAcquired_To_Date()
     * @uses Asset_Book_Configurations_Request_CriteriaType::setIn_Service_From_Date()
     * @uses Asset_Book_Configurations_Request_CriteriaType::setIn_Service_To_Date()
     * @uses Asset_Book_Configurations_Request_CriteriaType::setAsset_Depreciation_Schedule_Status_Reference()
     * @uses Asset_Book_Configurations_Request_CriteriaType::setAcquisition_Method_Reference()
     * @uses Asset_Book_Configurations_Request_CriteriaType::setAccounting_Treatment_Reference()
     * @uses Asset_Book_Configurations_Request_CriteriaType::setExclude_Schedules_with_Historical_Information()
     * @param \StructType\CompanyObjectType[] $company_Reference
     * @param string $asset_Name
     * @param \StructType\Asset_BookObjectType[] $asset_Book_Reference
     * @param \StructType\Spend_CategoryObjectType[] $spend_Category_Reference
     * @param \StructType\Asset_ClassObjectType[] $asset_Class_Reference
     * @param \StructType\Asset_TypeObjectType[] $asset_Type_Reference
     * @param \StructType\LocationObjectType[] $location_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @param string $acquired_From_Date
     * @param string $acquired_To_Date
     * @param string $in_Service_From_Date
     * @param string $in_Service_To_Date
     * @param \StructType\Document_StatusObjectType[] $asset_Depreciation_Schedule_Status_Reference
     * @param \StructType\Acquisition_MethodObjectType[] $acquisition_Method_Reference
     * @param \StructType\Accounting_TreatmentObjectType[] $accounting_Treatment_Reference
     * @param bool $exclude_Schedules_with_Historical_Information
     */
    public function __construct(array $company_Reference = array(), $asset_Name = null, array $asset_Book_Reference = array(), array $spend_Category_Reference = array(), array $asset_Class_Reference = array(), array $asset_Type_Reference = array(), array $location_Reference = array(), array $worktags_Reference = array(), $acquired_From_Date = null, $acquired_To_Date = null, $in_Service_From_Date = null, $in_Service_To_Date = null, array $asset_Depreciation_Schedule_Status_Reference = array(), array $acquisition_Method_Reference = array(), array $accounting_Treatment_Reference = array(), $exclude_Schedules_with_Historical_Information = null)
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setAsset_Name($asset_Name)
            ->setAsset_Book_Reference($asset_Book_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setAsset_Class_Reference($asset_Class_Reference)
            ->setAsset_Type_Reference($asset_Type_Reference)
            ->setLocation_Reference($location_Reference)
            ->setWorktags_Reference($worktags_Reference)
            ->setAcquired_From_Date($acquired_From_Date)
            ->setAcquired_To_Date($acquired_To_Date)
            ->setIn_Service_From_Date($in_Service_From_Date)
            ->setIn_Service_To_Date($in_Service_To_Date)
            ->setAsset_Depreciation_Schedule_Status_Reference($asset_Depreciation_Schedule_Status_Reference)
            ->setAcquisition_Method_Reference($acquisition_Method_Reference)
            ->setAccounting_Treatment_Reference($accounting_Treatment_Reference)
            ->setExclude_Schedules_with_Historical_Information($exclude_Schedules_with_Historical_Information);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_Configurations_Request_CriteriaTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Book_Configurations_Request_CriteriaTypeCompany_ReferenceItem instanceof \StructType\CompanyObjectType) {
                $invalidValues[] = is_object($asset_Book_Configurations_Request_CriteriaTypeCompany_ReferenceItem) ? get_class($asset_Book_Configurations_Request_CriteriaTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Book_Configurations_Request_CriteriaTypeCompany_ReferenceItem), var_export($asset_Book_Configurations_Request_CriteriaTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType[] $company_Reference
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType $item
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function addToCompany_Reference(\StructType\CompanyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Asset_Name value
     * @return string|null
     */
    public function getAsset_Name()
    {
        return $this->Asset_Name;
    }
    /**
     * Set Asset_Name value
     * @param string $asset_Name
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function setAsset_Name($asset_Name = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Name) && !is_string($asset_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Name, true), gettype($asset_Name)), __LINE__);
        }
        $this->Asset_Name = $asset_Name;
        return $this;
    }
    /**
     * Get Asset_Book_Reference value
     * @return \StructType\Asset_BookObjectType[]|null
     */
    public function getAsset_Book_Reference()
    {
        return $this->Asset_Book_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Book_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Book_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Book_ReferenceForArrayConstraintsFromSetAsset_Book_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_Configurations_Request_CriteriaTypeAsset_Book_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Book_Configurations_Request_CriteriaTypeAsset_Book_ReferenceItem instanceof \StructType\Asset_BookObjectType) {
                $invalidValues[] = is_object($asset_Book_Configurations_Request_CriteriaTypeAsset_Book_ReferenceItem) ? get_class($asset_Book_Configurations_Request_CriteriaTypeAsset_Book_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Book_Configurations_Request_CriteriaTypeAsset_Book_ReferenceItem), var_export($asset_Book_Configurations_Request_CriteriaTypeAsset_Book_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Book_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Book_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType[] $asset_Book_Reference
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function setAsset_Book_Reference(array $asset_Book_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Book_ReferenceArrayErrorMessage = self::validateAsset_Book_ReferenceForArrayConstraintsFromSetAsset_Book_Reference($asset_Book_Reference))) {
            throw new \InvalidArgumentException($asset_Book_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Asset_Book_Reference = $asset_Book_Reference;
        return $this;
    }
    /**
     * Add item to Asset_Book_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType $item
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function addToAsset_Book_Reference(\StructType\Asset_BookObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_BookObjectType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Book_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Book_Reference[] = $item;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType[]|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_Configurations_Request_CriteriaTypeSpend_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Book_Configurations_Request_CriteriaTypeSpend_Category_ReferenceItem instanceof \StructType\Spend_CategoryObjectType) {
                $invalidValues[] = is_object($asset_Book_Configurations_Request_CriteriaTypeSpend_Category_ReferenceItem) ? get_class($asset_Book_Configurations_Request_CriteriaTypeSpend_Category_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Book_Configurations_Request_CriteriaTypeSpend_Category_ReferenceItem), var_export($asset_Book_Configurations_Request_CriteriaTypeSpend_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_CategoryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType[] $spend_Category_Reference
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function setSpend_Category_Reference(array $spend_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Category_ReferenceArrayErrorMessage = self::validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference($spend_Category_Reference))) {
            throw new \InvalidArgumentException($spend_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Add item to Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType $item
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function addToSpend_Category_Reference(\StructType\Spend_CategoryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_CategoryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_CategoryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Category_Reference[] = $item;
        return $this;
    }
    /**
     * Get Asset_Class_Reference value
     * @return \StructType\Asset_ClassObjectType[]|null
     */
    public function getAsset_Class_Reference()
    {
        return $this->Asset_Class_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Class_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Class_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Class_ReferenceForArrayConstraintsFromSetAsset_Class_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_Configurations_Request_CriteriaTypeAsset_Class_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Book_Configurations_Request_CriteriaTypeAsset_Class_ReferenceItem instanceof \StructType\Asset_ClassObjectType) {
                $invalidValues[] = is_object($asset_Book_Configurations_Request_CriteriaTypeAsset_Class_ReferenceItem) ? get_class($asset_Book_Configurations_Request_CriteriaTypeAsset_Class_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Book_Configurations_Request_CriteriaTypeAsset_Class_ReferenceItem), var_export($asset_Book_Configurations_Request_CriteriaTypeAsset_Class_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Class_Reference property can only contain items of type \StructType\Asset_ClassObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Class_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_ClassObjectType[] $asset_Class_Reference
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function setAsset_Class_Reference(array $asset_Class_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Class_ReferenceArrayErrorMessage = self::validateAsset_Class_ReferenceForArrayConstraintsFromSetAsset_Class_Reference($asset_Class_Reference))) {
            throw new \InvalidArgumentException($asset_Class_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Asset_Class_Reference = $asset_Class_Reference;
        return $this;
    }
    /**
     * Add item to Asset_Class_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_ClassObjectType $item
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function addToAsset_Class_Reference(\StructType\Asset_ClassObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_ClassObjectType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Class_Reference property can only contain items of type \StructType\Asset_ClassObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Class_Reference[] = $item;
        return $this;
    }
    /**
     * Get Asset_Type_Reference value
     * @return \StructType\Asset_TypeObjectType[]|null
     */
    public function getAsset_Type_Reference()
    {
        return $this->Asset_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Type_ReferenceForArrayConstraintsFromSetAsset_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_Configurations_Request_CriteriaTypeAsset_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Book_Configurations_Request_CriteriaTypeAsset_Type_ReferenceItem instanceof \StructType\Asset_TypeObjectType) {
                $invalidValues[] = is_object($asset_Book_Configurations_Request_CriteriaTypeAsset_Type_ReferenceItem) ? get_class($asset_Book_Configurations_Request_CriteriaTypeAsset_Type_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Book_Configurations_Request_CriteriaTypeAsset_Type_ReferenceItem), var_export($asset_Book_Configurations_Request_CriteriaTypeAsset_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Type_Reference property can only contain items of type \StructType\Asset_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_TypeObjectType[] $asset_Type_Reference
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function setAsset_Type_Reference(array $asset_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Type_ReferenceArrayErrorMessage = self::validateAsset_Type_ReferenceForArrayConstraintsFromSetAsset_Type_Reference($asset_Type_Reference))) {
            throw new \InvalidArgumentException($asset_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Asset_Type_Reference = $asset_Type_Reference;
        return $this;
    }
    /**
     * Add item to Asset_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_TypeObjectType $item
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function addToAsset_Type_Reference(\StructType\Asset_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Type_Reference property can only contain items of type \StructType\Asset_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Location_Reference value
     * @return \StructType\LocationObjectType[]|null
     */
    public function getLocation_Reference()
    {
        return $this->Location_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocation_ReferenceForArrayConstraintsFromSetLocation_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_Configurations_Request_CriteriaTypeLocation_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Book_Configurations_Request_CriteriaTypeLocation_ReferenceItem instanceof \StructType\LocationObjectType) {
                $invalidValues[] = is_object($asset_Book_Configurations_Request_CriteriaTypeLocation_ReferenceItem) ? get_class($asset_Book_Configurations_Request_CriteriaTypeLocation_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Book_Configurations_Request_CriteriaTypeLocation_ReferenceItem), var_export($asset_Book_Configurations_Request_CriteriaTypeLocation_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Location_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType[] $location_Reference
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function setLocation_Reference(array $location_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($location_ReferenceArrayErrorMessage = self::validateLocation_ReferenceForArrayConstraintsFromSetLocation_Reference($location_Reference))) {
            throw new \InvalidArgumentException($location_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Location_Reference = $location_Reference;
        return $this;
    }
    /**
     * Add item to Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationObjectType $item
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function addToLocation_Reference(\StructType\LocationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Location_Reference property can only contain items of type \StructType\LocationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Location_Reference[] = $item;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_Configurations_Request_CriteriaTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Book_Configurations_Request_CriteriaTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($asset_Book_Configurations_Request_CriteriaTypeWorktags_ReferenceItem) ? get_class($asset_Book_Configurations_Request_CriteriaTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Book_Configurations_Request_CriteriaTypeWorktags_ReferenceItem), var_export($asset_Book_Configurations_Request_CriteriaTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Acquired_From_Date value
     * @return string|null
     */
    public function getAcquired_From_Date()
    {
        return $this->Acquired_From_Date;
    }
    /**
     * Set Acquired_From_Date value
     * @param string $acquired_From_Date
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function setAcquired_From_Date($acquired_From_Date = null)
    {
        // validation for constraint: string
        if (!is_null($acquired_From_Date) && !is_string($acquired_From_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acquired_From_Date, true), gettype($acquired_From_Date)), __LINE__);
        }
        $this->Acquired_From_Date = $acquired_From_Date;
        return $this;
    }
    /**
     * Get Acquired_To_Date value
     * @return string|null
     */
    public function getAcquired_To_Date()
    {
        return $this->Acquired_To_Date;
    }
    /**
     * Set Acquired_To_Date value
     * @param string $acquired_To_Date
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function setAcquired_To_Date($acquired_To_Date = null)
    {
        // validation for constraint: string
        if (!is_null($acquired_To_Date) && !is_string($acquired_To_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acquired_To_Date, true), gettype($acquired_To_Date)), __LINE__);
        }
        $this->Acquired_To_Date = $acquired_To_Date;
        return $this;
    }
    /**
     * Get In_Service_From_Date value
     * @return string|null
     */
    public function getIn_Service_From_Date()
    {
        return $this->In_Service_From_Date;
    }
    /**
     * Set In_Service_From_Date value
     * @param string $in_Service_From_Date
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function setIn_Service_From_Date($in_Service_From_Date = null)
    {
        // validation for constraint: string
        if (!is_null($in_Service_From_Date) && !is_string($in_Service_From_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($in_Service_From_Date, true), gettype($in_Service_From_Date)), __LINE__);
        }
        $this->In_Service_From_Date = $in_Service_From_Date;
        return $this;
    }
    /**
     * Get In_Service_To_Date value
     * @return string|null
     */
    public function getIn_Service_To_Date()
    {
        return $this->In_Service_To_Date;
    }
    /**
     * Set In_Service_To_Date value
     * @param string $in_Service_To_Date
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function setIn_Service_To_Date($in_Service_To_Date = null)
    {
        // validation for constraint: string
        if (!is_null($in_Service_To_Date) && !is_string($in_Service_To_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($in_Service_To_Date, true), gettype($in_Service_To_Date)), __LINE__);
        }
        $this->In_Service_To_Date = $in_Service_To_Date;
        return $this;
    }
    /**
     * Get Asset_Depreciation_Schedule_Status_Reference value
     * @return \StructType\Document_StatusObjectType[]|null
     */
    public function getAsset_Depreciation_Schedule_Status_Reference()
    {
        return $this->Asset_Depreciation_Schedule_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Depreciation_Schedule_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Depreciation_Schedule_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Depreciation_Schedule_Status_ReferenceForArrayConstraintsFromSetAsset_Depreciation_Schedule_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_Configurations_Request_CriteriaTypeAsset_Depreciation_Schedule_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Book_Configurations_Request_CriteriaTypeAsset_Depreciation_Schedule_Status_ReferenceItem instanceof \StructType\Document_StatusObjectType) {
                $invalidValues[] = is_object($asset_Book_Configurations_Request_CriteriaTypeAsset_Depreciation_Schedule_Status_ReferenceItem) ? get_class($asset_Book_Configurations_Request_CriteriaTypeAsset_Depreciation_Schedule_Status_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Book_Configurations_Request_CriteriaTypeAsset_Depreciation_Schedule_Status_ReferenceItem), var_export($asset_Book_Configurations_Request_CriteriaTypeAsset_Depreciation_Schedule_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Depreciation_Schedule_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Depreciation_Schedule_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType[] $asset_Depreciation_Schedule_Status_Reference
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function setAsset_Depreciation_Schedule_Status_Reference(array $asset_Depreciation_Schedule_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Depreciation_Schedule_Status_ReferenceArrayErrorMessage = self::validateAsset_Depreciation_Schedule_Status_ReferenceForArrayConstraintsFromSetAsset_Depreciation_Schedule_Status_Reference($asset_Depreciation_Schedule_Status_Reference))) {
            throw new \InvalidArgumentException($asset_Depreciation_Schedule_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Asset_Depreciation_Schedule_Status_Reference = $asset_Depreciation_Schedule_Status_Reference;
        return $this;
    }
    /**
     * Add item to Asset_Depreciation_Schedule_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType $item
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function addToAsset_Depreciation_Schedule_Status_Reference(\StructType\Document_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Depreciation_Schedule_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Depreciation_Schedule_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Acquisition_Method_Reference value
     * @return \StructType\Acquisition_MethodObjectType[]|null
     */
    public function getAcquisition_Method_Reference()
    {
        return $this->Acquisition_Method_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAcquisition_Method_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcquisition_Method_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAcquisition_Method_ReferenceForArrayConstraintsFromSetAcquisition_Method_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_Configurations_Request_CriteriaTypeAcquisition_Method_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Book_Configurations_Request_CriteriaTypeAcquisition_Method_ReferenceItem instanceof \StructType\Acquisition_MethodObjectType) {
                $invalidValues[] = is_object($asset_Book_Configurations_Request_CriteriaTypeAcquisition_Method_ReferenceItem) ? get_class($asset_Book_Configurations_Request_CriteriaTypeAcquisition_Method_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Book_Configurations_Request_CriteriaTypeAcquisition_Method_ReferenceItem), var_export($asset_Book_Configurations_Request_CriteriaTypeAcquisition_Method_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Acquisition_Method_Reference property can only contain items of type \StructType\Acquisition_MethodObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Acquisition_Method_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Acquisition_MethodObjectType[] $acquisition_Method_Reference
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function setAcquisition_Method_Reference(array $acquisition_Method_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($acquisition_Method_ReferenceArrayErrorMessage = self::validateAcquisition_Method_ReferenceForArrayConstraintsFromSetAcquisition_Method_Reference($acquisition_Method_Reference))) {
            throw new \InvalidArgumentException($acquisition_Method_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Acquisition_Method_Reference = $acquisition_Method_Reference;
        return $this;
    }
    /**
     * Add item to Acquisition_Method_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Acquisition_MethodObjectType $item
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function addToAcquisition_Method_Reference(\StructType\Acquisition_MethodObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Acquisition_MethodObjectType) {
            throw new \InvalidArgumentException(sprintf('The Acquisition_Method_Reference property can only contain items of type \StructType\Acquisition_MethodObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Acquisition_Method_Reference[] = $item;
        return $this;
    }
    /**
     * Get Accounting_Treatment_Reference value
     * @return \StructType\Accounting_TreatmentObjectType[]|null
     */
    public function getAccounting_Treatment_Reference()
    {
        return $this->Accounting_Treatment_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAccounting_Treatment_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccounting_Treatment_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccounting_Treatment_ReferenceForArrayConstraintsFromSetAccounting_Treatment_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_Configurations_Request_CriteriaTypeAccounting_Treatment_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Book_Configurations_Request_CriteriaTypeAccounting_Treatment_ReferenceItem instanceof \StructType\Accounting_TreatmentObjectType) {
                $invalidValues[] = is_object($asset_Book_Configurations_Request_CriteriaTypeAccounting_Treatment_ReferenceItem) ? get_class($asset_Book_Configurations_Request_CriteriaTypeAccounting_Treatment_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Book_Configurations_Request_CriteriaTypeAccounting_Treatment_ReferenceItem), var_export($asset_Book_Configurations_Request_CriteriaTypeAccounting_Treatment_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Accounting_Treatment_Reference property can only contain items of type \StructType\Accounting_TreatmentObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Accounting_Treatment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_TreatmentObjectType[] $accounting_Treatment_Reference
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function setAccounting_Treatment_Reference(array $accounting_Treatment_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($accounting_Treatment_ReferenceArrayErrorMessage = self::validateAccounting_Treatment_ReferenceForArrayConstraintsFromSetAccounting_Treatment_Reference($accounting_Treatment_Reference))) {
            throw new \InvalidArgumentException($accounting_Treatment_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Accounting_Treatment_Reference = $accounting_Treatment_Reference;
        return $this;
    }
    /**
     * Add item to Accounting_Treatment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_TreatmentObjectType $item
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function addToAccounting_Treatment_Reference(\StructType\Accounting_TreatmentObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_TreatmentObjectType) {
            throw new \InvalidArgumentException(sprintf('The Accounting_Treatment_Reference property can only contain items of type \StructType\Accounting_TreatmentObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Accounting_Treatment_Reference[] = $item;
        return $this;
    }
    /**
     * Get Exclude_Schedules_with_Historical_Information value
     * @return bool|null
     */
    public function getExclude_Schedules_with_Historical_Information()
    {
        return $this->Exclude_Schedules_with_Historical_Information;
    }
    /**
     * Set Exclude_Schedules_with_Historical_Information value
     * @param bool $exclude_Schedules_with_Historical_Information
     * @return \StructType\Asset_Book_Configurations_Request_CriteriaType
     */
    public function setExclude_Schedules_with_Historical_Information($exclude_Schedules_with_Historical_Information = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_Schedules_with_Historical_Information) && !is_bool($exclude_Schedules_with_Historical_Information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclude_Schedules_with_Historical_Information, true), gettype($exclude_Schedules_with_Historical_Information)), __LINE__);
        }
        $this->Exclude_Schedules_with_Historical_Information = $exclude_Schedules_with_Historical_Information;
        return $this;
    }
}
