<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Allowed_Worktag_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Reference to existing Allowed Related Worktags or Add new Allowed Related Worktags
 * @subpackage Structs
 */
class Allowed_Worktag_DataType extends AbstractStructBase
{
    /**
     * The Allowed_Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: IMPORTANT: You must check 'Separate Type Column' for this field in your EIB template to see values when you generate a template with data or to configure related worktags for multiple worktag types. The list of valid ID types for
     * this column exceeds the size limit of an Excel validation list so ID types must be entered as text. Valid ID types for this column may include: Business_Unit_Hierarchy_ID, Business_Unit_ID, Cost_Center_Reference_ID, Custom_Organization_Reference_ID,
     * Custom_Worktag_1-5_ID, Custom_Worktag_06-15_ID, Fund_Hierarchy_ID, Fund_ID, Gift_Hierarchy_ID, Gift_Reference_ID, Grant_Hierarchy_ID, Grant_ID, Investor_ID, Location_ID, Opportunity_Reference_ID, Organization_Reference_ID, Program_Hierarchy_ID,
     * Program_ID, Project_Hierarchy_ID, Project_ID, Project_Phase_Name_ID, Project_Task_Name_ID, Region_Reference_ID, Sales_Item_Group_ID, Sales_Item_ID.
     * - minOccurs: 0
     * @var \StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType
     */
    public $Allowed_Worktag_Reference;
    /**
     * The Delete_Allowed_Value
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate that specified allowed values are to be deleted. At least 1 existing allowed value must be specified When set to true (or 'y' in EIB). Cannot be set to true if 'Replace All Allowed Values' is set to true.
     * @var bool
     */
    public $Delete_Allowed_Value;
    /**
     * Constructor method for Allowed_Worktag_DataType
     * @uses Allowed_Worktag_DataType::setAllowed_Worktag_Reference()
     * @uses Allowed_Worktag_DataType::setDelete_Allowed_Value()
     * @param \StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType $allowed_Worktag_Reference
     * @param bool $delete_Allowed_Value
     */
    public function __construct(\StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType $allowed_Worktag_Reference = null, $delete_Allowed_Value = null)
    {
        $this
            ->setAllowed_Worktag_Reference($allowed_Worktag_Reference)
            ->setDelete_Allowed_Value($delete_Allowed_Value);
    }
    /**
     * Get Allowed_Worktag_Reference value
     * @return \StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType|null
     */
    public function getAllowed_Worktag_Reference()
    {
        return $this->Allowed_Worktag_Reference;
    }
    /**
     * Set Allowed_Worktag_Reference value
     * @param \StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType $allowed_Worktag_Reference
     * @return \StructType\Allowed_Worktag_DataType
     */
    public function setAllowed_Worktag_Reference(\StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType $allowed_Worktag_Reference = null)
    {
        $this->Allowed_Worktag_Reference = $allowed_Worktag_Reference;
        return $this;
    }
    /**
     * Get Delete_Allowed_Value value
     * @return bool|null
     */
    public function getDelete_Allowed_Value()
    {
        return $this->Delete_Allowed_Value;
    }
    /**
     * Set Delete_Allowed_Value value
     * @param bool $delete_Allowed_Value
     * @return \StructType\Allowed_Worktag_DataType
     */
    public function setDelete_Allowed_Value($delete_Allowed_Value = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete_Allowed_Value) && !is_bool($delete_Allowed_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete_Allowed_Value, true), gettype($delete_Allowed_Value)), __LINE__);
        }
        $this->Delete_Allowed_Value = $delete_Allowed_Value;
        return $this;
    }
}
