<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirportType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element for Airport Data
 * @subpackage Structs
 */
class AirportType extends AbstractStructBase
{
    /**
     * The Airport_Reference
     * Meta information extracted from the WSDL
     * - documentation: Airport Reference
     * - minOccurs: 0
     * @var \StructType\AirportObjectType
     */
    public $Airport_Reference;
    /**
     * The Airport_Data
     * Meta information extracted from the WSDL
     * - documentation: Airport Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Airport_DataType[]
     */
    public $Airport_Data;
    /**
     * Constructor method for AirportType
     * @uses AirportType::setAirport_Reference()
     * @uses AirportType::setAirport_Data()
     * @param \StructType\AirportObjectType $airport_Reference
     * @param \StructType\Airport_DataType[] $airport_Data
     */
    public function __construct(\StructType\AirportObjectType $airport_Reference = null, array $airport_Data = array())
    {
        $this
            ->setAirport_Reference($airport_Reference)
            ->setAirport_Data($airport_Data);
    }
    /**
     * Get Airport_Reference value
     * @return \StructType\AirportObjectType|null
     */
    public function getAirport_Reference()
    {
        return $this->Airport_Reference;
    }
    /**
     * Set Airport_Reference value
     * @param \StructType\AirportObjectType $airport_Reference
     * @return \StructType\AirportType
     */
    public function setAirport_Reference(\StructType\AirportObjectType $airport_Reference = null)
    {
        $this->Airport_Reference = $airport_Reference;
        return $this;
    }
    /**
     * Get Airport_Data value
     * @return \StructType\Airport_DataType[]|null
     */
    public function getAirport_Data()
    {
        return $this->Airport_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAirport_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirport_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirport_DataForArrayConstraintsFromSetAirport_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airportTypeAirport_DataItem) {
            // validation for constraint: itemType
            if (!$airportTypeAirport_DataItem instanceof \StructType\Airport_DataType) {
                $invalidValues[] = is_object($airportTypeAirport_DataItem) ? get_class($airportTypeAirport_DataItem) : sprintf('%s(%s)', gettype($airportTypeAirport_DataItem), var_export($airportTypeAirport_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Airport_Data property can only contain items of type \StructType\Airport_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Airport_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Airport_DataType[] $airport_Data
     * @return \StructType\AirportType
     */
    public function setAirport_Data(array $airport_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($airport_DataArrayErrorMessage = self::validateAirport_DataForArrayConstraintsFromSetAirport_Data($airport_Data))) {
            throw new \InvalidArgumentException($airport_DataArrayErrorMessage, __LINE__);
        }
        $this->Airport_Data = $airport_Data;
        return $this;
    }
    /**
     * Add item to Airport_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Airport_DataType $item
     * @return \StructType\AirportType
     */
    public function addToAirport_Data(\StructType\Airport_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Airport_DataType) {
            throw new \InvalidArgumentException(sprintf('The Airport_Data property can only contain items of type \StructType\Airport_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Airport_Data[] = $item;
        return $this;
    }
}
