<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Airline_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Airline Response Data
 * @subpackage Structs
 */
class Airline_Response_DataType extends AbstractStructBase
{
    /**
     * The Airline
     * Meta information extracted from the WSDL
     * - documentation: Airline
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineType[]
     */
    public $Airline;
    /**
     * Constructor method for Airline_Response_DataType
     * @uses Airline_Response_DataType::setAirline()
     * @param \StructType\AirlineType[] $airline
     */
    public function __construct(array $airline = array())
    {
        $this
            ->setAirline($airline);
    }
    /**
     * Get Airline value
     * @return \StructType\AirlineType[]|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * This method is responsible for validating the values passed to the setAirline method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirline method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineForArrayConstraintsFromSetAirline(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airline_Response_DataTypeAirlineItem) {
            // validation for constraint: itemType
            if (!$airline_Response_DataTypeAirlineItem instanceof \StructType\AirlineType) {
                $invalidValues[] = is_object($airline_Response_DataTypeAirlineItem) ? get_class($airline_Response_DataTypeAirlineItem) : sprintf('%s(%s)', gettype($airline_Response_DataTypeAirlineItem), var_export($airline_Response_DataTypeAirlineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Airline property can only contain items of type \StructType\AirlineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Airline value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineType[] $airline
     * @return \StructType\Airline_Response_DataType
     */
    public function setAirline(array $airline = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineArrayErrorMessage = self::validateAirlineForArrayConstraintsFromSetAirline($airline))) {
            throw new \InvalidArgumentException($airlineArrayErrorMessage, __LINE__);
        }
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Add item to Airline value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineType $item
     * @return \StructType\Airline_Response_DataType
     */
    public function addToAirline(\StructType\AirlineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineType) {
            throw new \InvalidArgumentException(sprintf('The Airline property can only contain items of type \StructType\AirlineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Airline[] = $item;
        return $this;
    }
}
