<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Add_Supplier_Contract_Line_Hold_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Add Supplier Contract Line Hold Data
 * @subpackage Structs
 */
class Add_Supplier_Contract_Line_Hold_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Contract_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Contract_ID;
    /**
     * The Supplier_Contract_Line_Add_Hold_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Goods_Line_Add_Hold_DataType[]
     */
    public $Supplier_Contract_Line_Add_Hold_Data;
    /**
     * Constructor method for Add_Supplier_Contract_Line_Hold_DataType
     * @uses Add_Supplier_Contract_Line_Hold_DataType::setSupplier_Contract_ID()
     * @uses Add_Supplier_Contract_Line_Hold_DataType::setSupplier_Contract_Line_Add_Hold_Data()
     * @param string $supplier_Contract_ID
     * @param \StructType\Goods_Line_Add_Hold_DataType[] $supplier_Contract_Line_Add_Hold_Data
     */
    public function __construct($supplier_Contract_ID = null, array $supplier_Contract_Line_Add_Hold_Data = array())
    {
        $this
            ->setSupplier_Contract_ID($supplier_Contract_ID)
            ->setSupplier_Contract_Line_Add_Hold_Data($supplier_Contract_Line_Add_Hold_Data);
    }
    /**
     * Get Supplier_Contract_ID value
     * @return string|null
     */
    public function getSupplier_Contract_ID()
    {
        return $this->Supplier_Contract_ID;
    }
    /**
     * Set Supplier_Contract_ID value
     * @param string $supplier_Contract_ID
     * @return \StructType\Add_Supplier_Contract_Line_Hold_DataType
     */
    public function setSupplier_Contract_ID($supplier_Contract_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Contract_ID) && !is_string($supplier_Contract_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Contract_ID, true), gettype($supplier_Contract_ID)), __LINE__);
        }
        $this->Supplier_Contract_ID = $supplier_Contract_ID;
        return $this;
    }
    /**
     * Get Supplier_Contract_Line_Add_Hold_Data value
     * @return \StructType\Goods_Line_Add_Hold_DataType[]|null
     */
    public function getSupplier_Contract_Line_Add_Hold_Data()
    {
        return $this->Supplier_Contract_Line_Add_Hold_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Contract_Line_Add_Hold_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Contract_Line_Add_Hold_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Contract_Line_Add_Hold_DataForArrayConstraintsFromSetSupplier_Contract_Line_Add_Hold_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $add_Supplier_Contract_Line_Hold_DataTypeSupplier_Contract_Line_Add_Hold_DataItem) {
            // validation for constraint: itemType
            if (!$add_Supplier_Contract_Line_Hold_DataTypeSupplier_Contract_Line_Add_Hold_DataItem instanceof \StructType\Goods_Line_Add_Hold_DataType) {
                $invalidValues[] = is_object($add_Supplier_Contract_Line_Hold_DataTypeSupplier_Contract_Line_Add_Hold_DataItem) ? get_class($add_Supplier_Contract_Line_Hold_DataTypeSupplier_Contract_Line_Add_Hold_DataItem) : sprintf('%s(%s)', gettype($add_Supplier_Contract_Line_Hold_DataTypeSupplier_Contract_Line_Add_Hold_DataItem), var_export($add_Supplier_Contract_Line_Hold_DataTypeSupplier_Contract_Line_Add_Hold_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Contract_Line_Add_Hold_Data property can only contain items of type \StructType\Goods_Line_Add_Hold_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Contract_Line_Add_Hold_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Goods_Line_Add_Hold_DataType[] $supplier_Contract_Line_Add_Hold_Data
     * @return \StructType\Add_Supplier_Contract_Line_Hold_DataType
     */
    public function setSupplier_Contract_Line_Add_Hold_Data(array $supplier_Contract_Line_Add_Hold_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Contract_Line_Add_Hold_DataArrayErrorMessage = self::validateSupplier_Contract_Line_Add_Hold_DataForArrayConstraintsFromSetSupplier_Contract_Line_Add_Hold_Data($supplier_Contract_Line_Add_Hold_Data))) {
            throw new \InvalidArgumentException($supplier_Contract_Line_Add_Hold_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Contract_Line_Add_Hold_Data = $supplier_Contract_Line_Add_Hold_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Contract_Line_Add_Hold_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Goods_Line_Add_Hold_DataType $item
     * @return \StructType\Add_Supplier_Contract_Line_Hold_DataType
     */
    public function addToSupplier_Contract_Line_Add_Hold_Data(\StructType\Goods_Line_Add_Hold_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Goods_Line_Add_Hold_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Contract_Line_Add_Hold_Data property can only contain items of type \StructType\Goods_Line_Add_Hold_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Contract_Line_Add_Hold_Data[] = $item;
        return $this;
    }
}
